/*
* @category    Formulario Tipo Componente
* @package     OfiClinic Web
* @author      Héctor Iván Ramírez Cardona<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddPacienteProgramaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Agregar Paciente a Programa ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winAddPacProgramaUi',
    
    initComponent: function() 
    {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddPacProgramaUi',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 70,
                        items:[
                            {
                                xtype:'hidden',
                                id:'intPacPrograma'
                            },
                            {
                                xtype:'hidden',
                                id:'intPacProIps'
                            },
                            {
                                xtype:'hidden',
                                id:'intPacProSede'
                            },
                            {
                                xtype: 'hidden',
                                id:'intPacProPrestador'
                            },
                            {
                                xtype: 'combo',
                                anchor: "100%",
                                store:'StoreCliente',
                                forceSelection: true,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                fieldLabel: 'Cliente',
                                name: 'Cliente',
                                emptyText: 'Seleccione...!',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                triggerAction: 'all',
                                mode: 'local',
                                id:'intPacProCliente'
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPacienteBasico',
                                value: 0
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysPacienteGeneroBasico'
                            },
                            {
                                xtype: 'textfield',
                                id: 'sysPacienteEdadMesesBasico'
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysPacienteEdadAniosBasico'
                            },
                            {
                                xtype: 'compositefield',
                                anchor: '100%',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: 'Paciente',
                                        width: 730,
                                        readOnly: true,
                                        allowBlank: true,
                                        emptyText: 'Debe Buscar Paciente....',
                                        id: 'sysPacienteBasico'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Paciente',
                                        id: 'btnBuscarPacientePrograma'
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                anchor: '100%',
                                store:'StorePrograma',
                                forceSelection: true,
                                valueField: 'IdPrograma',
                                displayField: 'Descripcion',
                                fieldLabel: 'Programa',
                                name: 'Programa',
                                emptyText: 'Seleccione...!',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                triggerAction: 'all',
                                mode: 'local',
                                id: 'intAddPacPrograma'
                                
                            },
                            {
                                xtype: 'textarea',
                                anchor: '100%',
                                fieldLabel: 'Observacion',
                                name: 'Observacion',
                                allowBlank: true,
                                emptyText: '',
                                maxLength: 250,
                                maxLengthText: 'maximo 250 caracteres ',
                                id: 'memAddProObservacion'
                            },
                            {
                                xtype:'hidden',
                                id:'intUsuInscribio'
                            }
                        ]
                    }
                ],
                tbar:
                {
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddProgramaPaciente'
                        }
                    ]
                },
                bbar:
                {   
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {   
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btn_SalirProPaciente'
                        }
                    ]
                }
            }
        ];
        winAddPacienteProgramaUi.superclass.initComponent.call(this);    
    }
});
