/*
* @category    Grid  Detalle Componentes
* @package     OfiClinic Web
* @author      Hèctor Ivàn Ramìrez Cardona<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

/**
*  Pre:---
*  Post: ---
*  Return: winGridDetalleComponentesUi
*  Resumen: Se crea el grid de detalle componente
**/

winGridDetalleSeguimientoUi = Ext.extend(Ext.grid.GridPanel, {
    closable: true,
    width:670,
    height:300,
    plain:true,
    resizable : false,
    y:120,
    layout: 'fit',
    id: 'gridDetalleSeguimiento',
    store: 'StoreGridDetalleSeguimiento',
    anchor: "100%",
    border: false,
    frame: true,
    
    /**
    *  Pre:---
    *  Post: ---
    *  Return: ---
    *  Resumen: Se inicializa el componente del grid
    **/
   
    initComponent: function() 
        {
            stStoreGridDetalleSeguimiento = new StoreGridDetalleSeguimiento();    
            el = Ext.get('idempresa');
            var ID_EMPRESA = el.getValue();
            this.columns = [
                {    
                    xtype: 'gridcolumn',
                    header: 'Id',
                    sortable: false,
                    width: 330,
                    hidden: true,
                    hideable: false,
                    dataIndex: 'IdBitacora'
                },
                {
                    xtype: 'gridcolumn',
                    header: 'Id Kardex',
                    sortable: true,
                    width: 330,
                    hidden: true,
                    hideable: false,
                    dataIndex: 'IdKardex'
                },
                {
                    xtype: 'gridcolumn',
                    header: 'Fecha de Contacto',
                    sortable: true,
                    width: 90,
                    tooltip:'Fecha de Contacto',
                    hidden: false,
                    hideable: false,
                    dataIndex: 'FechaContacto'
                },
                {
                    xtype: 'gridcolumn',
                    header: 'Tipo De Contacto',
                    sortable: true,
                    width: 100,
                    tooltip:'Tipo De Contacto',
                    hidden: false,
                    hideable: false,
                    dataIndex: 'TipoContacto'
                },
                {
                    xtype: 'gridcolumn',
                    header: 'Parentesco',
                    sortable: true,
                    width: 130,
                    hidden: false,
                    hideable: false,
                    dataIndex: 'Parentesco'
                },
                {
                    xtype: 'gridcolumn',
                    header: 'Observacion',
                    sortable: true,
                    width: 180,
                    hidden: false,
                    hideable: false,
                    dataIndex: 'Observacion'
                },
                {
                    xtype: 'gridcolumn',
                    header: 'Profesional que Realizo el Seguimiento',
                    sortable: true,
                    width: 100,
                    tooltip:'Profesional que Realizo el Seguimiento',
                    hidden: false,
                    hideable: false,
                    dataIndex: 'Usuario_Seguimiento'
                },
                {
                    xtype: 'gridcolumn',
                    header: 'Contacto Efectivo',
                    sortable: true,
                    width: 50,
                    tooltip:'Contacto Efectivo',
                    hidden: false,
                    hideable: false,
                    dataIndex: 'ContactoEfectivo'
                }
            ];
            this.selModel= new Ext.grid.RowSelectionModel({
                singleSelect:true
            });
            this.tbar = {
                xtype: 'toolbar',
                items: [
                    {
                        xtype: 'tbfill'
                    },
                    new Ext.app.SearchField({
                        id: 'qryDetalleComponente',
                        store: stStoreGridDetalleSeguimiento,
                        ValparamP1: ID_EMPRESA,
                        emptyText: 'Escriba el criterio que desea buscar',
                        params: {pEmpresa: 1, start: 0, limit: 15},
                        width: 120
                    })
                ]
            };
            this.bbar = {
                xtype:'paging',
                pageSize: 15,
                store: stStoreGridDetalleSeguimiento,
                displayInfo: true
            };
        winGridDetalleSeguimientoUi.superclass.initComponent.call(this);
    }
});
