/*
* @category    Clase Principal Notificación Reparación
* @package     OfiClinic Web
* @author      Héctor Iván Ramírez Cardona<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

/**
*  Pre: ----
*  Post: ----
*  Return: winFrmNotificacionReparaciones Object
*  Resumen: Clase que tiene los metodos del grid notificación reparación
**/

winFrmKardexPaciente = Ext.extend(winFrmKardexPacienteUi,  {
    initComponent: function(){     
        //se crea el objeto store
        winFrmKardexPaciente.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        el = Ext.get('idaplicacion');
        NOM_APLICACION = el.getValue();
        el = Ext.get('idxac');
        var ID_CONSULTORIO = el.getValue();
        el = Ext.get('usaPatrocinador');
        USA_PATROCINADOR = el.getValue();
        el = Ext.get('urlPrintHC');
        URLPrintHC = el.getValue();
        el = Ext.get('AddOfimedical');
        AddOfimedicalHC = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        el = Ext.get('IdMunicipio');
        ID_MUNICIPIO = el.getValue();
        Ext.getCmp('gridKardexPaciente').store.load({
            params: {
                query: null, 
                start: 0, 
                limit: 15,
                pEdad:0,
                pSexo: "",
                pPaciente:0,
                pFecVaciaCita:0,
                pFecVaciaInscripcion:0,
                pPrioridad: "",
                pEstado: "",
                pPrograma: ""
            }
        });
        var btnAddPacPrograma = Ext.getCmp('btnCreaPaciente').on("click",this.AddPaciPrograma,this);
        var btnAgrBitacora = Ext.getCmp('btnAgrBitacora').on("click",this.AddKarBitacora,this);
        var btnCerrarPrograma= Ext.getCmp('btnCerrarPrograma').on("click",this.CerrarPrograma,this);
        var btn_AplicarFiltro= Ext.getCmp('btn_AplicarFiltro').on("click",this.ComenzarFiltro,this);
        var btnConHisSeguimiento= Ext.getCmp('btnConHisSeguimiento').on("click",this.ConsultarHistorial,this);
        var btnProgramarFechas= Ext.getCmp('btnProgramarFechas').on("click",this.ProgramarFechas,this);
        
    },
    ProgramarFechas: function(){
        if(Ext.getCmp('gridKardexPaciente').selModel.getCount() == 1)
        {   
            var selections = Ext.getCmp('gridKardexPaciente').selModel.getSelections();
            var winKarBitacora = new winKarBitacoraUi();
            
            Ext.getCmp('intKarPaciente').setValue(selections[0].json.IdKardex);
            Ext.getCmp('intUsuSeguimiento').setValue(0);
            Ext.getCmp('btnUsuario').setValue("PACIENTE:"+selections[0].json.NomPaciente+"]");
            Ext.getCmp('btnPrograma').setValue("PROGRAMA:["+selections[0].json.NomPrograma);
            Ext.getCmp('frmKarBitacora').setVisible(false);
            Ext.getCmp('gridDetalleSeguimiento').setVisible(false);
            Ext.getCmp('gridKardexProgramacion').store.setBaseParam('pKardexProgramacion', Ext.getCmp('intKarPaciente').getValue());
            Ext.getCmp('gridKardexProgramacion').store.load({
                params: 
                    {
                        query:null,
                        start: 0, 
                        limit: 15
                    }           
            })
            var btn_SalirBitacora = Ext.getCmp('btn_SalirKarBitagora').on("click",this.CerrarBitacora,this);
            winKarBitacora.show();
        }else{
            Ext.MessageBox.show({
            title: 'INFORMACIÓN',
            msg: 'Verifique que  haya seleccionado un registro',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.INFO
            });
        }
    },
    
    ConsultarHistorial: function()
    {
        
        if(Ext.getCmp('gridKardexPaciente').selModel.getCount() == 1)
        {   
            var selections = Ext.getCmp('gridKardexPaciente').selModel.getSelections();
            var winDetalleseguimiento = new winKarBitacoraUi();
            
            Ext.getCmp('frmKarBitacora').setVisible(false);
            Ext.getCmp('gridKardexProgramacion').setVisible(false);
            Ext.getCmp('btnUsuario').setValue("PACIENTE:"+selections[0].json.NomPaciente+"]");
            Ext.getCmp('btnPrograma').setValue("PROGRAMA:["+selections[0].json.NomPrograma);
            Ext.getCmp('gridDetalleSeguimiento').store.setBaseParam('pDetalleSeguimiento', selections[0].json.IdKardex);
            Ext.getCmp('gridDetalleSeguimiento').store.load({
                params: 
                    {
                        query:null,
                        start: 0, 
                        limit: 15
                    }           
            }) 
            var btn_SalirBitacora = Ext.getCmp('btn_SalirKarBitagora').on("click",this.CerrarBitacora,this);
            winDetalleseguimiento.show();
        }else{
            Ext.MessageBox.show({
                title: 'INFORMACIÓN',
                msg: 'Verifique que  haya seleccionado un registro',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.INFO
            });
        }
    },
   
    AddPaciPrograma: function()
    {
        var winAddPacProgrma = new winAddPacienteProgramaUi();
        Ext.getCmp('intPacProIps').setValue(1);
        Ext.getCmp('intPacProSede').setValue(1);
        Ext.getCmp('intUsuInscribio').setValue(1);
        var btn_SalirCerrar = Ext.getCmp('btn_SalirProPaciente').on("click",this.CerrarVentanaPacPrograma,this);
        var btn_AddProPaciente= Ext.getCmp('btn_AddProgramaPaciente').on("click",this.GuaProPaciente,this);
        var btnBuscarPacientePrograma = Ext.getCmp('btnBuscarPacientePrograma').on("click",this.BuscarPaciente,this);
        var intAddPacPrograma = Ext.getCmp('intAddPacPrograma').on("select",this.ValidarProgramaPaciente,this);
        Ext.getCmp('intPacProCliente').store.load({
            params: {
                pEmpresa: ID_EMPRESA
            }
        });
        winAddPacProgrma.show();
    },
    ValidarProgramaPaciente: function(cmb, rec, idx) {
        var edadValido = 0;
        if(cmb.getValue() !== null && cmb.getValue() !== ""){
            
            if(rec.data.Genero !== null && rec.data.Genero !== ""){
                if(rec.data.Genero !== "A"){
                    if(rec.data.Genero !== Ext.getCmp('sysPacienteGeneroBasico').getValue()){
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'El programa seleccionado no aplica para el genero del paciente',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        Ext.getCmp('intAddPacPrograma').setValue(null);
                    }
                }
            }
            
            if(rec.data.EdadMinima !== null && rec.data.EdadMinima !== "" && rec.data.EdadMaxima !== null && rec.data.EdadMaxima !== ""){
                if(!(rec.data.EdadMinima >= Ext.getCmp('sysPacienteEdadMesesBasico').getValue() && rec.data.EdadMaxima <= Ext.getCmp('sysPacienteEdadMesesBasico').getValue())){
                    Ext.MessageBox.show({
                        title: 'eOfiClinic',
                        msg: 'La edad del paciente aplica para el rango de edad permitido del programa',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    Ext.getCmp('intAddPacPrograma').setValue(null);
                }
            }
            
            if(edadValido === 0 && ((rec.data.EdadPermitida1 !== null && rec.data.EdadPermitida1 !== "") || (rec.data.EdadPermitida2 !== null && rec.data.EdadPermitida2 !== "") || (rec.data.EdadPermitida3 !== null && rec.data.EdadPermitida3 !== "") || (rec.data.EdadPermitida4 !== null && rec.data.EdadPermitida4 !== "") || (rec.data.EdadPermitida5 !== null && rec.data.EdadPermitida5 !== "") || (rec.data.EdadPermitida6 !== null && rec.data.EdadPermitida6 !== "") || (rec.data.EdadPermitida7 !== null && rec.data.EdadPermitida7 !== "") || (rec.data.EdadPermitida8 !== null && rec.data.EdadPermitida8 !== "") || (rec.data.EdadPermitida9 !== null && rec.data.EdadPermitida9 !== ""))){
                if(rec.data.EdadPermitida1 !== 0 && Ext.getCmp('sysPacienteEdadMesesBasico').getValue() === rec.data.EdadPermitida1){
                    edadValido = 1;
                }
                if(edadValido === 0 && rec.data.EdadPermitida2 !== 0 && Ext.getCmp('sysPacienteEdadMesesBasico').getValue() === rec.data.EdadPermitida2){
                    edadValido = 1;
                }
                if(edadValido === 0 && rec.data.EdadPermitida3 !== 0 && Ext.getCmp('sysPacienteEdadMesesBasico').getValue() === rec.data.EdadPermitida3){
                    edadValido = 1;
                }
                if(edadValido === 0 && rec.data.EdadPermitida4 !== 0 && Ext.getCmp('sysPacienteEdadMesesBasico').getValue() === rec.data.EdadPermitida4){
                    edadValido = 1;
                }
                if(edadValido === 0 && rec.data.EdadPermitida5 !== 0 && Ext.getCmp('sysPacienteEdadMesesBasico').getValue() === rec.data.EdadPermitida5){
                    edadValido = 1;
                }
                if(edadValido === 0 && rec.data.EdadPermitida6 !== 0 && Ext.getCmp('sysPacienteEdadMesesBasico').getValue() === rec.data.EdadPermitida6){
                    edadValido = 1;
                }
                if(edadValido === 0 && rec.data.EdadPermitida7 !== 0 && Ext.getCmp('sysPacienteEdadMesesBasico').getValue() === rec.data.EdadPermitida7){
                    edadValido = 1;
                }
                if(edadValido === 0 && rec.data.EdadPermitida8 !== 0 && Ext.getCmp('sysPacienteEdadMesesBasico').getValue() === rec.data.EdadPermitida8){
                    edadValido = 1;
                }
                if(edadValido === 0 && rec.data.EdadPermitida9 !== 0 && Ext.getCmp('sysPacienteEdadMesesBasico').getValue() === rec.data.EdadPermitida9){
                    edadValido = 1;
                }
                if(edadValido === 0){
                    Ext.MessageBox.show({
                        title: 'eOfiClinic',
                        msg: 'La edad del paciente no es permitida para el programa seleccionado',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    Ext.getCmp('intAddPacPrograma').setValue(null);
                }
            }
        }
    },
    BuscarPaciente: function(){
        buscarpaciente("Basico");
    },
    GuaProPaciente: function()
    {
        Ext.Msg.show({
            title: 'Agregar Paciente a Programa ',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("INSERTAR PROGRAMA","SI","winAddPacProgramaUi","frmAddPacProgramaUi","../../controlador/kardex_paciente/controlador_kardex_paciente.php","gridKardexPaciente");
                }
            }
        });
    },
   
    CerrarVentanaPacPrograma: function()
    {
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winAddPacProgramaUi').close();
                }
            }
        });
    },
   
    AddKarBitacora: function()
    {
        
        if(Ext.getCmp('gridKardexPaciente').selModel.getCount() == 1)
        {   
            var selections = Ext.getCmp('gridKardexPaciente').selModel.getSelections();
            var winKarBitacora = new winKarBitacoraUi();
            
            Ext.getCmp('intKarPaciente').setValue(selections[0].json.IdKardex);
            Ext.getCmp('sysBitPaciente').setValue(selections[0].json.NomPaciente);
            Ext.getCmp('sysBitPrograma').setValue(PonerAcentosMayusculas(selections[0].json.NomPrograma));
            Ext.getCmp('intUsuSeguimiento').setValue(0);
            Ext.getCmp('btnUsuario').setValue("PACIENTE:"+selections[0].json.NomPaciente+"]");
            Ext.getCmp('btnPrograma').setValue("PROGRAMA:["+selections[0].json.NomPrograma);
            
            Ext.getCmp('gridDetalleSeguimiento').store.setBaseParam('pDetalleSeguimiento', Ext.getCmp('intKarPaciente').getValue());
            Ext.getCmp('gridDetalleSeguimiento').store.load({
                params: 
                    {
                        query:null,
                        start: 0, 
                        limit: 15
                    }           
            })
            
            Ext.getCmp('gridKardexProgramacion').store.setBaseParam('pKardexProgramacion', Ext.getCmp('intKarPaciente').getValue());
            Ext.getCmp('gridKardexProgramacion').store.load({
                params: 
                    {
                        query:null,
                        start: 0, 
                        limit: 15
                    }           
            })
            var btn_GuarSeguimiento = Ext.getCmp('btn_AdicionarKarBitagora').on("click",this.GuardarSeguimiento,this);
            var btn_SalirBitacora = Ext.getCmp('btn_SalirKarBitagora').on("click",this.CerrarBitacora,this);
            winKarBitacora.show();
        }else{
            Ext.MessageBox.show({
            title: 'INFORMACIÓN',
            msg: 'Verifique que  haya seleccionado un registro',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.INFO
            });
        }
    },
    
    CerrarPrograma: function()
    {
        
        if(Ext.getCmp('gridKardexPaciente').selModel.getCount() == 1)
        {   
            var selections = Ext.getCmp('gridKardexPaciente').selModel.getSelections();
            var winCerProgrma = new winCerProgrmaUi();
            Ext.getCmp('intCerPrograma').setValue(selections[0].json.IdKardex);
            Ext.getCmp('sysCerPaciente').setValue(selections[0].json.NomPaciente);
            Ext.getCmp('sysCerPrograma').setValue(PonerAcentosMayusculas(selections[0].json.NomPrograma));
            Ext.getCmp('intUsuCierre').setValue(0);
            var btn_SalirCerrar = Ext.getCmp('btn_SalirCerrPrograma').on("click",this.CerrarVentana,this);
            var btn_CerrarPrograma= Ext.getCmp('btn_CerrarPrograma').on("click",this.ModificarCerrarPrograma,this);
            winCerProgrma.show();
        }else{
            Ext.MessageBox.show({
            title: 'INFORMACIÓN',
            msg: 'Verifique que  haya seleccionado un registro',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.INFO
            });
        }
        
    },
    
    CerrarBitacora: function()
    {
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winKarBitacoraUi').close();
                }
            }
        });
    },
    
    CerrarVentana: function()
    {
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winCerrProgramaUi').close();
                }
            }
        });
    },
    
    ModificarCerrarPrograma: function()
    {
        Ext.Msg.show({ 
            title: 'Cerrar Progmama',
            msg: 'Esta Seguro que Desea Modificar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("MODIFICAR","SI","winCerrProgramaUi","frmCerrPrograma","../../controlador/kardex_paciente/controlador_kardex_paciente.php","gridKardexPaciente");
                }
            }
        });
    },
    
    GuardarSeguimiento: function()
    {
        Ext.Msg.show({
            title: 'Guardar Seguimiento ',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("INSERTAR","SI","winKarBitacoraUi","frmKarBitacora","../../controlador/kardex_paciente/controlador_kardex_paciente.php","gridKardexPaciente");
                }
            }
        });
    },
    
    ComenzarFiltro: function()
    {
        Ext.Msg.show({
        msg: 'Aplicar los criterios de búsqueda',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
            {
                if(btn=="yes")
                {
                    var fecvaciainscripcion=1;
                    var fecvaciacita=1;
                    var paciente=1;
                    var edad=1;
                    if (Ext.getCmp('intEdadDesde').getValue() == "" || Ext.getCmp('intEdadDesde').getValue() == null || Ext.getCmp('intEdadHasta').getValue() == "" || Ext.getCmp('intEdadHasta').getValue() == null)
                    {
                        edad=0;
                        Ext.getCmp('intEdadDesde').setValue("");
                        Ext.getCmp('intEdadHasta').setValue("");
                    }
                    if (Ext.getCmp('strSexo').getValue() == "" || Ext.getCmp('strSexo').getValue() == null)
                    {
                        Ext.getCmp('strSexo').setValue("");
                    }
                    if (Ext.getCmp('intPrograma').getValue() == "" || Ext.getCmp('intPrograma').getValue() == null)
                    {
                        Ext.getCmp('intPrograma').setValue("");
                    }
                    if (Ext.getCmp('strEstado').getValue() == "" || Ext.getCmp('strEstado').getValue() == null)
                    {
                        Ext.getCmp('strEstado').setValue("");
                    }
                    if (Ext.getCmp('strPrioridad').getValue() == "" || Ext.getCmp('strPrioridad').getValue() == null)
                    {
                        Ext.getCmp('strPrioridad').setValue("");
                    }
                    if (Ext.getCmp('strTipoDocumento').getValue() == "" || Ext.getCmp('strTipoDocumento').getValue() == null || Ext.getCmp('intNIdentificacion').getValue() == "" || Ext.getCmp('intNIdentificacion').getValue() == null || Ext.getCmp('strPaciente').getValue() == "" || Ext.getCmp('strPaciente').getValue() == null )
                    {
                        paciente=0;
                        Ext.getCmp('strTipoDocumento').setValue("");
                        Ext.getCmp('intNIdentificacion').setValue("");
                        Ext.getCmp('strPaciente').setValue("");
                    }
                    if (Ext.getCmp('fecDesInscripcion').getValue() == "" || Ext.getCmp('fecDesInscripcion').getValue() == null || Ext.getCmp('fecDesInscripcion').getValue() == "null")
                    {
                        fecvaciainscripcion=0;
                        Ext.getCmp('fecDesInscripcion').setValue("");
                    }
                    if (Ext.getCmp('fecHasInscripcion').getValue() == "" || Ext.getCmp('fecHasInscripcion').getValue() == null || Ext.getCmp('fecHasInscripcion').getValue() == "null")
                    {
                        fecvaciainscripcion=0;
                        Ext.getCmp('fecHasInscripcion').setValue("");
                    }
                    if (Ext.getCmp('fecProCita').getValue() == "" || Ext.getCmp('fecProCita').getValue() == null || Ext.getCmp('fecProCita').getValue() == "null")
                    {
                        fecvaciacita=0;
                        Ext.getCmp('fecProCita').setValue("");
                    }
                    if (Ext.getCmp('fecHasProCita').getValue() == "" || Ext.getCmp('fecHasProCita').getValue() == null || Ext.getCmp('fecHasProCita').getValue() == "null")
                    {
                        fecvaciacita=0;
                        Ext.getCmp('fecHasProCita').setValue("");
                    }
                    Ext.getCmp('gridKardexPaciente').store.setBaseParam('pSexo', Ext.getCmp('strSexo').getValue());
                    Ext.getCmp('gridKardexPaciente').store.setBaseParam('pEdad', edad);
                    Ext.getCmp('gridKardexPaciente').store.setBaseParam('pEdadDesde', Ext.getCmp('intEdadDesde').getValue());
                    Ext.getCmp('gridKardexPaciente').store.setBaseParam('pEdadHasta', Ext.getCmp('intEdadHasta').getValue());
                    Ext.getCmp('gridKardexPaciente').store.setBaseParam('pPaciente', paciente);
                    Ext.getCmp('gridKardexPaciente').store.setBaseParam('pTipDocumento', Ext.getCmp('strTipoDocumento').getValue());
                    Ext.getCmp('gridKardexPaciente').store.setBaseParam('pNumIdentificacion', Ext.getCmp('intNIdentificacion').getValue());
                    Ext.getCmp('gridKardexPaciente').store.setBaseParam('pNomPaciente', Ext.getCmp('strPaciente').getValue());
                    Ext.getCmp('gridKardexPaciente').store.setBaseParam('pFecVaciaCita', fecvaciacita);
                    Ext.getCmp('gridKardexPaciente').store.setBaseParam('pFecVaciaInscripcion', fecvaciainscripcion);
                    Ext.getCmp('gridKardexPaciente').store.setBaseParam('pDesProCita', Ext.getCmp('fecProCita').getValue());
                    Ext.getCmp('gridKardexPaciente').store.setBaseParam('pHasProCita', Ext.getCmp('fecHasProCita').getValue());
                    Ext.getCmp('gridKardexPaciente').store.setBaseParam('pDesInscripcion', Ext.getCmp('fecDesInscripcion').getValue());
                    Ext.getCmp('gridKardexPaciente').store.setBaseParam('pHasInscripcion', Ext.getCmp('fecHasInscripcion').getValue());
                    Ext.getCmp('gridKardexPaciente').store.setBaseParam('pPrioridad', Ext.getCmp('strPrioridad').getValue());
                    Ext.getCmp('gridKardexPaciente').store.setBaseParam('pEstado', Ext.getCmp('strEstado').getValue());
                    Ext.getCmp('gridKardexPaciente').store.setBaseParam('pPrograma', Ext.getCmp('intPrograma').getValue());
                    Ext.getCmp('gridKardexPaciente').store.reload({
                        params: 
                        {
                            task: 'LISTAR',
                            query: null,
                            start: 0,
                            limit: 15
                        }
                    });
                } 
            }
        }); 
    }
   
});


function fnGuardarRegistros(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Éxito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarDatosBasicosTarjeta').setVisible(false);
                                Ext.getCmp('btnModificarDatosBasicosTarjeta').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}