/*
* @category    Grid  Detalle Componentes
* @package     OfiClinic Web
* @author      Hèctor Ivàn Ramìrez Cardona<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

/**
*  Pre:---
*  Post: ---
*  Return: winGridDetalleComponentesUi
*  Resumen: Se crea el grid de detalle componente
**/

winGridKarProgramacionUi = Ext.extend(Ext.grid.GridPanel, {
    closable: true,
    width:670,
    height:300,
    plain:true,
    resizable : false,
    y:120,
    layout: 'fit',
    id: 'gridKardexProgramacion',
    store: 'StoreGridKardexProgramacion',
    anchor: "100%",
    border: false,
    frame: true,
    
    /**
    *  Pre:---
    *  Post: ---
    *  Return: ---
    *  Resumen: Se inicializa el componente del grid
    **/
   
    initComponent: function() 
        {
            stStoreGridKardexProgramacion= new StoreGridKardexProgramacion();    
            el = Ext.get('idempresa');
            var ID_EMPRESA = el.getValue();
            this.columns = [
                {    
                    xtype: 'gridcolumn',
                    header: 'Id',
                    sortable: false,
                    width: 330,
                    hidden: true,
                    hideable: false,
                    dataIndex: 'IdKardexProgramacion'
                },
                {
                    xtype: 'gridcolumn',
                    header: 'Fecha Proxima Cita',
                    sortable: true,
                    width: 100,
                    tooltip:'Fecha Proxima Cita',
                    hidden: false,
                    hideable: false,
                    dataIndex: 'Fecha_Probable'
                },
                {
                    xtype: 'gridcolumn',
                    header: 'Fecha Real Asistio',
                    sortable: true,
                    width: 100,
                    tooltip:'Fecha Real Asistio',
                    hidden: false,
                    hideable: false,
                    dataIndex: 'Fecha_Real'
                },
                {
                    xtype: 'gridcolumn',
                    header: 'Asistio',
                    sortable: true,
                    width: 100,
                    hidden: false,
                    hideable: false,
                    dataIndex: 'Asistio'
                },
                {
                    xtype: 'gridcolumn',
                    header: 'Profesional',
                    sortable: true,
                    width: 100,
                    hidden: false,
                    hideable: false,
                    dataIndex: 'Profesional'
                },
                {
                    xtype: 'gridcolumn',
                    header: 'Especialidad',
                    sortable: true,
                    width: 100,
                    hidden: false,
                    hideable: false,
                    dataIndex: 'Especialidad'
                },
                {
                    xtype: 'gridcolumn',
                    header: 'Servicio',
                    sortable: true,
                    width: 100,
                    hidden: false,
                    hideable: false,
                    dataIndex: 'Codigo_Servicio'
                }
            ];
            this.selModel= new Ext.grid.RowSelectionModel({
                singleSelect:true
            });
            this.tbar = {
                xtype: 'toolbar',
                items: [
                    {
                        xtype: 'button',
                        text: 'Programar Fecha',
                        iconCls: 'btnProFechas',
                        id: 'btnProFecha'
                    },
                    {
                        xtype: 'tbfill'
                    },
                    new Ext.app.SearchField({
                        id: 'qryDetalleComponente',
                        store: stStoreGridKardexProgramacion,
                        ValparamP1: ID_EMPRESA,
                        emptyText: 'Escriba el criterio que desea buscar',
                        params: {pEmpresa: 1, start: 0, limit: 15},
                        width: 120
                    })
                ]
            };
            this.bbar = {
                xtype:'paging',
                pageSize: 15,
                store: stStoreGridKardexProgramacion,
                displayInfo: true
            };
        winGridKarProgramacionUi.superclass.initComponent.call(this);
    }
});
