/*
* @category    Cargar Cargar Documentos por Paciente
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

CargarDocumentosxPacienteUi = Ext.extend(Ext.Window, {
    layout: 'fit',
    id: 'CargarDocumentosxPacienteUi',
    width: 560,
    autoHeight: true,
    closeAction: 'hide',
    plain: true,
    modal: true,
    frame: true,
    border: false,
    closable: false,
    draggable: false,
    resizable: false,
    title: 'Adjuntar Documentos por Paciente',

    initComponent: function() {
        el = Ext.get('idxac');
        var xID_CONSULTORIO = el.getValue();
        el = Ext.get('idaplicacion');
        NOM_APLICACION = el.getValue();
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        var frmCargarDocumento = new Ext.FormPanel({
            closeAction: 'hide',
            fileUpload: true,
            labelWidth: 80,
            frame: true,
            autoHeight: true,
            //height: 49,
            url: '../../controlador/pacientes/controlador_docsasoc.php',
            bodyStyle: 'padding:0px 0px 30px',
            defaults: {
                allowBlank: false
            },
            items: [
                {
                    xtype: 'hidden',
                    anchor: '100%',
                    allowBlank: true,
                    name: 'sysPacienteDoc',
                    id: 'sysPacienteDoc'
                },
                {
                    xtype: 'textfield',
                    fieldLabel: 'Nombre',
                    anchor: '100%',
                    name: 'txtNombreDocPac',
                    allowBlank: false,
                    id: 'txtNombreDocPac'
                },
                {
                    xtype: 'datefield',
                    fieldLabel: 'Fecha',
                    //anchor: '100%',
                    width: 120,
                    name: 'fecDocPac',
                    allowBlank: false,
                    disabledDates: '',
                    emptyText: '(dia/mes/año) ',
                    style: 'text-align:center;',
                    id: 'fecDocPac'
                },
                {
                    xtype: 'fileuploadfield',
                    anchor: '99%',
                    id: 'archivoDocxPac',
                    fieldLabel: 'Archivo',
                    name: 'firma-path',
                    buttonText: '...',
                    buttonCfg: {}
                },
                {
                    xtype: 'textarea',
                    fieldLabel: 'Notas',
                    anchor: '100%',
                    name: 'memNotasDocPac',
                    allowBlank: false,
                    id: 'memNotasDocPac'
                }
            ]
        });
    
        this.items = [
            frmCargarDocumento
        ];
        this.buttons = [
            {
                text: 'Adjuntar Documento',
                iconCls: 'btnCargarFile',
                handler: function(){
                    nomTarea = "GRABAR_OFIMEDICAL";
                    if(NOM_APLICACION == "OfiMedical"){
                        nomTarea = "GRABAR_OFIMEDICAL";
                    }else{
                        nomTarea = "GRABAR_OFICLINIC";
                    }
                    if (frmCargarDocumento.getForm().isValid()) {					
                        frmCargarDocumento.getForm().submit({
                            waitTitle: 'Estado',
                            waitMsg: 'Cargando Archivo ...',
                            params: {
                                task: nomTarea,
                                pPaciente: Ext.getCmp('sysPacienteDoc').getValue()
                            },
                            success: function(form, action){
                                var data = Ext.util.JSON.decode(action.response.responseText);
                                Ext.Msg.show({
                                    title: NOM_APLICACION,
                                    msg: data.message.reason,
                                    buttons: Ext.Msg.OK,
                                    icon: Ext.Msg.INFO
                                });
                                winDocxPac.reloadStore();
                                Ext.getCmp('CargarDocumentosxPacienteUi').close();
                            },
                            failure: function(form, action){
                                if (action.failureType == 'server') {
                                    var data = Ext.util.JSON.decode(action.response.responseText);
                                    Ext.Msg.show({
                                        title: NOM_APLICACION,
                                        msg: data.errors.reason,
                                        buttons: Ext.Msg.OK,
                                        icon: Ext.Msg.ERROR
                                    });
                                }
                            }
                        });
                    }
                }
            },
            {
                text: 'Salir',
                iconCls: 'btnSalir',
                handler: function(){
                    Ext.getCmp('CargarDocumentosxPacienteUi').close();
                }
            }
        ];
        CargarDocumentosxPacienteUi.superclass.initComponent.call(this);
    }
});
