/*
* @category    Programacion Eventos Formulario Tipo de Horario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmUnificarPaciente = Ext.extend(winFrmUnificarPacienteUi, {
    initComponent: function() {
        winFrmUnificarPaciente.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        
        
        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnBuscarPacienteUnificaMalo = Ext.getCmp('btnBuscarPacienteUnificaMalo').on("click",this.BuscarPacienteMalo,this);
        var btnBuscarPacienteUnificaBueno = Ext.getCmp('btnBuscarPacienteUnificaBueno').on("click",this.BuscarPacienteBueno,this);
        var btnUnificar = Ext.getCmp('btnUnificar').on("click",this.Unificar,this);
        
    },
    BuscarPacienteMalo: function(){
        buscarpaciente("UnificaPacienteMalo");
    },
    BuscarPacienteBueno: function(){
        buscarpaciente("UnificaPacienteBueno");
    },
    Unificar: function(){
        Ext.Msg.show({
            title: 'Pacientes....!',
            msg: 'Esta seguro que desea unificar la información de los pacientes, si hace esto después de la unificación el paciente malo será eliminado?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    var frm = Ext.getCmp('frmUnificarPaciente').getForm();
                    if (frm.isValid())
                    {
                        frm.submit({
                            url: '../../controlador/pacientes/controlador_pacientes.php',
                            params: {
                                task: 'UNIFICAR',
                                pEmpresa: ID_EMPRESA,
                                pIPS: ID_IPS ,
                                pUsuario: ID_USUARIO,
                                pPacienteMalo: Ext.getCmp('sysPacienteMalo').getValue(),
                                pPacienteBueno: Ext.getCmp('sysPacienteBueno').getValue(),
                                pMotivo: "Paciente Malo: " + Ext.getCmp('fPacienteMalo').getValue() + " - Paciente Bueno: " + Ext.getCmp('fPacienteBueno').getValue()
                            },
                            success: function(res,req)
                            {
                                switch(req.result.requestedId){
                                    case "1":
                                        Ext.MessageBox.show({
                                            title: 'Pacientes',
                                            msg: 'Se Unifico con Exito la información de los pacientes seleccionados.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.INFO
                                        });
                                        window.close();
                                        break;

                                    default:
                                        Ext.MessageBox.show({
                                            title: 'Pacientes',
                                            msg: 'Ocurrio un error al unificar los pacientes o no se pudo establecer conexión con el servidor.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                        break;
                                }
                            },
                            failure: function(response,options)
                            {
                                Ext.MessageBox.show({
                                    title: 'Error Base Datos',
                                    msg: 'No podemos unificar los pacientes en estos momentos',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            }
                        });
                    }else{
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Debe Seleccionar los Pacientes',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                }
            }
        });
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    }
    
});

