/*
* @category    Formulario Registrar Huella
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winRegistrarHuellaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Registrar Huella ::.',
    width:650,
    autoHeight: true,
    modal: true,
    padding: 10,
    closable: false,
    id: 'winRegistrarHuella',
    initComponent: function() {
        var verHuella = new Ext.Panel({ 
            autoLoad:{
                url:'../../../app/controlador/pacientes/showhuella.php?pPaciente=0',
                scripts:true,
                scope:this
            },
            id:'verHuella',
            title: 'Verificacion del Paciente',
            //height: 310,
            autoHeight: true,
            autoScroll:true
        });
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                labelWidth: 1,
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            listeners:{
                                click : function(){
                                    if (Ext.getCmp('sysPacienteHuella').getValue() !== "" && Ext.getCmp('sysPacienteHuella').getValue() !== null && parseInt(Ext.getCmp('sysPacienteHuella').getValue()) > 0){
                                        Ext.Ajax.request({
                                            url: '../../controlador/pacientes/controlador_pacientes.php',
                                            params:{
                                                task: 'UPDATE_HUELLA',
                                                pPaciente: Ext.getCmp('sysPacienteHuella').getValue()
                                            },
                                            success: function(response,options){
                                                Ext.getCmp('winRegistrarHuella').close();
                                            },
                                            failure: function(response,options){
                                                Ext.getCmp('winRegistrarHuella').close();
                                            },
                                            scope:this 
                                        });
                                    }else{
                                        Ext.getCmp('winRegistrarHuella').close();
                                    }
                                }
                            }
                        }
                    ]
                },
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Paciente',
                        id: 'sysPacienteHuella'
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '100%',
                        style: 'background:transparent;',
                        items: [
                            {
                                html:'<img src="../../../resources/botones/fingerprint.png" align="left" alt=""/>',border: false
                            },
                            {
                                xtype: 'textfield',
                                width: 60,
                                allowBlank: true,
                                inputType: 'password',
                                id: 'sysPacienteHuellaID',
                                listeners:{
                                    specialkey: function(f,e){
                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB && Ext.getCmp('sysPacienteHuellaID').getValue() !== "" && Ext.getCmp('sysPacienteHuellaID').getValue() !== null){
                                            Ext.Ajax.request({
                                                url: '../../controlador/pacientes/controlador_pacientes.php',
                                                params:{
                                                    task: 'SEARCH_HUELLA',
                                                    pHuella: Ext.getCmp('sysPacienteHuellaID').getValue(),
                                                    pPaciente: Ext.getCmp('sysPacienteHuella').getValue()
                                                },
                                                success: function(response,options){
                                                    var Respuesta = response.responseText;
                                                    var Contenido = Respuesta.split('^');
                                                    if(Contenido[0] === "0" || Contenido[0] === 0){
                                                        Ext.MessageBox.show({
                                                            title: 'eOfiClinic',
                                                            msg: 'La huella no ha sido reistrada.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.INFO
                                                        });
                                                        var embed = document.createElement('embed');
                                                        embed.setAttribute('type', 'application/x-ms-application');
                                                        embed.setAttribute('width', 0);
                                                        embed.setAttribute('height', 0);
                                                        document.body.appendChild(embed);
                                                        //embed.launchClickOnce("http://microerp.somee.com/apphuellero/DPBiocontrol.application?code="+ Ext.getCmp('sysPacienteHuella').getValue() +"&name=DEMO");
                                                        embed.launchClickOnce("http://190.147.69.221/huella/DPBiocontrol.application?code="+ Ext.getCmp('sysPacienteHuella').getValue() +"&name=DEMO");
                                                        //embed.launchClickOnce("http://www.lapatria.com");
                                                    }else{
                                                        if(Contenido[2] === "NO"){
                                                           Ext.MessageBox.show({
                                                                title: 'eOfiClinic',
                                                                msg: 'El Paciente ya tiene registrada una huella y no corresponde a la muestra.',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            }); 
                                                        }else{
                                                            if(Contenido[2] === "SI"){
                                                                Ext.getCmp('verHuella').doLayout();
                                                                var updater = Ext.getCmp('verHuella').getUpdater();
                                                                updater.setDefaultUrl('../../../app/controlador/pacientes/showhuella.php?pPaciente=' + Contenido[0]);
                                                                updater.refresh();
                                                            }
                                                        }
                                                    }
                                                    Ext.getCmp('sysPacienteHuellaID').clearValue();
                                                },
                                                failure: function(response,options){
                                                    Ext.MessageBox.show({
                                                        title: 'Error Conexión',
                                                        msg: 'La huella no ha sido reistrada.',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                    Ext.getCmp('sysPacienteHuellaID').clearValue();
                                                },
                                                scope:this 
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                html:'Haga Click en el cuadro y coloque la huella'
                            }
                        ]
                    },
                    verHuella
                ]
            }
        ];
        winRegistrarHuellaUi.superclass.initComponent.call(this);
    }
});
