/*
* @category    Formulario Verificar Huella
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winVerificarHuellaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Verificar Identidad por Huella ::.',
    width:650,
    autoHeight: true,
    modal: true,
    padding: 10,
    closable: false,
    id: 'winVerificarHuella',
    initComponent: function() {
        var verifyHuella = new Ext.Panel({ 
            autoLoad:{
                //url:'../../../app/controlador/pacientes/showhuella.php?pPaciente=0',
                scripts:true,
                scope:this
            },
            id:'verifyHuella',
            title: 'Verificacion del Paciente',
            //height: 310,
            autoHeight: true,
            autoScroll:true
        });
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                labelWidth: 1,
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            listeners:{
                                click : function(){
                                    Ext.getCmp('winVerificarHuella').close();
                                }
                            }
                        }
                    ]
                },
                items: [
                    verifyHuella
                ]
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                var updater = Ext.getCmp('verifyHuella').getUpdater();
                updater.setDefaultUrl('../../../app/controlador/pacientes/showhuella.php?pPaciente=' + Ext.getCmp('sysSearchPacienteHuellaID').getValue());
                updater.refresh();
            }}
        });
        winVerificarHuellaUi.superclass.initComponent.call(this);
    }
});
