/*
* @category    Programacion Eventos Formulario Manual Tarifario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmPaqueteServicio = Ext.extend(winFrmPaqueteServicioUi, {
    initComponent: function() {
        winFrmPaqueteServicio.superclass.initComponent.call(this);
        
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        el = Ext.get('idaplicacion');
        NOM_APLICACION = el.getValue();
        el = Ext.get('idxac');
        ID_CONSULTORIO = el.getValue();
        
        this.title = NOM_APLICACION + " .:: Paquete-Servicios ::.";
        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        if(NOM_APLICACION == "OfiClinic"){
            Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
            Ext.getCmp('fNomSede').setValue("");
            Ext.getCmp('fNomIPS').setValue("");
            Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        }else{
            Ext.getCmp('fNomEmpresa').setValue("");
            Ext.getCmp('fNomSede').setValue("");
            Ext.getCmp('fNomIPS').setValue("");
            Ext.getCmp('fNomUSR').setValue("");
        }
        
        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnAddPaquete = Ext.getCmp('btnAddPaquete').on("click",this.AddPaquete,this);
        var btnEditPaquete = Ext.getCmp('btnEditPaquete').on("click",this.EditPaquete,this);
        var btnAsociarPaquete = Ext.getCmp('btnAsociarPaquete').on("click",this.AsociarPaquete,this);
        var btnDesasociarPaquete = Ext.getCmp('btnDesasociarPaquete').on("click",this.DesasociarPaquete,this);
        

        var sm_gridmanualtarifario = Ext.getCmp('gridManualTarifario').getSelectionModel();
        sm_gridmanualtarifario.on("rowselect",this.UpdateConceptosxManual,this);
    },
    UpdateConceptosxManual: function(sm, rowIdx, r) {
        Ext.getCmp('gridConceptosxManual').store.setBaseParam('pManual',r.data.IdPaqueteServicio);
        Ext.getCmp('gridConceptosxManual').store.load();
    },
    SalirOpcion: function(){
        el = Ext.get('idaplicacion');
        var NOM_APLICACION = el.getValue();
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    
    AddPaquete: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddManualTarifario";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Manual Tarifario - Adicionar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            el = Ext.get('idaplicacion');
            var NOM_APLICACION = el.getValue();
            var winAddTipoHorario = new winFrmPaqueteServicioUi();
            winAddTipoHorario.title = NOM_APLICACION + ' .::Adicionar Paquete-Servicios::.';
            Ext.getCmp('intUsuario').setValue(ID_USUARIO);
            Ext.getCmp('btn_AdicionarPaquete').setVisible(true);
            Ext.getCmp('btn_ModificarPaquete').setVisible(false);
            var btn_AdicionarHorario = Ext.getCmp('btn_AdicionarPaquete').on("click",this.GuardarPaquete,this);
            var btn_SalirPaquete = Ext.getCmp('btn_SalirPaquete').on("click",this.CerrarVentana,this);
            winAddTipoHorario.show();
        }
    },
    AsociarPaquete: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AsocConceptoManualTarifario";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Manual Tarifario - Asociar Concepto:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridManualTarifario').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridManualTarifario').selModel.getSelections();
                var winAddTipoHorario = new winAsocConceptoPaqueteUi();
                winAddTipoHorario.title = NOM_APLICACION + ' .::Asociar Concepto a Paquete-Servicios ' + selections[0].json.Desripcion + '::.';
                Ext.getCmp('intUsuario').setValue(ID_USUARIO);
                Ext.getCmp('intIdPaqueteServicio').setValue(selections[0].json.IdPaqueteServicio);

                var btn_AsociarConceptoPaquete = Ext.getCmp('btn_AsociarConceptoPaquete').on("click",this.AsociarConceptoPaquete,this);
                var btn_SalirAsociarConceptoPaquete = Ext.getCmp('btn_SalirAsociarConceptoPaquete').on("click",this.CerrarVentanaAsociarConceptoPaquete,this);
                winAddTipoHorario.show();
            }
        }
    },
    AsociarConceptoPaquete: function(){
        Ext.Msg.show({
            title: 'Asociar Concepto al Paquete',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("ASOCIAR_CONCEPTO","SI","winAsocConceptoPaqueteUi","frmAsocConcepto","../../controlador/paqueteservicio/controlador_paqueteservicio.php","gridConceptosxManual");
                }
            }
        })    
    },
    DesasociarPaquete: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DesasocConceptoManualTarifario";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Manual Tarifario - Eliminar Concepto:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridConceptosxManual').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridConceptosxManual').selModel.getSelections();
                Ext.Msg.show({
                    title: 'Paquete-Servicios',
                    msg: 'Esta Seguro que Desea Eliminar el Concepto: ' + selections[0].json.DesProced + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            fnEliminarRegistros("../../controlador/paqueteservicio/controlador_paqueteservicio.php",{task: "DESASOCIAR_CONCEPTO", pManual: selections[0].json.IdPaqueteServicio, pConcepto: selections[0].json.IdProcedimiento}, 'gridConceptosxManual');
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }  
    },
    EditPaquete: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "EditManualTarifario";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Manual Tarifario - Modificar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridManualTarifario').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridManualTarifario').selModel.getSelections();
                var winAddTipoHorario = new winFrmPaqueteServicioUi();
                winAddTipoHorario.title = NOM_APLICACION + ' .::Modificar Paquete-Servicio::.';
                Ext.getCmp('intUsuario').setValue(ID_USUARIO);
                Ext.getCmp('btn_AdicionarPaquete').setVisible(false);
                Ext.getCmp('btn_ModificarPaquete').setVisible(true);
                Ext.getCmp('intIdPaqueteServicio').setValue(selections[0].json.IdPaqueteServicio);
                Ext.getCmp('strDescripcion').setValue(selections[0].json.Descripcion);
                if(selections[0].json.Activo == '1')
                    Ext.getCmp('bolActivo').setValue(true);
                else
                    Ext.getCmp('bolActivo').setValue(false);
                var btn_ModificarPaquete = Ext.getCmp('btn_ModificarPaquete').on("click",this.ModificarPaquete,this);
                var btn_SalirHorario = Ext.getCmp('btn_SalirPaquete').on("click",this.CerrarVentana,this);
                winAddTipoHorario.show();
            }
        }
    },
    GuardarPaquete: function(){
        Ext.Msg.show({
            title: 'Guardar Paquete-Servicios',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("INSERTAR","SI","winPaqueteServicioUi","frmPaquete","../../controlador/paqueteservicio/controlador_paqueteservicio.php","gridManualTarifario");
                }
            }
        });
    },
    ModificarPaquete: function(){
        Ext.Msg.show({
            title: 'Guardar Paquete-Servicios',
            msg: 'Esta Seguro que Desea Modificar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("MODIFICAR","SI","winPaqueteServicioUi","frmPaquete","../../controlador/paqueteservicio/controlador_paqueteservicio.php","gridManualTarifario");
                }
            }
        });
    },
    CerrarVentanaAsociarConceptoPaquete: function(){
        el = Ext.get('idaplicacion');
        var NOM_APLICACION = el.getValue();
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winAsocConceptoPaqueteUi').close();
                }
            }
        });
    },
    CerrarVentana: function(){
        el = Ext.get('idaplicacion');
        var NOM_APLICACION = el.getValue();
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winManualTarifaUi').close();
                }
            }
        });
    }
});


function fnEliminarRegistros(URL,arrParam, pGrid, arrParamStore)
{
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar los registros en estos momentos',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}

function fnGuardarRegistros(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
