/*
* @category    Formulario Grid Paquete Servicios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmPaqueteServicioUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Paquete-Servicios ::.',
    id: 'winFrmPaqueteServicio',
    closable:false,
    width:980,
    height:480,
    plain:true,
    resizable : false,
    y:120,
    //layout: 'fit',
    initComponent: function() {
        var mybbar = new utilBbarUi();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
               
        function renderEstado(value, p, record){
            switch (value){
                case "0":
                    return 'Negado';
                    break;
                default:
                    break;
            }
        }

        function DescripcionConcepto(val, x, store){
            var html = '<table><tr><td>'+val+'</td></tr></table>';
            return html;
        }
        
        Ext.util.Format.Currency = function(v)
        {
            return FormatoMoneda(v);
        };
        
        var st = new StoreGridPaqueteServicio();
        st.load();
        var stGridConcepto = new StoreGridConceptosxPaquete();
        
        this.bbar = mybbar;
        this.items = [
           {
                xtype: 'grid',
                id: 'gridManualTarifario',
                store: st,
                anchor: "100%",
                border: false,
                frame: true,
                height: 150,
                columns: [
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'IdPaqueteServicio',
                        id: 'IdPaqueteServicio'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción',
                        sortable: false,
                        width: 930,
                        dataIndex: 'Descripcion',
                        id: 'Descripcion'
                    }
                ],
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                viewConfig: {
                    getRowClass: function(record, index) {
                        if (record.get('Activo') == '0')
                            return 'Negado';
                        else
                            return;
                    }
                },
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'button',
                                text: 'Adicionar Paquete',
                                iconCls: 'btnAddRow',
                                id: 'btnAddPaquete'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Modificar Paquete',
                                iconCls: 'btnEditRow',
                                id: 'btnEditPaquete'
                            },
                            '->',
                            new Ext.app.SearchField({
                                id: 'qryxManualTarifario',
                                store: st,
                                params: {pEmpresa: Ext.get('idempresa').getValue(), start: 0, limit: 15},
                                ValparamP1: ID_EMPRESA,
                                emptyText: 'Escriba el criterio que desea buscar',
                                width: 120,
                                pLoadGrid: true,
                                pGrid: 'gridManualTarifario',
                                parrParam: {
                                    params:{
                                        pManual: 0
                                    }
                                }
                            })
                        ]
                    }
            },
            {
                xtype: 'grid',
                id: 'gridConceptosxManual',
                store: stGridConcepto,
                anchor: "100%",
                border: false,
                frame: true,
                height: 270,
                loadMask: true,
                stripeRows: true,
                title: 'Conceptos Asociados al Paquete',
                columns: [
                    {
                        xtype: 'gridcolumn',
                        header: 'IdPaqueteServicio',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'IdPaqueteServicio',
                        id: 'IdPaqueteServicio'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'IdProcedimiento',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'IdProcedimiento',
                        id: 'IdProcedimiento'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Activo',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'Activo',
                        id: 'Activo'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Usuario',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'Usuario',
                        id: 'Usuario'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Codigo',
                        sortable: true,
                        width: 100,
                        dataIndex: 'CodProced',
                        id: 'CodProced'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción',
                        sortable: true,
                        width: 700,
                        dataIndex: 'DesProced',
                        renderer: DescripcionConcepto,
                        id: 'DesProced'
                    },
                    {
                        header: 'Tarifa',
                        sortable: true,
                        width: 130,
                        renderer:  Ext.util.Format.Currency,
                        dataIndex: 'VlrTarifa',
                        align: 'right'
                    },
                ],
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'button',
                                text: 'Asociar Concepto al Paquete',
                                iconCls: 'btnAsociarConceptoMT',
                                id: 'btnAsociarPaquete'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Eliminar Concepto del Paquete',
                                iconCls: 'btnDesasociarConceptoMT',
                                id: 'btnDesasociarPaquete'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            '->',
                            new Ext.app.SearchField({
                                id: 'qryConceptosxManual',
                                store: stGridConcepto,
                                emptyText: 'Escriba el criterio que desea buscar',
                                width: 120
                            })
                        ]
                    },
                bbar: new Ext.PagingToolbar({
                    pageSize: 15,
                    store: stGridConcepto,
                    displayInfo: true
                })
            }
        ];
        winFrmPaqueteServicioUi.superclass.initComponent.call(this);
    }
});
