/*
* @category    Formulario POS (Punto de Venta Optica)
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

var xbtnValidarDoc = new btnValidarDoc({
    id: 'btnValidarDoc',
    ref: '../../../../../../btnValidarDoc'
});

winPOSOpticaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: POS - Optica ::.',
    width: 1024,
    //height: 646,
    autoHeight: true,
    closable: false,
    resizable: false,
    draggable: false,
    frame: true,
    id: 'winPOSOptica',
    initComponent: function() {
        
        var ID_VALIDAAUDITORIA = "0";
                
        Ext.util.Format.Currency = function(v)
        {
            return FormatoMoneda(v);
        };
        
        var dataTipoRegistrVenta = [
            //['C','COTIZACION'],
            ['P','VENTA A PARTICULARES'],
            ['I','VENTA INSTITUCIONAL']
        ];
        var stTipoRegistrVenta = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stTipoRegistrVenta.loadData(dataTipoRegistrVenta);
        
        var stBodegasUsuario = new StoreBodegas();
        stBodegasUsuario.load({
            params: {
                pIPS: ID_IPS,
                pUsuario: ID_USUARIO
            }
        });
        this.items = [
            {
                xtype: 'tabpanel',
                activeTab: 0,
                width: 990,
                height: 565,
                ref: 'fTabPanel',
                id: 'fTabPanel',
                frame: true,
                items: [
                    {
                        xtype: 'panel',
                        title: 'Registro',
                        height: 441,
                        width: 951,
                        id: 'fichaDatos',
                        autoScroll: true,
                        frame: true,
                        layout: 'form',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Punto Venta',
                                anchor: '100%',
                                allowBlank: false,
                                store: stBodegasUsuario,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'IdBodega',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'strBodegaVentaPOS'
                            },
                            {
                                xtype: 'form',
                                title: '',
                                padding: 5,
                                border: false,
                                ref: '../../frmRadica',
                                id: 'frmRadica',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Tipo',
                                        anchor: '100%',
                                        allowBlank: false,
                                        store: stTipoRegistrVenta,
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        id: 'strTipoVentaPOS'
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Datos del Cliente',
                                        layout: 'table',
                                        width: 949,
                                        height: 82,
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        id: 'fsCliente',
                                        layoutConfig: {
                                            columns: 4
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnCliete',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Cliente',
                                                        anchor: '100%',
                                                        name: 'cbCliente',
                                                        allowBlank: false,
                                                        store: 'StoreCliente',
                                                        displayField: 'Descripcion',
                                                        valueField: 'IdCliente',
                                                        emptyText: 'Selecione Cliente....',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        listWidth: 450,
                                                        typeAhead: true,
                                                        autoSelect: false,
                                                        typeAheadDelay: 50,
                                                        submitValue: true,
                                                        enableKeyEvents: true,
                                                        triggerAction: 'all',
                                                        ref: '../../../../../fCliente',
                                                        disabled: true,
                                                        id: 'fCliente'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 274,
                                                border: false,
                                                id: 'pnPlan',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Plan',
                                                        anchor: '100%',
                                                        name: 'cbPlan',
                                                        allowBlank: false,
                                                        mode: 'local',
                                                        store: 'StoreClientesPlan',
                                                        valueField: 'IdPlan',
                                                        displayField: 'Descripcion',
                                                        typeAhead: true,
                                                        triggerAction: 'all',
                                                        disabled: true,
                                                        typeAheadDelay: 50,
                                                        listWidth: 450,
                                                        emptyText: 'Selecione Plan....',
                                                        forceSelection: true,
                                                        ref: '../../../../../fPlan',
                                                        id: 'fPlan'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 215,
                                                border: false,
                                                id: 'pnSubplan',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Sub Plan',
                                                        anchor: '100%',
                                                        name: 'cbSubplan',
                                                        allowBlank: false,
                                                        disabled: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        store: 'StoreClienteSubplan',
                                                        displayField: 'Descripcion',
                                                        valueField: 'IdSubPlan',
                                                        mode: 'local',
                                                        emptyText: 'Selecione Sub Plan....',
                                                        listWidth: 450,
                                                        forceSelection: true,
                                                        ref: '../../../../../fSubPlan',
                                                        id: 'fSubPlan'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                border: false,
                                                width: 172,
                                                id: 'pnContrato',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Contrato',
                                                        anchor: '100%',
                                                        name: 'cbContrato',
                                                        allowBlank: false,
                                                        disabled: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        store: 'StoreClienteContrato',
                                                        valueField: 'IdContrato',
                                                        displayField: 'Contrato',
                                                        mode: 'local',
                                                        listWidth: 450,
                                                        emptyText: 'Selecione Contrato....',
                                                        forceSelection: true,
                                                        ref: '../../../../../fContrato',
                                                        id: 'fContrato'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtUsaListado',
                                                ref: '../../../../fUsaListado',
                                                id: 'fUsaListado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtAtenderFueraListado',
                                                ref: '../../../../fAtenderFueraListado',
                                                id: 'fAtenderFueraListado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtRequiereAutorizacion',
                                                ref: '../../../../fRequiereAutorizacion',
                                                id: 'fRequiereAutorizacion',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtFacturarParticular',
                                                ref: '../../../../fFacturarParticular',
                                                id: 'fFacturarParticular',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtMaxCopago',
                                                ref: '../../../../fMaxCopago',
                                                id: 'fMaxCopago',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'fFacturarCopagos',
                                                id: 'fFacturarCopagos',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'fCopagoDigitado',
                                                id: 'fCopagoDigitado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'fvlrCuotaModeradoraIndicada',
                                                id: 'fvlrCuotaModeradoraIndicada',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'fPorCopagos',
                                                id: 'fPorCopagos',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtUsaAuditoria',
                                                ref: '../../../../fUsaAuditoria',
                                                id: 'fUsaAuditoria',
                                                value: 0
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Datos del Solicitante',
                                        layout: 'table',
                                        width: 949,
                                        height: 82,
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        id: 'fsSolicitud',
                                        layoutConfig: {
                                            columns: 5
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 120,
                                                border: false,
                                                id: 'pnFecSol',
                                                items: [
                                                    {
                                                        xtype: 'datefield',
                                                        fieldLabel: 'Fecha Solicitud',
                                                        anchor: '100%',
                                                        name: 'txtFecSol',
                                                        allowBlank: false,
                                                        style: 'text-align:center;',
                                                        emptyText: '(dia/mes/año) ',
                                                        ref: '../../../../../fFecSol',
                                                        disabled: true,
                                                        value: new Date().format('d/m/Y'),
                                                        id: 'fFecSol'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 200,
                                                border: false,
                                                colspan: 1,
                                                iconCls: '',
                                                id: 'pnAutorizacion',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Autorización',
                                                        anchor: '100%',
                                                        name: 'txtAutorizacion',
                                                        style: 'text-transform:uppercase;',
                                                        allowBlank: false,
                                                        disabled: true,
                                                        ref: '../../../../../fAutorizacion',
                                                        id: 'fAutorizacion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                border: false,
                                                width: 340,
                                                colspan: 2,
                                                id: 'pnProfesional',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Profesional / IPS  Solicitante',
                                                                name: 'cbProfeSol',
                                                                allowBlank: false,
                                                                store: 'StoreProfeSol',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                emptyText: 'Seleccione Profesional / IPS Solicitante....',
                                                                valueField: 'idProfeSolicitante',
                                                                displayField: 'Descripcion',
                                                                width: 300,
                                                                listWidth: 450,
                                                                submitValue: true,
                                                                ref: '../../../../../fProfeSol',
                                                                disabled: true,
                                                                id: 'fProfeSol'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnDoctor',
                                                                tooltip: 'Adicionar Profesional / IPS Solicitante',
                                                                ref: '../../../../btnVerificaPacienteListado',
                                                                id: 'btnAddProfeSol'
                                                            }
                                                        ]
                                                    }
                                                 ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 340,
                                                border: false,
                                                colspan: 1,
                                                id: 'pnPrograma',
                                                items: [
                                                    {
                                                        xtype: 'hidden',
                                                        fieldLabel: 'Programa y/o Tipo de Atención',
                                                        anchor: '100%',
                                                        name: 'cbPrograma',
                                                        allowBlank: true,
                                                        //store: 'StorePrograma',
                                                        //forceSelection: true,
                                                        //triggerAction: 'all',
                                                        //typeAhead: true,
                                                        //typeAheadDelay: 50,
                                                        //mode: 'local',
                                                        //valueField: 'IdPrograma',
                                                        //displayField: 'Descripcion',
                                                        //emptyText: 'Seleccione Programa....',
                                                        //submitValue: true,
                                                        ref: '../../../../../fPrograma',
                                                        disabled: true,
                                                        id: 'fPrograma'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtFinalidad',
                                                ref: '../../../../fFinalidad',
                                                id: 'fFinalidad',
                                                value: '10'
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtExento',
                                                ref: '../../../../fExentoPrograma',
                                                id: 'fExentoPrograma',
                                                value: 0
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Datos del Tercero',
                                        layout: 'table',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        width: 949,
                                        //height: 317,
                                        autoHeight: true,
                                        id: 'fsPaciente',
                                        layoutConfig: {
                                            columns: 4
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnTdoc',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo Doc ID',
                                                        anchor: '100%',
                                                        name: 'cbTdoc',
                                                        allowBlank: false,
                                                        //store: 'StoreTdocPac',
                                                        store: 'StoreTdocPac',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Tipo Documento....',
                                                        mode: 'local',
                                                        triggerAction: 'all',
                                                        forceSelection: true,
                                                        ref: '../../../../../fTdoc',
                                                        disabled: true,
                                                        id: 'fTdoc'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 269,
                                                border: false,
                                                id: 'pnDocID',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Documento ID',
                                                                name: 'txtDocID',
                                                                allowBlank: false,
                                                                //anchor: '100%',
                                                                width: 200,
                                                                ref: '../../../../../fDocID',
                                                                disabled: true,
                                                                id: 'fDocID'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Paciente',
                                                                id: 'btnBuscarPacienteRadica'
                                                            }/*,
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnUsrVerifica',
                                                                tooltip: 'Verificar Paciente en el Listado de Atención',
                                                                ref: '../../../../btnVerificaPacienteListado',
                                                                id: 'btnVerificaPacienteListado'
                                                            }*/
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 215,
                                                border: false,
                                                colspan: 1,
                                                id: 'pnRegimen',
                                                items: [
                                                    {
                                                        xtype: 'hidden', //'combo',
                                                        fieldLabel: 'Régimen / Tipo Usuario',
                                                        anchor: '100%',
                                                        name: 'cbRegimen',
                                                        //allowBlank: false,
                                                        allowBlank: true,
                                                        //store: 'StoreTipoRegimen',
                                                        //valueField: 'Codigo',
                                                        //displayField: 'Descripcion',
                                                        //triggerAction: 'all',
                                                        //typeAhead: true,
                                                        //typeAheadDelay: 50,
                                                        //mode: 'local',
                                                        //emptyText: 'Seleccione Régimen/Tipo Usuario....',
                                                        //forceSelection: true,
                                                        //value: '1 - Contributivo',
                                                        //listWidth: 350,
                                                        disabled: true,
                                                        ref: '../../../../../fRegimen',
                                                        id: 'fRegimen'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 172,
                                                border: false,
                                                colspan: 1,
                                                id: 'pnGenero',
                                                items: [
                                                    {
                                                        xtype: 'hidden', //'combo',
                                                        fieldLabel: 'Genero',
                                                        anchor: '100%',
                                                        name: 'cbGenero',
                                                        //allowBlank: false,
                                                        allowBlank: true,
                                                        //store: 'StoreGenero',
                                                        //valueField: 'Codigo',
                                                        //displayField: 'Descripcion',
                                                        //triggerAction: 'all',
                                                        //typeAhead: true,
                                                        //typeAheadDelay: 50,
                                                        //mode: 'local',
                                                        //emptyText: 'Seleccione Genero....',
                                                        //forceSelection: true,
                                                        disabled: true,
                                                        ref: '../../../../../fGenero',
                                                        id: 'fGenero'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnApe1',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: '1er Apellido',
                                                        anchor: '100%',
                                                        name: 'txtApe1',
                                                        style: 'text-transform:uppercase;',
                                                        allowBlank: false,
                                                        disabled: true,
                                                        ref: '../../../../../fApe1',
                                                        id: 'fApe1'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnApe2',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: '2do Apellido',
                                                        anchor: '100%',
                                                        name: 'txtApe2',
                                                        style: 'text-transform:uppercase;',
                                                        ref: '../../../../../fApe2',
                                                        disabled: true,
                                                        id: 'fApe2'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 215,
                                                border: false,
                                                id: 'pnNom1',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: '1er Nombre',
                                                        anchor: '100%',
                                                        name: 'txtNom1',
                                                        allowBlank: false,
                                                        style: 'text-transform:uppercase;',
                                                        disabled: true,
                                                        ref: '../../../../../fNom1',
                                                        id: 'fNom1'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                border: false,
                                                width: 172,
                                                id: 'pnNom2',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: '2do Nombre',
                                                        anchor: '100%',
                                                        name: 'txtNom2',
                                                        disabled: true,
                                                        style: 'text-transform:uppercase;',
                                                        id: 'fNom2'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 146,
                                                border: false,
                                                id: 'pnFecNac',
                                                items: [
                                                    {
                                                        xtype: 'hidden', // 'datefield',
                                                        fieldLabel: 'Fecha Nacimiento',
                                                        anchor: '100%',
                                                        name: 'txtFecNac',
                                                        allowBlank: true,
                                                        //disabledDates: '',
                                                        //emptyText: '(dia/mes/año) ',
                                                        //style: 'text-align:center;',
                                                        ref: '../../../../../fFecNac',
                                                        disabled: true,
                                                        id: 'fFecNac'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnEdad',
                                                items: [
                                                    {
                                                        xtype: 'hidden', // 'textfield',
                                                        fieldLabel: 'Edad Actual',
                                                        anchor: '100%',
                                                        name: 'txtEdad',
                                                        readOnly: true,
                                                        //allowBlank: true,
                                                        //style: 'color: blue;text-align:center',
                                                        //disabled: true,
                                                        ref: '../../../../../fEdad',
                                                        id: 'fEdad'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 386,
                                                border: false,
                                                colspan: 2,
                                                id: 'pnDeptoMuni',
                                                items: [
                                                    {
                                                        xtype: 'hidden', // 'combo',
                                                        fieldLabel: 'Municipio - Departamento',
                                                        anchor: '100%',
                                                        name: 'cbDeptoMuni',
                                                        allowBlank: true,
                                                        //store: 'StoreDeptoMuni',
                                                        //valueField: 'IdDeptoMunicipio',
                                                        //displayField: 'Descripcion',
                                                        //emptyText: 'Seleccione Municipio - Departamento....',
                                                        //mode: 'local',
                                                        //listWidth: 450,
                                                        //forceSelection: true,
                                                        //typeAhead: true,
                                                        //typeAheadDelay: 10,
                                                        ref: '../../../../../fDeptoMuni',
                                                        disabled: true,
                                                        id: 'fDeptoMuni'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 928,
                                                border: false,
                                                colspan: 4,
                                                height: 54,
                                                id: 'pnDatDirTel',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        fieldLabel: 'Dirección - Teléfono - Teléfono (Otro - Cel.) - Zona - Email',
                                                        anchor: '100%',
                                                        id: 'composDatDirTel',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtDireccion',
                                                                allowBlank: false,
                                                                emptyText: 'Dirección....',
                                                                style: 'text-transform:uppercase;',
                                                                width: 250,
                                                                ref: '../../../../../../fDireccion',
                                                                disabled: true,
                                                                id: 'fDireccion'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtTel1',
                                                                allowBlank: false,
                                                                emptyText: 'Teléfono',
                                                                width: 160,
                                                                disabled: true,
                                                                id: 'fTel1'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtTel2',
                                                                emptyText: 'Teléfono (Otro - Cel.)',
                                                                width: 160,
                                                                disabled: true,
                                                                id: 'fTel2'
                                                            },
                                                            {
                                                                xtype: 'hidden',//'combo',
                                                                fieldLabel: 'Zona',
                                                                //store: 'StoreZonaResidencia',
                                                                //valueField: 'Codigo',
                                                                //displayField: 'Descripcion',
                                                                //mode: 'local',
                                                                //name: 'cbZona',
                                                                //emptyText: 'Zona....',
                                                                allowBlank: true,
                                                                //forceSelection: true,
                                                                //typeAhead: true,
                                                                //typeAheadDelay: 50,
                                                                width: 80,
                                                                value: 'Urbana',
                                                                //triggerAction: 'all',
                                                                ref: '../../../../../../fZona',
                                                                disabled: true,
                                                                id: 'fZona'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtEmail',
                                                                vtype: 'email',
                                                                emptyText: 'Email....',
                                                                width: 140,
                                                                disabled: true,
                                                                id: 'fEmail'
                                                            },
                                                            /*{
                                                                xtype: 'button',
                                                                tooltip: 'Limpiar Datos del Paciente',
                                                                iconCls: 'btnLimpiar',
                                                                id: 'btnLimpiarPac_citas'
                                                            },*/
                                                            {
                                                                xtype: 'button',
                                                                text: 'Actualiza',
                                                                tooltip: 'Actualizar Datos del Paciente',
                                                                iconCls: 'btnGuardar',
                                                                iconAlign: 'right',
                                                                ref: '../../../../btnActualizaPac',
                                                                id: 'btnActualizaPac'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnTafiliado',
                                                items: [
                                                    {
                                                        xtype:'hidden',// 'combo',
                                                        fieldLabel: 'Tipo de Afiliado',
                                                        anchor: '100%',
                                                        name: 'cbTafiliado',
                                                        allowBlank: true,
                                                        listEmptyText: 'Seleccione',
                                                        //store: 'StoreTipoAfiliado',
                                                        //forceSelection: true,
                                                        //triggerAction: 'all',
                                                        //typeAhead: true,
                                                        //typeAheadDelay: 50,
                                                        //mode: 'local',
                                                        //emptyText: 'Seleccione Tipo de Afiliado....',
                                                        //valueField: 'Codigo',
                                                        //displayField: 'Descripcion',
                                                        //tpl: '',
                                                        ref: '../../../../../fTafiliado',
                                                        disabled: true,
                                                        id: 'fTafiliado'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnTafiliacion',
                                                items: [
                                                    {
                                                        xtype:'hidden',// 'combo',
                                                        fieldLabel: 'Parentesco',
                                                        anchor: '100%',
                                                        name: 'cbParentesco',
                                                        allowBlank: true,
                                                        //listEmptyText: 'Seleccione',
                                                        //store: 'StoreParentesco',
                                                        //forceSelection: true,
                                                        //triggerAction: 'all',
                                                        //mode: 'local',
                                                        //typeAhead: true,
                                                        //typeAheadDelay: 50,
                                                        //emptyText: 'Seleccione Parentesco....',
                                                        //valueField: 'Codigo',
                                                        //displayField: 'Descripcion',
                                                        disabled: true,
                                                        ref: '../../../../../fParentesco',
                                                        id: 'fParentesco'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 213,
                                                border: false,
                                                id: 'pnRango',
                                                items: [
                                                    {
                                                        xtype: 'hidden',
                                                        fieldLabel: 'Rango Salarial',
                                                        anchor: '100%',
                                                        name: 'cbRango',
                                                        allowBlank: true,
                                                        //listEmptyText: 'Seleccione',
                                                        //store: 'StoreRangoSal',
                                                        //forceSelection: true,
                                                        //triggerAction: 'all',
                                                        //typeAhead: true,
                                                        //typeAheadDelay: 50,
                                                        //mode: 'local',
                                                        //emptyText: 'Seleccione Rango Salarial....',
                                                        //valueField: 'Codigo',
                                                        //displayField: 'Descripcion',
                                                        //tpl: '<tpl for="."><div class="cbRango"><h3>{Descripcion}</h3><p style="font-size: 12; color: #AA0033">Valor: $ {VlrCuotaModeradora}</p><p style="font-size: 11; color: #0000EE ">Porcentaje: {txtPorcentaje} %</p><p style="font-size: 10; color: #33373d">{Observaciones}</p><hr /></div></tpl>',
                                                        //itemSelector: 'div.cbRango',
                                                        //listWidth: 450,
                                                        //autoHeight: true,
                                                        ref: '../../../../../fRango',
                                                        disabled: true,
                                                        id: 'fRango'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 170,
                                                border: false,
                                                id: 'pnEstado',
                                                items: [
                                                    {
                                                        xtype: 'hidden',
                                                        fieldLabel: 'Estado - Listado Atención',
                                                        anchor: '100%',
                                                        name: 'cbEstado',
                                                        allowBlank: true,
                                                        //listEmptyText: 'Seleccione',
                                                        //store: 'StoreEstadoLA',
                                                        //forceSelection: true,
                                                        //triggerAction: 'all',
                                                        //mode: 'local',
                                                        //typeAhead: true,
                                                        //typeAheadDelay: 50,
                                                        //emptyText: 'Estado Actual....',
                                                        //valueField: 'Codigo',
                                                        //displayField: 'Descripcion',
                                                        //disabled: true,
                                                        //autoSelect: false,
                                                        ref: '../../../../../fEstado',
                                                        id: 'fEstado'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdEmpresa',
                                                id: 'fIdEmpresa',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdSede',
                                                id: 'fIdSede',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdIPS',
                                                id: 'fIdIPS',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdPaciente',
                                                id: 'fIdPaciente',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtExcento',
                                                id: 'fExento',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtTutela',
                                                id: 'fTutela',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtClieteLA',
                                                id: 'fClienteLA',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtPlanLA',
                                                id: 'fPlanLA',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtSubPlanLA',
                                                id: 'fSubPlanLA',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtPacienteValido',
                                                id: 'fPacienteValido',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtYaLiquidado',
                                                id: 'fYaLiquidado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtYaLegalizado',
                                                id: 'fYaLegalizado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtYaGuardo',
                                                id: 'fYaGuardo',
                                                value: 0
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        title: 'Conceptos Solicitados',
                                        layout: 'vbox',
                                        frame: true,
                                        width: 950,
                                        height: 465,
                                        ref: '../fichaServicios',
                                        id: 'fichaServicios',
                                        layoutConfig: {
                                            align: 'stretch'
                                        },
                                        items: [
                                            {
                                                xtype: 'grid',
                                                id: 'gridConceptosRegistroVenta',
                                                store: 'DTSConceptosRegistroVenta', 
                                                anchor: "100%",
                                                border: false,
                                                frame: true,
                                                flex: 1,
                                                height: 190,
                                                columns: [
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: '#',
                                                        sortable: false,
                                                        width: 50,
                                                        dataIndex: 'IDReg',
                                                        id: 'IDReg'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Codigo',
                                                        sortable: false,
                                                        width: 100,
                                                        dataIndex: 'CodConceptoItem',
                                                        id: 'CodConceptoItem'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Descripcion',
                                                        sortable: false,
                                                        width: 450,
                                                        dataIndex: 'DesConceptoItem',
                                                        id: 'DesConceptoItem'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Lote',
                                                        sortable: false,
                                                        width: 70,
                                                        dataIndex: 'DesLoteConceptoItem',
                                                        id: 'DesLoteConceptoItem'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Cantidad',
                                                        sortable: false,
                                                        width: 60,
                                                        dataIndex: 'CantidadItem',
                                                        id: 'CantidadItem'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'SubTotal',
                                                        sortable: false,
                                                        width: 110,
                                                        renderer:  Ext.util.Format.Currency,
                                                        dataIndex: 'VlrTotalItem',
                                                        id: 'VlrTotalItem'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'CM',
                                                        sortable: false,
                                                        width: 110,
                                                        renderer:  Ext.util.Format.Currency,
                                                        dataIndex: 'VlrCuotaModeradoraItem',
                                                        id: 'VlrCuotaModeradoraItem'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'COP',
                                                        sortable: false,
                                                        width: 110,
                                                        renderer:  Ext.util.Format.Currency,
                                                        dataIndex: 'VlrCopagoItem',
                                                        id: 'VlrCopagoItem'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Desc',
                                                        sortable: false,
                                                        width: 110,
                                                        renderer:  Ext.util.Format.Currency,
                                                        dataIndex: 'VlrDescuentosItem',
                                                        id: 'VlrDescuentosItem'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Empresa',
                                                        sortable: false,
                                                        width: 110,
                                                        renderer:  Ext.util.Format.Currency,
                                                        dataIndex: 'VlrEmpresaItem',
                                                        id: 'VlrEmpresaItem'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'VlrNeto',
                                                        sortable: false,
                                                        width: 110,
                                                        renderer:  Ext.util.Format.Currency,
                                                        dataIndex: 'VlrNetoItem',
                                                        id: 'VlrNetoItem'
                                                    }
                                                ],
                                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                stripeRows: true,
                                                tbar:
                                                {
                                                    xtype: 'toolbar',
                                                    items: [
                                                        {
                                                            xtype: 'button',
                                                            text: 'Adicionar Registro',
                                                            iconCls: 'btnAddRow',
                                                            id: 'btnAddRegistroConcepto'
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        },
                                                        {
                                                            xtype: 'button',
                                                            text: 'Eliminar Registro',
                                                            iconCls: 'btnDelRow',
                                                            id: 'btnDelRegistroConcepto'
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        }
                                                    ]
                                                }
                                            },
                                            {
                                                xtype: 'panel',
                                                title: 'Información Detallada del Concepto',
                                                autoHeight: true,
                                                padding: 10,
                                                autoScroll: true,
                                                ref: '../../pnDetalleServicio',
                                                id: 'pnDetalleServicio',
                                                flex: 1,
                                                tpl: [
                                                    '<table border="0" width="890"><tr><td class="ServicioID">{TituloItem}</td></tr></table>',
                                                    '<table border="0" width="890">',
                                                    '<tr>',
                                                    '<td width="310">',
                                                    '<table border="0" width="290">',
                                                    '<tr><td width="150">Cantidad:</td><td align="right" width="130">{CantidadItem}</td></tr>',
                                                    '<tr><td width="150">Tarifa:</td><td align="right" width="130">{VlrTotalItem:usMoney}</td></tr>',
                                                    '<tr><td width="150">Cuota Moderadora:</td><td align="right" width="130">{VlrCuotaModeradoraItem:usMoney}</td></tr>',
                                                    '<tr><td width="150">Copagos:</td><td align="right" width="130">{VlrCopagoItem:usMoney}</td></tr>',
                                                    '<tr><td width="150">Descuentos:</td><td align="right" width="130">{VlrDescuentosItem:usMoney}</td></tr>',
                                                    '<tr><td width="150">Empresa:</td><td align="right" width="130">{VlrEmpresaItem:usMoney}</td></tr>',
                                                    '<tr><td width="150">Neto a Pagar:</td><td align="right" width="130">{VlrNetoItem:usMoney}</td></tr>',
                                                    '</table>',
                                                    '</td>',
                                                    '<td>',
                                                    '<br><center><p style="font-size:34px, color:#000, text-align:center,"><b>LENTES</b></p>',
                                                    '<table width="440" border="1" cellspacing="0">',
                                                    '<tr>',
                                                    '<td width="50" align="center" style="border: 1px solid #000, font-size:27px, color:#000, text-align:center,"></td>',
                                                    '<td width="57" align="center" style="border: 1px solid #000, font-size:27px, color:#000, text-align:center,"><b>Esf:</b></td>',
                                                    '<td width="56" align="center" style="border: 1px solid #000, font-size:27px, color:#000, text-align:center,"><b>Cil:</b></td>',
                                                    '<td width="56" align="center" style="border: 1px solid #000, font-size:27px, color:#000, text-align:center,"><b>Eje:</b></td>',
                                                    '<td width="57" align="center" style="border: 1px solid #000, font-size:27px, color:#000, text-align:center,"><b>Add:</b></td>',
                                                    '<td width="57" align="center" style="border: 1px solid #000, font-size:27px, color:#000, text-align:center,"><b>AVFL:</b></td>',
                                                    '<td width="57" align="center" style="border: 1px solid #000, font-size:27px, color:#000, text-align:center,"><b>AVFP:</b></td>',
                                                    '</tr>',
                                                    '<tr>',
                                                    '<td width="50" style="border: 1px solid #000, font-size:27px, color:#000, text-align:center,"><b>Rx OD</b></td>',
                                                    '<td width="57" align="center" style="border: 1px solid #000, font-size:27px, color:#000, text-align:center,">{REFRACTIVO_RxOD_Esf}</td>',
                                                    '<td width="56" align="center" style="border: 1px solid #000, font-size:27px, color:#000, text-align:center,">{REFRACTIVO_RxOD_Cil}</td>',
                                                    '<td width="56" align="center" style="border: 1px solid #000, font-size:27px, color:#000, text-align:center,">{REFRACTIVO_RxOD_Eje}</td>',
                                                    '<td width="57" align="center" style="border: 1px solid #000, font-size:27px, color:#000, text-align:center,">{REFRACTIVO_RxOD_Add}</td>',
                                                    '<td width="57" align="center" style="border: 1px solid #000, font-size:27px, color:#000, text-align:center,">{REFRACTIVO_RxOD_AVFL}</td>',
                                                    '<td width="57" align="center" style="border: 1px solid #000, font-size:27px, color:#000, text-align:center,">{REFRACTIVO_RxOD_AVFP}</td>',
                                                    '</tr>',
                                                    '<tr>',
                                                    '<td width="50" style="border: 1px solid #000, font-size:27px, color:#000, text-align:center,"><b>Rx OI</b></td>',
                                                    '<td width="57" align="center" style="border: 1px solid #000, font-size:27px, color:#000, text-align:center,">{REFRACTIVO_RxOI_Esf}</td>',
                                                    '<td width="56" align="center" style="border: 1px solid #000, font-size:27px, color:#000, text-align:center,">{REFRACTIVO_RxOI_Cil}</td>',
                                                    '<td width="56" align="center" style="border: 1px solid #000, font-size:27px, color:#000, text-align:center,">{REFRACTIVO_RxOI_Eje}</td>',
                                                    '<td width="57" align="center" style="border: 1px solid #000, font-size:27px, color:#000, text-align:center,">{REFRACTIVO_RxOI_Add}</td>',
                                                    '<td width="57" align="center" style="border: 1px solid #000, font-size:27px, color:#000, text-align:center,">{REFRACTIVO_RxOI_AVFL}</td>',
                                                    '<td width="57" align="center" style="border: 1px solid #000, font-size:27px, color:#000, text-align:center,">{REFRACTIVO_RxOI_AVFP}</td>',
                                                    '</tr>',
                                                    '</table>',
                                                    '</center>',
                                                    '<span><b>COLOR Y TRATAMIENTOS: </b>{COLOR_TTO}</span><br>',
                                                    '<span><b>DESCRIPCION: </b>{COLOR_TTO_DESCRIPCION}</span><br>',
                                                    '<span><b>MONTURA: </b>{MONTURA}</span><br>',
                                                    '<span><b>H: </b>{MONTURA_H}&nbsp;&nbsp;<b>V: </b>{MONTURA_V}&nbsp;&nbsp;<b>D: </b>{MONTURA_D}&nbsp;&nbsp;<b>P: </b>{MONTURA_P}&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>NP - OD: </b>{MONTURA_NP_OD}&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b> - OI:</b>{MONTURA_NP_OI}</span><br>',
                                                    '<span><b>LABORATORIO: </b>{LABORATORIO_OBS}</span>',
                                                    '</td>',
                                                    '</tr>',
                                                    '</table>',
                                                    '</tpl>'
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        frame: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'numericfield',
                                                currencySymbol: "$",
                                                useThousandSeparator: true,
                                                alwaysDisplayDecimals: true,
                                                thousandSeparator: ',',
                                                minValue: 0,
                                                decimalPrecision: 2,
                                                fieldLabel: 'SubTotal',
                                                style: 'background-color:#69F; font-size: 13px; font-weight: bold; text-align:right;',
                                                allowBlank: true,
                                                readOnly: true,
                                                width: 150,
                                                value: 0,
                                                id: 'sysSubTotVenta'
                                            },
                                            {
                                                html: ' + CuotaMod:'
                                            },
                                            {
                                                xtype: 'numericfield',
                                                currencySymbol: "$",
                                                useThousandSeparator: true,
                                                alwaysDisplayDecimals: true,
                                                thousandSeparator: ',',
                                                minValue: 0,
                                                decimalPrecision: 2,
                                                style: 'background-color:#69F; font-size: 13px; font-weight: bold; text-align:right;',
                                                allowBlank: true,
                                                readOnly: true,
                                                width: 150,
                                                value: 0,
                                                id: 'sysCMVenta'
                                            },
                                            {
                                                html: ' &nbsp;&nbsp;&nbsp;&nbsp;+ Copagos:'
                                            },
                                            {
                                                xtype: 'numericfield',
                                                currencySymbol: "$",
                                                useThousandSeparator: true,
                                                alwaysDisplayDecimals: true,
                                                thousandSeparator: ',',
                                                minValue: 0,
                                                decimalPrecision: 2,
                                                style: 'background-color:#69F; font-size: 13px; font-weight: bold; text-align:right;',
                                                allowBlank: true,
                                                readOnly: true,
                                                width: 150,
                                                value: 0,
                                                id: 'sysCOPVenta'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        frame: true,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'numericfield',
                                                fieldLabel: 'Descuentos',
                                                currencySymbol: "$",
                                                useThousandSeparator: true,
                                                alwaysDisplayDecimals: true,
                                                thousandSeparator: ',',
                                                minValue: 0,
                                                decimalPrecision: 2,
                                                style: 'background-color:#F0C8C6; font-size: 13px; font-weight: bold; text-align:right;',
                                                allowBlank: true,
                                                readOnly: true,
                                                width: 150,
                                                value: 0,
                                                id: 'sysDescuentoVenta'
                                            },
                                            {
                                                html: ' &nbsp;&nbsp;&nbsp;- Empresa:'
                                            },
                                            {
                                                xtype: 'numericfield',
                                                currencySymbol: "$",
                                                useThousandSeparator: true,
                                                alwaysDisplayDecimals: true,
                                                thousandSeparator: ',',
                                                minValue: 0,
                                                decimalPrecision: 2,
                                                style: 'background-color:#F0C8C6; font-size: 13px; font-weight: bold; text-align:right;',
                                                allowBlank: true,
                                                readOnly: true,
                                                width: 150,
                                                value: 0,
                                                id: 'sysEmpresaVenta'
                                            },
                                            {
                                                html: '&nbsp;= Vlr a Pagar:'
                                            },
                                            {
                                                xtype: 'numericfield',
                                                currencySymbol: "$",
                                                useThousandSeparator: true,
                                                alwaysDisplayDecimals: true,
                                                thousandSeparator: ',',
                                                minValue: 0,
                                                decimalPrecision: 2,
                                                style: 'background-color:#CFC; font-size: 13px; font-weight: bold; text-align:right;',
                                                allowBlank: true,
                                                readOnly: true,
                                                width: 150,
                                                value: 0,
                                                id: 'sysSaldoVenta'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'hidden',
                                        allowBlank: true,
                                        readOnly: true,
                                        width: 150,
                                        value: 0,
                                        id: 'sysIVAVenta'
                                    },
                                    {
                                        xtype: 'hidden',
                                        name: 'txtCas',
                                        id: 'fCas',
                                        value: 0
                                    },
                                    {
                                        xtype: 'hidden',
                                        name: 'txtCas',
                                        id: 'fModificaCAS',
                                        value: 0
                                    },
                                    {
                                        xtype: 'grid',
                                        title: 'Registro de Pagos',
                                        store: 'StoreLegalizacionesxCAS',
                                        height: 235,
                                        border: true,
                                        id: 'gridFacturacionOrden',
                                        tbar: {
                                            xtype: 'toolbar',
                                            items: [
                                                /*{
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Anular Documento',
                                                    iconCls: 'btnCancelar',
                                                    id: 'btnAnularDocumentoFac'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },*/
                                                {
                                                    xtype: 'tbfill'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Imprimir Documento',
                                                    iconCls: 'btnImprimir',
                                                    id: 'btnImprimirDocumentoFac'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        },
                                        bbar: {
                                            xtype: 'toolbar',
                                            items: [
                                                {
                                                    xtype: 'tbseparator'
                                                },
                                                {
                                                    xtype: 'button',
                                                    text: 'Aplicar Pago Particulares',
                                                    iconCls: 'btnLiquidar',
                                                    id: 'btnPagoDocumentoFac'
                                                },
                                                {
                                                    xtype: 'tbseparator'
                                                }
                                            ]
                                        },
                                        columns: [
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha',
                                                sortable: true,
                                                width: 100,
                                                dataIndex: 'FechaMov'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Prefijo',
                                                sortable: true,
                                                width: 70,
                                                dataIndex: 'Prefijo',
                                                align: 'center'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'NroDocumento',
                                                sortable: true,
                                                width: 125,
                                                dataIndex: 'NroDocumento',
                                                align: 'center'
                                            },
                                            {
                                                type: 'gridcolumn',
                                                header: 'Credito',
                                                sortable: true,
                                                width: 180,
                                                renderer:  Ext.util.Format.Currency,
                                                dataIndex: 'Credito',
                                                align: 'right'
                                                //summaryType: 'sum'
                                            },
                                            {
                                                type: 'gridcolumn',
                                                header: 'Debito',
                                                sortable: true,
                                                width: 180,
                                                renderer:  Ext.util.Format.Currency,
                                                dataIndex: 'Debito',
                                                align: 'right'
                                                //summaryType: 'sum'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
        this.tbar = {
            xtype: 'toolbar',
            id: 'tbar',
            items: [
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Nuevo',
                    iconCls: 'btnNuevo',
                    ref: '../btnNuevo',
                    id: 'btnNuevo'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Buscar',
                    iconCls: 'btnBuscar',
                    ref: '../btnBuscarRadica',
                    id: 'btnBuscarRadica'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Generar Registro de Venta /Cotizacion',
                    iconCls: 'btnGuardar',
                    ref: '../btnRadicar',
                    id: 'btnRadicar'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'textfield',
                    value: '',
                    width: 110,
                    readOnly: true,
                    name: 'sysTextoEliminado',
                    style: 'background:transparent;color: darkred; font-size: large; font-weight: bold;border:none;',
                    id: 'sysTextoEliminado',
                    listeners:{
                        render: function( p ) {
                            p.getEl().on('dblclick', function (){
                                alert("Ver Quien Modifico");
                            });
                        }
                    }
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Reactivar CAS',
                    iconCls: 'btnAceptar',
                    id: 'btnReactivarCAS'
                },        
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'Sin Registrar',
                    name: 'txtNroCAS',
                    style: 'color: darkblue; font-size: large; font-weight: bold;',
                    ref: '../fNroCAS',
                    id: 'fNroCAS'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    name: 'txtFecRadicado',
                    style: 'color: darkblue; font-size: 13px; font-weight: bold;',
                    ref: '../fFecRadicado',
                    id: 'fFecRadicado'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    name: 'txtEstadoCAS',
                    style: 'color: red; font-size: 13px; font-weight: bold;text-decoration: blink;',
                    ref: '../fEstadoCAS',
                    id: 'fEstadoCAS'
                }
            ]
        };
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnAyuda',
                    tooltip: 'Ver Ayuda en Linea',
                    ref: '../btnAyuda',
                    id: 'btnAyuda'
                },
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'displayfield',
                    value: 'Empresa: PASBISALUD IPS',
                    name: 'txtNomEmpresa',
                    ref: '../fNomEmpresa',
                    id: 'fNomEmpresa'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'Sede: MANIZALES',
                    name: 'txtNomSede',
                    ref: '../fNomSede',
                    id: 'fNomSede'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'IPS: BELEN',
                    name: 'txtNomSede',
                    ref: '../fNomIPS',
                    id: 'fNomIPS'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnUsr',
                    ref: '../btnUsr',
                    id: 'btnUsr'
                },
                {
                    xtype: 'displayfield',
                    value: 'Usuario: GJUAN ',
                    name: 'txtNomUSR',
                    style: 'color:royalblue',
                    ref: '../fNomUSR',
                    id: 'fNomUSR'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    ref: '../btnSalir',
                    id: 'btnSalir'
                }
            ]
        };
        winPOSOpticaUi.superclass.initComponent.call(this);
    }
});
