/*
* @category    Programacion Eventos Formulario Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmProfesionales = Ext.extend(winFrmProfesionalesUi, {
    initComponent: function() {
        winFrmProfesionales.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        ID_PLANTILLA_CITAS = 0;
        ID_PROFESIONAL_EDIT = 0;
        ID_PLANTILLA_CITAS_ACT = 0;
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        Ext.getCmp('gridFormulario').store.load({params: {query: null, pEmpresa: ID_EMPRESA, start: 0, limit: 15}});

        Ext.getCmp('btnNoFilterItemGrid').setVisible(false);
        
        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnAddItemGrid = Ext.getCmp('btnAddItemGrid').on("click",this.AddItemGrid,this);
        var btnDelItemGrid = Ext.getCmp('btnDelItemGrid').on("click",this.DelItemGrid,this);
        var btnEditItemGrid = Ext.getCmp('btnEditItemGrid').on("click",this.EditItemGrid,this);

        var btnGrouping1 = Ext.getCmp('btnGrouping1').on("click",this.GroupingGrid1,this);
        var btnGrouping2 = Ext.getCmp('btnGrouping2').on("click",this.GroupingGrid2,this);
        var btnExcelItems = Ext.getCmp('btnExcelItems').on("click",this.ExcelGrid,this);
        var btnImprimirItems = Ext.getCmp('btnImprimirItems').on("click",this.ImprimirGrid,this);
        var btnFilterItemGrid = Ext.getCmp('btnFilterItemGrid').on("click",this.LlamarFiltro,this);
        var btnNoFilterItemGrid = Ext.getCmp('btnNoFilterItemGrid').on("click",this.QuitarFiltro,this);

    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    LlamarFiltro: function(){
        var winFilterProfesionales = new winFilterProfesionalesUi();
        var btn_CancelFiltroProfe = Ext.getCmp('btn_CancelFiltroProfe').on("click",this.CancelarVentanaFiltro,this);
        var btn_FiltroProfe = Ext.getCmp('btn_FiltroProfe').on("click",this.AplicarFiltro,this);
        
        winFilterProfesionales.show();
    },
    AplicarFiltro: function(){
        Ext.Msg.show({
            title: 'Búsqueda....!',
            msg: 'Esta seguro que desea aplicar los criterios de búsqueda?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    if (Ext.getCmp('strqryDocumentoProfe').getValue() == null || Ext.getCmp('strqryDocumentoProfe').getValue() == "")
                    {
                        Ext.getCmp('sysProfeDocumento').setValue(0);
                    }else{
                        Ext.getCmp('sysProfeDocumento').setValue(Ext.getCmp('strqryDocumentoProfe').getValue());
                    }
                    if (Ext.getCmp('strqryNombreProfe').getValue() == null || Ext.getCmp('strqryNombreProfe').getValue() == "")
                    {
                        Ext.getCmp('sysProfeNombre').setValue("Todos");
                    }else{
                        Ext.getCmp('sysProfeNombre').setValue(Ext.getCmp('strqryNombreProfe').getValue());
                    }
                    if (Ext.getCmp('strqryEspecialidadProfe').getValue() == null || Ext.getCmp('strqryEspecialidadProfe').getValue() == "")
                    {
                        Ext.getCmp('sysProfeEspecialidad').setValue("Todos");
                    }else{
                        Ext.getCmp('sysProfeEspecialidad').setValue(Ext.getCmp('strqryEspecialidadProfe').getValue());
                    }
                    if (Ext.getCmp('strqryTipoProfe').getValue() == null || Ext.getCmp('strqryTipoProfe').getValue() == "")
                    {
                        Ext.getCmp('sysProfeTipo').setValue("0");
                    }else{
                        Ext.getCmp('sysProfeTipo').setValue(Ext.getCmp('strqryTipoProfe').getValue());
                    }
                    Ext.getCmp('gridFormulario').store.reload({
                        params: {
                            task: 'BUSCAR',
                            query: Ext.getCmp('sysProfeNombre').getValue(),
                            pDocumento: Ext.getCmp('sysProfeDocumento').getValue(),
                            pEspecialidad: Ext.getCmp('sysProfeEspecialidad').getValue(),
                            pTipo: Ext.getCmp('sysProfeTipo').getValue(),
                            start: 0,
                            limit: 15
                        }
                    });
                    if (Ext.getCmp('sysProfeNombre').getValue() == "Todos" && Ext.getCmp('sysProfeDocumento').getValue() == 0 && Ext.getCmp('sysProfeEspecialidad').getValue() == "Todos" && Ext.getCmp('sysProfeTipo').getValue() == "0")
                    {
                        Ext.getCmp('btnNoFilterItemGrid').setVisible(false);
                        Ext.getCmp('btnFilterItemGrid').setVisible(true);
                    }else{
                        Ext.getCmp('btnNoFilterItemGrid').setVisible(true);
                        Ext.getCmp('btnFilterItemGrid').setVisible(false);
                    }
                    Ext.getCmp('winFilterProfesionales').close();
                }
            }
        });
    },
    CancelarVentanaFiltro: function(){
        Ext.getCmp('winFilterProfesionales').close();
    },
    QuitarFiltro: function(){
        Ext.Msg.show({
            title: 'Quitar Búsqueda....!',
            msg: 'Esta seguro que desea quitar los criterios de búsqueda?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    Ext.getCmp('sysProfeDocumento').setValue(0);
                    Ext.getCmp('sysProfeNombre').setValue("Todos");
                    Ext.getCmp('sysProfeEspecialidad').setValue("Todos");
                    Ext.getCmp('sysProfeTipo').setValue("0");
                    Ext.getCmp('gridFormulario').store.reload({
                        params: {
                            task: 'BUSCAR',
                            query: Ext.getCmp('sysProfeNombre').getValue(),
                            pDocumento: Ext.getCmp('sysProfeDocumento').getValue(),
                            pEspecialidad: Ext.getCmp('sysProfeEspecialidad').getValue(),
                            pTipo: Ext.getCmp('sysProfeTipo').getValue(),
                            start: 0,
                            limit: 15
                        }
                    });
                    Ext.getCmp('btnNoFilterItemGrid').setVisible(false);
                    Ext.getCmp('btnFilterItemGrid').setVisible(true);
                }
            }
        });
    },
    GroupingGrid1: function(){
        Ext.getCmp('gridFormulario').store.clearGrouping();
        Ext.getCmp('gridFormulario').store.groupBy("TipoProfe");
    },
    GroupingGrid2: function(){
        Ext.getCmp('gridFormulario').store.clearGrouping();
        Ext.getCmp('gridFormulario').store.groupBy("Especialidad");
    },
    ExcelGrid: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "ExcelProfesionales";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Exportar a Excel:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            //location.href='../../controlador/agendas/tipo_horario_excel.php?pEmpresa='+ID_EMPRESA+'&query='+Ext.getCmp('qryTipoHorario').getValue();
        }
    },
    ImprimirGrid: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "PrintProfesionales";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Imprimir:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            //location.href='../../controlador/agendas/tipo_horario_print.php?pEmpresa='+ID_EMPRESA+'&query='+Ext.getCmp('qryTipoHorario').getValue();
        }
    },
    AddItemGrid: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddProfesionales";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Adicionar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            var winAddProfesional = new winProfesionalesUi();
            winAddProfesional.title = 'eOfiClinic .::Adicionar Profesionales::.';
            Ext.getCmp('btn_AdicionarItemFrm').setVisible(true);
            Ext.getCmp('btn_ModificarItemFrm').setVisible(false);
            Ext.getCmp('systxtusr').setVisible(false);
            Ext.getCmp('sysUsuario').setVisible(false);
            Ext.getCmp('systxtfec').setVisible(false);
            Ext.getCmp('sysFechaAct').setVisible(false);
            Ext.getCmp('intUsuario').setValue(ID_USUARIO);
            Ext.getCmp('bolActivo').setValue("true");
            Ext.getCmp('bolModificaKardex').setValue("true");
            Ext.getCmp('bolProgramarAgenda').setValue("true");
            Ext.getCmp('tbOpcionesProfesionales').setVisible(false);
            
            var btn_AdicionarItemFrm = Ext.getCmp('btn_AdicionarItemFrm').on("click",this.GuardarItem,this);
            var btn_SalirItemFrm = Ext.getCmp('btn_SalirItemFrm').on("click",this.CerrarVentana,this);
            winAddProfesional.show();
        }
    },
    EditItemGrid: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "EditProfesionales";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Modificar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
                ID_PROFESIONAL_EDIT = selections[0].json.idrecord;
                var winEditProfesional = new winProfesionalesUi();
                winEditProfesional.title = 'eOfiClinic .::Modificar Profesionales::.';
                Ext.getCmp('btn_AdicionarItemFrm').setVisible(false);
                Ext.getCmp('btn_ModificarItemFrm').setVisible(true);
                Ext.getCmp('systxtusr').setVisible(false);
                Ext.getCmp('sysUsuario').setVisible(false);
                Ext.getCmp('systxtfec').setVisible(true);
                Ext.getCmp('sysFechaAct').setVisible(true);
                Ext.getCmp('intUsuario').setValue(ID_USUARIO);
                Ext.getCmp('sysUsuario').setValue(selections[0].json.Usuario);
                Ext.getCmp('sysUsuario').addClass('field_quienmodifico')
                Ext.getCmp('sysFechaAct').setValue(selections[0].json.FechaAct);
                Ext.getCmp('sysFechaAct').addClass('field_quienmodifico')
                Ext.getCmp('intidProfesional').setValue(selections[0].json.idrecord);
                Ext.getCmp('intDocProfesional').setValue(selections[0].json.documento);
                Ext.getCmp('strRegistroProfesional').setValue(selections[0].json.registro);
                Ext.getCmp('strDescripcion').setValue(selections[0].json.descripcion);
                Ext.getCmp('strTipoProfesional').setValue(selections[0].json.tipoprofe);
                Ext.getCmp('strIdEspecialidad').setValue(selections[0].json.especialidad);
                Ext.getCmp('strDireccion').setValue(selections[0].json.direccion);
                Ext.getCmp('strTelefono').setValue(selections[0].json.telefono);
                Ext.getCmp('strEmail').setValue(selections[0].json.email);
                if (selections[0].json.programar == "SI")
                    Ext.getCmp('bolProgramarAgenda').setValue("true");
                else
                    Ext.getCmp('bolProgramarAgenda').setValue(null);

                if (selections[0].json.modificar == "SI")
                    Ext.getCmp('bolModificaKardex').setValue("true");
                else
                    Ext.getCmp('bolModificaKardex').setValue(null);

                if (selections[0].json.activo == "SI")
                    Ext.getCmp('bolActivo').setValue("true");
                else
                    Ext.getCmp('bolActivo').setValue(null);

                Ext.getCmp('gridSedesIPSxProfe').store.load({
                    params: {
                        task: 'GRID_SEDE_IPS',
                        pEmpresa: ID_EMPRESA,
                        pProfesional: selections[0].json.idrecord
                    }
                });
                Ext.getCmp('gridPlantillasxProfe').store.load({
                    params: {
                        task: 'GRID_PLANTILLA_CITAS',
                        pEmpresa: ID_EMPRESA,
                        pProfesional: selections[0].json.idrecord
                    }
                });
                Ext.getCmp('gridPlantillasResxProcexProfe').store.load({
                    params: {
                        task: 'GRID_PLANTILLA_PROCED',
                        pEmpresa: ID_EMPRESA,
                        pProfesional: selections[0].json.idrecord
                    }
                });
                Ext.getCmp('gridProgProcedxProfe').store.load({
                    params: {
                        task: 'GRID_PROCEDIMIENTOS',
                        pProfesional: selections[0].json.idrecord
                    }
                });
                Ext.getCmp('gridConsultoriosIPSxProfe').store.load({
                    params: {
                        pProfesional: selections[0].json.idrecord,
                        pIPS: ID_IPS
                    }
                });
				Ext.getCmp('gridPlantillasHCxProfe').store.load({
                    params: {
                        pProfesional: selections[0].json.idrecord
                    }
                });
                
                var btn_ModificarItemFrm = Ext.getCmp('btn_ModificarItemFrm').on("click",this.ModificarItem,this);
                var btn_SalirItemFrm = Ext.getCmp('btn_SalirItemFrm').on("click",this.CerrarVentana,this);
                var btnAddItemGridSedeIPS = Ext.getCmp('btnAddItemGridSedeIPS').on("click",this.AdiconarItemGridSedeIPS,this);
                var btnDelItemGridSedeIPS = Ext.getCmp('btnDelItemGridSedeIPS').on("click",this.EliminarSedeGridSedeIPS,this);
                var gridPlantillasxProfe = Ext.getCmp('gridPlantillasxProfe').on("rowclick",this.SeleccionarPlantillaCita,this);
                var btnAddItemGridPlantilla = Ext.getCmp('btnAddItemGridPlantilla').on("click",this.AdicionarPlantillaGridPlantilla,this);
                //var btnDelItemGridPlantilla = Ext.getCmp('btnDelItemGridPlantilla').on("click",this.EliminarPlantillaGridPlantilla,this);
                var btnAddItemGridHorarioPlantilla = Ext.getCmp('btnAddItemGridHorarioPlantilla').on("click",this.AdicionarHorarioGridPlantilla,this);
                var btnDelItemGridHorarioPlantilla = Ext.getCmp('btnDelItemGridHorarioPlantilla').on("click",this.EliminarHorarioGridPlantilla,this);
                var btnAddItemGridProcedxProfe = Ext.getCmp('btnAddItemGridProcedxProfe').on("click",this.AdicionarProcedGridProgramar,this);
                var btnDelItemGridProcedxProfe = Ext.getCmp('btnDelItemGridProcedxProfe').on("click",this.EliminarProcedGridProgramar,this);
                var btnAddItemGridAgendaProgramar = Ext.getCmp('btnAddItemGridAgendaProgramar').on("click",this.AdicionarAgendaGridProgramar,this);
                var btnDelItemGridAgendaProgramar = Ext.getCmp('btnDelItemGridAgendaProgramar').on("click",this.EliminarAgendaGridProgramar,this);
                var btnSearchItemGridAgendaProgramar = Ext.getCmp('btnSearchItemGridAgendaProgramara').on("click",this.BuscarAgendaGridProgramar,this);
                var btnEditItemGridAgendaProgramar = Ext.getCmp('btnEditItemGridAgendaProgramar').on("click",this.EditarAgendaGridProgramar,this);
                var btnAddItemGridConsultorios = Ext.getCmp('btnAddItemGridConsultorios').on("click",this.AsociarConsultorioxProfe,this);
                var btnDelItemGridConsultorios = Ext.getCmp('btnDelItemGridConsultorios').on("click",this.DesasociarConsultorioxProfe,this);
                var smGridPlantillaResProced = Ext.getCmp('gridPlantillasResxProcexProfe').getSelectionModel();
                smGridPlantillaResProced.on("rowselect",this.UpdateDetallePlantillaResxProced,this);
                var btnAddItemGridPlantillaProced = Ext.getCmp('btnAddItemGridPlantillaProced').on("click",this.AddPlantillaResxProced,this);
                var btnDelItemGridPlantillaProced = Ext.getCmp('btnDelItemGridPlantillaProced').on("click",this.DelPlantillaResxProced,this);
                var btnEditItemGridPlantillaProced = Ext.getCmp('btnEditItemGridPlantillaProced').on("click",this.EditPlantillaResxProced,this);
                var btnAddIPlantillaHCxProfe = Ext.getCmp('btnAddIPlantillaHCxProfe').on("click",this.AddPlantillaHCxProfe,this);
                var btnDelIPlantillaHCxProfe = Ext.getCmp('btnDelIPlantillaHCxProfe').on("click",this.DelPlantillaHCxProfe,this);
                var btnDeshabItemGridPlantilla = Ext.getCmp('btnDeshabItemGridPlantilla').on("click",this.DeshabilitarPlantilla,this);
                winEditProfesional.show();
            }
        }
    },
    AddPlantillaHCxProfe: function(){
        //Adicionar Plantilla
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddPlantillas_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Plantilla HC:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            var winPlantillaHCProfe = new winAddPlantillaHCProfeUi();
            //var btn_SalirPlantillaHC = Ext.getCmp('btn_SalirPlantillaProced').on("click",this.CerrarVentanaPlantillaHC,this);
            var btn_AsociarPlantillaHC = Ext.getCmp('btn_AsociarPlantillaHC').on("click",this.GuardarPlantillaHC,this);
            Ext.getCmp('intProfesionalPalntillaHC').setValue(Ext.getCmp('intidProfesional').getValue());
            winPlantillaHCProfe.show();
        }
    },
    CerrarVentanaPlantillaHC: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winAddPlantillaHCProfeUi').close();
                }
            }
        });
    },
    GuardarPlantillaHC: function(){
        if(Ext.getCmp('intPalntillaHCxProfe').getValue() == null || Ext.getCmp('intPalntillaHCxProfe').getValue() == ""){
            Ext.Msg.show({
                title: 'Error',
                msg: 'El campo de Plantilla HC es obligatorio',
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.ERROR
            });
        }else{
            Ext.Msg.show({
                title: 'Guardar Plantilla',
                msg: 'Esta Seguro que Desea Guardar la Información?',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn)
                {
                    if(btn=="yes")
                    {
                        fnGuardarRegistros("GRID_PLANTILLAHC_INSERTAR","SI","winAddPlantillaHCProfeUi","frmPlantillaHCxProfe","../../controlador/profesionales/controlador_profesionales201601.php","gridPlantillasHCxProfe");
                    }
                }
            });
        }
    },
    DelPlantillaHCxProfe: function(){
        //Eliminar Plantilla
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DelPlantillas_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir){
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Plantilla HC - Eliminar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else{
            if(Ext.getCmp('gridPlantillasHCxProfe').selModel.getCount() == 1){
                var selections = Ext.getCmp('gridPlantillasHCxProfe').selModel.getSelections();
                Ext.Msg.show({
                    title: 'Plantilla HC',
                    msg: 'Esta Seguro que Desea Eliminar la Plantilla ' + selections[0].json.NomPlantilla + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            fnEliminarRegistros("../../controlador/profesionales/controlador_profesionales201601.php",{task: "GRID_PLANTILLAHC_ELIMINAR", pidPlantillaHCxProfe: selections[0].json.IdRegistro}, 'gridPlantillasHCxProfe');
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    CerrarVentanaPlantillaProced: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winPlantillaResultadoxProced').close();
                }
            }
        });
    },
    
    GuardarPlantillaProced: function(){
        if(Ext.getCmp('memHTMLformatoPlantilla').getValue() == null || Ext.getCmp('memHTMLformatoPlantilla').getValue() == ""){
            Ext.Msg.show({
                title: 'Error',
                msg: 'El campo de formato de la plantilla es obligatorio',
                buttons: Ext.Msg.OK,
                icon: Ext.Msg.ERROR
            });
        }else{
            Ext.Msg.show({
                title: 'Guardar Plantilla',
                msg: 'Esta Seguro que Desea Guardar la Información?',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn)
                {
                    if(btn=="yes")
                    {
                        fnGuardarRegistros("GRID_PLANTILLA_PROCED_INSERTAR","SI","winPlantillaResultadoxProced","frmPlantillaResProcedxProfe","../../controlador/profesionales/controlador_profesionales.php","gridPlantillasResxProcexProfe");
                    }
                }
            });
        }
    },
    DelPlantillaResxProced: function(){
        //Eliminar Plantilla
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DelPlantillas_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Plantilla Procedimientos - Eliminar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridPlantillasResxProcexProfe').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridPlantillasResxProcexProfe').selModel.getSelections();
                Ext.Msg.show({
                    title: 'Plantilla de Procedimientos',
                    msg: 'Esta Seguro que Desea Eliminar la Plantilla ' + selections[0].json.nomPlantilla + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            fnEliminarRegistros("../../controlador/profesionales/controlador_profesionales.php",{task: "GRID_PLANTILLA_PROCED_ELIMINAR", pidPlantillaProcedxProfe: selections[0].json.idPlantillaProcedxProfe}, 'gridPlantillasResxProcexProfe')
                            Ext.getCmp('sysDetallePlantillaProcedimiento').setValue(" ");
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    EditPlantillaResxProced: function(){
        //Adicionar Plantilla
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddPlantillas_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Plantilla Procedimientos:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridPlantillasResxProcexProfe').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridPlantillasResxProcexProfe').selModel.getSelections();
                Ext.Msg.show({
                    title: 'Plantilla de Procedimientos',
                    msg: 'Esta Seguro que Desea Modificar la Plantilla ' + selections[0].json.nomPlantilla + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            var winPlantillaResProced = new winPlantillaResultadoxProcedUi();
                            Ext.getCmp('btn_AsociarPlantillaProced').setVisible(false);
                            Ext.getCmp('btn_EditPlantillaProced').setVisible(true);
                            Ext.getCmp('intUsuarioPlantillaProced').setValue(ID_USUARIO);
                            Ext.getCmp('intIdProfesionalPlantillaProced').setValue(selections[0].json.idProfesional);
                            Ext.getCmp('intIdPlantillaProcedxProfe').setValue(selections[0].json.idPlantillaProcedxProfe);
                            Ext.getCmp('intIdProcedimiento').setValue(selections[0].json.IdProced);
                            Ext.getCmp('sysCodConcepto').setValue(selections[0].json.CodProced);
                            Ext.getCmp('sysDesConcepto').setValue(selections[0].json.DesProced);
                            Ext.getCmp('strnomPlantilla').setValue(selections[0].json.nomPlantilla);
                            Ext.getCmp('memHTMLformatoPlantilla').setValue(selections[0].json.formatoPlantilla);
                            //var btn_SalirPlantillaProced = Ext.getCmp('btn_SalirPlantillaProced').on("click",this.CerrarVentanaPlantillaProced,this);
                            //var btn_EditPlantillaProced = Ext.getCmp('btn_EditPlantillaProced').on("click",this.ModificarPlantillaProced,this);
                            var btn_SalirPlantillaProced = Ext.getCmp('btn_SalirPlantillaProced').on("click",function(){
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Esta seguro que desea cerrar la ventana?',
                                    buttons: Ext.Msg.YESNO,
                                    icon: Ext.Msg.QUESTION,
                                    fn: function(btn)
                                    {
                                        if(btn=="yes")
                                        {
                                           Ext.getCmp('winPlantillaResultadoxProced').close();
                                        }
                                    }
                                });
                            },this);
                            var btn_EditPlantillaProced = Ext.getCmp('btn_EditPlantillaProced').on("click",function(){
                                if(Ext.getCmp('memHTMLformatoPlantilla').getValue() == null || Ext.getCmp('memHTMLformatoPlantilla').getValue() == ""){
                                    Ext.Msg.show({
                                        title: 'Error',
                                        msg: 'El campo de formato de la plantilla es obligatorio',
                                        buttons: Ext.Msg.OK,
                                        icon: Ext.Msg.ERROR
                                    });
                                }else{
                                    Ext.Msg.show({
                                        title: 'Guardar Plantilla',
                                        msg: 'Esta Seguro que Desea Guardar la Información?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn)
                                        {
                                            if(btn=="yes")
                                            {
                                                fnGuardarRegistros("GRID_PLANTILLA_PROCED_MODIFICAR","SI","winPlantillaResultadoxProced","frmPlantillaResProcedxProfe","../../controlador/profesionales/controlador_profesionales.php","gridPlantillasResxProcexProfe");
                                            }
                                        }
                                    });
                                }
                            },this);
                            winPlantillaResProced.show();
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos Modificar el registro en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    AddPlantillaResxProced: function(){
        //Adicionar Plantilla
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddPlantillas_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Plantilla Procedimientos:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            var winPlantillaResProced = new winPlantillaResultadoxProcedUi();
            var btn_SalirPlantillaProced = Ext.getCmp('btn_SalirPlantillaProced').on("click",this.CerrarVentanaPlantillaProced,this);
            var btn_AsociarPlantillaProced = Ext.getCmp('btn_AsociarPlantillaProced').on("click",this.GuardarPlantillaProced,this);
            Ext.getCmp('btn_AsociarPlantillaProced').setVisible(true);
            Ext.getCmp('btn_EditPlantillaProced').setVisible(false);
            Ext.getCmp('intUsuarioPlantillaProced').setValue(ID_USUARIO);
            Ext.getCmp('intIdProfesionalPlantillaProced').setValue(Ext.getCmp('intidProfesional').getValue());
            winPlantillaResProced.show();
        }
    },
    UpdateDetallePlantillaResxProced: function(sm, rowIdx, r) {
        Ext.getCmp('sysDetallePlantillaProcedimiento').setValue(r.data.formatoPlantilla);
    },
    DesasociarConsultorioxProfe: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DelConsultorio_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Asociar Consultorios - Eliminar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridConsultoriosIPSxProfe').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridConsultoriosIPSxProfe').selModel.getSelections();
                Ext.Msg.show({
                    title: 'Plantilla de Citas',
                    msg: 'Esta Seguro que Desea Eliminar el Consultorio ' + selections[0].json.Consultorio + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            fnEliminarRegistros("../../controlador/profesionales/controlador_profesionales.php",{task: "GRID_CONSULTORIOS_ELIMINAR", pProfesional: selections[0].json.idProfesional, pIPS: selections[0].json.idIPS, pConsultorio: selections[0].json.idConsultorio}, 'gridConsultoriosIPSxProfe')
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    AsociarConsultorioxProfe: function(){
        //Adicionar Plantilla
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddConsultorio_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Asociar Consultorios:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            var winAsociarConsultoriosProfe = new winAsociarConsultoriosProfeUi();
            winAsociarConsultoriosProfe.title = 'eOfiClinic .::Asociar Consultorio::.';
            var btnGuardarAsociarConsultorios = Ext.getCmp('btnGuardarAsociarConsultorios').on("click",this.GuardarConsultorioxProfe,this);
            Ext.getCmp('intidProfesionalGridConsultorios').setValue(Ext.getCmp('intidProfesional').getValue());
            Ext.getCmp('intidIPSGridConsultorios').setValue(ID_IPS);
            Ext.getCmp('intidConsultorioGridConsultorios').store.load({
                params: {
                    pIPS: ID_IPS
                }
            });
            winAsociarConsultoriosProfe.show();
        }
    },
    GuardarConsultorioxProfe: function(){
        Ext.Msg.show({
            title: 'Guardar Consultorio',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("GRID_CONSULTORIOS_INSERTAR","SI","winAsociarConsultoriosProfeUi","frmAsociarConsultoriosProfe","../../controlador/profesionales/controlador_profesionales.php","gridConsultoriosIPSxProfe");
                }
            }
        });
    },
    BuscarAgendaGridProgramar: function(){
        Ext.getCmp('gridProgramaAgendaxProfe').store.load({
            params: {
                task: 'GRID_AGENDA_PROGRAMADAS',
                pEmpresa: ID_EMPRESA,
                pProfesional: Ext.getCmp('intidProfesional').getValue(),
                pIps: ID_IPS,
                pDesde: Ext.getCmp('Desde').getValue().format('Y-m-d'),
                pHasta: Ext.getCmp('Hasta').getValue().format('Y-m-d'),
                pConsultorio: Ext.getCmp('intidConsultorioxIPS').getValue()
            }
        });
    },
    DeshabilitarPlantilla: function(){
        //Eliminar Plantilla
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id){
            return record.get('codOpcion') == "DelPlantillas_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir){
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Plantilla Citas - Deshabilitar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else{
            if(Ext.getCmp('gridPlantillasxProfe').selModel.getCount() == 1){
                var selections = Ext.getCmp('gridPlantillasxProfe').selModel.getSelections();
                Ext.Msg.show({
                    title: 'Plantilla de Citas',
                    msg: 'Esta Seguro que Desea Deshabilitar la Plantilla ' + selections[0].json.Descripcion + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn){
                        if(btn=="yes"){
                            fnDeshabilitarRegistros("../../controlador/profesionales/controlador_profesionales1701.php",{task: "GRID_PLANTILLA_CITAS_DESHABILITAR", pPlantilla: selections[0].json.idPlantilla}, 'gridPlantillasxProfe')
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    EliminarPlantillaGridPlantilla: function(){
        //Eliminar Plantilla
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DelPlantillas_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Plantilla Citas - Eliminar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridPlantillasxProfe').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridPlantillasxProfe').selModel.getSelections();
                Ext.Msg.show({
                    title: 'Plantilla de Citas',
                    msg: 'Esta Seguro que Desea Eliminar la Plantilla ' + selections[0].json.Descripcion + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            fnEliminarRegistros("../../controlador/profesionales/controlador_profesionales.php",{task: "GRID_PLANTILLA_CITAS_ELIMINAR", pPlantilla: selections[0].json.idPlantilla}, 'gridPlantillasxProfe')
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    AdicionarPlantillaGridPlantilla: function(){
        //Adicionar Plantilla
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddPlantillas_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Plantilla Citas - Adicionar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            var winAdicionarPlantillaCitasProfe = new winAdicionarPlantillaCitasProfeUi();
            var btnGuardarPlantilla = Ext.getCmp('btnGuardarPlantilla').on("click",this.GuardarItemPlantilla,this);
            winAdicionarPlantillaCitasProfe.title = 'eOfiClinic .:: Adicionar Plantilla de Citas ::.';
            Ext.getCmp('intidPrestadorGridPlantilla').setValue(ID_EMPRESA);
            Ext.getCmp('intidProfesionalGridPlantilla').setValue(Ext.getCmp('intidProfesional').getValue());
            Ext.getCmp('intidUsuarioGridPlantilla').setValue(ID_USUARIO);
            winAdicionarPlantillaCitasProfe.show();
        }
    },
    GuardarItemPlantilla: function(){
        Ext.Msg.show({
            title: 'Guardar Plantilla',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("GRID_PLANTILLA_CITAS_INSERTAR","SI","winAdicionarPlantillaCitasProfeUi","frmAdicionarPlantillaCitasProfe","../../controlador/profesionales/controlador_profesionales.php","gridPlantillasxProfe");
                }
            }
        });
    },
    AdicionarHorarioGridPlantilla: function(){
        //Adicionar Horario Plantilla
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddPlantillasHorario_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Plantilla Citas - Adicionar Horario:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if (ID_PLANTILLA_CITAS == 0)
            {
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'La plantilla de citas no ha sido creada o no esta disponible',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }else{
                if(parseInt(ID_PLANTILLA_CITAS_ACT) === 1){
                    var winAddHorarioxPlantilla = new winAdicionarHorarioPlantillaCitasProfeUi();
                    winAddHorarioxPlantilla.title = 'eOfiClinic .:: Adicionar Horario a Plantilla de Citas ::.';
                    Ext.getCmp('intidPlantillaGridHorario').setValue(ID_PLANTILLA_CITAS);
                    Ext.getCmp('intidUsuarioGridHorario').setValue(ID_USUARIO);
                    winAddHorarioxPlantilla.show();
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'La plantilla no esta disponible',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    },
    GuardarItemHorarioPlantilla: function(){
        Ext.Msg.show({
            title: 'Guardar Horario Plantilla',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("GRID_PLANTILLA_CITAS_HORARIO_INSERTAR","SI","winAdicionarHorarioPlantillaCitasProfe","frmAdicionarHorarioPlantillaCitasProfe","../../controlador/profesionales/controlador_profesionales.php","gridPlantillasHorarioxProfe");
                }
            }
        });
    },
    EliminarHorarioGridPlantilla: function(){
        //Eliminar Horario Plantilla
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id){
            return record.get('codOpcion') == "DelPlantillasHorario_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir){
            Ext.example.Tiempo = 3;
            Ext.example.msg('Plantilla Citas - Eliminar Horario:', "Usted no tiene acceso a esta opción del sistema...!");
        }else{
            if(parseInt(ID_PLANTILLA_CITAS_ACT) === 1){
                var Registros;
                Registros = Ext.getCmp('gridPlantillasHorarioxProfe').selModel.getCount();
                if(Registros > 0){
                    Ext.Msg.show({
                        title: 'eOfiClinic',
                        msg: 'Esta Seguro que Desea Eliminar los Horarios Seleccionados?',
                        buttons: Ext.Msg.YESNO,
                        icon: Ext.Msg.QUESTION,
                        fn: function(btn)
                        {
                            if(btn=="yes")
                            {
                                var selections = Ext.getCmp('gridPlantillasHorarioxProfe').selModel.getSelections();
                                var prez = [];
                                for(i = 0; i < Registros; i++){
                                    prez.push(selections[i].json.idTipoHorario);
                                }
                                var encoded_array = Ext.encode(prez);
                                fnEliminarRegistros("../../controlador/profesionales/controlador_profesionales.php",{task: "GRID_PLANTILLA_CITAS_HORARIO_ELIMINAR", pPlantilla: selections[0].json.idPlantilla, pHorarios: encoded_array}, 'gridPlantillasHorarioxProfe');
                            }
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar los registros en estos momentos, verifique haya seleccionado registros',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'La plantilla no esta disponible',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    AdicionarProcedGridProgramar: function(){
        //Adicionar Procedimiento a Programar
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddProced_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Procedimientos a Programar - Adicionar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            var winAdicionarProcedimientoAgendarProfe = new winAdicionarProcedimientoAgendarProfeUi();
            Ext.getCmp('intidProfesionalGridProced').setValue(Ext.getCmp('intidProfesional').getValue());
            Ext.getCmp('intidUsuarioGridProced').setValue(ID_USUARIO);
            winAdicionarProcedimientoAgendarProfe.show();
        }
    },
    EliminarProcedGridProgramar: function(){
        //Eliminar Procedimiento a Programar
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DelProced_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Procedimientos a Programar - Eliminar :', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            var Registros;
            Registros = Ext.getCmp('gridProgProcedxProfe').selModel.getCount();
            if(Registros > 0)
            {
                Ext.Msg.show({
                    title: 'eOfiClinic',
                    msg: 'Esta Seguro que Desea Eliminar los procedimientos Seleccionados?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            var selections = Ext.getCmp('gridProgProcedxProfe').selModel.getSelections();
                            var prez = [];
                            for(i = 0; i < Registros; i++){
                                prez.push(selections[i].json.IdProced);
                            }
                            var encoded_array = Ext.encode(prez);
                            fnEliminarRegistros("../../controlador/profesionales/controlador_profesionales.php",{task: "GRID_PROCEDIMIENTOS_ELIMINAR", pProfesional: selections[0].json.idProfesional, pProcedimientos: encoded_array}, 'gridProgProcedxProfe');
                        }
                    }
                });
            }
        }
    },
    AdicionarAgendaGridProgramar: function(){
        //Adicionar Agenda a Programar
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddAgenda_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Programar Agenda - Adicionar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            
            var winProgramarAgendasxProfe = new winProgramarAgendasxProfeUi();
            Ext.getCmp('intidIPSAgenda').setValue(ID_IPS);
            Ext.getCmp('intidProfesionalAgenda').setValue(Ext.getCmp('intidProfesional').getValue());
            Ext.getCmp('intidUsuarioGridAgenda').setValue(ID_USUARIO);
            Ext.getCmp('bolLunes').setValue(true);
            Ext.getCmp('bolMartes').setValue(true);
            Ext.getCmp('bolMiercoles').setValue(true);
            Ext.getCmp('bolJueves').setValue(true);
            Ext.getCmp('bolViernes').setValue(true);
            Ext.getCmp('bolSabado').setValue(false);
            Ext.getCmp('bolDomingo').setValue(false);
            Ext.getCmp('intidPlantillaCitaProgramar').store.load({
                params: {
                    pEmpresa: ID_EMPRESA,
                    pProfesional: Ext.getCmp('intidProfesional').getValue(),
                    pIPS: ID_IPS
                }
            });
            Ext.getCmp('intidConsultorioCitaProgramar').store.load({
                params: {
                    pIPS: ID_IPS
                }
            });
            
            Ext.getCmp('gridSeleccionarConsultoriosProgramar').store.load({
                params: {
                    pProfesional: Ext.getCmp('intidProfesional').getValue(),
                    pIPS: ID_IPS
                }
            });
                        
            winProgramarAgendasxProfe.show();
        }
    },
    EliminarAgendaGridProgramar: function(){
        //Eliminar Agenda a Programar
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DelAgenda_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Programar Agenda - Eliminar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridProgramaAgendaxProfe').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridProgramaAgendaxProfe').selModel.getSelections();
                if (selections[0].json.estado == "a")
                {
                    Ext.Msg.show({
                        title: 'Agendas',
                        msg: 'Esta Seguro que Desea Eliminar la Agenda del día ' + selections[0].json.fecAgenda + ', Ubicación: [' + selections[0].json.Consultorio + '] ?',
                        buttons: Ext.Msg.YESNO,
                        icon: Ext.Msg.QUESTION,
                        fn: function(btn)
                        {
                            if(btn=="yes")
                            {
                                fnEliminarRegistros("../../controlador/profesionales/controlador_profesionales.php",{task: "PROGRAMAR_AGENDAS_ANULAR", pAgenda: selections[0].json.idAgenda}, 'gridProgramaAgendaxProfe')
                            }
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'La Agenda del día ' + selections[0].json.fecAgenda + ' Ubicación: [' + selections[0].json.Consultorio + ']. No Esta Disponible para Anular',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
                }
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    ImprimirAgendaGridProgramar: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "PrintAgenda_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Agendas - Imprimir:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
        location.href='../../controlador/agendas/agenda_print.php?pEmpresa='+ID_EMPRESA+'&pFiltroAgenda=s&pAgenda=' + Ext.getCmp('detAgendaidAgenda').getValue();
        }
    },
    EditarAgendaGridProgramar: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "EditAgenda_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Agendas - Editar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridProgramaAgendaxProfe').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridProgramaAgendaxProfe').selModel.getSelections();
                var winEditarAgenda = new winEditarAgendaUi();
                Ext.getCmp('detAgendaidAgenda').setValue(selections[0].json.idAgenda);
                Ext.getCmp('detAgendaEstado').setValue(selections[0].json.estado);
                switch(selections[0].json.estado)
                {
                    case "0":
                        Ext.getCmp('detAgendaCANCELADA').setValue('AGENDA ANULADA');
                        Ext.getCmp('detAgendaCANCELADA').setVisible(true);
                        Ext.getCmp('detAgendaCERRADA').setVisible(false);
                        break;
                    case "2":
                        Ext.getCmp('detAgendaCANCELADA').setVisible(false);
                        Ext.getCmp('detAgendaCERRADA').setVisible(true);
                        Ext.getCmp('detAgendaCERRADA').setValue('AGENDA CERRADA');
                        break;
                    default:
                        Ext.getCmp('detAgendaCANCELADA').setVisible(false);
                        Ext.getCmp('detAgendaCERRADA').setVisible(false);
                        break;
                }
                
                Ext.getCmp('detAgendaDocProfesional').setValue(Ext.getCmp('intDocProfesional').getValue());
                Ext.getCmp('detAgendaRegistroProfesional').setValue(Ext.getCmp('strRegistroProfesional').getValue());
                Ext.getCmp('detAgendaDescripcion').setValue(Ext.getCmp('strDescripcion').getValue());
                Ext.getCmp('detAgendaTipoProfesional').setValue(Ext.getCmp('strTipoProfesional').getRawValue());
                Ext.getCmp('detAgendaIdEspecialidad').setValue(Ext.getCmp('strIdEspecialidad').getRawValue());
                Ext.getCmp('detAgendaConsultorio').setValue(selections[0].json.Consultorio);
                Ext.getCmp('detAgendaPlantilla').setValue(selections[0].json.Plantilla);
                Ext.getCmp('detAgendaFecAgenda').setValue(selections[0].json.fecAgenda);
                Ext.getCmp('detAgendaFecha').setValue(FormatoFechaLarga(selections[0].json.fecAgenda));
                var btnPrintdetAgenda = Ext.getCmp('btnPrintdetAgenda').on("click",this.ImprimirAgendaGridProgramar,this);
                var btnAdddetAgenda = Ext.getCmp('btnAdddetAgenda').on("click",this.AddHorarioDetAgenda,this);
                var btnDeldetAgenda = Ext.getCmp('btnDeldetAgenda').on("click",this.BlockHorarioDetAgenda,this);
                var btnDesbldetAgenda = Ext.getCmp('btnDesbldetAgenda').on("click",this.DesbloquearHorarioxAgenda,this);
                
                
                Ext.getCmp('detAgendagrid').store.load({
                    params: {
                        task: "GRID_DETALLE_AGENDA",
                        pEmpresa: ID_EMPRESA,
                        pAgenda: selections[0].json.idAgenda
                    }
                });
                winEditarAgenda.show();
            }
        }
    },
    DesbloquearHorarioxAgenda: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id){
            return record.get('codOpcion') == "BlockHorarioAgenda_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir){
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Agendas - Desbloquear Horario:', "Usted no tiene acceso a esta opción del sistema...!");
        }else{
            if (Ext.getCmp('detAgendaEstado').getValue() != "0" && Ext.getCmp('detAgendaEstado').getValue() != "2"){
                if(parseInt(Ext.getCmp('detAgendagrid').selModel.getCount()) === 1){
                    var selections = Ext.getCmp('detAgendagrid').selModel.getSelections();
                    if(selections[0].json.Estado !== "b"){
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'El horario no esta disponible para desbloquearlo',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }else{
                        Ext.Msg.show({
                            title: 'Búsqueda....!',
                            msg: 'Esta seguro que desea desbloquear el horario seleccionado?',
                            buttons: Ext.Msg.YESNO,
                            icon: Ext.Msg.QUESTION,
                            fn: function(btn){
                                if(btn=="yes"){
                                    Ext.Ajax.request({
                                        waitMsg: 'Por favor Espere...',
                                        url: '../../controlador/agendas/controlador_agendas_002.php',
                                        params: {
                                            task: 'DESBLOQUEAR_HORARIOS',
                                            pIdRegistro: selections[0].json.detalleagendaID,
                                            pHorario: selections[0].json.detalleagendaDesCita
                                        },
                                        success: function(response,options){
                                            var Respuesta = response.responseText;
                                            var Contenido = Respuesta.split('^');
                                            if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                Ext.MessageBox.show({
                                                    title: 'eOfiClinic',
                                                    msg: 'Ocurrio un error al desbloquear el horario.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }else{
                                                Ext.getCmp('detAgendagrid').store.reload();
                                                Ext.MessageBox.show({
                                                    title: 'eOfiClinic',
                                                    msg: 'Se desbloqueo con exito el horario seleccionado.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.INFO
                                                });
                                            }
                                        },
                                        failure: function(response,options){
                                            Ext.MessageBox.show({
                                                title: 'eOfiClinic',
                                                msg: 'Ocurrio un error al desbloquear el horario o no se pudo establecer conexión con el servidor.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        },
                                        scope:this
                                    });
                                }
                            }
                        });
                    }
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Verifique que haya seleccionado un horario',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'La Agenda no se encuentra disponible para realizar esta operación',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    AddHorarioDetAgenda: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddHorarioAgenda_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Agendas - Incluir Horario:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if (Ext.getCmp('detAgendaEstado').getValue() != "0" && Ext.getCmp('detAgendaEstado').getValue() != "2")
            {
                var winIncluirHorarioxAgenda = new winIncluirHorarioxAgendaUi();
                Ext.getCmp('intDetAgendaAddAgenda').setValue(Ext.getCmp('detAgendaidAgenda').getValue());
                Ext.getCmp('intDetAgendaAddidUsuario').setValue(ID_USUARIO);
                Ext.getCmp('strDetAgendaAddEstado').setValue('a');
                Ext.getCmp('strDetAgendaAddFecha').setValue(Ext.getCmp('detAgendaFecAgenda').getValue());
                var btnDetAgendaAddGuardar = Ext.getCmp('btnDetAgendaAddGuardar').on("click",this.GuardarHorarioDetAgenda,this);
                
                Ext.getCmp('intDetAgendaAddHorario').store.load({
                    params: {
                        pEmpresa: ID_EMPRESA
                    }
                });
                                
                winIncluirHorarioxAgenda.show();
            }else
            {
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'La Agenda no se encuentra disponible para realizar esta operación',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    BlockHorarioDetAgenda: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "BlockHorarioAgenda_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Agendas - Excluir:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if (Ext.getCmp('detAgendaEstado').getValue() != "0" && Ext.getCmp('detAgendaEstado').getValue() != "2")
            {
                if(Ext.getCmp('detAgendagrid').selModel.getCount() == 1)
                {
                    var selections = Ext.getCmp('detAgendagrid').selModel.getSelections();
                    if(selections[0].json.Estado != "s")
                    {
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'El horario no esta disponible para excluirlo',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }else{
                        var winExcluirHorarioxAgenda = new winExcluirHorarioxAgendaUi();
                        Ext.getCmp('intDetAgendaExcidRegistro').setValue(selections[0].json.detalleagendaID);
                        Ext.getCmp('intDetAgendaExcidUsuario').setValue(ID_USUARIO);
                        Ext.getCmp('sysDetAgendaExcHorario').setValue(selections[0].json.detalleagendaDesCita);
                        Ext.getCmp('memDetAgendaExcObservaciones').setValue(selections[0].json.Observaciones);
                        var btnDetAgendaExcGuardar = Ext.getCmp('btnDetAgendaExcGuardar').on("click",this.GuardarExcluirHorarioDetAgenda,this);
                        winExcluirHorarioxAgenda.show();
                    }
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Verifique que haya seleccionado un horario',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }else
            {
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'La Agenda no se encuentra disponible para realizar esta operación',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    GuardarHorarioDetAgenda: function(){
        Ext.Msg.show({
            title: 'Guardar Incluir Horario',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("GRID_DETALLE_AGENDA_INCLUIR","SI","winIncluirHorarioxAgendaUi","frmIncluirHorarioxAgenda","../../controlador/agendas/controlador_agendas.php","detAgendagrid");
                }
            }
        });
    },
    GuardarExcluirHorarioDetAgenda: function(){
        Ext.Msg.show({
            title: 'Guardar Excluir Horario',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("GRID_DETALLE_AGENDA_EXCLUIR","SI","winExcluirHorarioxAgendaUi","frmExcluirHorarioxAgenda","../../controlador/agendas/controlador_agendas.php","detAgendagrid");
                }
            }
        });
    },
    SeleccionarPlantillaCita: function(grid, fila, e){
         var selections = grid.selModel.getSelections();
         ID_PLANTILLA_CITAS = selections[0].json.idPlantilla;
         ID_PLANTILLA_CITAS_ACT = selections[0].json.Activo;
         Ext.getCmp('gridPlantillasHorarioxProfe').store.load({
            params: {
                task: 'GRID_PLANTILLA_CITAS_HORARIO',
                pEmpresa: ID_EMPRESA,
                pPlantilla: selections[0].json.idPlantilla
            }
        });
    },
    DelItemGrid: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DelProfesionales";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Eliminar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridFormulario').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridFormulario').selModel.getSelections();
                Ext.Msg.show({
                    title: 'Profesionales',
                    msg: 'Esta Seguro que Desea Eliminar el Profesional ' + selections[0].json.descripcion + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            fnEliminarRegistros("../../controlador/profesionales/controlador_profesionales.php",{task: "ELIMINAR", pidProfesional: selections[0].json.idrecord}, 'gridFormulario')
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    GuardarItem: function(){
        Ext.Msg.show({
            title: 'Guardar Profesional',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("INSERTAR","SI","winProfesionalesUi","frmProfesionales","../../controlador/profesionales/controlador_profesionales.php","gridFormulario");
                }
            }
        });
    },
    
    ModificarItem: function(){
        Ext.Msg.show({
            title: 'Guardar Profesional',
            msg: 'Esta Seguro que Desea Modificar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("MODIFICAR","SI","winProfesionalesUi","frmProfesionales","../../controlador/profesionales/controlador_profesionales.php","gridFormulario");
                }
            }
        });
    },
    AdiconarItemGridSedeIPS: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddAsociaIPS_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Asociar IPS - Adicionar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('intidProfesional').getValue() == 0 && Ext.getCmp('intidProfesional').getValue() == null)
            {
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'El profesional no ha sido creado o no esta disponible',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }else{
                var winAsociarSedeIPSProfe = new winAsociarSedeIPSProfeUi();
                winAsociarSedeIPSProfe.title = 'eOfiClinic .::Asociar Sede / IPS por Profesional::.';
                var sysidSEDEGridSedeIPS = Ext.getCmp('sysidSEDEGridSedeIPS').on("select",this.SelectSedeGridSedeIPS,this);
                var btnGuardarAsociarSedeIPS = Ext.getCmp('btnGuardarAsociarSedeIPS').on("click",this.GuardarSedeGridSedeIPS,this);

                Ext.getCmp('intidProfesionalGridSedeIPS').setValue(Ext.getCmp('intidProfesional').getValue());
                Ext.getCmp('sysidSEDEGridSedeIPS').store.load({
                    params: {
                        pEmpresa: ID_EMPRESA
                    }
                });
                winAsociarSedeIPSProfe.show();
            }
        }
    },
    SelectSedeGridSedeIPS: function(cmb, rec, idx){
        Ext.getCmp('intidIPSGridSedeIPS').store.load({
                params: {
                    pSede: cmb.getValue()
                }
            });
    },
    EliminarSedeGridSedeIPS: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DelAsociaIPS_profe";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesionales - Asociar IPS - Eliminar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridSedesIPSxProfe').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridSedesIPSxProfe').selModel.getSelections();
                Ext.Msg.show({
                    title: 'Profesionales',
                    msg: 'Esta Seguro que Desea Eliminar la Asociadon de la IPS ' + selections[0].json.ips + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            fnEliminarRegistros("../../controlador/profesionales/controlador_profesionales.php",{task: "GRID_SEDE_IPS_ELIMINAR", pProfesional: selections[0].json.profesional, pIPS: selections[0].json.idips}, 'gridSedesIPSxProfe')
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    GuardarSedeGridSedeIPS: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea guardar la información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("GRID_SEDE_IPS_ASOCIAR","SI","winAsociarSedeIPSProfeUi","frmAsociarSedeIPSProfe","../../controlador/profesionales/controlador_profesionales.php","gridSedesIPSxProfe");
                }
            }
        });
    },
    CerrarVentana: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winProfesionalesUi').close();
                }
            }
        });
    }
});


function fnEliminarRegistros(URL,arrParam, pGrid, arrParamStore)
{
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        ID_PLANTILLA_CITAS_ACT = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        ID_PLANTILLA_CITAS_ACT = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}

function fnDeshabilitarRegistros(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        ID_PLANTILLA_CITAS_ACT = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid != 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        ID_PLANTILLA_CITAS_ACT = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron deshabilitar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}

function fnGuardarRegistros(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarDatosBasicosTarjeta').setVisible(false);
                                Ext.getCmp('btnModificarDatosBasicosTarjeta').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
