/*
* @category    Formulario Abrir Agenda
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmAbrirAgendaUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Abrir Agendas ::.',
    id: 'winFrmAbrirAgenda',
    closable:false,
    width:980,
    //height:280,
    autoHeight: true,
    resizable : false,
    border: false,
    frame: true,
    y:120,
    initComponent: function() {
        var mybbar = new utilBbarUi();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        el = Ext.get('idips');
        var ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        var ID_USUARIO = el.getValue();
        this.bbar = mybbar;
        var stProfesionales = new StoreProfesionales();
        stProfesionales.load({
            params: {
                pIPS: ID_IPS, 
                pUsuario: ID_USUARIO
            }
        });
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAbrirAgenda',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        html: '<img src="../../../resources/varios/cambiarfec.png" align="left" alt=""/>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        html:'&nbsp;&nbsp;&nbsp;',
                        border: false
                    },
                    {
                        xtype: 'combo',
                        anchor: '100%',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        title: '',
                        fieldLabel: 'Profesional',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: stProfesionales,
                        triggerAction: 'all',
                        mode: 'local',
                        emptyText: 'Seleccione...!',
                        allowBlank: false,
                        id: 'intProfesionalAbrirAgenda'
                    },
                    {
                        html:'&nbsp;&nbsp;&nbsp;',
                        border: false
                    }
                ],
                tbar: {
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            iconCls: 'btnAceptar',
                            text: 'Abrir Agendas del Dia',
                            id: 'btnAbrirAgendas'
                        }
                    ]
                }
            }
        ];
        winFrmAbrirAgendaUi.superclass.initComponent.call(this);
    }
});
