/*
* @category    Formulario Adicionar Horarios a Plantilla Citas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAdicionarHorarioPlantillaCitasProfeUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Adicionar Horario ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winAdicionarHorarioPlantillaCitasProfe',
    initComponent: function() {
        
        var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"Cargando Horarios..."});
        myMask.show();

        var xg = Ext.grid;
        var st = new StoreSeleccionHorarios();
        st.load({
            params: {
                paramP1: ID_EMPRESA
            }
        });
        var chkColumnSeleccionarHorario = new xg.CheckColumn({
           header: 'Seleccionar',
           dataIndex: 'Seleccionar',
           id: 'chkColumnSeleccionarHorario',
           value: false,
           width: 100
        });

        var chkColumnGrupoPrioritario = new xg.CheckColumn({
           header: 'Grupo Prioritario',
           dataIndex: 'GrupoPrioritario',
           id: 'chkGrupoPrioritario',
           value: false,
           width: 120
        });

        var chkColumnAsignarWeb = new xg.CheckColumn({
           header: 'Asignar Web',
           dataIndex: 'AsignarWeb',
           id: 'chkColumnAsignarWeb',
           value: false,
           width: 100
        });

        var strcitaInfoAdd = new Ext.form.TextField();
        
        this.items = [
            {
                xtype: 'hidden',
                id: 'intidPlantillaGridHorario'
            },
            {
                xtype: 'hidden',
                id: 'intidUsuarioGridHorario'
            },
            {
                xtype: 'editorgrid',
                id: 'gridSeleccionarHorarios',
                store: st,
                anchor: "100%",
                height: 390,
                border: false,
                frame: true,
                loadMask: true,
                cm: new xg.ColumnModel([
                    {
                        header: 'idTipoHorario',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Codigo',
                        width: 1,
                        hidden: true,
                        hideable: false
                    },
                    chkColumnSeleccionarHorario,
                    {
                        header: 'Descripción de la Cita',
                        dataIndex: 'Descripcion',
                        readOnly: true,
                        sortable: false,
                        width: 300,
                        hideable: false
                    },
                    {
                        header: 'Información Adicional',
                        readOnly: false,
                        sortable: false,
                        dataIndex: 'citaInfoAdd',
                        editor: strcitaInfoAdd,
                        width: 200
                    },
                    chkColumnGrupoPrioritario,
                    chkColumnAsignarWeb
                ]),
                plugins: [chkColumnSeleccionarHorario,chkColumnGrupoPrioritario,chkColumnAsignarWeb],
                iconCls:'icon-grid',
                viewConfig: {
                    forceFit:true
                },
                columnLines: true,
                tbar: [
                    '->',
                    'Buscar: ', ' ',
                    new Ext.app.SearchField({
                        id: 'qryTipoHorariou',
                        store: st,
                        emptyText: 'Escriba el criterio que desea buscar',
                        params: {pEmpresa: Ext.get('idempresa').getValue(), start: 0, limit: 15},
                        width: 120,
                        ValparamP1: ID_EMPRESA
                    })
                ],
                buttons: [
                    {
                        text: 'Adicionar Horarios',
                        iconCls: 'btnAddHour',
                        id: 'btnAdicionarHorariosGridPlantilla',
                        listeners: {
                            click : function() {
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Esta seguro que desea adicionar los horarios a la plantilla?',
                                    buttons: Ext.Msg.YESNO,
                                    icon: Ext.Msg.QUESTION,
                                    fn: function(btn)
                                    {
                                        if(btn=="yes")
                                        {
                                            //recorrer el estor del grid
                                            Ext.getCmp('gridSeleccionarHorarios').store.filterBy(function(record,id){
                                                return record.get('Seleccionar') == true;
                                            });
                                            var cadenasql = "INSERT INTO tabla (campo1, campo2, campo3, campo4, campo5, campo6, campo7) VALUES ";
                                            var gp;
                                            var aw;
                                            Ext.getCmp('gridSeleccionarHorarios').store.each(function(record){
                                                gp = (record.get('GrupoPrioritario')==true)?'1':'0';
                                                aw = (record.get('AsignarWeb')==true)?'1':'0';
                                                infcita = (record.get('citaInfoAdd')==" ")?null:record.get('citaInfoAdd');
                                                infcita = infcita.replace(/^(\s|\&nbsp;)*|(\s|\&nbsp;)*$/g,"");
                                                cadenasql = cadenasql + "(" + Ext.getCmp('intidPlantillaGridHorario').getValue() + "," + record.get('IdTipoHorario')  + "," + gp + "," + aw + ",\"" + infcita + "\"," + Ext.getCmp('intidUsuarioGridHorario').getValue() + ", now()),";
                                            });
                                            Ext.Ajax.request({
                                                waitMsg: 'Por favor Espere...',
                                                url: "../../controlador/profesionales/controlador_profesionales.php",
                                                params: {
                                                    task: "GRID_PLANTILLA_CITAS_HORARIO_INSERTAR",
                                                    qry: cadenasql
                                                },
                                                success: function(response){
                                                    var result=eval(response.responseText);
                                                    switch(result){
                                                        case 1:
                                                            Ext.MessageBox.show({
                                                                title: 'eOfiClinic',
                                                                msg: 'Se adicionaron los horarios a la plantilla, Recuerde que estas modificaciones se aplicaran para las agendas nuevas.',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.INFO
                                                            });
                                                            Ext.getCmp('gridPlantillasHorarioxProfe').store.reload();
                                                            st.reload();
                                                            break;

                                                        default:
                                                            Ext.MessageBox.show({
                                                                title: 'Error',
                                                                msg: 'No podemos adicionar los registros en estos momentos',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                            break;
                                                    }
                                                },
                                                failure: function(response){
                                                    var result = response.responseText;
                                                    Ext.MessageBox.show({
                                                        title: 'Error Base Datos',
                                                        msg: 'No podemos adicionar los registros en estos momentos',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                }
                                            });
                                        }
                                    }
                                });
                            }
                        }
                    },
                    {
                        text: 'Salir',
                        iconCls: 'btnSalir',
                        listeners: {
                            click : function() {
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Esta seguro que desea cerrar la ventana?',
                                    buttons: Ext.Msg.YESNO,
                                    icon: Ext.Msg.QUESTION,
                                    fn: function(btn)
                                    {
                                        if(btn=="yes")
                                        {
                                            Ext.getCmp('winAdicionarHorarioPlantillaCitasProfe').close();
                                        }
                                    }
                                });
                            }
                        }
                    }
                ],
                buttonAlign: 'center',
                listeners: {
                    viewready : function() {
                        myMask.hide();
                    }
                }
            }
        ];
        winAdicionarHorarioPlantillaCitasProfeUi.superclass.initComponent.call(this);
    }
});
