/*
* @category    Formulario Adicionar Formato HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddPlantillaHCProfeUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Adicionar Plantilla HC ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAddPlantillaHCProfeUi',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmPlantillaHCxProfe',
                padding: 10,
                items: [
                    {
                        xtype: 'hidden',
                        id: 'intProfesionalPalntillaHC'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Plantilla HC',
                        anchor: '100%',
                        triggerAction: 'all',
                        mode: 'local',
                        typeAhead: true,
                        emptyText: 'Seleccionar...!',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: 'StorePlantillasHC',
                        forceSelection: false,
                        allowBlank: false,
                        id: 'intPalntillaHCxProfe'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AsociarPlantillaHC'
                        }
                    ]
                }
            }
        ];
        winAddPlantillaHCProfeUi.superclass.initComponent.call(this);
    }
});
