/*
* @category    Formulario Adicionar Procedimientoa  Agendar x Profesional
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAdicionarProcedimientoAgendarProfeUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Adicionar Procedimiento / Consulta para Agendar ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winAdicionarProcedimientoAgendarProfe',
    initComponent: function() {
        
        var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"Cargando Procedimientos..."});
        myMask.show();
        
        var xg = Ext.grid;
        var st = new StoreSeleccionProcedimientos();
        st.load({
            params: {
                query: 'OFIVACIO'
            }
        });
        var chkColumnSeleccionarProcedimiento = new xg.CheckColumn({
           header: 'Seleccionar',
           dataIndex: 'Seleccionar',
           id: 'chkColumnSeleccionarProcedimiento',
           value: false,
           width: 70
        });

        this.items = [
            {
                xtype: 'hidden',
                id: 'intidProfesionalGridProced'
            },
            {
                xtype: 'hidden',
                id: 'intidUsuarioGridProced'
            },
            {
                xtype: 'grid',
                id: 'gridSeleccionarProcedimientos',
                store: st,
                anchor: "100%",
                height: 490,
                border: false,
                frame: true,
                loadMask: true,
                cm: new xg.ColumnModel([
                    {
                        header: 'IdProced',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'IdProced',
                        width: 1,
                        hidden: true,
                        hideable: false
                    },
                    chkColumnSeleccionarProcedimiento,
                    {
                        header: 'Descripción del Procedimiento',
                        dataIndex: 'Descripcion',
                        readOnly: true,
                        sortable: true,
                        width: 750,
                        hideable: false
                    }
                ]),
                plugins: [chkColumnSeleccionarProcedimiento],
                iconCls:'icon-grid',
                viewConfig: {
                    forceFit:true
                },
                columnLines: true,
                tbar: [
                    '->',
                    'Buscar: ', ' ',
                    new Ext.app.SearchField({
                        id: 'qryProcediminto',
                        store: st,
                        emptyText: 'Escriba el criterio que desea buscar',
                        params: {start: 0, limit: 15},
                        width: 250
                    })
                ],
                buttons: [
                    {
                        text: 'Adicionar Procedimientos',
                        iconCls: 'btnAddProcedimiento',
                        id: 'btnAdicionarProcedimientosGridProced',
                        listeners: {
                            click : function() {
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Esta seguro que desea adicionar los procedimientos al profesional?',
                                    buttons: Ext.Msg.YESNO,
                                    icon: Ext.Msg.QUESTION,
                                    fn: function(btn)
                                    {
                                        if(btn=="yes")
                                        {
                                           //recorrer el estor del grid
                                            Ext.getCmp('gridSeleccionarProcedimientos').store.filterBy(function(record,id){
                                                return record.get('Seleccionar') == true;
                                            });
                                            var cadenasql = "INSERT INTO tabla (campo1, campo2, campo3, campo4) VALUES ";
                                            Ext.getCmp('gridSeleccionarProcedimientos').store.each(function(record){
                                                cadenasql = cadenasql + "(" + Ext.getCmp('intidProfesionalGridProced').getValue() + "," + record.get('IdProced')  + "," + Ext.getCmp('intidUsuarioGridProced').getValue() + ", now()),";
                                            });
                                            Ext.Ajax.request({
                                                waitMsg: 'Por favor Espere...',
                                                url: "../../controlador/profesionales/controlador_profesionales.php",
                                                params: {
                                                    task: "GRID_PROCEDIMIENTOS_INSERTAR",
                                                    qry: cadenasql
                                                },
                                                success: function(response){
                                                    var result=eval(response.responseText);
                                                    switch(result){
                                                        case 1:
                                                            Ext.MessageBox.show({
                                                                title: 'eOfiClinic',
                                                                msg: 'Se adicionaron los procedimientos / consultas para programar agendas para el profesional, Recuerde que estas modificaciones se aplicaran para las agendas nuevas.',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.INFO
                                                            });
                                                            Ext.getCmp('gridProgProcedxProfe').store.reload();
                                                            st.reload();
                                                            break;

                                                        default:
                                                            Ext.MessageBox.show({
                                                                title: 'Error',
                                                                msg: 'No podemos adicionar los registros en estos momentos',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                            break;
                                                    }
                                                },
                                                failure: function(response){
                                                    var result = response.responseText;
                                                    Ext.MessageBox.show({
                                                        title: 'Error Base Datos',
                                                        msg: 'No podemos adicionar los registros en estos momentos',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                }
                                            });
                                        }
                                    }
                                });
                            }
                        }
                    },
                    {
                        text: 'Cancelar',
                        iconCls: 'btnCancelar',
                        listeners: {
                            click : function() {
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Esta seguro que desea cerrar la ventana?',
                                    buttons: Ext.Msg.YESNO,
                                    icon: Ext.Msg.QUESTION,
                                    fn: function(btn)
                                    {
                                        if(btn=="yes")
                                        {
                                            Ext.getCmp('winAdicionarProcedimientoAgendarProfe').close();
                                        }
                                    }
                                });
                            }
                        }
                    }
                ],
                buttonAlign: 'center',
                listeners: {
                    viewready : function() {
                        myMask.hide();
                    }
                }
            }
        ];
        winAdicionarProcedimientoAgendarProfeUi.superclass.initComponent.call(this);
    }
});
