/*
* @category    Formulario Asociar Consultorio
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAsociarConsultoriosProfeUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Asociar Consultorios ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAsociarConsultoriosProfeUi',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAsociarConsultoriosProfe',
                padding: 10,
                items: [
                    {
                        xtype: 'hidden',
                        id: 'intidProfesionalGridConsultorios'
                    },
                    {
                        xtype: 'hidden',
                        id: 'intidIPSGridConsultorios'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Consultorio',
                        anchor: '100%',
                        triggerAction: 'all',
                        mode: 'local',
                        typeAhead: true,
                        emptyText: 'Seleccionar...!',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: 'StoreGridConsultorios',
                        forceSelection: false,
                        allowBlank: false,
                        id: 'intidConsultorioGridConsultorios'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarAsociarConsultorios'
                        }
                    ]
                }
            }
        ];
        winAsociarConsultoriosProfeUi.superclass.initComponent.call(this);
    }
});
