/*
* @category    Formulario Asociar Sede IPS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAsociarSedeIPSProfeUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Asociar Sede / IPS ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAsociarSedeIPSProfeUi',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAsociarSedeIPSProfe',
                padding: 10,
                items: [
                    {
                        xtype: 'hidden',
                        id: 'intidProfesionalGridSedeIPS'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Sede',
                        anchor: '100%',
                        triggerAction: 'all',
                        mode: 'local',
                        typeAhead: true,
                        emptyText: 'Seleccionar...!',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: 'StoreSedexEmpresa',
                        forceSelection: false,
                        allowBlank: false,
                        id: 'sysidSEDEGridSedeIPS'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'IPS',
                        anchor: '100%',
                        triggerAction: 'all',
                        mode: 'local',
                        typeAhead: true,
                        emptyText: 'Seleccionar...!',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: 'StoreIPSxSedexEmpresa',
                        forceSelection: false,
                        allowBlank: false,
                        id: 'intidIPSGridSedeIPS'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            ref: '../btnGuardarAsociarSedeIPS',
                            id: 'btnGuardarAsociarSedeIPS'
                        }
                    ]
                }
            }
        ];
        winAsociarSedeIPSProfeUi.superclass.initComponent.call(this);
    }
});
