/*
* @category    Formulario Incluir Horario por Agenda
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winIncluirHorarioxAgendaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Incluir Horario a Agenda ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winIncluirHorarioxAgendaUi',
    initComponent: function() {
        var stHorarios = new StoreHorarios();
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmIncluirHorarioxAgenda',
                padding: 10,
                items: [
                    {
                        xtype: 'hidden',
                        id: 'intDetAgendaAddAgenda'
                    },
                    {
                        xtype: 'hidden',
                        id: 'intDetAgendaAddidUsuario'
                    },
                    {
                        xtype: 'hidden',
                        id: 'strDetAgendaAddFecha'
                    },
                    {
                        xtype: 'hidden',
                        id: 'strDetAgendaAddEstado'
                    },
                    {
                        xtype: 'combo',
                        width: 150,
                        fieldLabel: 'Tipo',
                        anchor: '100%',
                        triggerAction: 'all',
                        mode: 'local',
                        typeAhead: true,
                        emptyText: 'Seleccione...!',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: stHorarios,
                        forceSelection: true,
                        allowBlank: false,
                        id: 'intDetAgendaAddHorario'
                    },
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Observaciones',
                        anchor: '100%',
                        allowBlank: false,
                        emptyText: 'Observaciones',
                        id: 'memDetAgendaAddObservaciones'
                    },
                    {
                        xtype: 'checkbox',
                        anchor: '100%',
                        value: 'true',
                        fieldLabel: 'Grupo Prioritario',
                        id: 'bolDetAgendaAddGrupoPrioritario'
                    },
                    {
                        xtype: 'checkbox',
                        anchor: '100%',
                        value: 'true',
                        fieldLabel: 'Asignar WEB',
                        id: 'bolDetAgendaAddAsignarWeb'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btnDetAgendaAddGuardar'
                        }
                    ]
                }
            }
        ];
        winIncluirHorarioxAgendaUi.superclass.initComponent.call(this);
    }
});
