
/*
* @category    Formulario Programacion de Agendas x Profesional
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winProgramarAgendasxProfeUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Programación de Agendas ::.',
    width: 730,
    autoHeight: true,
    modal: true,
    closable: false,
    frame: true,
    padding: 10,
    labelWidth: 150,
    layout: 'form',
    id: 'winProgramarAgendasxProfe',
    initComponent: function() {
        
        var myMask = new Ext.LoadMask(Ext.getBody(), {msg:"Cargando Formulario..."});
        myMask.show();

        var xg = Ext.grid;
        var st = new StoreSeleccionFechasAgenda();
                
        var chkColumnSeleccionarConsultorio = new xg.CheckColumn({
           header: 'Seleccionar',
           dataIndex: 'Seleccionar',
           id: 'chkColumnSeleccionarConsultorio',
           value: false,
           width: 100
        });
        
        var chkColumnSeleccionarFecha = new xg.CheckColumn({
           header: 'Seleccionar',
           dataIndex: 'Seleccionar',
           id: 'chkColumnSeleccionarFecha',
           value: false,
           width: 100
        });

       this.items = [
            {
                xtype: 'hidden',
                id: 'intidIPSAgenda'
            },
            {
                xtype: 'hidden',
                id: 'intidProfesionalAgenda'
            },
            {
                xtype: 'hidden',
                id: 'intidUsuarioGridAgenda'
            },
            {
                xtype: 'combo',
                fieldLabel: 'Plantilla Citas',
                anchor: '100%',
                triggerAction: 'all',
                mode: 'local',
                typeAhead: true,
                emptyText: 'Seleccionar...!',
                valueField: 'Codigo',
                displayField: 'Descripcion',
                store: 'StorePlantillaCitasxProfe',
                forceSelection: true,
                allowBlank: false,
                id: 'intidPlantillaCitaProgramar'
            },
            {
                xtype: 'combo',
                fieldLabel: 'Consultorio / Unidad',
                anchor: '100%',
                triggerAction: 'all',
                mode: 'local',
                typeAhead: true,
                emptyText: 'Seleccionar...!',
                valueField: 'Codigo',
                displayField: 'Descripcion',
                store: 'StoreConsultoriosxIPS',
                forceSelection: true,
                allowBlank: true,
                id: 'intidConsultorioCitaProgramar'
            },
            {
                xtype: 'compositefield',
                frame: true,
                fieldLabel: 'Programación de Días',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'displayfield',
                        value: 'Lunes: '
                    },
                    {
                        xtype: 'checkbox',
                        anchor: '100%',
                        value: 'true',
                        id: 'bolLunes'
                    },
                    {
                        xtype: 'displayfield',
                        value: 'Martes: '
                    },
                    {
                        xtype: 'checkbox',
                        anchor: '100%',
                        value: 'true',
                        id: 'bolMartes'
                    },
                    {
                        xtype: 'displayfield',
                        value: 'Miércoles: '
                    },
                    {
                        xtype: 'checkbox',
                        anchor: '100%',
                        value: 'true',
                        id: 'bolMiercoles'
                    },
                    {
                        xtype: 'displayfield',
                        value: 'Jueves: '
                    },
                    {
                        xtype: 'checkbox',
                        anchor: '100%',
                        value: 'true',
                        id: 'bolJueves'
                    },
                    {
                        xtype: 'displayfield',
                        value: 'Viernes: '
                    },
                    {
                        xtype: 'checkbox',
                        anchor: '100%',
                        value: 'true',
                        id: 'bolViernes'
                    },
                    {
                        xtype: 'displayfield',
                        value: 'Sábado: '
                    },
                    {
                        xtype: 'checkbox',
                        anchor: '100%',
                        value: 'true',
                        id: 'bolSabado'
                    },
                    {
                        xtype: 'displayfield',
                        value: 'Domingo: '
                    },
                    {
                        xtype: 'checkbox',
                        anchor: '100%',
                        value: 'true',
                        id: 'bolDomingo'
                    }
                ]
            },
            {
                xtype: 'compositefield',
                frame: true,
                fieldLabel: 'Programación de Fechas',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'displayfield',
                        value: 'Desde: '
                    },
                    {
                        xtype: 'datefield',
                        width: 120,
                        emptyText: '(dia/mes/año)',
                        style: 'text-align:center;',
                        allowBlank: false,
                        id: 'fecDesdeAgenda'
                    },
                    {
                        xtype: 'displayfield',
                        value: ' - Hasta:'
                    },
                    {
                        xtype: 'datefield',
                        width: 120,
                        emptyText: '(dia/mes/año)',
                        style: 'text-align:center;',
                        allowBlank: false,
                        id: 'fecHastaAgenda'
                    },
                    {
                        xtype: 'displayfield',
                        value: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'
                    },
                    {
                        xtype: 'button',
                        text: 'Generar Días a Programar',
                        iconCls: 'btnFecha',
                        listeners: {
                            click : function() {
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Esta seguro que desea establecer las fechas a programar?',
                                    buttons: Ext.Msg.YESNO,
                                    icon: Ext.Msg.QUESTION,
                                    fn: function(btn)
                                    {
                                        if(btn=="yes")
                                        {
                                            if (Ext.getCmp('fecDesdeAgenda').getValue() == null || Ext.getCmp('fecDesdeAgenda').getValue() == '' || Ext.getCmp('fecHastaAgenda').getValue() == null || Ext.getCmp('fecHastaAgenda').getValue() == '') 
                                            {
                                                Ext.MessageBox.show({
                                                    title: 'Error',
                                                    msg: 'Los campos de fecha desde y hasta son requeridos',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }else{
                                                Ext.getCmp('gridSeleccionarFechasProgramar').store.load({
                                                    params: {
                                                        pLunes: Ext.getCmp('bolLunes').getValue(),
                                                        pMartes: Ext.getCmp('bolMartes').getValue(),
                                                        pMiercoles: Ext.getCmp('bolMiercoles').getValue(),
                                                        pJueves: Ext.getCmp('bolJueves').getValue(),
                                                        pViernes: Ext.getCmp('bolViernes').getValue(),
                                                        pSabado: Ext.getCmp('bolSabado').getValue(),
                                                        pDomingo: Ext.getCmp('bolDomingo').getValue(),
                                                        pDesde: Ext.getCmp('fecDesdeAgenda').getValue().format('d-m-Y'),
                                                        pHasta: Ext.getCmp('fecHastaAgenda').getValue().format('d-m-Y')
                                                    }
                                                });
                                            }
                                        }
                                    }
                                });
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'displayfield',
                value: ' '
            },
            {
                xtype: 'grid',
                id: 'gridSeleccionarConsultoriosProgramar',
                store: 'StoreGridProfesionalesConsultorios',
                anchor: "100%",
                height: 100,
                border: false,
                frame: true,
                loadMask: true,
                stripeRows: true,
                cm: new xg.ColumnModel([
                    chkColumnSeleccionarConsultorio,
                    {
                        header: 'IdConsultorio',
                        dataIndex: 'Codigo',
                        readOnly: true,
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false
                    },{
                        header: 'Ubicación / Consultorio',
                        dataIndex: 'Descripcion',
                        readOnly: true,
                        sortable: false,
                        width: 300,
                        hideable: false
                    }
                ]),
                plugins: [chkColumnSeleccionarConsultorio],
                iconCls:'icon-grid',
                viewConfig: {
                    forceFit:true
                },
                columnLines: true
            },
            {
                xtype: 'grid',
                id: 'gridSeleccionarFechasProgramar',
                store: st,
                anchor: "100%",
                height: 290,
                border: false,
                frame: true,
                loadMask: true,
                stripeRows: true,
                cm: new xg.ColumnModel([
                    chkColumnSeleccionarFecha,
                    {
                        header: 'Fecha a Agendar',
                        dataIndex: 'FechaAgendar',
                        readOnly: true,
                        sortable: false,
                        width: 300,
                        hideable: false
                    },{
                        header: 'Día de la Semana',
                        dataIndex: 'DiaSemana',
                        readOnly: true,
                        sortable: false,
                        width: 300,
                        hideable: false
                    }
                ]),
                plugins: [chkColumnSeleccionarFecha],
                iconCls:'icon-grid',
                viewConfig: {
                    forceFit:true
                },
                columnLines: true,
                buttons: [
                    {
                        text: 'Programar Agendas',
                        iconCls: 'btnProgramarAgenda',
                        listeners: {
                            click : function() {
                                if (Ext.getCmp('intidPlantillaCitaProgramar').getValue() == null || Ext.getCmp('intidPlantillaCitaProgramar').getValue() == "")
                                {
                                    Ext.MessageBox.show({
                                        title: 'OfiClinic',
                                        msg: 'Los campos de Plantilla, Consultorio / Unidad, y Fechas a Programar son Requeridos.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                }else{
                                    Ext.Msg.show({
                                        title: 'eOfiClinic',
                                        msg: 'Esta seguro que desea programar las agendas?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn)
                                        {
                                            if(btn=="yes")
                                            {
                                                //recorrer el estor del grid
                                                Ext.getCmp('gridSeleccionarFechasProgramar').store.filterBy(function(record,id){
                                                    return record.get('Seleccionar') == true;
                                                });
                                                var tmp = new Array();
                                                var i = 0;
                                                var seguir = false;
                                                Ext.getCmp('gridSeleccionarFechasProgramar').store.each(function(record){
                                                    tmp[i] = record.get('FechaAgendar');
                                                    i++;
                                                    seguir = true;
                                                });
                                                
                                                Ext.getCmp('gridSeleccionarConsultoriosProgramar').store.filterBy(function(record,id){
                                                    return record.get('Seleccionar') == true;
                                                });
                                                i = 0;
                                                var tmp1 = new Array();
                                                Ext.getCmp('gridSeleccionarConsultoriosProgramar').store.each(function(record){
                                                    tmp1[i] = record.get('Codigo');
                                                    i++;
                                                });
                                                if (seguir)
                                                {
                                                    Ext.MessageBox.wait('Programando Agendas......');
                                                    var res = tmp.toString();
                                                    var res1 = tmp1.toString();
                                                    Ext.Ajax.request({
                                                        waitMsg: 'Por favor Espere...',
                                                        url: "../../controlador/profesionales/controlador_profesionales.php",
                                                        params: {
                                                            task: "PROGRAMAR_AGENDAS_INSERTAR",
                                                            pIPS: Ext.getCmp('intidIPSAgenda').getValue(),
                                                            pProfesional: Ext.getCmp('intidProfesionalAgenda').getValue(),
                                                            pPlantilla: Ext.getCmp('intidPlantillaCitaProgramar').getValue(),
                                                            pConsultorio: Ext.getCmp('intidConsultorioCitaProgramar').getValue(),
                                                            pUsuario: Ext.getCmp('intidUsuarioGridAgenda').getValue(),
                                                            pDias: res,
                                                            pConsultorios: res1
                                                        },
                                                        callback: function(options, success, response){
                                                            Ext.MessageBox.hide();
                                                            if (success) {
                                                                Ext.MessageBox.show({
                                                                    title: 'eOfiClinic',
                                                                    msg: 'Se programaron las agendas con exito.',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.INFO
                                                                });
                                                            }else{
                                                                Ext.MessageBox.show({
                                                                    title: 'Error',
                                                                    msg: 'No podemos adicionar los registros en estos momentos',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });    
                                                            }
                                                        },
                                                        success: function(response){
                                                            var result=eval(response.responseText);
                                                            switch(result){
                                                                case 1:
                                                                    Ext.getCmp('gridProgramaAgendaxProfe').store.reload();
                                                                    st.removeAll(true);
                                                                    st.reload();
                                                                    break;

                                                                default:
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'No podemos adicionar los registros en estos momentos',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                    break;
                                                            }
                                                        },
                                                        failure: function(response){
                                                            var result = response.responseText;
                                                            Ext.MessageBox.show({
                                                                title: 'Error Base Datos',
                                                                msg: 'No podemos adicionar los registros en estos momentos',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                        }
                                                    });
                                                }else{
                                                    Ext.MessageBox.show({
                                                        title: 'OfiClinic',
                                                        msg: 'Debe establecer por lo menos una fecha a programar.',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                }
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    },
                    {
                        text: 'Salir',
                        iconCls: 'btnSalir',
                        listeners: {
                            click : function() {
                                Ext.Msg.show({
                                    title: 'eOfiClinic',
                                    msg: 'Esta seguro que desea cerrar la ventana?',
                                    buttons: Ext.Msg.YESNO,
                                    icon: Ext.Msg.QUESTION,
                                    fn: function(btn)
                                    {
                                        if(btn=="yes")
                                        {
                                            Ext.getCmp('winProgramarAgendasxProfe').close();
                                        }
                                    }
                                });
                            }
                        }
                    }
                ],
                buttonAlign: 'center',
                listeners: {
                    viewready : function() {
                        myMask.hide();
                    }
                }
            }
        ];
        winProgramarAgendasxProfeUi.superclass.initComponent.call(this);
    }
});
