/*
* @category    Programacion Eventos Formulario Tipo de Horario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmProfeSol = Ext.extend(winFrmProfeSolUi, {
    initComponent: function() {
        winFrmProfeSol.superclass.initComponent.call(this);
        //this.title = Ext.get('ofiversion').getValue() + " .:: Tipos de Horarios ::.";
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        el = Ext.get('idaplicacion');
        var NOM_APLICACION = el.getValue();
        el = Ext.get('idxac');
        var ID_CONSULTORIO = el.getValue();
        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        if(NOM_APLICACION == "OfiClinic"){
            Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
            Ext.getCmp('fNomSede').setValue("");
            Ext.getCmp('fNomIPS').setValue("");
            Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        }else{
            Ext.getCmp('fNomEmpresa').setValue("");
            Ext.getCmp('fNomSede').setValue("");
            Ext.getCmp('fNomIPS').setValue("");
            Ext.getCmp('fNomUSR').setValue("");
        }

        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnAddProfeSolicitante = Ext.getCmp('btnAddProfeSolicitante').on("click",this.AddProfeSolicita,this);
        var btnDelProfeSolicitante = Ext.getCmp('btnDelProfeSolicitante').on("click",this.DelProfeSolicita,this);
        var btnEditProfeSolicitante = Ext.getCmp('btnEditProfeSolicitante').on("click",this.EditProfeSolicita,this);
        Ext.getCmp('gridProfeSol').store.load();
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    AddProfeSolicita: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddTipoHorario";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesional Solicitante - Adicionar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else{
            var winProfeSol = new winProfeSolUi();
            winProfeSol.title = 'eOfiClinic .::Adicionar Profesional Solicitante::.';
            Ext.getCmp('btn_AdicionarProfeSol').setVisible(true);
            Ext.getCmp('btn_ModificarProfeSol').setVisible(false);
            Ext.getCmp('sysUsuario').setVisible(false);
            Ext.getCmp('sysFechaAct').setVisible(false);
            Ext.getCmp('intUsuario').setValue(ID_USUARIO);
            var btn_AdicionarProfeSol = Ext.getCmp('btn_AdicionarProfeSol').on("click",this.GuardarProfeSol,this);
            var btn_SalirProfeSol = Ext.getCmp('btn_SalirProfeSol').on("click",this.CerrarVentanaProfeSol,this);
            winProfeSol.show();
        }
    },
    EditProfeSolicita: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "EditTipoHorario";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesional Solicitante - Modificar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridProfeSol').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridProfeSol').selModel.getSelections();
                var winProfeSol = new winProfeSolUi();
                winProfeSol.title = 'eOfiClinic .::Modificar Profesional Solicitante::.';
                Ext.getCmp('btn_AdicionarProfeSol').setVisible(false);
                Ext.getCmp('btn_ModificarProfeSol').setVisible(true);
                Ext.getCmp('intUsuario').setValue(ID_USUARIO);
                Ext.getCmp('sysUsuario').setVisible(true);
                Ext.getCmp('sysFechaAct').setVisible(true);
                Ext.getCmp('intIdProfeSol').setValue(selections[0].json.Codigo);
                Ext.getCmp('strDescripcion').setValue(selections[0].json.Descripcion);
                Ext.getCmp('strEspecialidad').setValue(selections[0].json.Especialidad);
                Ext.getCmp('strDireccion').setValue(selections[0].json.Direccion);
                Ext.getCmp('strTelefono').setValue(selections[0].json.Telefono);
                Ext.getCmp('sysUsuario').setValue(selections[0].json.Usuario);
                Ext.getCmp('sysUsuario').addClass('field_quienmodifico')
                Ext.getCmp('sysFechaAct').setValue(selections[0].json.FechaAct);
                Ext.getCmp('sysFechaAct').addClass('field_quienmodifico')
                var btn_ModificarProfeSol = Ext.getCmp('btn_ModificarProfeSol').on("click",this.ModificarProfeSol,this);
                var btn_SalirProfeSol = Ext.getCmp('btn_SalirProfeSol').on("click",this.CerrarVentanaProfeSol,this);
                winProfeSol.show();
            }
        }
    },
    GuardarProfeSol: function(){
        Ext.Msg.show({
            title: 'Guardar Profesional Solicitante',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistrosProfeSol("INSERTAR","SI","winProfeSolUi","frmProfeSol","../../controlador/profesol/controlador_profesol.php","gridProfeSol");
                }
            }
        });
    },
    DelProfeSolicita: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DelTipoHorario";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Profesional Solicitante - Eliminar:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            if(Ext.getCmp('gridProfeSol').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridProfeSol').selModel.getSelections();
                Ext.Msg.show({
                    title: 'Profesional Solicitante',
                    msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.Descripcion + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            fnEliminarRegistrosProfeSol("../../controlador/profesol/controlador_profesol.php",{task: "ELIMINAR", pIdProfeSol: selections[0].json.Codigo}, 'gridProfeSol')
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }
    },
    ModificarProfeSol: function(){
        Ext.Msg.show({
            title: 'Guardar Tipo de Horario',
            msg: 'Esta Seguro que Desea Modificar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistrosProfeSol("MODIFICAR","SI","winProfeSolUi","frmProfeSol","../../controlador/profesol/controlador_profesol.php","gridProfeSol");
                }
            }
        });
    },
    CerrarVentanaProfeSol: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winProfeSolUi').close();
                }
            }
        });
    }
});


function fnEliminarRegistrosProfeSol(URL,arrParam, pGrid, arrParamStore)
{
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar los registros en estos momentos',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}

function fnGuardarRegistrosProfeSol(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarDatosBasicosTarjeta').setVisible(false);
                                Ext.getCmp('btnModificarDatosBasicosTarjeta').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
