/*
* @category    Formulario Adicionar Plantillas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

var qActivo = 0;

winAddPlantillasUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Adicionar Plantillas ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAddPlantillasUi',
    initComponent: function() {
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddPlantillas',
                padding: 10,
                items: [
                    {
                        xtype: 'hidden',
                        id: 'sysIdPrograma'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Plantilla',
                        name: 'Plantilla',
                        store: 'StorePlantillasxPrograma',
                        anchor: '100%',
                        allowBlank: false,
                        valueField: 'IdPlantilla',
                        displayField: 'NomPlantilla',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'intPlantilla'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarPlantilla',
                            listeners:{
                                click : function(){
                                    guardarPlantilla();
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winAddPlantillasUi.superclass.initComponent.call(this);
    }
});


function guardarPlantilla(){
    Ext.Msg.show({
        title: 'Guardar Plantilla....!',
        msg: 'Esta seguro que desea Guardar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn==="yes"){
                var frm = Ext.getCmp('frmAddPlantillas').getForm();
                if (frm.isValid())
                {
                    frm.submit({
                        url: '../../controlador/programas/controlador_programas.php',
                        params: {
                            task: 'INSERTAR_PLANTILLA',
                            pIdPrograma: Ext.getCmp('sysIdPrograma').getValue(),
                            pPlantilla: Ext.getCmp('intPlantilla').getValue()
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Guardar Plantilla',
                                        msg: 'Se Guardo Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('gridProgramasPlantillas').store.load({
                                        params: {
                                            pPrograma: Ext.getCmp('sysIdPrograma').getValue()
                                        }
                                    });
                                    Ext.getCmp('winAddPlantillasUi').close();
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Guardar Plantilla',
                                        msg: 'Ocurrio un error al Guardar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Guardar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
        
}
