/*
* @category    Formulario Adicionar Tipo Atencion
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

var qActivo = 0;

winAddTipoAtencionUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Adicionar Tipo Atencion ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAddTipoAtencionUi',
    initComponent: function() {
        
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddTipoAtencion',
                padding: 10,
                items: [
                    {
                        xtype: 'hidden',
                        id: 'sysIdPrograma'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysIdTipoAtencion'
                    },
                    {
                        xtype: 'textfield',
                        fieldLabel: 'Tipo Atencion',
                        name: 'Tipo Atencion',
                        anchor: '100%',
                        allowBlank: false,
                        id: 'sysTipoAtencion'
                    },
                    {
                        xtype: 'numberfield',
                        name: 'Turnos',
                        fieldLabel: 'Turnos',
                        width: 150,
                        minValue: 0,
                        decimalPrecision: 0,
                        allowBlank: false,
                        id: 'intTurnos'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Activo',
                        name: 'Activo',
                        width: 150,
                        allowBlank: false,
                        store: 'StoreSiNo',
                        valueField: 'Descripcion',
                        displayField: 'Descripcion',
                        mode: 'local',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 10,
                        triggerAction: 'all',
                        id: 'bolActivo'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarTipoAtencion',
                            listeners:{
                                click : function(){
                                    guardarTipoAtencion();
                                }
                            }
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btnModificarTipoAtencion',
                            listeners:{
                                click : function(){
                                    
                                    modificarTipoAtencion();
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winAddTipoAtencionUi.superclass.initComponent.call(this);
    }
});


function guardarTipoAtencion(){
    Ext.Msg.show({
        title: 'Guardar Tipo Atencion....!',
        msg: 'Esta seguro que desea Guardar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn==="yes"){
                var frm = Ext.getCmp('frmAddTipoAtencion').getForm();
                if (frm.isValid())
                {
                    
                    if(Ext.getCmp('bolActivo').getValue() == "SI"){
                        qActivo = 1;
                    }else{
                        qActivo = 0;
                    }
                    frm.submit({
                        url: '../../controlador/programas/controlador_programas.php',
                        params: {
                            task: 'INSERTAR_TIPOATENCION',
                            pIdPrograma: Ext.getCmp('sysIdPrograma').getValue(),
                            pTipoAtencion: Ext.getCmp('sysTipoAtencion').getValue(),
                            pTurnos: Ext.getCmp('intTurnos').getValue(),
                            pActivo: qActivo,
                            pUsuario: ID_USUARIO
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Guardar Tipo Atencion',
                                        msg: 'Se Guardo Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('gridTipoAtencion').store.load({
                                        params: {
                                            pPrograma: Ext.getCmp('sysIdPrograma').getValue()
                                        }
                                    });
                                    Ext.getCmp('winAddTipoAtencionUi').close();
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Guardar Tipo Atencion',
                                        msg: 'Ocurrio un error al Guardar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Guardar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
        
}

function modificarTipoAtencion(){
    Ext.Msg.show({
        title: 'Modificar Tipo Atencion....!',
        msg: 'Esta seguro que desea Modificar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn==="yes"){
              var frm = Ext.getCmp('frmAddTipoAtencion').getForm();
                if (frm.isValid())
                {
                    if(Ext.getCmp('bolActivo').getValue() == "SI"){
                        qActivo = 1;
                    }else{
                        qActivo = 0;
                    }
                    frm.submit({
                        url: '../../controlador/programas/controlador_programas.php',
                        params: {
                            task: 'MODIFICAR_TIPOATENCION',
                            pIdTipoAtencion: Ext.getCmp('sysIdTipoAtencion').getValue(),
                            pIdPrograma: Ext.getCmp('sysIdPrograma').getValue(),
                            pTipoAtencion: Ext.getCmp('sysTipoAtencion').getValue(),
                            pTurnos: Ext.getCmp('intTurnos').getValue(),
                            pActivo: qActivo,
                            pUsuario: ID_USUARIO
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Guardar Tipo Atencion',
                                        msg: 'Se Guardo Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('gridTipoAtencion').store.load({
                                        params: {
                                            pPrograma: Ext.getCmp('sysIdPrograma').getValue()
                                        }
                                    });
                                    Ext.getCmp('winAddTipoAtencionUi').close();
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Modificar Programa',
                                        msg: 'Ocurrio un error al Guardar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Guardar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
}