/*
* @category    Programacion Eventos Formulario Programas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmProgramas = Ext.extend(winFrmProgramasUi, {
    initComponent: function() {
        winFrmProgramas.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";

        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        
        
        Ext.getCmp('gridProgramas').store.load({
            params: {
                pEmpresa: ID_EMPRESA
            }
        });
        
        var gridProgramas = Ext.getCmp('gridProgramas').on("rowclick",this.SeleccionarPrograma,this);
        
    },
    
    SeleccionarPrograma: function(grid, fila, e){ // ok
        var selections = grid.selModel.getSelections();
        Ext.getCmp('gridTipoAtencion').store.load({
            params: {
                pPrograma: selections[0].json.IdPrograma
            }
        });
        Ext.getCmp('gridProgramasPlantillas').store.load({
            params: {
                pPrograma: selections[0].json.IdPrograma
            }
        });
        Ext.getCmp('gridProgramasServicios').store.load({
            params: {
                pPrograma: selections[0].json.IdPrograma
            }
        });
    },
            
            
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    }
});
