/*
* @category    Formulario Radicacion de Servicios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

var xbtnValidarDoc = new btnValidarDoc({
    id: 'btnValidarDoc',
});

winRadicacionServiciosAnatomopatologiaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Radicación de Servicios Anatomopatologia ::.',
    width: 1024,
    height: 646,
    closable: false,
    resizable: false,
    draggable: false,
    frame: true,
    id: 'winRadicacionServicios',
    initComponent: function() {
        
        var ID_VALIDAAUDITORIA = "0";
                
        Ext.util.Format.Currency = function(v)
        {
            return FormatoMoneda(v);
        };
        
        this.items = [
            {
                xtype: 'tabpanel',
                activeTab: 0,
                width: 990,
                height: 565,
                id: 'fTabPanel',
                frame: true,
                items: [
                    {
                        xtype: 'panel',
                        title: 'Radicar',
                        height: 441,
                        width: 951,
                        id: 'fichaDatos',
                        autoScroll: true,
                        frame: true,
                        items: [
                            {
                                xtype: 'form',
                                title: '',
                                padding: 5,
                                border: false,
                                id: 'frmRadica',
                                items: [
                                    {
                                        xtype: 'hidden',
                                        name: 'txtCas',
                                        id: 'fCas',
                                        value: 0
                                    },
                                    {
                                        xtype: 'hidden',
                                        name: 'txtCas',
                                        id: 'fModificaCAS',
                                        value: 0
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Datos del Cliente',
                                        layout: 'table',
                                        width: 949,
                                        height: 82,
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        id: 'fsCliente',
                                        layoutConfig: {
                                            columns: 4
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnCliete',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Cliente',
                                                        anchor: '100%',
                                                        name: 'cbCliente',
                                                        allowBlank: false,
                                                        store: 'StoreCliente',
                                                        displayField: 'Descripcion',
                                                        valueField: 'IdCliente',
                                                        emptyText: 'Selecione Cliente....',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        listWidth: 450,
                                                        typeAhead: true,
                                                        autoSelect: false,
                                                        typeAheadDelay: 50,
                                                        submitValue: true,
                                                        enableKeyEvents: true,
                                                        triggerAction: 'all',
                                                        disabled: true,
                                                        id: 'fCliente'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 274,
                                                border: false,
                                                id: 'pnPlan',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Plan',
                                                        anchor: '100%',
                                                        name: 'cbPlan',
                                                        allowBlank: false,
                                                        mode: 'local',
                                                        store: 'StoreClientesPlan',
                                                        valueField: 'IdPlan',
                                                        displayField: 'Descripcion',
                                                        typeAhead: true,
                                                        triggerAction: 'all',
                                                        disabled: true,
                                                        typeAheadDelay: 50,
                                                        listWidth: 450,
                                                        emptyText: 'Selecione Plan....',
                                                        forceSelection: true,
                                                        id: 'fPlan'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 215,
                                                border: false,
                                                id: 'pnSubplan',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Sub Plan',
                                                        anchor: '100%',
                                                        name: 'cbSubplan',
                                                        allowBlank: false,
                                                        disabled: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        store: 'StoreClienteSubplan',
                                                        displayField: 'Descripcion',
                                                        valueField: 'IdSubPlan',
                                                        mode: 'local',
                                                        emptyText: 'Selecione Sub Plan....',
                                                        listWidth: 450,
                                                        forceSelection: true,
                                                        id: 'fSubPlan'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                border: false,
                                                width: 172,
                                                id: 'pnContrato',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Contrato',
                                                        anchor: '100%',
                                                        name: 'cbContrato',
                                                        allowBlank: false,
                                                        disabled: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        store: 'StoreClienteContrato',
                                                        valueField: 'IdContrato',
                                                        displayField: 'Contrato',
                                                        mode: 'local',
                                                        listWidth: 450,
                                                        emptyText: 'Selecione Contrato....',
                                                        forceSelection: true,
                                                        id: 'fContrato'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtUsaListado',
                                                id: 'fUsaListado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtAtenderFueraListado',
                                                id: 'fAtenderFueraListado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtRequiereAutorizacion',
                                                id: 'fRequiereAutorizacion',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtFacturarParticular',
                                                id: 'fFacturarParticular',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtMaxCopago',
                                                ref: '../../../../fMaxCopago',
                                                id: 'fMaxCopago',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'fFacturarCopagos',
                                                id: 'fFacturarCopagos',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'fCopagoDigitado',
                                                id: 'fCopagoDigitado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'fvlrCuotaModeradoraIndicada',
                                                id: 'fvlrCuotaModeradoraIndicada',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'fPorCopagos',
                                                id: 'fPorCopagos',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtUsaAuditoria',
                                                id: 'fUsaAuditoria',
                                                value: 0
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Datos del Solicitante',
                                        layout: 'table',
                                        width: 949,
                                        height: 82,
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        id: 'fsSolicitud',
                                        layoutConfig: {
                                            columns: 5
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 120,
                                                border: false,
                                                id: 'pnFecSol',
                                                items: [
                                                    {
                                                        xtype: 'datefield',
                                                        fieldLabel: 'Fecha Radicaciòn',
                                                        anchor: '100%',
                                                        name: 'txtFecSol',
                                                        allowBlank: false,
                                                        style: 'text-align:center;',
                                                        emptyText: '(dia/mes/año) ',
                                                        disabled: true,
                                                        id: 'fFecSol'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 274,
                                                border: false,
                                                colspan: 1,
                                                id: 'pnPrograma',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Programa y/o Tipo de Atención',
                                                        anchor: '100%',
                                                        name: 'cbPrograma',
                                                        allowBlank: false,
                                                        store: 'StorePrograma',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'IdPrograma',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Programa....',
                                                        submitValue: true,
                                                        disabled: true,
                                                        id: 'fPrograma'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 200,
                                                border: false,
                                                colspan: 1,
                                                iconCls: '',
                                                id: 'pnAutorizacion',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Autorización',
                                                        anchor: '100%',
                                                        name: 'txtAutorizacion',
                                                        style: 'text-transform:uppercase;',
                                                        allowBlank: false,
                                                        disabled: true,
                                                        id: 'fAutorizacion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                border: false,
                                                width: 340,
                                                colspan: 2,
                                                id: 'pnProfesional',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Profesional / IPS  Solicitante',
                                                                name: 'cbProfeSol',
                                                                allowBlank: false,
                                                                store: 'StoreProfeSol',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                emptyText: 'Seleccione Profesional / IPS Solicitante....',
                                                                valueField: 'idProfeSolicitante',
                                                                displayField: 'Descripcion',
                                                                width: 300,
                                                                listWidth: 450,
                                                                submitValue: true,
                                                                disabled: true,
                                                                id: 'fProfeSol'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnDoctor',
                                                                tooltip: 'Adicionar Profesional / IPS Solicitante',
                                                                id: 'btnAddProfeSol'
                                                            }
                                                        ]
                                                    }
                                                 ]
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtFinalidad',
                                                id: 'fFinalidad',
                                                value: '10'
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtExento',
                                                id: 'fExentoPrograma',
                                                value: 0
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Datos del Concepto',
                                        layout: 'form',
                                        width: 949,
                                        height: 105,
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        id: 'fsConcepto',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Concepto',
                                                anchor: '100%',
                                                allowBlank: false,
                                                store: 'StoreConceptosCliente',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion1',
                                                tpl: '<tpl for="."><div class="cbConcepto"><h3>{CodProced} - {Descripcion}</h3><span style="font-size: 12; color: #AA0033">Codigo: {CUPSCodigo}</span><br/><span style="font-size: 12; color: #0000EE ">Tarifa: $ {Tarifa}</span><hr /></div></tpl>',
                                                emptyText: 'Seleccione Concepto....',
                                                itemSelector: 'div.cbConcepto',
                                                mode: 'local',
                                                triggerAction: 'all',
                                                forceSelection: true,
                                                id: 'intIdProcedimiento',
                                                listeners:{
                                                    select: function(cmb, rec, idx) {
                                                        if(cmb.getValue() != null && cmb.getValue() != ""){
                                                            Ext.getCmp('sysDesConcepto').setValue(rec.data.Descripcion);
                                                            Ext.getCmp('sysCodConcepto').setValue(rec.data.CodProced);
                                                            Ext.getCmp('sysVlrTarifa').setValue(rec.data.VlrTarifa);
                                                            Ext.getCmp('sysIdProcedimiento').setValue(rec.data.Codigo);
                                                            Ext.getCmp('sysidTipoReg').setValue(rec.data.TipoRegProced);
                                                            Ext.getCmp('sysIVA').setValue(0);
                                                            Ext.getCmp('sysVlrIVA').setValue(0);
                                                            Ext.getCmp('sysCantidad').setValue(1);
                                                        }else{
                                                            Ext.getCmp('sysDesConcepto').setValue(null);
                                                            Ext.getCmp('sysCodConcepto').setValue(null);
                                                            Ext.getCmp('sysVlrTarifa').setValue(null);
                                                            Ext.getCmp('sysIdProcedimiento').setValue(0);
                                                            Ext.getCmp('sysIVA').setValue(0);
                                                            Ext.getCmp('sysVlrIVA').setValue(0);
                                                            Ext.getCmp('sysidTipoReg').setValue(0);
                                                            Ext.getCmp('sysCantidad').setValue(1);
                                                        }
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'hidden',
                                                id: 'sysIdProcedimiento',
                                                value: 0
                                            },       
                                            {
                                                xtype: 'hidden',
                                                readOnly: true,
                                                width: 96,
                                                allowBlank: true,
                                                style: 'color: #0000cc; font-weight: bold;',
                                                id: 'sysCodConcepto'
                                            },
                                            {
                                                xtype: 'hidden',
                                                readOnly: true,
                                                width: 695,
                                                height: 40,
                                                fieldLabel: 'Descripción',
                                                style: 'font-family: Arial,Helvetica,sans-serif;font-size: 10px; color: #0000cc; font-weight: bold;',
                                                id: 'sysDesConcepto'
                                            },
                                            {
                                                xtype: 'hidden',
                                                id: 'sysIVA',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                id: 'sysVlrIVA',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                id: 'sysidTipoReg',
                                                value: 0
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                fieldLabel: 'Vlr Tarifa',
                                                items: [
                                                    {
                                                        xtype: 'numericfield',
                                                        currencySymbol: "$",
                                                        useThousandSeparator: true,
                                                        alwaysDisplayDecimals: true,
                                                        thousandSeparator: ',',
                                                        minValue: 0,
                                                        decimalPrecision: 2,
                                                        allowBlank: true,
                                                        id: 'sysVlrTarifa'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        labelStyle: 'color: Brown;',
                                                        anchor: '100%',
                                                        value: true,
                                                        tooltip: 'RIPS',
                                                        id: 'bolCrearCASxServicio'
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'form',
                                        padding: 5,
                                        border: false,
                                        id: 'frmRadicaDatPac',
                                        renderTo: Ext.getBody(),
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                title: 'Datos del Paciente',
                                                layout: 'table',
                                                collapseFirst: false,
                                                collapsible: true,
                                                animCollapse: true,
                                                titleCollapse: true,
                                                width: 949,
                                                height: 317,
                                                id: 'fsPaciente',
                                                layoutConfig: {
                                                    columns: 4
                                                },
                                                items: [
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 271,
                                                        border: false,
                                                        id: 'pnTdoc',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Tipo Doc ID',
                                                                anchor: '100%',
                                                                name: 'cbTdoc',
                                                                allowBlank: false,
                                                                //store: 'StoreTdocPac',
                                                                store: 'StoreTdocPac',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione Tipo Documento....',
                                                                mode: 'local',
                                                                triggerAction: 'all',
                                                                forceSelection: true,
                                                                disabled: true,
                                                                id: 'fTdoc'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 269,
                                                        border: false,
                                                        id: 'pnDocID',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        fieldLabel: 'Documento ID',
                                                                        name: 'txtDocID',
                                                                        allowBlank: false,
                                                                        //anchor: '100%',
                                                                        width: 200,
                                                                        disabled: true,
                                                                        id: 'fDocID'
                                                                    },
                                                                    {
                                                                        xtype: 'button',
                                                                        iconCls: 'btnBuscar',
                                                                        tooltip: 'Buscar Paciente',
                                                                        id: 'btnBuscarPacienteRadica'
                                                                    },
                                                                    {
                                                                        xtype: 'button',
                                                                        iconCls: 'btnUsrVerifica',
                                                                        tooltip: 'Verificar Paciente en el Listado de Atención',
                                                                        id: 'btnVerificaPacienteListado'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 215,
                                                        border: false,
                                                        colspan: 1,
                                                        id: 'pnRegimen',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Régimen / Tipo Usuario',
                                                                anchor: '100%',
                                                                name: 'cbRegimen',
                                                                allowBlank: false,
                                                                store: 'StoreTipoRegimen',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                emptyText: 'Seleccione Régimen/Tipo Usuario....',
                                                                forceSelection: true,
                                                                value: '1 - Contributivo',
                                                                listWidth: 350,
                                                                disabled: true,
                                                                id: 'fRegimen'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 172,
                                                        border: false,
                                                        colspan: 1,
                                                        id: 'pnGenero',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Genero',
                                                                anchor: '100%',
                                                                name: 'cbGenero',
                                                                allowBlank: false,
                                                                store: 'StoreGenero',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                emptyText: 'Seleccione Genero....',
                                                                forceSelection: true,
                                                                disabled: true,
                                                                id: 'fGenero'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 271,
                                                        border: false,
                                                        id: 'pnApe1',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '1er Apellido',
                                                                anchor: '100%',
                                                                name: 'txtApe1',
                                                                style: 'text-transform:uppercase;',
                                                                allowBlank: false,
                                                                disabled: true,
                                                                id: 'fApe1'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 271,
                                                        border: false,
                                                        id: 'pnApe2',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '2do Apellido',
                                                                anchor: '100%',
                                                                name: 'txtApe2',
                                                                style: 'text-transform:uppercase;',
                                                                disabled: true,
                                                                id: 'fApe2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 215,
                                                        border: false,
                                                        id: 'pnNom1',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '1er Nombre',
                                                                anchor: '100%',
                                                                name: 'txtNom1',
                                                                allowBlank: false,
                                                                style: 'text-transform:uppercase;',
                                                                disabled: true,
                                                                id: 'fNom1'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        border: false,
                                                        width: 172,
                                                        id: 'pnNom2',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: '2do Nombre',
                                                                anchor: '100%',
                                                                name: 'txtNom2',
                                                                disabled: true,
                                                                style: 'text-transform:uppercase;',
                                                                id: 'fNom2'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 146,
                                                        border: false,
                                                        id: 'pnFecNac',
                                                        items: [
                                                            {
                                                                xtype: 'datefield',
                                                                fieldLabel: 'Fecha Nacimiento',
                                                                anchor: '100%',
                                                                name: 'txtFecNac',
                                                                allowBlank: true,
                                                                disabledDates: '',
                                                                emptyText: '(dia/mes/año) ',
                                                                style: 'text-align:center;',
                                                                disabled: true,
                                                                id: 'fFecNac'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 271,
                                                        border: false,
                                                        id: 'pnEdad',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Edad Actual',
                                                                anchor: '100%',
                                                                name: 'txtEdad',
                                                                readOnly: false,
                                                                allowBlank: false,
                                                                style: 'color: blue;text-align:center',
                                                                //disabled: true,
                                                                id: 'fEdad'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 386,
                                                        border: false,
                                                        colspan: 2,
                                                        id: 'pnDeptoMuni',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Municipio - Departamento',
                                                                anchor: '100%',
                                                                name: 'cbDeptoMuni',
                                                                allowBlank: false,
                                                                store: 'StoreDeptoMuni',
                                                                valueField: 'IdDeptoMunicipio',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione Municipio - Departamento....',
                                                                mode: 'local',
                                                                listWidth: 450,
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 10,
                                                                disabled: true,
                                                                id: 'fDeptoMuni'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 928,
                                                        border: false,
                                                        colspan: 4,
                                                        height: 54,
                                                        id: 'pnDatDirTel',
                                                        items: [
                                                            {
                                                                xtype: 'compositefield',
                                                                fieldLabel: 'Dirección - Teléfono - Teléfono (Otro - Cel.) - Zona - Email',
                                                                anchor: '100%',
                                                                id: 'composDatDirTel',
                                                                items: [
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtDireccion',
                                                                        allowBlank: false,
                                                                        emptyText: 'Dirección....',
                                                                        style: 'text-transform:uppercase;',
                                                                        width: 250,
                                                                        disabled: true,
                                                                        id: 'fDireccion'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtTel1',
                                                                        allowBlank: false,
                                                                        emptyText: 'Teléfono',
                                                                        width: 160,
                                                                        disabled: true,
                                                                        id: 'fTel1'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtTel2',
                                                                        emptyText: 'Teléfono (Otro - Cel.)',
                                                                        width: 160,
                                                                        disabled: true,
                                                                        id: 'fTel2'
                                                                    },
                                                                    {
                                                                        xtype: 'combo',
                                                                        flex: 1,
                                                                        fieldLabel: 'Zona',
                                                                        store: 'StoreZonaResidencia',
                                                                        valueField: 'Codigo',
                                                                        displayField: 'Descripcion',
                                                                        mode: 'local',
                                                                        name: 'cbZona',
                                                                        emptyText: 'Zona....',
                                                                        allowBlank: false,
                                                                        forceSelection: true,
                                                                        typeAhead: true,
                                                                        typeAheadDelay: 50,
                                                                        width: 80,
                                                                        value: 'Urbana',
                                                                        triggerAction: 'all',
                                                                        disabled: true,
                                                                        id: 'fZona'
                                                                    },
                                                                    {
                                                                        xtype: 'textfield',
                                                                        name: 'txtEmail',
                                                                        vtype: 'email',
                                                                        emptyText: 'Email....',
                                                                        width: 140,
                                                                        disabled: true,
                                                                        id: 'fEmail'
                                                                    },
                                                                    {
                                                                        xtype: 'button',
                                                                        text: 'Actualiza',
                                                                        tooltip: 'Actualizar Datos del Paciente',
                                                                        iconCls: 'btnGuardar',
                                                                        iconAlign: 'right',
                                                                        id: 'btnActualizaPac'
                                                                    }
                                                                ]
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 271,
                                                        border: false,
                                                        id: 'pnTafiliado',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Tipo de Afiliado',
                                                                anchor: '100%',
                                                                name: 'cbTafiliado',
                                                                allowBlank: false,
                                                                listEmptyText: 'Seleccione',
                                                                store: 'StoreTipoAfiliado',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                emptyText: 'Seleccione Tipo de Afiliado....',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                tpl: '',
                                                                disabled: true,
                                                                id: 'fTafiliado'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 271,
                                                        border: false,
                                                        id: 'pnTafiliacion',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Parentesco',
                                                                anchor: '100%',
                                                                name: 'cbParentesco',
                                                                listEmptyText: 'Seleccione',
                                                                store: 'StoreParentesco',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                emptyText: 'Seleccione Parentesco....',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                disabled: true,
                                                                id: 'fParentesco'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 213,
                                                        border: false,
                                                        id: 'pnRango',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Rango Salarial',
                                                                anchor: '100%',
                                                                name: 'cbRango',
                                                                allowBlank: false,
                                                                listEmptyText: 'Seleccione',
                                                                store: 'StoreRangoSal',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                emptyText: 'Seleccione Rango Salarial....',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                tpl: '<tpl for="."><div class="cbRango"><h3>{Descripcion}</h3><p style="font-size: 12; color: #AA0033">Valor: $ {VlrCuotaModeradora}</p><p style="font-size: 11; color: #0000EE ">Porcentaje: {txtPorcentaje} %</p><p style="font-size: 10; color: #33373d">{Observaciones}</p><hr /></div></tpl>',
                                                                itemSelector: 'div.cbRango',
                                                                listWidth: 450,
                                                                autoHeight: true,
                                                                disabled: true,
                                                                id: 'fRango'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'panel',
                                                        title: '',
                                                        layout: 'form',
                                                        labelAlign: 'top',
                                                        padding: 5,
                                                        width: 170,
                                                        border: false,
                                                        id: 'pnEstado',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Estado - Listado Atención',
                                                                anchor: '100%',
                                                                name: 'cbEstado',
                                                                allowBlank: false,
                                                                listEmptyText: 'Seleccione',
                                                                store: 'StoreEstadoLA',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                emptyText: 'Estado Actual....',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                disabled: true,
                                                                autoSelect: false,
                                                                id: 'fEstado'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdEmpresa',
                                                id: 'fIdEmpresa',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdSede',
                                                id: 'fIdSede',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdIPS',
                                                id: 'fIdIPS',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdPaciente',
                                                id: 'fIdPaciente',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtExcento',
                                                id: 'fExento',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtTutela',
                                                id: 'fTutela',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtClieteLA',
                                                id: 'fClienteLA',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtPlanLA',
                                                id: 'fPlanLA',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtSubPlanLA',
                                                id: 'fSubPlanLA',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtPacienteValido',
                                                id: 'fPacienteValido',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtYaLiquidado',
                                                id: 'fYaLiquidado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtYaLegalizado',
                                                id: 'fYaLegalizado',
                                                value: 0
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        padding: 5,
                                        border: false,
                                        id: 'frmRadicaDatExam',
                                        renderTo: Ext.getBody(),
                                        items: [
                                            {
                                                xtype: 'fieldset',
                                                autoHeight: true,
                                                title: 'Laboratorio Anatomía Patológica y Citología',
                                                autoScroll: true,
                                                collapsible: true,
                                                //collapsed: true,
                                                anchor: '100%',
                                                animCollapse: true,
                                                id: 'fsAnatomopatologia',
                                                items: [
                                                    {
                                                        xtype: 'numberfield',
                                                        fieldLabel: 'Cantidad',
                                                        width: 50,
                                                        minValue: 1,
                                                        value: 1,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        id: 'sysCantidad'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        title: '',
                                                        width: 542,
                                                        store: 'StoreExamen',
                                                        fieldLabel: 'Examen',
                                                        anchor: '100%',
                                                        validationDelay: 50,
                                                        triggerAction: 'all',
                                                        mode: 'local',
                                                        typeAhead: true,
                                                        forceSelection: true,
                                                        displayField: 'Descripcion',
                                                        listWidth: 950,
                                                        listEmptyText: '',
                                                        valueField: 'Codigo',
                                                        allowBlank: false,
                                                        id: 'intExamen_conceptos',
                                                        listeners:
                                                        {
                                                            scope: this,
                                                            select: function(cmb, rec, idx) {
                                                                if(rec.data.Prefijo === "0" || rec.data.Prefijo === 0){
                                                                    Ext.getCmp('strPrefijoExamen_conceptos').setValue(rec.data.Prefijo);
                                                                }else{
                                                                    Ext.getCmp('strPrefijoExamen_conceptos').setValue(rec.data.Prefijo);
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        fieldLabel: 'Nro Examen',
                                                        anchor: '100%',
                                                        id: 'cmpExamen',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                flex: 1,
                                                                readOnly: true,
                                                                allowBlank: true,
                                                                width: 79,
                                                                id: 'strPrefijoExamen_conceptos',
                                                                listeners: {
                                                                    specialkey: function(field, e){
                                                                        if(field.getValue() != "" && field.getValue() != null && Ext.getCmp('strNroExamen_conceptos').getValue() != null && Ext.getCmp('strNroExamen_conceptos').getValue() != 0){
                                                                            if (e.getKey() == e.ENTER || e.getKey() == e.TAB){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/citopato/controlador_citopato.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR_CONSECUTIVO',
                                                                                        pPrefijo: field.getValue(),
                                                                                        pConsecutivo: Ext.getCmp('strNroExamen_conceptos').getValue()
                                                                                    },
                                                                                    success: function(response,options){
                                                                                        var el = Ext.get('response'); 
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]!="{success:false}"){
                                                                                            Ext.MessageBox.show({
                                                                                                title: 'eOfiClinic',
                                                                                                msg: 'El numero de examen: "' + field.getValue() + '-' + Ext.getCmp('strNroExamen_conceptos').getValue() + '", ya fue radicado',
                                                                                                buttons: Ext.MessageBox.OK,
                                                                                                icon: Ext.MessageBox.ERROR
                                                                                            });
                                                                                            Ext.getCmp('strNroExamen_conceptos').setValue(null);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.MessageBox.show({
                                                                                            title: 'eOfiClinic',
                                                                                            msg: 'No se pudo establecer conexión con el servidor.',
                                                                                            buttons: Ext.MessageBox.OK,
                                                                                            icon: Ext.MessageBox.ERROR
                                                                                        });
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                flex: 1,
                                                                width: 130,
                                                                allowBlank: true,
                                                                id: 'strNroExamen_conceptos',
                                                                listeners: {
                                                                    specialkey: function(field, e){
                                                                        if(field.getValue() != 0 && field.getValue() != null && Ext.getCmp('strPrefijoExamen_conceptos').getValue() != null && Ext.getCmp('strPrefijoExamen_conceptos').getValue() != ""){
                                                                            if (e.getKey() == e.ENTER || e.getKey() == e.TAB){
                                                                                Ext.Ajax.request({
                                                                                    url: '../../controlador/citopato/controlador_citopato.php',
                                                                                    params:{
                                                                                        task: 'BUSCAR_CONSECUTIVO',
                                                                                        pPrefijo: Ext.getCmp('strPrefijoExamen_conceptos').getValue(),
                                                                                        pConsecutivo: field.getValue()
                                                                                    },
                                                                                    success: function(response,options){
                                                                                        var el = Ext.get('response'); 
                                                                                        var Respuesta = response.responseText;
                                                                                        var Contenido = Respuesta.split('^');
                                                                                        if(Contenido[0]!="{success:false}"){
                                                                                            Ext.MessageBox.show({
                                                                                                title: 'eOfiClinic',
                                                                                                msg: 'El numero de examen: "' + Ext.getCmp('strPrefijoExamen_conceptos').getValue() + '-' + field.getValue() + '", ya fue radicado',
                                                                                                buttons: Ext.MessageBox.OK,
                                                                                                icon: Ext.MessageBox.ERROR
                                                                                            });
                                                                                            field.setValue(null);
                                                                                        }
                                                                                    },
                                                                                    failure: function(response,options){
                                                                                        var el = Ext.get('response');
                                                                                        Ext.MessageBox.show({
                                                                                            title: 'eOfiClinic',
                                                                                            msg: 'No se pudo establecer conexión con el servidor.',
                                                                                            buttons: Ext.MessageBox.OK,
                                                                                            icon: Ext.MessageBox.ERROR
                                                                                        });
                                                                                    },
                                                                                    scope:this //bind the callbacks
                                                                                });
                                                                            }
                                                                        }
                                                                    },
                                                                    blur: function(t){
                                                                        if(Ext.getCmp('strNroExamen_conceptos').getValue() != 0 && Ext.getCmp('strNroExamen_conceptos').getValue() != null && Ext.getCmp('strPrefijoExamen_conceptos').getValue() != null && Ext.getCmp('strPrefijoExamen_conceptos').getValue() != ""){
                                                                            Ext.Ajax.request({
                                                                                url: '../../controlador/citopato/controlador_citopato.php',
                                                                                params:{
                                                                                    task: 'BUSCAR_CONSECUTIVO',
                                                                                    pPrefijo: Ext.getCmp('strPrefijoExamen_conceptos').getValue(),
                                                                                    pConsecutivo: Ext.getCmp('strNroExamen_conceptos').getValue()
                                                                                },
                                                                                success: function(response,options){
                                                                                    var el = Ext.get('response'); 
                                                                                    var Respuesta = response.responseText;
                                                                                    var Contenido = Respuesta.split('^');
                                                                                    if(Contenido[0]!="{success:false}"){
                                                                                        Ext.MessageBox.show({
                                                                                            title: 'eOfiClinic',
                                                                                            msg: 'El numero de examen: "' + Ext.getCmp('strPrefijoExamen_conceptos').getValue() + '-' + Ext.getCmp('strNroExamen_conceptos').getValue() + '", ya fue radicado',
                                                                                            buttons: Ext.MessageBox.OK,
                                                                                            icon: Ext.MessageBox.ERROR
                                                                                        });
                                                                                        Ext.getCmp('strNroExamen_conceptos').setValue(null);
                                                                                    }
                                                                                },
                                                                                failure: function(response,options){
                                                                                    var el = Ext.get('response');
                                                                                    Ext.MessageBox.show({
                                                                                        title: 'eOfiClinic',
                                                                                        msg: 'No se pudo establecer conexión con el servidor.',
                                                                                        buttons: Ext.MessageBox.OK,
                                                                                        icon: Ext.MessageBox.ERROR
                                                                                    });
                                                                                },
                                                                                scope:this //bind the callbacks
                                                                            });
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        title: '',
                                                        width: 542,
                                                        store: 'StoreMiembroParte',
                                                        anchor: '100%',
                                                        validationDelay: 50,
                                                        triggerAction: 'all',
                                                        mode: 'local',
                                                        typeAhead: true,
                                                        forceSelection: true,
                                                        fieldLabel: 'Parte Cuerpo',
                                                        displayField: 'Descripcion',
                                                        listWidth: 950,
                                                        listEmptyText: '',
                                                        valueField: 'Codigo',
                                                        allowBlank: true,
                                                        id: 'intParteCuerpo_conceptos'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Prioridad',
                                                        title: '',
                                                        width: 542,
                                                        store: 'StorePrioridad',
                                                        anchor: '100%',
                                                        validationDelay: 50,
                                                        triggerAction: 'all',
                                                        mode: 'local',
                                                        typeAhead: true,
                                                        allowBlank: true,
                                                        forceSelection: true,
                                                        displayField: 'Descripcion',
                                                        listEmptyText: '',
                                                        valueField: 'Descripcion',
                                                        value: "NORMAL",
                                                        id: 'strPrioridad_conceptos'
                                                    },
                                                    {
                                                        xtype: 'compositefield',
                                                        fieldLabel: 'Nro Muestras',
                                                        anchor: '100%',
                                                        id: 'cmpNroMuestras',
                                                        items: [
                                                            {
                                                                xtype: 'numberfield',
                                                                flex: 1,
                                                                emptyText: 'Nro Placas',
                                                                allowBlank: true,
                                                                id: 'intPlacas_conceptos'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                flex: 1,
                                                                emptyText: 'Nro Frascos',
                                                                allowBlank: true,
                                                                id: 'intFrascos_conceptos'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                flex: 1,
                                                                emptyText: 'Nro Bolsas',
                                                                allowBlank: true,
                                                                id: 'intBolsas_conceptos'
                                                            },
                                                            {
                                                                xtype: 'numberfield',
                                                                flex: 1,
                                                                emptyText: 'Nro Otros',
                                                                allowBlank: true,
                                                                id: 'intOtros_conceptos'
                                                            }
                                                        ]
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Criterio Calidad',
                                                        title: '',
                                                        width: 542,
                                                        store: 'StoreCriteriosQMuestra',
                                                        anchor: '100%',
                                                        validationDelay: 50,
                                                        triggerAction: 'all',
                                                        mode: 'local',
                                                        typeAhead: true,
                                                        forceSelection: true,
                                                        allowBlank: true,
                                                        displayField: 'Descripcion',
                                                        listEmptyText: '',
                                                        valueField: 'Descripcion',
                                                        value: "ADECUADA",
                                                        id: 'strCriteriosCalidad_conceptos'
                                                    },
                                                    {
                                                        xtype: 'checkbox',
                                                        boxLabel: 'Cumple Criterios de Calidad de la Informacion que llega a Macro?',
                                                        anchor: '100%',
                                                        id: 'bolCumpleCriterioCalidad_conceptos'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
        this.tbar = {
            xtype: 'toolbar',
            id: 'tbar',
            items: [
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Nuevo',
                    iconCls: 'btnNuevo',
                    id: 'btnNuevo'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Generar Radicación de Servicios',
                    iconCls: 'btnGuardar',
                    id: 'btnRadicar'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'textfield',
                    value: '',
                    width: 110,
                    readOnly: true,
                    name: 'sysTextoEliminado',
                    style: 'background:transparent;color: darkred; font-size: large; font-weight: bold;border:none;',
                    id: 'sysTextoEliminado',
                    listeners:{
                        render: function( p ) {
                            p.getEl().on('dblclick', function (){
                                alert("Ver Quien Modifico");
                            });
                        }
                    }
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Reactivar CAS',
                    iconCls: 'btnAceptar',
                    id: 'btnReactivarCAS'
                },        
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'Sin Registrar',
                    name: 'txtNroCAS',
                    style: 'color: darkblue; font-size: large; font-weight: bold;',
                    id: 'fNroCAS'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    name: 'txtFecRadicado',
                    style: 'color: darkblue; font-size: 13px; font-weight: bold;',
                    id: 'fFecRadicado'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    name: 'txtEstadoCAS',
                    style: 'color: red; font-size: 13px; font-weight: bold;text-decoration: blink;',
                    id: 'fEstadoCAS'
                }
            ]
        };
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnAyuda',
                    tooltip: 'Ver Ayuda en Linea',
                    ref: '../btnAyuda',
                    id: 'btnAyuda'
                },
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'displayfield',
                    value: 'Empresa: PASBISALUD IPS',
                    name: 'txtNomEmpresa',
                    ref: '../fNomEmpresa',
                    id: 'fNomEmpresa'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'Sede: MANIZALES',
                    name: 'txtNomSede',
                    ref: '../fNomSede',
                    id: 'fNomSede'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'IPS: BELEN',
                    name: 'txtNomSede',
                    ref: '../fNomIPS',
                    id: 'fNomIPS'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnUsr',
                    ref: '../btnUsr',
                    id: 'btnUsr'
                },
                {
                    xtype: 'displayfield',
                    value: 'Usuario: GJUAN ',
                    name: 'txtNomUSR',
                    style: 'color:royalblue',
                    ref: '../fNomUSR',
                    id: 'fNomUSR'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    ref: '../btnSalir',
                    id: 'btnSalir'
                }
            ]
        };
        winRadicacionServiciosAnatomopatologiaUi.superclass.initComponent.call(this);
    }
});
