/*
* @category    Funcion Adicionar / Editar Concepto
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
function AddEditConcepto(pOperacion, pCAS, wUsuario,wConsecutivoDetalle, widConcepto,wCodigo,wDescripcion,wCantidad,wVlrTarifa,wVlrTotal,wVlrCuotaModeradora,wVlrIVA,wVlrNeto, wVlrCopagos, wPorIVA, wPorAplicacion, wVlrDescuentos, wObservaciones, wCriteriosCalidad, wCriteriosLLegaMacro, wIdExamen, wIdMiembro, wPrefijoNroEstudio, wSubNroEstudioINT, wRecip_NroPlaca, wNroBolsa, wNroFrasco, wRecip_NroOtro, wPrioridad, wTipoRegistroDetalle, wIdProveedor,wNotasProveedor,wFechaRealizado,wYaRealizado,wFecProgramacionProveedor,wFecProveedor,wHoraProgramacionProveedor,wYaProgramadoProveedor,wGenerarAutizacionProveedor,wnomProveedor,wYaFacturadoEnt,wNroFactura, wTarifaProveedor, wOrganoProveedor)
{

    var AddEditConceptoUi = new Ext.Window({
        title: 'Radicación de Conceptos',
        width: 1010,
        height: 354,
        modal: true,
        closable: false,
        resizable: false,
        draggable: false,
        frame: true,
        id: 'AddEditConcepto',
        items: [
        {
            xtype: 'form',
            width: 1005,
            height: 329,
            padding: 5,
            frame: true,
            layout: 'border',
            id: 'frmRadicaConceptos',
            items: [
                {
                    xtype: 'panel',
                    flex: 1,
                    region: 'west',
                    width: 710,
                    padding: 5,
                    layout: 'form',
                    autoScroll: true,
                    id: 'pnDatosConcepto',
                    autoHeight: true,
                    items: [
                        {
                            xtype: 'compositefield',
                            fieldLabel: 'Concepto',
                            width: 566,
                            id: 'cmpConceptos',
                            items: [
                                {
                                    xtype: 'button',
                                    iconCls: 'btnBuscar',
                                    tooltip: 'Buscar Concepto',
                                    id: 'btnSearchConcepto_conceptos',
                                    handler:function(){
                                        var UsaAuditoria = "NO";
                                        if(Ext.getCmp('fUsaAuditoria').getValue() == 1){
                                            UsaAuditoria = "SI";
                                        }
                                        buscarconcepto('Radicacion', UsaAuditoria,'NO','NO','SI','gridServicios','Radicacion',Ext.getCmp('fCliente').getValue(), Ext.getCmp('fPlan').getValue(), Ext.getCmp('fSubPlan').getValue());
                                    }
                                },
                                {
                                    xtype: 'hidden',
                                    flex: 1,
                                    readOnly: true,
                                    width: 96,
                                    value: "add",
                                    id: 'sysOperacion_conceptos'
                                },
                                {
                                    xtype: 'hidden',
                                    flex: 1,
                                    readOnly: true,
                                    width: 96,
                                    value: 0,
                                    id: 'sysConsecutivo_conceptos'
                                },
                                {
                                    xtype: 'hidden',
                                    flex: 1,
                                    readOnly: true,
                                    width: 96,
                                    value: pCAS,
                                    id: 'intCAS_conceptos'
                                },
                                {
                                    xtype: 'hidden',
                                    flex: 1,
                                    readOnly: true,
                                    width: 96,
                                    id: 'intidConcepto_conceptos'
                                },
                                {
                                    xtype: 'textfield',
                                    flex: 1,
                                    readOnly: true,
                                    width: 96,
                                    allowBlank: false,
                                    style: 'color: #0000cc; font-weight: bold;',
                                    id: 'strCodConcepto_conceptos'
                                },
                                {
                                    xtype: 'textarea',
                                    flex: 1,
                                    readOnly: true,
                                    width: 435,
                                    height: 90,
                                    style: 'font-family: Arial,Helvetica,sans-serif;font-size: 10px; color: #0000cc; font-weight: bold;',
                                    id: 'strDesConcepto_conceptos'
                                }
                            ]
                        },
                        {
                            xtype: 'numberfield',
                            minValue: 1,
                            fieldLabel: 'Cantidad',
                            decimalPrecision: 0,
                            allowBlank: false,
                            id: 'intCantidad_conceptos',
                            listeners:
                            {
                                scope: this,
                                specialkey: function(f,e)
                                {
                                    if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                    {
                                        var vlr = (Ext.getCmp('intVlrUnitario_conceptos').getValue() * Ext.getCmp('intCantidad_conceptos').getValue());  
                                        Ext.getCmp('intVlrTotal_conceptos').setValue(vlr);
                                        var vlrneto = vlr + Ext.getCmp('intVlrIVA_conceptos').getValue() - Ext.getCmp('intVlrCM_conceptos').getValue() - Ext.getCmp('intVlrCopago_conceptos').getValue() - Ext.getCmp('intDescuentos_conceptos').getValue();
                                        Ext.getCmp('intVlrNeto_conceptos').setValue(vlrneto);
                                    }
                                }
                            }
                        },
                        {
                            xtype: 'textarea',
                            fieldLabel: 'Observaciones',
                            width: 565,
                            height: 50,
                            emptyText: 'Observaciones',
                            id: 'memObservaciones_conceptos'
                        },
                        {
                            xtype: 'fieldset',
                            title: 'Suministro de Medicamentos',
                            autoScroll: true,
                            collapsible: true,
                            autoHeight: true,
                            //collapsed: true,
                            width: 670,
                            animCollapse: true,
                            id: 'fsMedicamentos',
                            items: [
                                {
                                    xtype: 'numberfield',
                                    fieldLabel: 'Consumo x Día',
                                    allowBlank: true,
                                    id: 'strConsumoDia_conceptos'
                                },
                                {
                                    xtype: 'textfield',
                                    fieldLabel: 'Posología',
                                    anchor: '100%',
                                    allowBlank: true,
                                    id: 'strPosologia_conceptos'
                                }
                            ]
                        },
                        {
                            xtype: 'fieldset',
                            autoHeight: true,
                            title: 'Laboratorio Anatomía Patológica y Citología',
                            autoScroll: true,
                            collapsible: true,
                            //collapsed: true,
                            width: 670,
                            animCollapse: true,
                            id: 'fsAnatomopatologia',
                            items: [
                                {
                                    xtype: 'combo',
                                    title: '',
                                    width: 542,
                                    store: 'StoreExamen',
                                    fieldLabel: 'Examen',
                                    anchor: '100%',
                                    validationDelay: 50,
                                    triggerAction: 'all',
                                    mode: 'local',
                                    typeAhead: true,
                                    forceSelection: true,
                                    displayField: 'Descripcion',
                                    listWidth: 950,
                                    listEmptyText: '',
                                    valueField: 'Codigo',
                                    allowBlank: true,
                                    id: 'intExamen_conceptos',
                                    listeners:
                                    {
                                        scope: this,
                                        select: function(cmb, rec, idx) {
                                            Ext.getCmp('strPrefijoExamen_conceptos').setValue(rec.data.Prefijo);
                                        }
                                    }
                                },
                                {
                                    xtype: 'compositefield',
                                    fieldLabel: 'Nro Examen',
                                    anchor: '100%',
                                    id: 'cmpExamen',
                                    items: [
                                        {
                                            xtype: 'textfield',
                                            flex: 1,
                                            readOnly: true,
                                            allowBlank: true,
                                            width: 79,
                                            id: 'strPrefijoExamen_conceptos',
                                            listeners: {
                                                specialkey: function(field, e){
                                                    if(field.getValue() != "" && field.getValue() != null && Ext.getCmp('strNroExamen_conceptos').getValue() != null && Ext.getCmp('strNroExamen_conceptos').getValue() != 0){
                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB){
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/citopato/controlador_citopato.php',
                                                                params:{
                                                                    task: 'BUSCAR_CONSECUTIVO',
                                                                    pPrefijo: field.getValue(),
                                                                    pConsecutivo: Ext.getCmp('strNroExamen_conceptos').getValue()
                                                                },
                                                                success: function(response,options){
                                                                    var el = Ext.get('response'); 
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0]!="{success:false}"){
                                                                        Ext.MessageBox.show({
                                                                            title: 'eOfiClinic',
                                                                            msg: 'El numero de examen: "' + field.getValue() + '-' + Ext.getCmp('strNroExamen_conceptos').getValue() + '", ya fue radicado',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                        Ext.getCmp('strNroExamen_conceptos').setValue(null);
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    var el = Ext.get('response');
                                                                    Ext.MessageBox.show({
                                                                        title: 'eOfiClinic',
                                                                        msg: 'No se pudo establecer conexión con el servidor.',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                },
                                                                scope:this //bind the callbacks
                                                            });
                                                        }
                                                    }
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'textfield',
                                            flex: 1,
                                            width: 130,
                                            allowBlank: true,
                                            id: 'strNroExamen_conceptos',
                                            listeners: {
                                                specialkey: function(field, e){
                                                    if(field.getValue() != 0 && field.getValue() != null && Ext.getCmp('strPrefijoExamen_conceptos').getValue() != null && Ext.getCmp('strPrefijoExamen_conceptos').getValue() != ""){
                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB){
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/citopato/controlador_citopato.php',
                                                                params:{
                                                                    task: 'BUSCAR_CONSECUTIVO',
                                                                    pPrefijo: Ext.getCmp('strPrefijoExamen_conceptos').getValue(),
                                                                    pConsecutivo: field.getValue()
                                                                },
                                                                success: function(response,options){
                                                                    var el = Ext.get('response'); 
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0]!="{success:false}"){
                                                                        Ext.MessageBox.show({
                                                                            title: 'eOfiClinic',
                                                                            msg: 'El numero de examen: "' + Ext.getCmp('strPrefijoExamen_conceptos').getValue() + '-' + field.getValue() + '", ya fue radicado',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                        field.setValue(null);
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    var el = Ext.get('response');
                                                                    Ext.MessageBox.show({
                                                                        title: 'eOfiClinic',
                                                                        msg: 'No se pudo establecer conexión con el servidor.',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                },
                                                                scope:this //bind the callbacks
                                                            });
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    ]
                                },
                                {
                                    xtype: 'combo',
                                    title: '',
                                    width: 542,
                                    store: 'StoreMiembroParte',
                                    anchor: '100%',
                                    validationDelay: 50,
                                    triggerAction: 'all',
                                    mode: 'local',
                                    typeAhead: true,
                                    forceSelection: true,
                                    fieldLabel: 'Parte Cuerpo',
                                    displayField: 'Descripcion',
                                    listWidth: 950,
                                    listEmptyText: '',
                                    valueField: 'Codigo',
                                    allowBlank: true,
                                    id: 'intParteCuerpo_conceptos'
                                },
                                {
                                    xtype: 'combo',
                                    fieldLabel: 'Prioridad',
                                    title: '',
                                    width: 542,
                                    store: 'StorePrioridad',
                                    anchor: '100%',
                                    validationDelay: 50,
                                    triggerAction: 'all',
                                    mode: 'local',
                                    typeAhead: true,
                                    allowBlank: true,
                                    forceSelection: true,
                                    displayField: 'Descripcion',
                                    listEmptyText: '',
                                    valueField: 'Descripcion',
                                    id: 'strPrioridad_conceptos'
                                },
                                {
                                    xtype: 'compositefield',
                                    fieldLabel: 'Nro Muestras',
                                    anchor: '100%',
                                    id: 'cmpNroMuestras',
                                    items: [
                                        {
                                            xtype: 'numberfield',
                                            flex: 1,
                                            emptyText: 'Nro Placas',
                                            allowBlank: true,
                                            id: 'intPlacas_conceptos'
                                        },
                                        {
                                            xtype: 'numberfield',
                                            flex: 1,
                                            emptyText: 'Nro Frascos',
                                            allowBlank: true,
                                            id: 'intFrascos_conceptos'
                                        },
                                        {
                                            xtype: 'numberfield',
                                            flex: 1,
                                            emptyText: 'Nro Bolsas',
                                            allowBlank: true,
                                            id: 'intBolsas_conceptos'
                                        },
                                        {
                                            xtype: 'numberfield',
                                            flex: 1,
                                            emptyText: 'Nro Otros',
                                            allowBlank: true,
                                            id: 'intOtros_conceptos'
                                        }
                                    ]
                                },
                                {
                                    xtype: 'combo',
                                    fieldLabel: 'Criterio Calidad',
                                    title: '',
                                    width: 542,
                                    store: 'StoreCriteriosQMuestra',
                                    anchor: '100%',
                                    validationDelay: 50,
                                    triggerAction: 'all',
                                    mode: 'local',
                                    typeAhead: true,
                                    forceSelection: true,
                                    allowBlank: true,
                                    displayField: 'Descripcion',
                                    listEmptyText: '',
                                    valueField: 'Descripcion',
                                    id: 'strCriteriosCalidad_conceptos'
                                },
                                {
                                    xtype: 'checkbox',
                                    boxLabel: 'Cumple Criterios de Calidad de la Informacion que llega a Macro?',
                                    anchor: '100%',
                                    id: 'bolCumpleCriterioCalidad_conceptos'
                                }
                            ]
                        },
                        {
                            xtype: 'combo',
                            fieldLabel: 'Generar Autorización a Proveedor?',
                            name: 'Generar Autorización a Proveedor?',
                            store: 'StoreSiNo',
                            width: 100,
                            valueField: 'Descripcion',
                            displayField: 'Descripcion',
                            forceSelection: false,
                            triggerAction: 'all',
                            typeAhead: true,
                            allowBlank: true,
                            value: "NO",
                            mode: 'local',
                            id: 'strProveedor_GenerarAuto',
                            listeners:{
                                select : function(cmb, rec, idx){
                                    if (cmb.getValue() == "SI"){
                                        Ext.getCmp('fsAutorizaProveedores').setVisible(true);
                                    }else{
                                        Ext.getCmp('fsAutorizaProveedores').setVisible(false);
                                        Ext.getCmp('intProveedor_conceptos').setValue(null);
                                        Ext.getCmp('intProveedor_conceptosOrgano').setValue(null);
                                        Ext.getCmp('memProveedor_conceptosNotas').setValue(null);
                                        Ext.getCmp('fecProveedor_conceptosFechaRealiza').setValue(null);
                                        Ext.getCmp('intProveedor_conceptosTarifa').setValue(null);
                                    }
                                }
                            }
                        },
                        {
                            xtype: 'fieldset',
                            title: 'Autorización Servicios a Proveedores',
                            autoScroll: true,
                            collapsible: true,
                            width: 670,
                            animCollapse: true,
                            autoHeight: true,
                            id: 'fsAutorizaProveedores',
                            items: [
                                {
                                    xtype: 'combo',
                                    fieldLabel: 'Proveedor',
                                    name: 'Proveedor',
                                    store: 'StoreProveedor',
                                    anchor: '100%',
                                    valueField: 'Codigo',
                                    displayField: 'Descripcion',
                                    listWidth: 850,
                                    validationDelay: 50,
                                    typeAhead: true,
                                    allowBlank: true,
                                    emptyText: 'Seleccione un Proveedor...',
                                    mode: 'local',
                                    id: 'intProveedor_conceptos'
                                },
                                {
                                    xtype: 'combo',
                                    width: 542,
                                    store: 'StoreMiembroParte',
                                    anchor: '100%',
                                    validationDelay: 50,
                                    triggerAction: 'all',
                                    mode: 'local',
                                    typeAhead: true,
                                    forceSelection: true,
                                    allowBlank: true,
                                    fieldLabel: 'Organo',
                                    valueField: 'Codigo',
                                    displayField: 'Descripcion',
                                    id: 'intProveedor_conceptosOrgano'
                                },
                                {
                                    xtype: 'textarea',
                                    fieldLabel: 'Notas',
                                    anchor: '100%',
                                    height: 50,
                                    allowBlank: true,
                                    emptyText: 'Notas a Proveedor',
                                    id: 'memProveedor_conceptosNotas'
                                },
                                {
                                    xtype: 'datefield',
                                    fieldLabel: 'Fecha Realización',
                                    width: 120,
                                    allowBlank: true,
                                    disabledDates: '',
                                    emptyText: '(dia/mes/año) ',
                                    style: 'text-align:center;',
                                    id: 'fecProveedor_conceptosFechaRealiza'
                                },
                                {
                                    xtype: 'hidden',
                                    fieldLabel: 'Tarifa',
                                    width: 120,
                                    allowBlank: true,
                                    value: 0,
                                    id: 'intProveedor_conceptosTarifa'
                                }
                            ]
                        }
                    ]
                },
                {
                    xtype: 'panel',
                    region: 'center',
                    padding: 5,
                    layout: 'form',
                    id: 'pnValorProced',
                    items: [
                        {
                            xtype: 'numberfield',
                            minValue: 1,
                            fieldLabel: '% Aplicación',
                            decimalPrecision: 2,
                            allowBlank: false,
                            readOnly: true,
                            value: 100,
                            id: 'intPorAplicacion_conceptos'
                        },
                        {
                            xtype: 'numericfield',
                            currencySymbol: "$",
                            useThousandSeparator: true,
                            alwaysDisplayDecimals: true,
                            thousandSeparator: ',',
                            minValue: 0,
                            fieldLabel: 'Vlr Unitario',
                            decimalPrecision: 2,
                            allowBlank: false,
                            readOnly: false,
                            id: 'intVlrUnitario_conceptos',
                            listeners: // arreglo temporal autonoma
                            {
                                scope: this,
                                specialkey: function(f,e)
                                {
                                    if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                    {
                                        var vlr = (Ext.getCmp('intVlrUnitario_conceptos').getValue() * Ext.getCmp('intCantidad_conceptos').getValue());
                                        Ext.getCmp('intVlrTotal_conceptos').setValue(vlr);
                                        var vlrneto = vlr + Ext.getCmp('intVlrIVA_conceptos').getValue() - Ext.getCmp('intVlrCM_conceptos').getValue() - Ext.getCmp('intVlrCopago_conceptos').getValue() - Ext.getCmp('intDescuentos_conceptos').getValue();
                                        Ext.getCmp('intVlrNeto_conceptos').setValue(vlrneto);
                                    }
                                }
                            }
                        },
                        {
                            xtype: 'numericfield',
                            currencySymbol: "$",
                            useThousandSeparator: true,
                            alwaysDisplayDecimals: true,
                            thousandSeparator: ',',
                            minValue: 0,
                            fieldLabel: 'Vlr Total',
                            decimalPrecision: 2,
                            allowBlank: false,
                            readOnly: true,
                            id: 'intVlrTotal_conceptos'
                        },
                        {
                            xtype: 'hidden',
                            //minValue: 0,
                            fieldLabel: 'PorIVA',
                            //decimalPrecision: 2,
                            allowBlank: true,
                            readOnly: true,
                            labelStyle: '',
                            value: 0,
                            id: 'intPorIVA_conceptos'
                        },
                        {
                            xtype: 'numericfield',
                            currencySymbol: "$",
                            useThousandSeparator: true,
                            alwaysDisplayDecimals: true,
                            thousandSeparator: ',',
                            minValue: 0,
                            fieldLabel: 'Vlr IVA',
                            decimalPrecision: 2,
                            allowBlank: false,
                            readOnly: true,
                            labelStyle: '',
                            value: 0,
                            id: 'intVlrIVA_conceptos'
                        },
                        {
                            xtype: 'numericfield',
                            currencySymbol: "$",
                            useThousandSeparator: true,
                            alwaysDisplayDecimals: true,
                            thousandSeparator: ',',
                            minValue: 0,
                            fieldLabel: 'Vlr Cuota Moderadora',
                            decimalPrecision: 2,
                            allowBlank: false,
                            //readOnly: true,
                            labelStyle: '',
                            value: 0,
                            id: 'intVlrCM_conceptos',
                            listeners:
                            {
                                scope: this,
                                specialkey: function(f,e)
                                {
                                    if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                    {
                                        var vlr = f.getValue();  
                                        var vlrneto = Ext.getCmp('intVlrTotal_conceptos').getValue() + Ext.getCmp('intVlrIVA_conceptos').getValue() - vlr - Ext.getCmp('intVlrCopago_conceptos').getValue() - Ext.getCmp('intDescuentos_conceptos').getValue();
                                        Ext.getCmp('intVlrNeto_conceptos').setValue(vlrneto);
                                    }
                                }
                            }
                        },
                        {
                            xtype: 'numericfield',
                            currencySymbol: "$",
                            useThousandSeparator: true,
                            alwaysDisplayDecimals: true,
                            thousandSeparator: ',',
                            minValue: 0,
                            fieldLabel: 'Vlr Copago',
                            decimalPrecision: 2,
                            allowBlank: false,
                            //readOnly: true,
                            labelStyle: '',
                            value: 0,
                            id: 'intVlrCopago_conceptos',
                            listeners:
                            {
                                scope: this,
                                specialkey: function(f,e)
                                {
                                    if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                    {
                                        var vlr = f.getValue();  
                                        var vlrneto = Ext.getCmp('intVlrTotal_conceptos').getValue() + Ext.getCmp('intVlrIVA_conceptos').getValue() - vlr - Ext.getCmp('intVlrCM_conceptos').getValue() - Ext.getCmp('intDescuentos_conceptos').getValue();
                                        Ext.getCmp('intVlrNeto_conceptos').setValue(vlrneto);
                                    }
                                }
                            }
                        },
                        {
                            xtype: 'numericfield',
                            currencySymbol: "$",
                            useThousandSeparator: true,
                            alwaysDisplayDecimals: true,
                            thousandSeparator: ',',
                            minValue: 0,
                            fieldLabel: 'Vlr Descuentos',
                            decimalPrecision: 2,
                            allowBlank: false,
                            value: 0,
                            id: 'intDescuentos_conceptos',
                            listeners:
                            {
                                scope: this,
                                specialkey: function(f,e)
                                {
                                    if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                    {
                                        var vlr = f.getValue();  
                                        var vlrneto = Ext.getCmp('intVlrTotal_conceptos').getValue() + Ext.getCmp('intVlrIVA_conceptos').getValue() - vlr - Ext.getCmp('intVlrCM_conceptos').getValue() - Ext.getCmp('intVlrCopago_conceptos').getValue();
                                        Ext.getCmp('intVlrNeto_conceptos').setValue(vlrneto);
                                    }
                                }
                            }
                        },
                        {
                            xtype: 'numericfield',
                            currencySymbol: "$",
                            useThousandSeparator: true,
                            alwaysDisplayDecimals: true,
                            thousandSeparator: ',',
                            fieldLabel: 'Vlr Neto',
                            decimalPrecision: 2,
                            allowBlank: false,
                            readOnly: true,
                            labelStyle: '',
                            value: 0,
                            id: 'intVlrNeto_conceptos'
                        }
                    ]
                },
                {
                    xtype: 'hidden',
                    flex: 1,
                    allowBlank: true,
                    id: 'strTipoRegistroDetalle'
                }
            ],
            bbar: {
                xtype: 'toolbar',
                buttonAlign: 'right',
                height: 31,
                width: 982,
                items: [
                    {
                        xtype: 'button',
                        text: 'Guardar',
                        iconCls: 'btnGuardar',
                        id: 'btnGuardarConcepto_conceptos',
                        handler:function(){
                            fnGuardarConcepto(pCAS, wUsuario);
                        }
                    },
                    {
                        xtype: 'tbseparator'
                    },
                    {
                        xtype: 'button',
                        text: 'Salir',
                        iconCls: 'btnSalir',
                        id: 'btnSalir_conceptos',
                        handler:function(){
                            AddEditConceptoUi.close();
                        }
                    }
                ]
            }
        }]
    });
    Ext.getCmp('fsMedicamentos').setVisible(false);
    Ext.getCmp('fsAnatomopatologia').setVisible(false);
    el = Ext.get('idusaproveedor');
    ID_USAPROVEEDOR = el.getValue();
    Ext.getCmp('fsAutorizaProveedores').setVisible(false);
    /*if (ID_USAPROVEEDOR == "SI"){
        Ext.getCmp('fsAutorizaProveedores').setVisible(true);
    }else{
        Ext.getCmp('fsAutorizaProveedores').setVisible(false);
    }*/
    if (pOperacion == "edit")
   {
        Ext.getCmp('sysConsecutivo_conceptos').setValue(wConsecutivoDetalle);
        Ext.getCmp('intCAS_conceptos').setValue(pCAS);
        Ext.getCmp('intidConcepto_conceptos').setValue(widConcepto);
        Ext.getCmp('strCodConcepto_conceptos').setValue(wCodigo);
        Ext.getCmp('strDesConcepto_conceptos').setValue(wDescripcion);
        Ext.getCmp('intCantidad_conceptos').setValue(wCantidad);
        Ext.getCmp('memObservaciones_conceptos').setValue(wObservaciones);
        //Ext.getCmp('intPorAplicacion_conceptos').setValue(wPorAplicacion);
        Ext.getCmp('intPorAplicacion_conceptos').setValue(100);
        Ext.getCmp('intVlrUnitario_conceptos').setValue(wVlrTarifa);
        Ext.getCmp('intVlrTotal_conceptos').setValue(wVlrTotal);
        Ext.getCmp('intPorIVA_conceptos').setValue(wPorIVA);
        Ext.getCmp('intVlrIVA_conceptos').setValue(wVlrIVA);
        Ext.getCmp('intVlrCM_conceptos').setValue(wVlrCuotaModeradora);
        Ext.getCmp('intVlrCopago_conceptos').setValue(wVlrCopagos);
        Ext.getCmp('intDescuentos_conceptos').setValue(wVlrDescuentos);
        Ext.getCmp('intVlrNeto_conceptos').setValue(wVlrNeto);
        
        Ext.getCmp('intExamen_conceptos').setValue(wIdExamen);
        Ext.getCmp('strPrefijoExamen_conceptos').setValue(wPrefijoNroEstudio);
        Ext.getCmp('strNroExamen_conceptos').setValue(wSubNroEstudioINT);
        Ext.getCmp('intParteCuerpo_conceptos').setValue(wIdMiembro);
        Ext.getCmp('strPrioridad_conceptos').setValue(wPrioridad);
        Ext.getCmp('intPlacas_conceptos').setValue(wRecip_NroPlaca);
        Ext.getCmp('intFrascos_conceptos').setValue(wNroFrasco);
        Ext.getCmp('intBolsas_conceptos').setValue(wNroBolsa);
        Ext.getCmp('intOtros_conceptos').setValue(wRecip_NroOtro);
        Ext.getCmp('strCriteriosCalidad_conceptos').setValue(wCriteriosCalidad);
        Ext.getCmp('bolCumpleCriterioCalidad_conceptos').setValue(wCriteriosLLegaMacro);
        Ext.getCmp('strTipoRegistroDetalle').setValue(wTipoRegistroDetalle);
        if(wTipoRegistroDetalle == "LaboAnatomopatologia"){
            Ext.getCmp('fsAnatomopatologia').setVisible(true);
            Ext.getCmp('AddEditConcepto').setHeight(475);
            Ext.getCmp('frmRadicaConceptos').setHeight(450);
        }else{
            Ext.getCmp('fsAnatomopatologia').setVisible(false);
        }
        Ext.getCmp('intProveedor_conceptos').setValue(wIdProveedor);
        Ext.getCmp('memProveedor_conceptosNotas').setValue(wNotasProveedor);
        Ext.getCmp('intProveedor_conceptosOrgano').setValue(wOrganoProveedor);
        Ext.getCmp('fecProveedor_conceptosFechaRealiza').setValue(wFechaRealizado);
        Ext.getCmp('strProveedor_GenerarAuto').setValue(wGenerarAutizacionProveedor);
        Ext.getCmp('intProveedor_conceptosTarifa').setValue(wTarifaProveedor);
        /*if(wGenerarAutizacionProveedor=="SI"){
            Ext.getCmp('fsAutorizaProveedores').setVisible(true);
        }else{
            Ext.getCmp('fsAutorizaProveedores').setVisible(false);
        }*/
        Ext.getCmp('sysOperacion_conceptos').setValue("edit");
   }
   Ext.getCmp('strProveedor_GenerarAuto').setVisible(false);
   Ext.getCmp('fsAutorizaProveedores').setVisible(false);
   AddEditConceptoUi.show();
}

function fnGuardarConcepto(wCas,wUsuario){
    var frm = Ext.getCmp('frmRadicaConceptos').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        if (Ext.getCmp('sysOperacion_conceptos').getValue() == "edit")
        {
            Ext.Msg.show({
                title: 'eOfiClinic',
                msg: 'Esta seguro que desea guardar el concepto',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn)
                {
                    if(btn=="yes")
                    {
                        frm.submit({
                            waitMsg: 'Por favor Espere...',
                            url: '../../controlador/radicacionservicios/guardar_datosbasicos.php',
                            params:{
                                PROCESO: 'ModificarConcepto',
                                CAMPOS: listacampos,
                                pUsuario: wUsuario,
                                pConsecutivoDetalle: Ext.getCmp('sysConsecutivo_conceptos').getValue()
                            },
                            success: function(res,req)
                            {
                                switch(req.result.requestedId){
                                    case "1":
                                        Ext.MessageBox.hide();
                                        Ext.MessageBox.show({
                                            title: 'Guardar',
                                            msg: 'Se Guardo la Información con Exito.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.INFO
                                        });
                                        Ext.getCmp('gridServicios').store.load({
                                            params:{
                                                pCAS: wCas
                                            }
                                        });
                                        Ext.getCmp('fYaLiquidado').setValue(0);
                                        Ext.getCmp('AddEditConcepto').close();
                                        break;

                                    default:
                                        Ext.MessageBox.hide();
                                        Ext.MessageBox.show({
                                            title: 'Guardar',
                                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                        break;
                                }
                            },
                            failure: function(response,options)
                            {
                                Ext.MessageBox.hide();
                                Ext.MessageBox.show({
                                    title: 'Guardar',
                                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            }
                        });
                    }
                }
            });
        }else{
            Ext.Msg.show({
                title: 'eOfiClinic',
                msg: 'Esta seguro que desea guardar el concepto',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn)
                {
                    if(btn=="yes")
                    {
                        frm.submit({
                            waitMsg: 'Por favor Espere...',
                            url: '../../controlador/radicacionservicios/guardar_datosbasicos.php',
                            params:{
                                PROCESO: 'AdicionarConcepto',
                                CAMPOS: listacampos,
                                pUsuario: wUsuario
                            },
                            success: function(res,req)
                            {
                                switch(req.result.requestedId){
                                    case "1":
                                        Ext.MessageBox.hide();
                                        Ext.MessageBox.show({
                                            title: 'Guardar',
                                            msg: 'Se Guardo la Información con Exito.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.INFO
                                        });
                                        Ext.getCmp('fYaLiquidado').setValue(0);
                                        Ext.getCmp('gridServicios').store.load({
                                            params:{
                                                pCAS: wCas
                                            }
                                        });
                                        Ext.getCmp('AddEditConcepto').close();
                                        break;

                                    default:
                                        Ext.MessageBox.hide();
                                        Ext.MessageBox.show({
                                            title: 'Guardar',
                                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                        break;
                                }
                            },
                            failure: function(response,options)
                            {
                                Ext.MessageBox.hide();
                                Ext.MessageBox.show({
                                    title: 'Guardar',
                                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            }
                        });
                    }
                }
            });
        }
    }else{
        Ext.MessageBox.hide();
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
