/*
* @category    Funcion Buscar Estudios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
function buscarmultas(wPantalla)
{
    var DGDataStore;
    var DGColumnModel;
    var DGListingEditorGrid;
    var DGListingWindow;
    var DGListingSelectedRow;
    var DGListingContextMenu;
    var anchoPantalla;
    var MargenIzquierdo;

    var el = Ext.get('idusuario');
    var ID_USUARIO = el.getValue();
    el = Ext.get('nomusuario');
    var NOM_USUARIO = el.getValue();
    el = Ext.get('codusuario');
    var COD_USUARIO = el.getValue();
    el = Ext.get('idempresa');
    var ID_EMPRESA = el.getValue();
    el = Ext.get('nomempresa');
    var NOM_EMPRESA = el.getValue();
    el = Ext.get('idcliente');
    var ID_CLIENTE = el.getValue();
    el = Ext.get('nomcliente');
    var NOM_CLIENTE = el.getValue();
    el = Ext.get('idsede');
    var ID_SEDE = el.getValue();
    el = Ext.get('nomsede');
    var NOM_SEDE = el.getValue();
    el = Ext.get('idperfil');
    var ID_PERFIL = el.getValue();
    var ID_ORIGEN = wPantalla;
    anchoPantalla = screen.width;
    
    switch(anchoPantalla)
    {
        case 1024:
            MargenIzquierdo = 15;
            break;
        case 1280:
            MargenIzquierdo = 150;
            break;
    }

    var btnSalir = new Ext.Button({
        id: 'btnSalir',
        text: 'Salir',
        iconCls: 'btnSalir',
        minWidth: 80,
        handler:function(){
            DGListingWindow.close();
        }
    });

    DGDataStore = new Ext.data.GroupingStore({
        id: 'DGDataStore',
        proxy: new Ext.data.HttpProxy({
            url: '../../controlador/radicacionservicios/gridmultas.php',
            method: 'POST'
        }),
        baseParams: {
            pEmpresa: ID_EMPRESA,
            pIPS: ID_IPS
        },
        loadMask: {msg:"Cargando Registros, por favor espere..."},
        autoload: false,
        groupField: 'FechaEstudio',
        reader: new Ext.data.JsonReader({
            root: 'results',
            totalProperty: 'total',
            id: 'id'
          },[
            { name: 'CAS' },
            { name: 'FechaEstudio' },
            { name: 'TipDoc' },
            { name: 'Documento' },
            { name: 'PrimerApellido' },
            { name: 'SegundoApellido' },
            { name: 'PrimerNombre' },
            { name: 'SegundoNombre' }
         ])
    });
    
    DGDataStore.on('beforeload', function(store){
	store.baseParams = {
            pEmpresa: ID_EMPRESA,
            pIPS: ID_IPS,
            pCAS: Ext.getCmp('searchpCAS').getValue(),
            pDocumento: Ext.getCmp('searchpDocumento').getValue(),
            pNom1: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpNom1').getValue().toUpperCase()),
            pNom2: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpNom2').getValue().toUpperCase()),
            pApe1: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpApe1').getValue().toUpperCase()),
            pApe2: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpApe2').getValue().toUpperCase()),
            pExamen: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpExamen').getValue().toUpperCase())
        };
    });

    DGColumnModel = new Ext.grid.ColumnModel(
        [{
            header: 'CAS',
            dataIndex: 'CAS',
            width: 120,
            sortable: true,
            hideable: false
        },{
            header: 'Fecha',
            dataIndex: 'FechaEstudio',
            width: 120,
            sortable: true,
            hideable: false
        },{
            header: 'TipDoc',
            dataIndex: 'TipDoc',
            sortable: true,
            width: 40
        },{
            header: 'Documento',
            dataIndex: 'Documento',
            sortable: true,
            width: 130
        },{ 
            header: 'Primer Apellido',
            dataIndex: 'PrimerApellido',
            sortable: true,
            width: 127
        },{
            header: 'Segundo Apellido',
            dataIndex: 'SegundoApellido',
            sortable: true,
            width: 127
        },{
            header: 'Primer Nombre',
            dataIndex: 'PrimerNombre',
            sortable: true,
            width: 127
        },{
            header: 'Segundo Nombre',
            dataIndex: 'SegundoNombre',
            sortable: false,
            width: 129
        }]
    );
    DGColumnModel.defaultSortable= true;

    doMsgBoxAlert = function(record) {
        switch(wPantalla)
        {
            case "CambiarFechaRadicacion":
                Ext.getCmp('fPacienteCambiarFechaRadica').setValue("CAS: " + record.get('CAS') + " Fecha: " + record.get('FechaEstudio') + " Pac: " + record.get('TipDoc') + '-' + record.get('Documento') + " " + record.get('PrimerNombre') + " "  + record.get('SegundoNombre') + " " + record.get('PrimerApellido') + " " + record.get('SegundoApellido'));
                Ext.getCmp('sysCASCambiarFechaRadica').setValue(record.get('CAS'));
                break;
                
            default:
                break;
        }
        DGListingWindow.close();
    };

    doRowDblClick = function(thisGrid, rowIndex)  {
       var record = thisGrid.getStore().getAt(rowIndex);
       doMsgBoxAlert(record);
    };

    doRowCtxMenu = function(thisGrid, rowIndex, evtObj)
    {
        evtObj.stopEvent();
        var record = thisGrid.getStore().getAt(rowIndex);
        if (!thisGrid.rowCtxMenu)
        {
            thisGrid.rowCtxMenu = new Ext.menu.Menu({
                items : {
                    text    : 'Seleccionar Estudio',
                    handler : function() {
                        doMsgBoxAlert(record);
                    }
                }
            });
       }
       thisGrid.rowCtxMenu.showAt(evtObj.getXY());
    };
    
    DGListingEditorGrid =  new Ext.grid.GridPanel({
        id: 'DGListingEditorGrid',
        store: DGDataStore,
        cm: DGColumnModel,
        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
        iconCls:'icon-grid',
        loadMask:{msg:"Cargando Registros, por favor espere..."},
        listeners: {
           rowdblclick: doRowDblClick,
           rowcontextmenu: doRowCtxMenu,
           destroy: function(thisGrid) {
               if (thisGrid.rowCtxMenu) {
                   thisGrid.rowCtxMenu.destroy();
               }
           }
        },
        view: new Ext.grid.GroupingView({
            groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})',
            getRowClass: function(record, index, rowParams, store){
                var estado = record.data.YaFacturadoEntDetalle;
                switch (estado){
                    case "1":
                        return 'YaFacturado';
                        break;
                    default:
                        var estadoReg = record.data.CodEstadoReg;
                        switch (estadoReg){
                            case "9":
                                return 'NoActivo';
                                break;
                            default:
                                break;
                        }
                        break;
                }       
            }
        }),
        columnLines: true,
        bbar: new Ext.PagingToolbar({
            pageSize: 15,
            store: DGDataStore,
            displayInfo: true
        }),
        tbar:[
            {
                xtype: 'numberfield',
                minValue: 0,
                style: 'text-align:center;',
                emptyText: 'CAS...!',
                id: 'searchpCAS',
                width: 100
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'textfield',
                emptyText: 'Nro Documento...!',
                id: 'searchpDocumento',
                width: 100
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'textfield',
                emptyText: '1er Nombre...!',
                id: 'searchpNom1',
                width: 90
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'textfield',
                emptyText: '2do Nombre...!',
                id: 'searchpNom2',
                width: 90
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'textfield',
                emptyText: '1er Apellido...!',
                id: 'searchpApe1',
                width: 90
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'textfield',
                emptyText: '2do Apellido...!',
                id: 'searchpApe2',
                width: 90
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'textfield',
                emptyText: 'Nro Examen...!',
                id: 'searchpExamen',
                width: 90
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                tooltip: 'Buscar Paciente',
                iconCls: 'btnBuscar',
                id: 'btnEjecutarSearchPac',
                listeners:{
                    click: function(){
                        DGDataStore.load({
                            params: {
                                pCAS: Ext.getCmp('searchpCAS').getValue(),
                                pDocumento: Ext.getCmp('searchpDocumento').getValue(),
                                pNom1: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpNom1').getValue().toUpperCase()),
                                pNom2: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpNom2').getValue().toUpperCase()),
                                pApe1: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpApe1').getValue().toUpperCase()),
                                pApe2: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpApe2').getValue().toUpperCase()),
                                pExamen: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpExamen').getValue().toUpperCase()),
                                start: 0, 
                                limit: 15
                            }
                        });
                    }
                }
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                tooltip: 'Limpiar Datos del Paciente',
                iconCls: 'btnLimpiar',
                id: 'btnLimpiarSearchPac',
                listeners:{
                    click: function(){
                        Ext.getCmp('searchpCAS').setValue(null);
                        Ext.getCmp('searchpDocumento').setValue(null);
                        Ext.getCmp('searchpNom1').setValue(null);
                        Ext.getCmp('searchpNom2').setValue(null);
                        Ext.getCmp('searchpApe1').setValue(null);
                        Ext.getCmp('searchpApe2').setValue(null);
                        Ext.getCmp('searchpExamen').setValue(null);
                        DGDataStore.load({
                            params: {
                                pCAS: -1,
                                pDocumento: 'NA',
                                pApe1: 'NA',
                                pApe2: 'NA',
                                pNom1: 'NA',
                                pNom2: 'NA',
                                pExamen: 'NA',
                                start: 0, 
                                limit: 15
                            }
                        });
                    }
                }
            },
            '->',
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Seleccionar',
                iconCls: 'btnSelect',
                id: 'btnSelectSearch',
                listeners:{
                    click : function(){
                        if(Ext.getCmp('DGListingEditorGrid').selModel.getCount() == 1){
                            doMsgBoxAlert(Ext.getCmp('DGListingEditorGrid').selModel.getSelected());
                        }else{
                            Ext.MessageBox.show({
                                title: 'Pacientes',
                                msg: 'Debe Seleccionar un Registro.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ]
    });

   DGListingWindow = new Ext.Window({
        id: 'DGListingWindow',
        title: 'Busqueda de Estudios',
        closable:false,
        width:980,
        height:480,
        plain:true,
        resizable : false,
        modal: true,
        x: MargenIzquierdo,
        y:120,
        layout: 'fit',
        loadMask: true,
        items: DGListingEditorGrid,
        bbar:[{
            text  : 'Empresa: ' + NOM_EMPRESA,
            xtype : 'tbtext'
        },'->',{
            text  : 'Sistemas Ofisalud - desarrollo@ofisalud.com - Tel: 3016398114',
            xtype : 'tbtext'
        },'-',btnSalir]
    });
    DGListingWindow.show();
   
}