/*
* @category    Programacion Eventos Formulario Cambiar Entidad
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmCambiarEntidad = Ext.extend(winFrmCambiarEntidadUi, {
    initComponent: function() {
        winFrmCambiarEntidad.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        
        
        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnBuscarPacienteUnificaMalo = Ext.getCmp('btnBuscarPacienteUnificaMalo').on("click",this.BuscarPacienteMalo,this);
        var btnUnificar = Ext.getCmp('btnUnificar').on("click",this.Unificar,this);
        
    },
    BuscarPacienteMalo: function(){
        buscarestudios("CambiarFechaRadicacion");
    },
    Unificar: function(){
        Ext.Msg.show({
            title: 'OfiClinic....!',
            msg: 'Esta seguro que desea cambiar la entidad de la atencion?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    var frm = Ext.getCmp('frmModificarEntidad').getForm();
                    if (frm.isValid())
                    {
                        frm.submit({
                            url: '../../controlador/radicacionservicios/modificacioncas.php',
                            params: {
                                task: 'CAMBIAR_ENTIDAD',
                                pEmpresa: ID_EMPRESA,
                                pIPS: ID_IPS,
                                pUsuario: ID_USUARIO,
                                pCAS: Ext.getCmp('sysCASCambiarFechaRadica').getValue(),
                                pCliente: Ext.getCmp('sysIdCliente').getValue(),
                                pNomCliente: Ext.getCmp('sysIdCliente').getRawValue(),
                                pPlan: Ext.getCmp('sysIdPlan').getValue(),
                                pNomPlan: Ext.getCmp('sysIdPlan').getRawValue(),
                                pSubPlan: Ext.getCmp('sysIdSubPlan').getValue(),
                                pNomSubPlan: Ext.getCmp('sysIdSubPlan').getRawValue(),
                                pContrato: Ext.getCmp('sysIdContrato').getValue()
                            },
                            success: function(res,req)
                            {
                                switch(req.result.requestedId){
                                    case "1":
                                        Ext.MessageBox.show({
                                            title: 'OfiClinic',
                                            msg: 'Se Cambio la Entidad con Exito.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.INFO
                                        });
                                        break;

                                    default:
                                        Ext.MessageBox.show({
                                            title: 'OfiClinic',
                                            msg: 'Ocurrio un error al cambiar la entidad o no se pudo establecer conexión con el servidor.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                        break;
                                }
                            },
                            failure: function(response,options)
                            {
                                Ext.MessageBox.show({
                                    title: 'Error Base Datos',
                                    msg: 'No podemos cambiar la entidad en estos momentos',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            }
                        });
                    }else{
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Debe verificar los campos',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                }
            }
        });
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    }
    
});

