/*
* @category    Formulario Radicacion de Servicios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

var xbtnValidarDoc = new btnValidarDoc({
    id: 'btnValidarDoc',
    ref: '../../../../../../btnValidarDoc'
});

winRadicacionServiciosUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Radicación de Servicios ::.',
    width: 1024,
    height: 646,
    closable: false,
    resizable: false,
    draggable: false,
    frame: true,
    id: 'winRadicacionServicios',
    initComponent: function() {
        
        var ID_VALIDAAUDITORIA = "0";
                
        Ext.util.Format.Currency = function(v)
        {
            return FormatoMoneda(v);
        };
        
        this.items = [
            {
                xtype: 'tabpanel',
                activeTab: 0,
                width: 990,
                height: 565,
                ref: 'fTabPanel',
                id: 'fTabPanel',
                frame: true,
                items: [
                    {
                        xtype: 'panel',
                        title: 'Radicar',
                        height: 441,
                        width: 951,
                        id: 'fichaDatos',
                        autoScroll: true,
                        frame: true,
                        items: [
                            {
                                xtype: 'form',
                                title: '',
                                padding: 5,
                                border: false,
                                ref: '../../frmRadica',
                                id: 'frmRadica',
                                items: [
                                    {
                                        xtype: 'fieldset',
                                        title: 'Datos del Paciente',
                                        layout: 'table',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        width: 949,
                                        height: 317,
                                        id: 'fsPaciente',
                                        layoutConfig: {
                                            columns: 4
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnTdoc',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo Doc ID',
                                                        anchor: '100%',
                                                        name: 'cbTdoc',
                                                        allowBlank: false,
                                                        //store: 'StoreTdocPac',
                                                        store: 'StoreTdocPac',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Tipo Documento....',
                                                        mode: 'local',
                                                        triggerAction: 'all',
                                                        forceSelection: true,
                                                        ref: '../../../../../fTdoc',
                                                        disabled: true,
                                                        id: 'fTdoc'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 269,
                                                border: false,
                                                id: 'pnDocID',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Documento ID',
                                                                name: 'txtDocID',
                                                                allowBlank: false,
                                                                //anchor: '100%',
                                                                width: 200,
                                                                ref: '../../../../../fDocID',
                                                                disabled: true,
                                                                id: 'fDocID'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Paciente',
                                                                id: 'btnBuscarPacienteRadica'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnUsrVerifica',
                                                                tooltip: 'Verificar Paciente en el Listado de Atención',
                                                                ref: '../../../../btnVerificaPacienteListado',
                                                                id: 'btnVerificaPacienteListado'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 215,
                                                border: false,
                                                colspan: 1,
                                                id: 'pnRegimen',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Régimen / Tipo Usuario',
                                                        anchor: '100%',
                                                        name: 'cbRegimen',
                                                        allowBlank: false,
                                                        store: 'StoreTipoRegimen',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        emptyText: 'Seleccione Régimen/Tipo Usuario....',
                                                        forceSelection: true,
                                                        value: '1 - Contributivo',
                                                        listWidth: 350,
                                                        disabled: true,
                                                        ref: '../../../../../fRegimen',
                                                        id: 'fRegimen'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 172,
                                                border: false,
                                                colspan: 1,
                                                id: 'pnGenero',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Genero',
                                                        anchor: '100%',
                                                        name: 'cbGenero',
                                                        allowBlank: false,
                                                        store: 'StoreGenero',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        emptyText: 'Seleccione Genero....',
                                                        forceSelection: true,
                                                        disabled: true,
                                                        ref: '../../../../../fGenero',
                                                        id: 'fGenero'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnApe1',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: '1er Apellido',
                                                        anchor: '100%',
                                                        name: 'txtApe1',
                                                        style: 'text-transform:uppercase;',
                                                        allowBlank: false,
                                                        disabled: true,
                                                        ref: '../../../../../fApe1',
                                                        id: 'fApe1'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnApe2',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: '2do Apellido',
                                                        anchor: '100%',
                                                        name: 'txtApe2',
                                                        style: 'text-transform:uppercase;',
                                                        ref: '../../../../../fApe2',
                                                        disabled: true,
                                                        id: 'fApe2'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 215,
                                                border: false,
                                                id: 'pnNom1',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: '1er Nombre',
                                                        anchor: '100%',
                                                        name: 'txtNom1',
                                                        allowBlank: false,
                                                        style: 'text-transform:uppercase;',
                                                        disabled: true,
                                                        ref: '../../../../../fNom1',
                                                        id: 'fNom1'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                border: false,
                                                width: 172,
                                                id: 'pnNom2',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: '2do Nombre',
                                                        anchor: '100%',
                                                        name: 'txtNom2',
                                                        disabled: true,
                                                        style: 'text-transform:uppercase;',
                                                        id: 'fNom2'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 146,
                                                border: false,
                                                id: 'pnFecNac',
                                                items: [
                                                    {
                                                        xtype: 'datefield',
                                                        fieldLabel: 'Fecha Nacimiento',
                                                        anchor: '100%',
                                                        name: 'txtFecNac',
                                                        allowBlank: false,
                                                        disabledDates: '',
                                                        emptyText: '(dia/mes/año) ',
                                                        style: 'text-align:center;',
                                                        ref: '../../../../../fFecNac',
                                                        disabled: true,
                                                        id: 'fFecNac'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnEdad',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Edad Actual',
                                                        anchor: '100%',
                                                        name: 'txtEdad',
                                                        readOnly: true,
                                                        allowBlank: false,
                                                        style: 'color: blue;text-align:center',
                                                        disabled: true,
                                                        ref: '../../../../../fEdad',
                                                        id: 'fEdad'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 386,
                                                border: false,
                                                colspan: 2,
                                                id: 'pnDeptoMuni',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Municipio - Departamento',
                                                        anchor: '100%',
                                                        name: 'cbDeptoMuni',
                                                        allowBlank: false,
                                                        store: 'StoreDeptoMuni',
                                                        valueField: 'IdDeptoMunicipio',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Municipio - Departamento....',
                                                        mode: 'local',
                                                        listWidth: 450,
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        ref: '../../../../../fDeptoMuni',
                                                        disabled: true,
                                                        id: 'fDeptoMuni'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 928,
                                                border: false,
                                                colspan: 4,
                                                height: 54,
                                                id: 'pnDatDirTel',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        fieldLabel: 'Dirección - Teléfono - Teléfono (Otro - Cel.) - Zona - Email',
                                                        anchor: '100%',
                                                        id: 'composDatDirTel',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtDireccion',
                                                                allowBlank: false,
                                                                emptyText: 'Dirección....',
                                                                style: 'text-transform:uppercase;',
                                                                width: 250,
                                                                ref: '../../../../../../fDireccion',
                                                                disabled: true,
                                                                id: 'fDireccion'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtTel1',
                                                                allowBlank: false,
                                                                emptyText: 'Teléfono',
                                                                width: 160,
                                                                disabled: true,
                                                                id: 'fTel1'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtTel2',
                                                                emptyText: 'Teléfono (Otro - Cel.)',
                                                                width: 160,
                                                                disabled: true,
                                                                id: 'fTel2'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                flex: 1,
                                                                fieldLabel: 'Zona',
                                                                store: 'StoreZonaResidencia',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                name: 'cbZona',
                                                                emptyText: 'Zona....',
                                                                allowBlank: false,
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                width: 80,
                                                                value: 'Urbana',
                                                                triggerAction: 'all',
                                                                ref: '../../../../../../fZona',
                                                                disabled: true,
                                                                id: 'fZona'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtEmail',
                                                                vtype: 'email',
                                                                emptyText: 'Email....',
                                                                width: 140,
                                                                disabled: true,
                                                                id: 'fEmail'
                                                            },
                                                            /*{
                                                                xtype: 'button',
                                                                tooltip: 'Limpiar Datos del Paciente',
                                                                iconCls: 'btnLimpiar',
                                                                id: 'btnLimpiarPac_citas'
                                                            },*/
                                                            {
                                                                xtype: 'button',
                                                                text: 'Actualiza',
                                                                tooltip: 'Actualizar Datos del Paciente',
                                                                iconCls: 'btnGuardar',
                                                                iconAlign: 'right',
                                                                ref: '../../../../btnActualizaPac',
                                                                id: 'btnActualizaPac'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnTafiliado',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Afiliado',
                                                        anchor: '100%',
                                                        name: 'cbTafiliado',
                                                        allowBlank: false,
                                                        listEmptyText: 'Seleccione',
                                                        store: 'StoreTipoAfiliado',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        emptyText: 'Seleccione Tipo de Afiliado....',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        tpl: '',
                                                        ref: '../../../../../fTafiliado',
                                                        disabled: true,
                                                        id: 'fTafiliado'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnTafiliacion',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Parentesco',
                                                        anchor: '100%',
                                                        name: 'cbParentesco',
                                                        listEmptyText: 'Seleccione',
                                                        store: 'StoreParentesco',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        mode: 'local',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        emptyText: 'Seleccione Parentesco....',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        disabled: true,
                                                        ref: '../../../../../fParentesco',
                                                        id: 'fParentesco'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 213,
                                                border: false,
                                                id: 'pnRango',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Rango Salarial',
                                                        anchor: '100%',
                                                        name: 'cbRango',
                                                        allowBlank: false,
                                                        listEmptyText: 'Seleccione',
                                                        store: 'StoreRangoSal',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        emptyText: 'Seleccione Rango Salarial....',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        tpl: '<tpl for="."><div class="cbRango"><h3>{Descripcion}</h3><p style="font-size: 12; color: #AA0033">Valor: $ {VlrCuotaModeradora}</p><p style="font-size: 11; color: #0000EE ">Porcentaje: {txtPorcentaje} %</p><p style="font-size: 10; color: #33373d">{Observaciones}</p><hr /></div></tpl>',
                                                        itemSelector: 'div.cbRango',
                                                        listWidth: 450,
                                                        autoHeight: true,
                                                        ref: '../../../../../fRango',
                                                        disabled: true,
                                                        id: 'fRango'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 170,
                                                border: false,
                                                id: 'pnEstado',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Estado - Listado Atención',
                                                        anchor: '100%',
                                                        name: 'cbEstado',
                                                        allowBlank: false,
                                                        listEmptyText: 'Seleccione',
                                                        store: 'StoreEstadoLA',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        mode: 'local',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        emptyText: 'Estado Actual....',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        disabled: true,
                                                        autoSelect: false,
                                                        ref: '../../../../../fEstado',
                                                        id: 'fEstado'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdEmpresa',
                                                id: 'fIdEmpresa',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdSede',
                                                id: 'fIdSede',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdIPS',
                                                id: 'fIdIPS',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdPaciente',
                                                id: 'fIdPaciente',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtExcento',
                                                id: 'fExento',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtTutela',
                                                id: 'fTutela',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtClieteLA',
                                                id: 'fClienteLA',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtPlanLA',
                                                id: 'fPlanLA',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtSubPlanLA',
                                                id: 'fSubPlanLA',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtPacienteValido',
                                                id: 'fPacienteValido',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtYaLiquidado',
                                                id: 'fYaLiquidado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtYaLegalizado',
                                                id: 'fYaLegalizado',
                                                value: 0
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Datos del Cliente',
                                        layout: 'table',
                                        width: 949,
                                        height: 82,
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        id: 'fsCliente',
                                        layoutConfig: {
                                            columns: 4
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnCliete',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Cliente',
                                                        anchor: '100%',
                                                        name: 'cbCliente',
                                                        allowBlank: false,
                                                        store: 'StoreCliente',
                                                        displayField: 'Descripcion',
                                                        valueField: 'IdCliente',
                                                        emptyText: 'Selecione Cliente....',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        listWidth: 450,
                                                        typeAhead: true,
                                                        autoSelect: false,
                                                        typeAheadDelay: 50,
                                                        submitValue: true,
                                                        enableKeyEvents: true,
                                                        triggerAction: 'all',
                                                        ref: '../../../../../fCliente',
                                                        disabled: true,
                                                        id: 'fCliente'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 274,
                                                border: false,
                                                id: 'pnPlan',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Plan',
                                                        anchor: '100%',
                                                        name: 'cbPlan',
                                                        allowBlank: false,
                                                        mode: 'local',
                                                        store: 'StoreClientesPlan',
                                                        valueField: 'IdPlan',
                                                        displayField: 'Descripcion',
                                                        typeAhead: true,
                                                        triggerAction: 'all',
                                                        disabled: true,
                                                        typeAheadDelay: 50,
                                                        listWidth: 450,
                                                        emptyText: 'Selecione Plan....',
                                                        forceSelection: true,
                                                        ref: '../../../../../fPlan',
                                                        id: 'fPlan'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 215,
                                                border: false,
                                                id: 'pnSubplan',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Sub Plan',
                                                        anchor: '100%',
                                                        name: 'cbSubplan',
                                                        allowBlank: false,
                                                        disabled: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        store: 'StoreClienteSubplan',
                                                        displayField: 'Descripcion',
                                                        valueField: 'IdSubPlan',
                                                        mode: 'local',
                                                        emptyText: 'Selecione Sub Plan....',
                                                        listWidth: 450,
                                                        forceSelection: true,
                                                        ref: '../../../../../fSubPlan',
                                                        id: 'fSubPlan'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                border: false,
                                                width: 172,
                                                id: 'pnContrato',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Contrato',
                                                        anchor: '100%',
                                                        name: 'cbContrato',
                                                        allowBlank: false,
                                                        disabled: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        store: 'StoreClienteContrato',
                                                        valueField: 'IdContrato',
                                                        displayField: 'Contrato',
                                                        mode: 'local',
                                                        listWidth: 450,
                                                        emptyText: 'Selecione Contrato....',
                                                        forceSelection: true,
                                                        ref: '../../../../../fContrato',
                                                        id: 'fContrato'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtUsaListado',
                                                ref: '../../../../fUsaListado',
                                                id: 'fUsaListado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtAtenderFueraListado',
                                                ref: '../../../../fAtenderFueraListado',
                                                id: 'fAtenderFueraListado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtRequiereAutorizacion',
                                                ref: '../../../../fRequiereAutorizacion',
                                                id: 'fRequiereAutorizacion',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtFacturarParticular',
                                                ref: '../../../../fFacturarParticular',
                                                id: 'fFacturarParticular',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtMaxCopago',
                                                ref: '../../../../fMaxCopago',
                                                id: 'fMaxCopago',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'fFacturarCopagos',
                                                id: 'fFacturarCopagos',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'fCopagoDigitado',
                                                id: 'fCopagoDigitado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'fvlrCuotaModeradoraIndicada',
                                                id: 'fvlrCuotaModeradoraIndicada',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'fPorCopagos',
                                                id: 'fPorCopagos',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtUsaAuditoria',
                                                ref: '../../../../fUsaAuditoria',
                                                id: 'fUsaAuditoria',
                                                value: 0
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Datos del Solicitante',
                                        layout: 'table',
                                        width: 949,
                                        height: 82,
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        id: 'fsSolicitud',
                                        layoutConfig: {
                                            columns: 5
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 120,
                                                border: false,
                                                id: 'pnFecSol',
                                                items: [
                                                    {
                                                        xtype: 'datefield',
                                                        fieldLabel: 'Fecha Solicitud',
                                                        anchor: '100%',
                                                        name: 'txtFecSol',
                                                        allowBlank: false,
                                                        style: 'text-align:center;',
                                                        emptyText: '(dia/mes/año) ',
                                                        ref: '../../../../../fFecSol',
                                                        disabled: true,
                                                        id: 'fFecSol'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 274,
                                                border: false,
                                                colspan: 1,
                                                id: 'pnPrograma',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Programa y/o Tipo de Atención',
                                                        anchor: '100%',
                                                        name: 'cbPrograma',
                                                        allowBlank: false,
                                                        store: 'StorePrograma',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'IdPrograma',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Programa....',
                                                        submitValue: true,
                                                        ref: '../../../../../fPrograma',
                                                        disabled: true,
                                                        id: 'fPrograma'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 200,
                                                border: false,
                                                colspan: 1,
                                                iconCls: '',
                                                id: 'pnAutorizacion',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Autorización',
                                                        anchor: '100%',
                                                        name: 'txtAutorizacion',
                                                        style: 'text-transform:uppercase;',
                                                        allowBlank: false,
                                                        disabled: true,
                                                        ref: '../../../../../fAutorizacion',
                                                        id: 'fAutorizacion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                border: false,
                                                width: 340,
                                                colspan: 2,
                                                id: 'pnProfesional',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Profesional / IPS  Solicitante',
                                                                name: 'cbProfeSol',
                                                                allowBlank: false,
                                                                store: 'StoreProfeSol',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                emptyText: 'Seleccione Profesional / IPS Solicitante....',
                                                                valueField: 'idProfeSolicitante',
                                                                displayField: 'Descripcion',
                                                                width: 300,
                                                                listWidth: 450,
                                                                submitValue: true,
                                                                ref: '../../../../../fProfeSol',
                                                                disabled: true,
                                                                id: 'fProfeSol'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnDoctor',
                                                                tooltip: 'Adicionar Profesional / IPS Solicitante',
                                                                ref: '../../../../btnVerificaPacienteListado',
                                                                id: 'btnAddProfeSol'
                                                            }
                                                        ]
                                                    }
                                                 ]
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtFinalidad',
                                                ref: '../../../../fFinalidad',
                                                id: 'fFinalidad',
                                                value: '10'
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtExento',
                                                ref: '../../../../fExentoPrograma',
                                                id: 'fExentoPrograma',
                                                value: 0
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Datos del Concepto',
                                        layout: 'form',
                                        width: 949,
                                        height: 105,
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        id: 'fsConcepto',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                fieldLabel: 'Concepto',
                                                items: [
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Concepto',
                                                        id: 'btnSearchConcepto',
                                                        handler:function(){
                                                            buscarconcepto(ID_VALIDAAUDITORIA,'NO','NA','NA',Ext.getCmp('fCliente').getValue(),Ext.getCmp('fPlan').getValue(),Ext.getCmp('fSubPlan').getValue());
                                                        }
                                                    },
                                                    {
                                                        xtype: 'textfield',
                                                        readOnly: true,
                                                        width: 96,
                                                        allowBlank: true,
                                                        style: 'color: #0000cc; font-weight: bold;',
                                                        id: 'sysCodConcepto'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 695,
                                                        height: 40,
                                                        fieldLabel: 'Descripción',
                                                        style: 'font-family: Arial,Helvetica,sans-serif;font-size: 10px; color: #0000cc; font-weight: bold;',
                                                        id: 'sysDesConcepto'
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'sysIdProcedimiento',
                                                        value: 0
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'sysIVA',
                                                        value: 0
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'sysVlrIVA',
                                                        value: 0
                                                    },
                                                    {
                                                        xtype: 'hidden',
                                                        id: 'sysidTipoReg',
                                                        value: 0
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                fieldLabel: 'Vlr Tarifa',
                                                items: [
                                                    {
                                                        xtype: 'numericfield',
                                                        currencySymbol: "$",
                                                        useThousandSeparator: true,
                                                        alwaysDisplayDecimals: true,
                                                        thousandSeparator: ',',
                                                        minValue: 0,
                                                        decimalPrecision: 2,
                                                        allowBlank: true,
                                                        id: 'sysVlrTarifa'
                                                    },
                                                    /*
                                                    {
                                                        xtype: 'displayfield',
                                                        id: 'sysCASIndependiente',
                                                        value: 'Crear CAS por Servicio?:'
                                                    },*/
                                                    {
                                                        xtype: 'hidden',
                                                        labelStyle: 'color: Brown;',
                                                        anchor: '100%',
                                                        value: true,
                                                        tooltip: 'RIPS',
                                                        id: 'bolCrearCASxServicio'
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'RIPS CONSULTAS - AC',
                                        layout: 'form',
                                        width: 890,
                                        autoHeight: true,
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        id: 'fsRIPSAC',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Principal',
                                                        id: 'sysDiagPpalHC'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 600,
                                                        height: 22,
                                                        id: 'sysDiagPpalHCNom'
                                                    },
                                                    /*{
                                                        xtype: 'combo',
                                                        fieldLabel: 'Diagnostico Principal',
                                                        width:700,
                                                        name: 'Diagnostico Principal',
                                                        allowBlank: false,
                                                        store: 'StoreCIE10',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Diagnostico....',
                                                        submitValue: true,
                                                        id: 'sysDiagPpalHC'
                                                    },*/
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Principal',
                                                        id: 'btnSearchDiagPpalHC',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagPpalHC','sysDiagPpalHCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                        id: 'sysDiagRel1HC'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 600,
                                                        height: 22,
                                                        id: 'sysDiagRel1HCNom'
                                                    },
                                                    /*{
                                                        xtype: 'combo',
                                                        fieldLabel: 'Diagnostico Relacionado Nro.1',
                                                        name: 'Diagnostico Relacionado1',
                                                        width:700,
                                                        allowBlank: true,
                                                        store: 'StoreCIE10',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Diagnostico....',
                                                        submitValue: true,
                                                        id: 'sysDiagRel1HC'
                                                    },*/
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado1',
                                                        id: 'btnSearchDiagRel1HC',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel1HC','sysDiagRel1HCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                        id: 'sysDiagRel2HC'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 600,
                                                        height: 22,
                                                        id: 'sysDiagRel2HCNom'
                                                    },
                                                    /*{
                                                        xtype: 'combo',
                                                        fieldLabel: 'Diagnostico Relacionado Nro.2',
                                                        name: 'Diagnostico Relacionado Nro2',
                                                        width:700,
                                                        allowBlank: true,
                                                        store: 'StoreCIE10',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Diagnostico....',
                                                        submitValue: true,
                                                        id: 'sysDiagRel2HC'
                                                    },*/
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado2',
                                                        id: 'btnSearchDiagRel2HC1',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel2HC','sysDiagRel2HCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                        id: 'sysDiagRel3HC'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 600,
                                                        height: 22,
                                                        id: 'sysDiagRel3HCNom'
                                                    },
                                                    /*{
                                                        xtype: 'combo',
                                                        fieldLabel: 'Diagnostico Relacionado Nro.3',
                                                        name: 'Diagnostico Relacionado Nro3',
                                                        width:700,
                                                        allowBlank: true,
                                                        store: 'StoreCIE10',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Diagnostico....',
                                                        submitValue: true,
                                                        id: 'sysDiagRel3HC'
                                                    },*/
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado3',
                                                        id: 'btnSearchDiagRel3HC',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel3HC','sysDiagRel3HCNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Tipo de Diagnostico',
                                                width:700,
                                                name: 'Tipo de Diagnostico',
                                                allowBlank: false,
                                                store: 'StoreTipoDiagnostico',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                id: 'sysTipoDiagosticoHC'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Finalidad Consulta',
                                                width:700,
                                                name: 'Finalidad Consulta',
                                                allowBlank: false,
                                                store: 'StoreFinalidadConsulta',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                //value: 10,
                                                id: 'sysFinalidadConsultaHC'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Causa Externa',
                                                width:700,
                                                name: 'Causa Externa',
                                                allowBlank: false,
                                                store: 'StoreCausaExterna',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                //value: 13,
                                                id: 'sysCausaExternaHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'RIPS PROCEDIMIENTOS - AP',
                                        layout: 'form',
                                        width: 890,
                                        autoHeight: true,
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        id: 'fsRIPSAP',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Principal',
                                                        id: 'sysDiagPpalProc'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 600,
                                                        height: 22,
                                                        id: 'sysDiagPpalProcNom'
                                                    },
                                                    /*{
                                                        xtype: 'combo',
                                                        fieldLabel: 'Diagnostico Principal',
                                                        width:700,
                                                        name: 'Diagnostico Principal',
                                                        allowBlank: false,
                                                        store: 'StoreCIE10',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Diagnostico....',
                                                        submitValue: true,
                                                        id: 'sysDiagPpalProc'
                                                    },*/
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Principal',
                                                        id: 'btnSearchDiagPpalProc',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagPpalProc','sysDiagPpalProcNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Relacionado',
                                                        id: 'sysDiagRel1Proc'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 600,
                                                        height: 22,
                                                        id: 'sysDiagRel1ProcNom'
                                                    },
                                                    /*{
                                                        xtype: 'combo',
                                                        fieldLabel: 'Diagnostico Relacionado',
                                                        width:700,
                                                        name: 'Diagnostico Relacionado',
                                                        allowBlank: true,
                                                        store: 'StoreCIE10',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Diagnostico....',
                                                        submitValue: true,
                                                        id: 'sysDiagRel1Proc'
                                                    },*/
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Relacionado',
                                                        id: 'btnSearchDiagRel1Proc',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel1Proc','sysDiagRel1ProcNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 96,
                                                        allowBlank: true,
                                                        fieldLabel: 'Diagnostico Complicación',
                                                        id: 'sysDiagRel2Proc'
                                                    },
                                                    {
                                                        xtype: 'textarea',
                                                        readOnly: true,
                                                        width: 600,
                                                        height: 22,
                                                        id: 'sysDiagRel2ProcNom'
                                                    },
                                                    /*{
                                                        xtype: 'combo',
                                                        fieldLabel: 'Diagnostico Complicación',
                                                        width:700,
                                                        name: 'Diagnostico Complicación',
                                                        allowBlank: true,
                                                        store: 'StoreCIE10',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Diagnostico....',
                                                        submitValue: true,
                                                        id: 'sysDiagRel2Proc'
                                                    },*/
                                                    {
                                                        xtype: 'button',
                                                        iconCls: 'btnBuscar',
                                                        tooltip: 'Buscar Diagnostico Complicación',
                                                        id: 'btnSearchDiagRel1Proc',
                                                        listeners:{
                                                            click : function(){
                                                                buscarcie10('sysDiagRel2Proc','sysDiagRel2ProcNom');
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Ambito',
                                                width:700,
                                                name: 'Ambito',
                                                allowBlank: false,
                                                store: 'StoreAmbitoProcedimiento',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                //value: 1,
                                                id: 'sysAmbitoProc'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Finalidad Procedimiento',
                                                width:700,
                                                name: 'Finalidad Procedimiento',
                                                allowBlank: false,
                                                store: 'StoreFinalidadProcedimiento',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                id: 'sysFinalidadProcedimientoProc'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Personal Atiende',
                                                width:700,
                                                name: 'Personal Atiende',
                                                allowBlank: false,
                                                store: 'StorePersonalAtiendeProcedimiento',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                id: 'sysPersonalAtiendeProcedimientoProc'
                                            },
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Forma Realización Acto Quirúrgico',
                                                width:700,
                                                name: 'Forma Realización Acto Quirúrgico',
                                                allowBlank: false,
                                                store: 'StoreFormaRealizacionProcedimiento',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                //value: 1,
                                                id: 'sysFormaRealizaProcedimientoProc'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        title: 'Conceptos Solicitados',
                                        layout: 'vbox',
                                        frame: true,
                                        width: 950,
                                        height: 410,
                                        ref: '../fichaServicios',
                                        id: 'fichaServicios',
                                        layoutConfig: {
                                            align: 'stretch'
                                        },
                                        items: [
                                            {
                                                xtype: 'grid',
                                                id: 'gridConceptosRadicacion',
                                                store: 'DTSConceptosRadicacion', 
                                                anchor: "100%",
                                                border: false,
                                                frame: true,
                                                flex: 1,
                                                height: 190,
                                                columns: [
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Fecha',
                                                        sortable: false,
                                                        width: 100,
                                                        dataIndex: 'Fecha',
                                                        renderer : Ext.util.Format.dateRenderer('Y/m/d'), 
                                                        id: 'Fecha'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Codigo',
                                                        sortable: false,
                                                        width: 120,
                                                        dataIndex: 'codConcepto',
                                                        id: 'codConcepto'
                                                    },
                                                    {
                                                        xtype: 'gridcolumn',
                                                        header: 'Descripcion',
                                                        sortable: false,
                                                        width: 685,
                                                        dataIndex: 'desConcepto',
                                                        id: 'desConcepto'
                                                    }
                                                ],
                                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                                stripeRows: true,
                                                tbar:
                                                {
                                                    xtype: 'toolbar',
                                                    items: [
                                                        {
                                                            xtype: 'button',
                                                            text: 'Adicionar Registro',
                                                            iconCls: 'btnAddRow',
                                                            id: 'btnAddRegistroConcepto'
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        },
                                                        {
                                                            xtype: 'button',
                                                            text: 'Eliminar Registro',
                                                            iconCls: 'btnDelRow',
                                                            id: 'btnDelRegistroConcepto'
                                                        },
                                                        {
                                                            xtype: 'tbseparator'
                                                        }
                                                    ]
                                                }
                                            },
                                            {
                                                xtype: 'panel',
                                                title: 'Información Detallada del Concepto',
                                                flex: 1,
                                                tpl: [
                                                    '<table border="0" width="890"><tr><td class="ServicioID">{codConcepto} - {desConcepto}</td></tr></table>',
                                                    '<table border="0" width="890"><tr><td width="100">Tarifa:</td><td width="100">$ {vlrTarifa}</td><td width="130">Cuota Moderadora:</td><td width="100">$ {vlrCuotaModeradora}</td><td width="100">Copagos:</td><td width="100">$ {vlrCopago}</td><td width="100">Descuentos:</td><td width="100">$ {vlrDescuentos}</td><td width="100">Neto:</td><td width="100">$ {vlrNeto}</td></tr></table>',
                                                    '<table border="0" width="890"><tr><td width="100">Fecha Atencion:</td><td width="100">{Fecha}</td><td width="50">Profesional:</td><td>{nomProfesional}</td></tr></table>',
                                                    '<tpl if="idTipoReg==\'1\'">',
                                                    '<table border="0" width="890">',
                                                    '<tr><td width="100">Finalidad:</td><td>{nomfinalidadConsulta}</td></tr>',
                                                    '<tr><td width="100">Causa Externa:</td><td>{nomcausaExterna}</td></tr>',
                                                    '<tr><td width="100">Tipo Diagnostico:</td><td>{nomtipDiagnostico}</td></tr>',
                                                    '<tr><td width="100">Diag Ppal:</td><td>{nomdiagPpal}</td></tr>',
                                                    '<tr><td width="100">Diag Rel1:</td><td>{nomdiagRel1}</td></tr>',
                                                    '<tr><td width="100">Diag Rel2:</td><td>{nomdiagRel2}</td></tr>',
                                                    '<tr><td width="100">Diag Rel3:</td><td>{nomdiagRel3}</td></tr>',
                                                    '</table>',
                                                    '</tpl>',
                                                    '<tpl if="idTipoReg==\'2\'">',
                                                    '<table border="0" width="890">',
                                                    '<tr><td width="100">Ambito:</td><td>{nomAmbito}</td></tr>',
                                                    '<tr><td width="100">Finalidad:</td><td>{nomfinalidadProcedimiento}</td></tr>',
                                                    '<tr><td width="100">Personal Atiende:</td><td>{nompersonalAtiende}</td></tr>',
                                                    '<tr><td width="100">Diag Ppal:</td><td>{nomdiagPpalProc}</td></tr>',
                                                    '<tr><td width="100">Diag Rel:</td><td>{nomdiagRel1Proc}</td></tr>',
                                                    '<tr><td width="100">Diag Complicacion:</td><td>{nomdiagRel2Proc}</td></tr>',
                                                    '<tr><td width="100">Forma Acto Qx:</td><td>{nomformaRealizacion}</td></tr>',
                                                    '</table>',
                                                    '</tpl>',
                                                ],
                                                padding: 10,
                                                height: 190,
                                                autoScroll: true,
                                                ref: '../../pnDetalleServicio',
                                                id: 'pnDetalleServicio'
                                            }
                                        ]
                                    },
                                    
                                    {
                                        xtype: 'hidden',
                                        name: 'txtCas',
                                        id: 'fCas',
                                        value: 0
                                    },
                                    {
                                        xtype: 'hidden',
                                        name: 'txtCas',
                                        id: 'fModificaCAS',
                                        value: 0
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
        this.tbar = {
            xtype: 'toolbar',
            id: 'tbar',
            items: [
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Nuevo',
                    iconCls: 'btnNuevo',
                    ref: '../btnNuevo',
                    id: 'btnNuevo'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Generar Radicación de Servicios',
                    iconCls: 'btnGuardar',
                    ref: '../btnRadicar',
                    id: 'btnRadicar'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'textfield',
                    value: '',
                    width: 110,
                    readOnly: true,
                    name: 'sysTextoEliminado',
                    style: 'background:transparent;color: darkred; font-size: large; font-weight: bold;border:none;',
                    id: 'sysTextoEliminado',
                    listeners:{
                        render: function( p ) {
                            p.getEl().on('dblclick', function (){
                                alert("Ver Quien Modifico");
                            });
                        }
                    }
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Reactivar CAS',
                    iconCls: 'btnAceptar',
                    id: 'btnReactivarCAS'
                },        
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'Sin Registrar',
                    name: 'txtNroCAS',
                    style: 'color: darkblue; font-size: large; font-weight: bold;',
                    ref: '../fNroCAS',
                    id: 'fNroCAS'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    name: 'txtFecRadicado',
                    style: 'color: darkblue; font-size: 13px; font-weight: bold;',
                    ref: '../fFecRadicado',
                    id: 'fFecRadicado'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    name: 'txtEstadoCAS',
                    style: 'color: red; font-size: 13px; font-weight: bold;text-decoration: blink;',
                    ref: '../fEstadoCAS',
                    id: 'fEstadoCAS'
                }
            ]
        };
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnAyuda',
                    tooltip: 'Ver Ayuda en Linea',
                    ref: '../btnAyuda',
                    id: 'btnAyuda'
                },
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'displayfield',
                    value: 'Empresa: PASBISALUD IPS',
                    name: 'txtNomEmpresa',
                    ref: '../fNomEmpresa',
                    id: 'fNomEmpresa'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'Sede: MANIZALES',
                    name: 'txtNomSede',
                    ref: '../fNomSede',
                    id: 'fNomSede'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'IPS: BELEN',
                    name: 'txtNomSede',
                    ref: '../fNomIPS',
                    id: 'fNomIPS'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnUsr',
                    ref: '../btnUsr',
                    id: 'btnUsr'
                },
                {
                    xtype: 'displayfield',
                    value: 'Usuario: GJUAN ',
                    name: 'txtNomUSR',
                    style: 'color:royalblue',
                    ref: '../fNomUSR',
                    id: 'fNomUSR'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    ref: '../btnSalir',
                    id: 'btnSalir'
                }
            ]
        };
        winRadicacionServiciosUi.superclass.initComponent.call(this);
    }
});
