/*
* @category    Funcion Adicionar / Editar Concepto
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
function AddEditConcepto(pOperacion)
{
    
    var winRadicaConceptosUi = new Ext.Window({
        title: 'Radicación de Conceptos',
        width: 994,
        height: 354,
        modal: true,
        closable: false,
        resizable: false,
        draggable: false,
        id: 'winRadicaConceptos',
        items: [
        {
            xtype: 'form',
            width: 980,
            height: 329,
            padding: 5,
            layout: 'border',
            ref: 'frmRadicaConceptos',
            id: 'frmRadicaConceptos',
            items: [
                {
                    xtype: 'panel',
                    flex: 1,
                    region: 'west',
                    width: 710,
                    padding: 10,
                    layout: 'form',
                    autoScroll: true,
                    ref: '../pnDatosConcepto',
                    id: 'pnDatosConcepto',
                    items: [
                        {
                            xtype: 'compositefield',
                            fieldLabel: 'Concepto',
                            width: 566,
                            id: 'cmpConceptos',
                            items: [
                                {
                                    xtype: 'button',
                                    iconCls: 'btnSearch',
                                    tooltip: 'Buscar Concepto',
                                    ref: '../../../../btnSearchConcepto',
                                    id: 'btnSearchConcepto',
                                    handler:function(){
                                        buscarconcepto('Radicacion', '1');
                                    }
                                },
                                {
                                    xtype: 'textfield',
                                    flex: 1,
                                    readOnly: true,
                                    width: 96,
                                    style: 'color: #0000cc; font-weight: bold;',
                                    ref: '../../../../fCodConcepto',
                                    id: 'fCodConcepto'
                                },
                                {
                                    xtype: 'textarea',
                                    flex: 1,
                                    readOnly: true,
                                    width: 435,
                                    height: 90,
                                    style: 'font-family: Arial,Helvetica,sans-serif;font-size: 10px; color: #0000cc; font-weight: bold;',
                                    ref: '../../../../fDesConcepto',
                                    id: 'fDesConcepto'
                                }
                            ]
                        },
                        {
                            xtype: 'numberfield',
                            minValue: 1,
                            fieldLabel: 'Cantidad',
                            decimalPrecision: 0,
                            allowBlank: false,
                            ref: '../../fCantidad',
                            id: 'fCantidad',
                            listeners:
                            {
                                scope: this,
                                specialkey: function(f,e)
                                {
                                    if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                    {
                                        var vlr = Ext.getCmp('fVlrUnitario').getValue() * Ext.getCmp('fCantidad').getValue();
                                        Ext.getCmp('fVlrTotal').setValue(vlr);
                                        Ext.getCmp('fVlrNeto').setValue(vlr);
                                    }
                                }
                            }
                        },
                        {
                            xtype: 'textarea',
                            fieldLabel: 'Observaciones',
                            width: 565,
                            height: 50,
                            emptyText: 'Observaciones / Notas a Proveedor',
                            ref: '../../fObservaciones',
                            id: 'fObservaciones'
                        },
                        {
                            xtype: 'fieldset',
                            title: 'Suministro de Medicamentos',
                            autoScroll: true,
                            collapsible: true,
                            //collapsed: true,
                            width: 670,
                            animCollapse: true,
                            ref: '../../fsMedicamentos',
                            id: 'fsMedicamentos',
                            items: [
                                {
                                    xtype: 'numberfield',
                                    fieldLabel: 'Consumo x Día',
                                    ref: '../../../fConsumoDia',
                                    id: 'fConsumoDia'
                                },
                                {
                                    xtype: 'textfield',
                                    fieldLabel: 'Posología',
                                    anchor: '100%',
                                    ref: '../../../fPosologia',
                                    id: 'fPosologia'
                                }
                            ]
                        },
                        {
                            xtype: 'fieldset',
                            title: 'Laboratorio Anatomía Patológica y Citología',
                            autoScroll: true,
                            collapsible: true,
                            //collapsed: true,
                            width: 670,
                            animCollapse: true,
                            ref: '../../fsAnatomopatologia',
                            id: 'fsAnatomopatologia',
                            items: [
                                {
                                    xtype: 'combo',
                                    title: '',
                                    name: 'cbExamen',
                                    width: 542,
                                    fieldLabel: 'Examen',
                                    autoHeight: true,
                                    boxMaxHeight: 100,
                                    forceSelection: true,
                                    displayField: 'Descripcion',
                                    listWidth: 950,
                                    listEmptyText: '',
                                    valueField: 'Codigo',
                                    validationDelay: 50,
                                    typeAhead: true,
                                    emptyText: 'Seleccione un Procedimiento...',
                                    mode: 'local',
                                    ref: '../../../fExamen',
                                    id: 'fExamen'
                                },
                                {
                                    xtype: 'compositefield',
                                    fieldLabel: 'Nro Examen',
                                    anchor: '100%',
                                    id: 'cmpExamen',
                                    items: [
                                        {
                                            xtype: 'textfield',
                                            flex: 1,
                                            readOnly: true,
                                            width: 79,
                                            ref: '../../../../fPrefijoExamen',
                                            id: 'fPrefijoExamen'
                                        },
                                        {
                                            xtype: 'textfield',
                                            flex: 1,
                                            width: 130,
                                            ref: '../../../../fNroExamen',
                                            id: 'fNroExamen'
                                        }
                                    ]
                                },
                                {
                                    xtype: 'combo',
                                    title: '',
                                    name: 'cbParteCuerpo',
                                    width: 542,
                                    fieldLabel: 'Parte Cuerpo',
                                    autoHeight: true,
                                    boxMaxHeight: 100,
                                    forceSelection: true,
                                    displayField: 'Descripcion',
                                    listWidth: 950,
                                    listEmptyText: '',
                                    valueField: 'Codigo',
                                    validationDelay: 50,
                                    typeAhead: true,
                                    emptyText: 'Seleccione un Procedimiento...',
                                    mode: 'local',
                                    ref: '../../../fParteCuerpo',
                                    id: 'fParteCuerpo'
                                },
                                {
                                    xtype: 'combo',
                                    title: '',
                                    name: 'cbPrioridad',
                                    width: 542,
                                    fieldLabel: 'Prioridad',
                                    autoHeight: true,
                                    boxMaxHeight: 100,
                                    forceSelection: true,
                                    displayField: 'Descripcion',
                                    listWidth: 950,
                                    listEmptyText: '',
                                    valueField: 'Codigo',
                                    validationDelay: 50,
                                    typeAhead: true,
                                    emptyText: 'Seleccione un Procedimiento...',
                                    mode: 'local',
                                    ref: '../../../fPrioridad',
                                    id: 'fPrioridad'
                                },
                                {
                                    xtype: 'compositefield',
                                    fieldLabel: 'Nro Muestras',
                                    anchor: '100%',
                                    id: 'cmpNroMuestras',
                                    items: [
                                        {
                                            xtype: 'numberfield',
                                            flex: 1,
                                            emptyText: 'Nro Placas',
                                            ref: '../../../../fPlacas',
                                            id: 'fPlacas'
                                        },
                                        {
                                            xtype: 'numberfield',
                                            flex: 1,
                                            emptyText: 'Nro Frascos',
                                            ref: '../../../../fFrascos',
                                            id: 'fFrascos'
                                        },
                                        {
                                            xtype: 'numberfield',
                                            flex: 1,
                                            emptyText: 'Nro Bolsas',
                                            ref: '../../../../fBolsas',
                                            id: 'fBolsas'
                                        },
                                        {
                                            xtype: 'numberfield',
                                            flex: 1,
                                            emptyText: 'Nro Otros',
                                            ref: '../../../../fOtros',
                                            id: 'fOtros'
                                        }
                                    ]
                                },
                                {
                                    xtype: 'combo',
                                    title: '',
                                    name: 'cbCriteriosCalidad',
                                    width: 542,
                                    fieldLabel: 'Criterios Calidad',
                                    autoHeight: true,
                                    boxMaxHeight: 100,
                                    forceSelection: true,
                                    displayField: 'Descripcion',
                                    listWidth: 950,
                                    listEmptyText: '',
                                    valueField: 'Codigo',
                                    validationDelay: 50,
                                    typeAhead: true,
                                    emptyText: 'Seleccione un Procedimiento...',
                                    mode: 'local',
                                    ref: '../../../fCriteriosCalidad',
                                    id: 'fCriteriosCalidad'
                                },
                                {
                                    xtype: 'checkbox',
                                    boxLabel: 'Cumple Criterios de Calidad de la Informacion que llega a Macro?',
                                    anchor: '100%',
                                    ref: '../../../fCumpleCriterioCalidad',
                                    id: 'fCumpleCriterioCalidad'
                                }
                            ]
                        },
                        {
                            xtype: 'combo',
                            title: '',
                            name: 'cbProveedor',
                            width: 566,
                            fieldLabel: 'Proveedor',
                            autoHeight: true,
                            boxMaxHeight: 100,
                            forceSelection: true,
                            displayField: 'Descripcion',
                            listWidth: 950,
                            listEmptyText: '',
                            valueField: 'Codigo',
                            validationDelay: 50,
                            typeAhead: true,
                            allowBlank: false,
                            emptyText: 'Seleccione un Proveedor...',
                            mode: 'local',
                            ref: '../../fProveedor',
                            id: 'fProveedor'
                        }
                    ]
                },
                {
                    xtype: 'panel',
                    region: 'center',
                    padding: 10,
                    layout: 'form',
                    ref: '../pnValorProced',
                    id: 'pnValorProced',
                    items: [
                        {
                            xtype: 'numberfield',
                            minValue: 1,
                            fieldLabel: '% Aplicación',
                            decimalPrecision: 0,
                            allowBlank: false,
                            ref: '../../fPorAplicacion',
                            id: 'fPorAplicacion'
                        },
                        {
                            xtype: 'numberfield',
                            minValue: 0,
                            fieldLabel: 'Vlr Unitario',
                            decimalPrecision: 0,
                            allowBlank: false,
                            readOnly: true,
                            ref: '../../fVlrUnitario',
                            id: 'fVlrUnitario'
                        },
                        {
                            xtype: 'numberfield',
                            minValue: 0,
                            fieldLabel: 'Vlr Total',
                            decimalPrecision: 0,
                            allowBlank: false,
                            readOnly: true,
                            ref: '../../fVlrTotal',
                            id: 'fVlrTotal'
                        },
                        {
                            xtype: 'numberfield',
                            minValue: 0,
                            fieldLabel: 'Vlr Cuota Moderadora',
                            decimalPrecision: 0,
                            allowBlank: false,
                            readOnly: true,
                            labelStyle: '',
                            ref: '../../fVlrCM',
                            id: 'fVlrCM'
                        },
                        {
                            xtype: 'numberfield',
                            minValue: 0,
                            fieldLabel: 'Vlr Copago',
                            decimalPrecision: 0,
                            allowBlank: false,
                            readOnly: true,
                            labelStyle: '',
                            ref: '../../fVlrCopago',
                            id: 'fVlrCopago'
                        },
                        {
                            xtype: 'numberfield',
                            minValue: 0,
                            fieldLabel: 'Vlr Descuentos',
                            decimalPrecision: 0,
                            allowBlank: false,
                            value: 0,
                            ref: '../../fDescuentos',
                            id: 'fDescuentos'
                        },
                        {
                            xtype: 'numberfield',
                            minValue: 0,
                            fieldLabel: 'Vlr Neto',
                            decimalPrecision: 0,
                            allowBlank: false,
                            readOnly: true,
                            labelStyle: '',
                            ref: '../../fVlrNeto',
                            id: 'fVlrNeto'
                        }
                    ]
                }
            ],
            bbar: {
                xtype: 'toolbar',
                buttonAlign: 'right',
                height: 31,
                width: 982,
                items: [
                    {
                        xtype: 'button',
                        text: 'Guardar',
                        iconCls: 'btnGuardar',
                        ref: '../../btnGuardar',
                        id: 'btnGuardar'
                    },
                    {
                        xtype: 'tbseparator'
                    },
                    {
                        xtype: 'button',
                        text: 'Salir',
                        iconCls: 'btnSalir',
                        ref: '../../btnSalir',
                        id: 'btnSalir',
                        handler:function(){
                            winRadicaConceptosUi.close();
                        }
                    }
                ]
            }
        }]
    });
    Ext.getCmp('fsMedicamentos').setVisible(false);
    Ext.getCmp('fsAnatomopatologia').setVisible(false);
    /*if (pOperacion == "add")
    {
        Ext.getCmp('btnModificar').setVisible(false);
        Ext.getCmp('btnGuardar').setVisible(true);
    } else {
        Ext.getCmp('btnModificar').setVisible(true);
        Ext.getCmp('btnGuardar').setVisible(false);
    }*/
    winRadicaConceptosUi.show();
}