/*
* @category    Formulario Adicionar Bitacora de Seguimiento
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddBitacoraUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Adicionar Bitacora de Seguimiento ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAddBitacora',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddBitacora',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysIdCitaCXBS'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuarioBS'
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        fieldLabel: 'Bitacora',
                        name: 'strBitacora',
                        maxLength: 400,
                        allowBlank: false,
                        emptyText: 'Digite el Motivo del Seguimiento...!',
                        id: 'strMotivo'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            listeners:{
                                click : function(){
                                    var frm = Ext.getCmp('frmAddBitacora').getForm();
                                    if (frm.isValid()){
                                        frm.submit({
                                            url: '../../controlador/asignarcitasesp/controlador_radicarcitas.php',
                                            params: {
                                                task: 'GUARDAR_BITACORA',
                                                pIdCita: Ext.getCmp('sysIdCitaCXBS').getValue(),
                                                pMotivo: QuitarAcentosMayusculas(Ext.getCmp('strMotivo').getValue()),
                                                pUsuario: Ext.getCmp('sysUsuarioBS').getValue()
                                            },
                                            success: function(res,req)
                                            {
                                                switch(req.result.requestedId){
                                                    case "1":
                                                        Ext.getCmp('gridBitacoraCitasRadicada').store.reload();
                                                        Ext.getCmp('winAddBitacora').close();
                                                        break;

                                                    default:
                                                        Ext.MessageBox.show({
                                                            title: 'Bitacora',
                                                            msg: 'Ocurrio un error al guardar el seguimiento la cita o no se pudo establecer conexión con el servidor.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                        break;
                                                }
                                            },
                                            failure: function(response,options)
                                            {
                                                Ext.MessageBox.show({
                                                    title: 'Error Base Datos',
                                                    msg: 'No podemos guardar el seguimiento en estos momentos',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        });
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'El Motivo del Seguimiento es Requerido',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winAddBitacoraUi.superclass.initComponent.call(this);
    }
});
