/*
* @category    Cargar CargarFotoPaciente
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

CargarFotoPacienteUi = Ext.extend(Ext.Window, {
    layout: 'fit',
    id: 'CargarFotoPacienteUi',
    width: 560,
    autoHeight: true,
    //closeAction: 'hide',
    closable: true,
    plain: true,
    modal: true,
    frame: true,
    border: false,
    draggable: false,
    resizable: false,
    title: 'Adjuntar Foto del Paciente',

    initComponent: function() {
        el = Ext.get('idxac');
        var xID_CONSULTORIO = el.getValue();
        el = Ext.get('idaplicacion');
        NOM_APLICACION = el.getValue();
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();

        var frmCargarArchivo = new Ext.FormPanel({
            fileUpload: true,
            labelWidth: 80,
            frame: true,
            height: 49,
            url: '../../controlador/recursos/fotopaciente.php',
            bodyStyle: 'padding:0px 0px 30px',
            defaults: {
                allowBlank: false
            },
            items: [
                {
                    xtype: 'fileuploadfield',
                    anchor: '99%',
                    id: 'archivoFoto',
                    fieldLabel: 'Archivo',
                    name: 'foto-path',
                    buttonText: '...',
                    buttonCfg: {}
                }
            ]
        });
    
        this.items = [
            {
                xtype: 'hidden',
                anchor: '100%',
                allowBlank: true,
                id: 'sysPacienteFoto'
            },
            frmCargarArchivo
        ];
        this.buttons = [
            {
                text: 'Adjuntar Foto',
                iconCls: 'btnCargarFile',
                handler: function(){
                    nomTarea = "GRABAR_OFIMEDICAL";
                    if(NOM_APLICACION === "OfiMedical"){
                        nomTarea = "GRABAR_OFIMEDICAL";
                    }else{
                        nomTarea = "GRABAR_OFICLINIC";
                    }
                    if (frmCargarArchivo.getForm().isValid()) {					
                        frmCargarArchivo.getForm().submit({
                            waitTitle: 'Estado',
                            waitMsg: 'Cargando Archivo ...',
                            params: {
                                task: nomTarea,
                                pPaciente: Ext.getCmp('sysPacienteFoto').getValue()
                            },
                            success: function(form, action){
                                var data = Ext.util.JSON.decode(action.response.responseText);
                                Ext.Msg.show({
                                    title: NOM_APLICACION,
                                    msg: data.message.reason,
                                    buttons: Ext.Msg.OK,
                                    icon: Ext.Msg.INFO
                                });
                                if(NOM_APLICACION === "OfiMedical"){
                                    Ext.getDom('picFoto').src = "../../../consultoriovirtual/" + xID_CONSULTORIO + "/pacientes/" + Ext.getCmp('sysPacienteFoto').getValue() + "/uploads/foto.jpg";
                                }else{
                                    Ext.getDom('picFoto').src = "../../../empresas/" + ID_EMPRESA + "/pacientes/" + Ext.getCmp('sysPacienteFoto').getValue() + "/uploads/foto.jpg";
                                }
                                Ext.getCmp('CargarFotoPacienteUi').close();
                                //store.reload();
                                //w_NuevoArchivo.hide();
                            },
                            failure: function(form, action){
                                if (action.failureType === 'server') {
                                    var data = Ext.util.JSON.decode(action.response.responseText);
                                    Ext.Msg.show({
                                        title: NOM_APLICACION,
                                        msg: data.errors.reason,
                                        buttons: Ext.Msg.OK,
                                        icon: Ext.Msg.ERROR
                                    });
                                    Ext.getCmp('CargarFotoPacienteUi').close();
                                }
                            }
                    });
                }
            }
        }];
    
        CargarFotoPacienteUi.superclass.initComponent.call(this);
    }
});
