/*
* @category    Formulario Salida de Consulta
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winSalidaConsultaUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic .:: Salida de Consulta ::.',
    width: 970,
    height: 580,
    modal: true,
    frame: true,
    closable: false,
    padding: 10,
    id: 'winSalidaConsultaUi',
    initComponent: function() {
        
        function VerInfoServicio(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return '<h3><b>' + value + '</b></h3>' + '</br><h4>' + record.get('Programa') + '</span></h4>';  
        }
        
        function DescripcionRemision(value, metaData, record, rowIndex, colIndex, store){  
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += value;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }
        
        function DescripcionProveedor(value, metaData, record, rowIndex, colIndex, store){  
            mostrarHC = '<table><tr><td c>';
            mostrarHC += '<span><b>Proveedor: ' + record.get('NomProveedor') + '</b></span><br><br>' + value;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }
        
        var xg = Ext.grid;
               
        var chkColumnSeleccionarServicio = new xg.CheckColumn({
            header: ' ',
            dataIndex: 'Seleccionar',
            id: 'chkColumnSeleccionarServicio',
            value: true,
            width: 20
        });
        
        this.items = [
            {
                xtype: 'panel',
                border: false, 
                autoHeight: true,
                frame: true,
                layout: 'form',
                items:[
                    {
                        xtype: 'hidden',
                        value: '0',
                        id: 'sysPacienteSearch'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Paciente',
                                width: 790,
                                readOnly: true,
                                allowBlank: false,
                                emptyText: 'Seleccione Paciente ....',
                                id: 'fPacienteSearch'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Paciente',
                                id: 'btnBuscarPaciente'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'panel',
                autoScroll: true,
                //width: 610,
                height: 470,
                anchor: '100%',
                frame: true,
                border: true,
                items: [
                    {
                        xtype: 'tabpanel',
                        anchor: '100%',
                        height: 450,
                        border: false,
                        enableTabScroll: true,
                        activeTab: 0,
                        items: [
                            {
                                xtype: 'panel',
                                title: 'Pendientes x Autorizar',
                                anchor: '100%',
                                autoHeight: true,
                                autoScroll: true,
                                frame: true,
                                border: false,
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'grid',
                                        title: ' ',
                                        id: 'gridExamenesHC',
                                        store: 'StoreGridExaSolicitadosHC',
                                        anchor: "100%",
                                        height: 370,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        //colModel: new Ext.ux.grid.LockingColumnModel([
                                        cm: new xg.ColumnModel([
                                            chkColumnSeleccionarServicio,
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Id',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'idConsecutivoSolicitud',
                                                id: 'idConsecutivoSolicitud'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Descripción',
                                                sortable: false,
                                                width: 450,
                                                dataIndex: 'descConcepto',
                                                id: 'descConcepto'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Cantidad',
                                                sortable: false,
                                                width: 80,
                                                dataIndex: 'Cantidad',
                                                id: 'Cantidad'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Notas a Proveedor',
                                                sortable: false,
                                                width: 330,
                                                dataIndex: 'notasProveedor',
                                                renderer: DescripcionProveedor,
                                                id: 'notasProveedor'
                                            }
                                        ]),
                                        plugins: [chkColumnSeleccionarServicio],
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                        /*view: new Ext.ux.grid.LockingGridView({
                                            getRowClass: function(record, index, rowParams, store){
                                                var estado = record.data.Finalidad;
                                                switch (estado){
                                                    case "P":
                                                        return 'Apto';
                                                        break;
                                                    case "D":
                                                        return 'Apto';
                                                        break;
                                                    case "S":
                                                        return 'Azul';
                                                        break;
                                                    case "X":
                                                        return 'Rojo';
                                                        break;
                                                    case "A":
                                                        return 'Amarillo';
                                                        break;
                                                    default:
                                                        return; 
                                                        break;
                                                }
                                            }
                                        }),*/
                                        iconCls:'icon-grid',
                                        tbar:
                                            {
                                                xtype: 'toolbar',
                                                items: [
                                                    {
                                                        xtype: 'button',
                                                        text: 'Actualizar Lista',
                                                        iconCls: 'btnActualizarGrid',
                                                        listeners: {
                                                            click : function() {
                                                                Ext.getCmp('gridExamenesHC').store.removeAll();
                                                                Ext.getCmp('gridExamenesHC').store.load({
                                                                    params: {
                                                                        pEmpresa: ID_EMPRESA,
                                                                        pIPS: ID_IPS,
                                                                        pPaciente: Ext.getCmp('sysPacienteSearch').getValue(),
                                                                        pCAS: wCAS
                                                                    }
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Modificar',
                                                        iconCls: 'btnEditRow',
                                                        listeners: {
                                                            click : function() {

                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    '->',
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Generar Autorizacion',
                                                        iconCls: 'btnAceptar',
                                                        listeners: {
                                                            click : function() {
                                                                if(parseInt(wCAS) !== 0 && parseInt(Ext.getCmp('sysPacienteSearch').getValue()) !== 0){
                                                                    //window.open ("../../controlador/asistencial/printordenexaecopetrol0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysPacienteSearch').getValue() + "&pCAS=" + wCAS,"Ordenamientos");
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Imprimir Autorizacion',
                                                        iconCls: 'btnImprimir',
                                                        listeners: {
                                                            click : function() {
                                                                if(parseInt(wCAS) !== 0 && parseInt(Ext.getCmp('sysPacienteSearch').getValue()) !== 0){
                                                                    //window.open ("../../controlador/asistencial/printordenexaecopetrol0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysPacienteSearch').getValue() + "&pCAS=" + wCAS,"Ordenamientos");
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Imprimir Pago',
                                                        iconCls: 'btnLiquidar',
                                                        listeners: {
                                                            click : function() {
                                                                if(parseInt(wCAS) !== 0 && parseInt(Ext.getCmp('sysPacienteSearch').getValue()) !== 0){
                                                                    //window.open ("../../controlador/asistencial/printordenexaecopetrol0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysPacienteSearch').getValue() + "&pCAS=" + wCAS,"Ordenamientos");
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    }
                                                ]
                                            }
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        frame: true,
                                        border: false,
                                        labelWidth: 50,
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                frame: true,
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'numericfield',
                                                        fieldLabel: 'C.M',
                                                        currencySymbol: "$",
                                                        width: 120,
                                                        value: 0,
                                                        useThousandSeparator: true,
                                                        alwaysDisplayDecimals: true,
                                                        thousandSeparator: ',',
                                                        minValue: 0,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysTotCM'
                                                    },
                                                    {
                                                        html: 'Copago:'
                                                    },
                                                    {
                                                        xtype: 'numericfield',
                                                        currencySymbol: "$",
                                                        width: 120,
                                                        value: 0,
                                                        useThousandSeparator: true,
                                                        alwaysDisplayDecimals: true,
                                                        thousandSeparator: ',',
                                                        minValue: 0,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysTotCOP'
                                                    },
                                                    {
                                                        html: 'Total a Pagar:'
                                                    },
                                                    {
                                                        xtype: 'numericfield',
                                                        currencySymbol: "$",
                                                        width: 120,
                                                        value: 0,
                                                        useThousandSeparator: true,
                                                        alwaysDisplayDecimals: true,
                                                        thousandSeparator: ',',
                                                        minValue: 0,
                                                        decimalPrecision: 0,
                                                        allowBlank: true,
                                                        readOnly: true,
                                                        id: 'sysTotNETO'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Remisiones',
                                anchor: '100%',
                                autoHeight: true,
                                autoScroll: true,
                                frame: true,
                                border: false,
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'grid',
                                        title: ' ',
                                        id: 'gridRemisionesHC',
                                        store: 'StoreGridRemSolicitadosHC',
                                        anchor: "100%",
                                        height: 410,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Id',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'idConsecutivoSolicitud',
                                                id: 'idConsecutivoSolicitud'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Especialidad',
                                                sortable: false,
                                                width: 250,
                                                dataIndex: 'descConcepto',
                                                id: 'descConcepto'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Remision',
                                                sortable: false,
                                                renderer: DescripcionRemision,
                                                width: 410,
                                                dataIndex: 'Remision',
                                                id: 'Remision'
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                        iconCls:'icon-grid',
                                        //view: new Ext.grid.GroupingView(),
                                        tbar:
                                            {
                                                xtype: 'toolbar',
                                                items: [
                                                    {
                                                        xtype: 'button',
                                                        text: 'Actualizar Lista',
                                                        iconCls: 'btnActualizarGrid',
                                                        listeners: {
                                                            click : function() {
                                                                Ext.getCmp('gridRemisionesHC').store.removeAll();
                                                                Ext.getCmp('gridRemisionesHC').store.load({
                                                                    params: {
                                                                        pEmpresa: ID_EMPRESA,
                                                                        pIPS: ID_IPS,
                                                                        pPaciente: Ext.getCmp('sysPacienteSearch').getValue(),
                                                                        pCAS: wCAS
                                                                    }
                                                                });
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    '->',
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Imprimir Orden',
                                                        iconCls: 'btnImprimir',
                                                        listeners: {
                                                            click : function() {
                                                                if(parseInt(wCAS) !== 0 && parseInt(Ext.getCmp('sysPacienteSearch').getValue()) !== 0){
                                                                    window.open ("../../controlador/asistencial/printordenrem0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysPacienteSearch').getValue() + "&pCAS=" + wCAS,"Remisiones");
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Imprimir Remisiones Seleccionadas',
                                                        iconCls: 'btnImprimir',
                                                        listeners: {
                                                            click : function() {
                                                                if(parseInt(wCAS) !== 0 && parseInt(Ext.getCmp('sysPacienteSearch').getValue()) !== 0){
                                                                    var Registros;
                                                                    Registros = Ext.getCmp('gridRemisionesHC').selModel.getCount();
                                                                    if(Registros > 0){
                                                                        var selections = Ext.getCmp('gridRemisionesHC').selModel.getSelections();
                                                                        var prez = [];
                                                                        for(i = 0; i < Registros; i++){
                                                                            prez.push(selections[i].json.idConsecutivoSolicitud);
                                                                        }
                                                                        var encoded_array = Ext.encode(prez);
                                                                        window.open ("../../controlador/asistencial/printordenrem0_1.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysPacienteSearch').getValue() + "&pCAS=" + wCAS +  "&pItems=" + encoded_array,"Remisiones");
                                                                    }else{
                                                                        Ext.MessageBox.show({
                                                                            title: 'Error',
                                                                            msg: 'Debe seleccionar las Remisiones a imprimir',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    }
                                                ]
                                            }
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Formula Medica',
                                anchor: '100%',
                                autoHeight: true,
                                autoScroll: true,
                                frame: true,
                                border: false,
                                layout: 'form',
                                items: [
                                    {
                                        xtype: 'grid',
                                        id: 'gridMedicamentosHC',
                                        store: 'StoreGridMxSolicitadosHC',
                                        anchor: "100%",
                                        height: 410,
                                        border: false,
                                        frame: true,
                                        loadMask: true,
                                        colModel: new Ext.ux.grid.LockingColumnModel([
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Id',
                                                sortable: false,
                                                width: 1,
                                                hidden: true,
                                                hideable: false,
                                                dataIndex: 'idConsecutivoSolicitud',
                                                id: 'idConsecutivoSolicitud'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Descripción',
                                                sortable: false,
                                                width: 450,
                                                dataIndex: 'descConcepto',
                                                id: 'descConcepto'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Cantidad',
                                                sortable: false,
                                                width: 80,
                                                dataIndex: 'Cantidad',
                                                id: 'Cantidad'
                                            },
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Posologia',
                                                sortable: false,
                                                width: 330,
                                                dataIndex: 'Posologia',
                                                id: 'Posologia'
                                            }
                                        ]),
                                        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                                        iconCls:'icon-grid',
                                        tbar:
                                            {
                                                xtype: 'toolbar',
                                                items: [
                                                    {
                                                        xtype: 'button',
                                                        text: 'Actualizar Lista',
                                                        iconCls: 'btnActualizarGrid',
                                                        id: 'btnUpdateMxEvolucion',
                                                        listeners: {
                                                            click : function() {
                                                                Ext.getCmp('gridMedicamentosHC').store.removeAll();
                                                                if(parseInt(wCAS) !== 0 && parseInt(Ext.getCmp('sysPacienteSearch').getValue()) !== 0){
                                                                    Ext.getCmp('gridMedicamentosHC').store.load({
                                                                        params: {
                                                                            task: 'MX_IPS_BASICA',
                                                                            pEmpresa: ID_EMPRESA,
                                                                            pIPS: ID_IPS,
                                                                            pPaciente: Ext.getCmp('sysPacienteSearch').getValue(),
                                                                            pCAS: wCAS
                                                                        }
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    '->',
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Imprimir Formula',
                                                        iconCls: 'btnImprimir',
                                                        listeners: {
                                                            click : function() {
                                                                if(parseInt(wCAS) !== 0 && parseInt(Ext.getCmp('sysPacienteSearch').getValue()) !== 0){
                                                                    window.open ("../../controlador/asistencial/printformula2013.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysPacienteSearch').getValue() + "&pCAS=" + wCAS,"Formula Medica");
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    },
                                                    {
                                                        xtype: 'button',
                                                        text: 'Imprimir Medicamentos Seleccionados',
                                                        iconCls: 'btnImprimir',
                                                        listeners: {
                                                            click : function() {
                                                                var Registros;
                                                                Registros = Ext.getCmp('gridMedicamentosHC').selModel.getCount();
                                                                if(Registros > 0){
                                                                    var selections = Ext.getCmp('gridMedicamentosHC').selModel.getSelections();
                                                                    var prez = [];
                                                                    for(i = 0; i < Registros; i++){
                                                                        prez.push(selections[i].json.idConsecutivoSolicitud);
                                                                    }
                                                                    var encoded_array = Ext.encode(prez);
                                                                    window.open ("../../controlador/asistencial/printformula0_1.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysPacienteSearch').getValue() + "&pCAS=" + wCAS +  "&pItems=" + encoded_array,"Formula Medica");
                                                                }else{
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'Debe seleccionar los medicamentos a imprimir',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'tbseparator'
                                                    }
                                                ]
                                            }
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
        winSalidaConsultaUi.superclass.initComponent.call(this);
    }
});
