/*
* @category    Formulario Visualizacion de Pendientes por Autorizar x Paciente
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

function verPendientesxAutorizarxPaciente(wPaciente, wInfoBasica, wCAS){
    var HTML = "";
    var classbody = "";
    var winListadoAtencion;
    var Contenido;
    var ID_PACIENTE = wPaciente;
    
    //creamos la ventana que contendrá el formulario
    var stProveedor = new StoreProveedor();
    var stGridServiciosPac = new StoreGridExaSolicitadosHC();
    stGridServiciosPac.removeAll();
    stGridServiciosPac.load({
        params: {
            pEmpresa: ID_EMPRESA,
            pIPS: ID_IPS,
            pPaciente: wPaciente,
            pCAS: 0
        },
        callback: function(){
            /*stGridServiciosPac.each(function(record){
                if(record.get('Origen') === "ODONTOLOGIA"){
                    SI_ASIGNAR_CITAS = 0;
                }
            });*/
        }
    });
    
    function NotasProveedor(value, metaData, record, rowIndex, colIndex, store){  
        mostrarHC = '<table><tr><td c>';
        mostrarHC += '<span><b>Proveedor: ' + record.get('NomProveedor') + '</b></span><br><br>' + value;
        mostrarHC += '</td></tr></table>';
        return mostrarHC;
    }
        
    function VerInfoServicio(value, metaData, record, rowIndex, colIndex, store){  
        metaData.attr = 'style="white-space:normal"';  
        mostrarHC = '<table><tr><td>';
        mostrarHC += '<h3><b>' + value + '</b></h3>' + '</br><h4 style="color: darkred;">Programa: ' + record.get('Programa') + '</span></h4>';
        mostrarHC += '</td></tr></table>';
        return mostrarHC;
        //return '<h3><b>' + value + '</b></h3>' + '</br><h4 style="color: darkred;">Programa: ' + record.get('Programa') + '</span></h4>';  
    }
        
    var xg = Ext.grid;
    var chkColumnSeleccionarServicio = new xg.CheckColumn({
        header: ' ',
        dataIndex: 'Seleccionar',
        id: 'chkColumnSeleccionarServicio',
        value: true,
        width: 20
    });
    
    var intProveedorServ = new Ext.form.ComboBox({
        typeAhead: true,
        triggerAction: 'all',
        model: 'local',
        valueField: 'Codigo',
        displayField: 'Descripcion',
        anchor: '100%',
        store: stProveedor,
        ref: '../../../../../../idProveedorAut'
    });
    
    function DescripcionProveedor(value, metaData, record, rowIndex, colIndex, store){  
        var stProveedor00 = new StoreProveedor();
        var txtCombo = "";
        stProveedor00.on('load', function () {
            stProveedor00.data.each(function(item, index, totalItems ) {
                if(item.data['Codigo'] == value){
                    txtCombo = item.data['Descripcion'];
                }
            });
        });
        mostrarHC = '<table><tr><td>';
        mostrarHC += '<span><b>' + txtCombo + '</b></span>';
        mostrarHC += '</td></tr></table>';
        return mostrarHC;
    }
    //var intProveedorServ = new Ext.form.TextField();
    
    var verInfoActividadesxPaciente = new Ext.Window({ 
            title: '.:: Servicios Pendientes x Autorizar: ' + wInfoBasica + ' ::.', 
            width: 1004,
            height: 600,
            closable: false,
            resizable: false,
            draggable: false,
            modal: true,
            id: 'winInfoActividadesxPaciente',
            bbar:{
                items: [
                    {
                        xtype: 'tbfill'
                    },
                    {
                        xtype: 'tbseparator'
                    },
                    {
                        xtype: 'button',
                        text: 'Salir',
                        iconCls: 'btnSalir',
                        id: 'btnSalirInfoActividadesxPaciente',
                        listeners:{
                            click : function(){
                                Ext.getCmp('winInfoActividadesxPaciente').close();
                            }
                        }
                    }
                ]
            },
            items: [
                    {
                    xtype: 'panel',
                    title: '',
                    autoScroll: true,
                    width: 996,
                    autoHeight: true,
                    frame: true,
                    border: false,
                    colspan: 2,
                    items: [
                        {
                            xtype: 'editorgrid',
                            title: ' ',
                            id: 'gridExamenesHC',
                            store: 'StoreGridExaSolicitadosHC',
                            anchor: "100%",
                            height: 520,
                            border: false,
                            frame: true,
                            loadMask: true,
                            stripeRows: true,
                            clicksToEdit: 1,
                            cm: new xg.ColumnModel([
                                chkColumnSeleccionarServicio,
                                {
                                    xtype: 'gridcolumn',
                                    header: 'Id',
                                    sortable: false,
                                    width: 1,
                                    hidden: true,
                                    hideable: false,
                                    dataIndex: 'idConsecutivoSolicitud',
                                    id: 'idConsecutivoSolicitud'
                                },
                                {
                                    xtype: 'gridcolumn',
                                    header: 'Descripción',
                                    sortable: false,
                                    width: 350,
                                    dataIndex: 'descConcepto',
                                    renderer: VerInfoServicio,
                                    id: 'descConcepto'
                                },
                                {
                                    xtype: 'gridcolumn',
                                    header: 'Cantidad',
                                    sortable: false,
                                    width: 80,
                                    dataIndex: 'Cantidad',
                                    id: 'Cantidad'
                                },
                                {
                                    xtype: 'gridcolumn',
                                    header: 'Observaciones',
                                    sortable: false,
                                    width: 200,
                                    dataIndex: 'notasProveedor',
                                    renderer: NotasProveedor,
                                    id: 'notasProveedor'
                                },
                                {
                                    dataIndex: 'idProveedorAut',
                                    header: 'Proveedor',
                                    width: 270,
                                    editor: {
                                        xtype: 'combo',
                                        width: 270,
                                        typeAhead: true,
                                        triggerAction: 'all',
                                        model: 'local',
                                        valueField: 'id',
                                        displayField: 'Descripcion',
                                        anchor: '100%',
                                        store: stProveedor
                                    },
                                    renderer: function(value) {
                                        var rec = stProveedor.getById(value);
                                        if (rec){
                                            return rec.get('Descripcion');
                                        }
                                        return '-- SIN REGISTRAR --';
                                    }
                                }
                            ]),
                            plugins: [chkColumnSeleccionarServicio],
                            selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                            /*view: new Ext.ux.grid.LockingGridView({
                                getRowClass: function(record, index, rowParams, store){
                                    var estado = record.data.Finalidad;
                                    switch (estado){
                                        case "P":
                                            return 'Apto';
                                            break;
                                        case "D":
                                            return 'Apto';
                                            break;
                                        case "S":
                                            return 'Azul';
                                            break;
                                        case "X":
                                            return 'Rojo';
                                            break;
                                        case "A":
                                            return 'Amarillo';
                                            break;
                                        default:
                                            return; 
                                            break;
                                    }
                                }
                            }),*/
                            iconCls:'icon-grid',
                            tbar:
                                {
                                    xtype: 'toolbar',
                                    items: [
                                        '->',
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Generar Autorizacion',
                                            iconCls: 'btnAceptar',
                                            listeners: {
                                                click : function() {
                                                    var parametrosServiciosSeleccionados = "";
                                                    Ext.Msg.show({
                                                        title: 'eOfiClinic',
                                                        msg: 'Esta seguro que desea adicionar los servicios seleccionados?',
                                                        buttons: Ext.Msg.YESNO,
                                                        icon: Ext.Msg.QUESTION,
                                                        fn: function(btn){
                                                            if(btn=="yes"){
                                                                var serviciosSeleccionados = false;
                                                                Ext.getCmp('gridExamenesHC').store.filterBy(function(record,id){
                                                                    return record.get('Seleccionar') == true;
                                                                });
                                                                Ext.getCmp('gridExamenesHC').store.each(function(record){
                                                                    serviciosSeleccionados = true;
                                                                    parametrosServiciosSeleccionados = parametrosServiciosSeleccionados + record.get('CAS') + "^" + record.get('idConsecutivoSolicitud') + "^" + record.get('idConcepto') + "^" + record.get('idProveedorAut')  + "^" + record.get('notasProveedor') + "¬";
                                                                });
                                                                if (serviciosSeleccionados == false){
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error',
                                                                        msg: 'Debe seleccionar al menos una servicio para poder realizar la accion',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                }else{
                                                                    //alert(parametrosCitasSeleccionadas);
                                                                    Ext.Ajax.request({
                                                                        waitMsg: 'Por favor Espere...',
                                                                        url: '../../controlador/radicacionservicios/guardar_datosbasicos1702.php',
                                                                        params: {
                                                                            task: "ADICIONAR_SERVICIOSxAUTORIZAR",
                                                                            pEmpresa: ID_EMPRESA,
                                                                            pSede: ID_SEDE, 
                                                                            pIPS: ID_IPS, 
                                                                            pCAS: wCAS, 
                                                                            pUsuario: ID_USUARIO,
                                                                            pInfoServicios: parametrosServiciosSeleccionados
                                                                        },
                                                                        success: function(response){
                                                                            var result=eval(response.responseText);
                                                                            switch(result){
                                                                                case 1:
                                                                                    Ext.getCmp('gridServicios').store.removeAll();
                                                                                    Ext.getCmp('gridServicios').store.load({
                                                                                        params:{
                                                                                            pCAS: wCAS
                                                                                        }
                                                                                    });
                                                                                    Ext.getCmp('winInfoActividadesxPaciente').close();
                                                                                    break;
                                                                                default:
                                                                                    Ext.MessageBox.hide();
                                                                                    Ext.MessageBox.show({
                                                                                        title: 'Adicionar Items',
                                                                                        msg: 'Ocurrio un error al guardar, vuelve a intentarlo.',
                                                                                        buttons: Ext.MessageBox.OK,
                                                                                        icon: Ext.MessageBox.ERROR
                                                                                    });
                                                                                    break;
                                                                            }
                                                                        },
                                                                        failure: function(response,options){
                                                                            Ext.MessageBox.hide();
                                                                            Ext.MessageBox.show({
                                                                                title: 'Error Base Datos',
                                                                                msg: 'No podemos adicionar los servicios en estos momentos',
                                                                                buttons: Ext.MessageBox.OK,
                                                                                icon: Ext.MessageBox.ERROR
                                                                            });
                                                                        }
                                                                    });
                                                                }
                                                            }
                                                        }
                                                    });
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        }
                                    ]
                                }
                        }
                    ]
                }
            ]
    }); 
    verInfoActividadesxPaciente.show();
}
