/*
* @category    Funcion Buscar Cie10
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
function buscarcie10(pCampo, pCampo2)
{
    var DGDataStore;
    var DGColumnModel;
    var DGListingEditorGrid;
    var DGListingWindow;
    var DGListingSelectedRow;
    var DGListingContextMenu;
    var anchoPantalla;
    var MargenIzquierdo;

    var el = Ext.get('idusuario');
    var ID_USUARIO = el.getValue();
    el = Ext.get('nomusuario');
    var NOM_USUARIO = el.getValue();
    el = Ext.get('codusuario');
    var COD_USUARIO = el.getValue();
    el = Ext.get('idempresa');
    var ID_EMPRESA = el.getValue();
    el = Ext.get('nomempresa');
    var NOM_EMPRESA = el.getValue();
    el = Ext.get('idcliente');
    var ID_CLIENTE = el.getValue();
    el = Ext.get('nomcliente');
    var NOM_CLIENTE = el.getValue();
    el = Ext.get('idsede');
    var ID_SEDE = el.getValue();
    el = Ext.get('nomsede');
    var NOM_SEDE = el.getValue();
    el = Ext.get('idperfil');
    var ID_PERFIL = el.getValue();
    anchoPantalla = screen.width;
    switch(anchoPantalla)
    {
        case 1024:
            MargenIzquierdo = 15;
            break;
        case 1280:
            MargenIzquierdo = 150;
            break;
    }

    var btnSalir = new Ext.Button({
        id: 'btnSalir',
        text: 'Salir',
        icon: '../../../resources/botones/salir.png',
        iconCls: 'x-btn-text-icon',
        minWidth: 80,
        handler:function(){
            DGListingWindow.close();
        }
    });

    DGDataStore = new Ext.data.Store({
        id: 'DGDataStore',
        proxy: new Ext.data.HttpProxy({
            url: '../../controlador/cie10/gridcie10.php',
            method: 'POST'
        }),
        loadMask: {msg:"Cargando Registros, por favor espere..."},
        autoload: false,
        reader: new Ext.data.JsonReader({
            root: 'results',
            totalProperty: 'total',
            id: 'id'
          },[
            {name: 'Codigo', type: 'string', mapping: 'Codigo'},
            {name: 'Descripcion', type: 'string', mapping: 'Descripcion'}
         ]),
      sortInfo:{field: 'Codigo', field: 'Descripcion', direction: "ASC"}
    });

    DGColumnModel = new Ext.grid.ColumnModel(
        [{
            header: 'Codigo',
            dataIndex: 'Codigo',
            sortable: true,
            width: 120
        },{
            header: 'Descripcion',
            dataIndex: 'Descripcion',
            sortable: true,
            width: 780
        }]
    );
    DGColumnModel.defaultSortable= true;

    doMsgBoxAlert = function(record) {
        //alert(pCampo);
        var codcie10 = record.get('Codigo');
        Ext.getCmp(pCampo).setValue(codcie10);
        if(typeof pCampo2 != 'undefined'){
            Ext.getCmp(pCampo2).setValue(record.get('Descripcion'));
        }
        DGListingWindow.close();
    };

    doRowDblClick = function(thisGrid, rowIndex)  {
       var record = thisGrid.getStore().getAt(rowIndex);
       doMsgBoxAlert(record);
    };

    doRowCtxMenu = function(thisGrid, rowIndex, evtObj)
    {
        evtObj.stopEvent();
        var record = thisGrid.getStore().getAt(rowIndex);
        if (!thisGrid.rowCtxMenu)
        {
            thisGrid.rowCtxMenu = new Ext.menu.Menu({
                items : {
                    text    : 'Seleccionar Diagnostico',
                    handler : function() {
                        doMsgBoxAlert(record);
                    }
                }
            });
       }
       thisGrid.rowCtxMenu.showAt(evtObj.getXY());
    };
    
    DGListingEditorGrid =  new Ext.grid.GridPanel({
        id: 'DGListingEditorGrid',
        store: DGDataStore,
        cm: DGColumnModel,
        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
        iconCls:'icon-grid',
        loadMask:{msg:"Cargando Registros, por favor espere..."},
        listeners: {
           rowdblclick: doRowDblClick,
           rowcontextmenu: doRowCtxMenu,
           destroy: function(thisGrid) {
               if (thisGrid.rowCtxMenu) {
                   thisGrid.rowCtxMenu.destroy();
               }
           }
        },
        bbar: new Ext.PagingToolbar({
            pageSize: 15,
            store: DGDataStore,
            displayInfo: true
        }),
        tbar:[
            new Ext.app.SearchField({
                store: DGDataStore,
                params: {start: 0, limit: 15},
                width: 120
            }),
            '->',
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Seleccionar',
                iconCls: 'btnSelect',
                id: 'btnSelectSearch',
                listeners:{
                    click : function(){
                        if(Ext.getCmp('DGListingEditorGrid').selModel.getCount() == 1){
                            doMsgBoxAlert(Ext.getCmp('DGListingEditorGrid').selModel.getSelected());
                        }else{
                            Ext.MessageBox.show({
                                title: 'Pacientes',
                                msg: 'Debe Seleccionar un Registro.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ]
    });

   DGListingWindow = new Ext.Window({
        id: 'DGListingWindow',
        title: 'Busqueda de Diagnosticos CIE-10',
        closable:false,
        width:980,
        height:480,
        plain:true,
        resizable : false,
        modal: true,
        x: MargenIzquierdo,
        y:120,
        layout: 'fit',
        loadMask: true,
        items: DGListingEditorGrid,
        bbar:[{
            text  : 'Empresa: ' + NOM_EMPRESA,
            xtype : 'tbtext'
        },'->',{
            text  : 'Sistemas Ofisalud - desarrollo@ofisalud.com - Tel: 3016398114',
            xtype : 'tbtext'
        },'-',btnSalir]
    });
    DGListingWindow.show();
   
}