/*
* @category    Funcion Buscar Concepto (Procedimientos - Medicamentos - Insumos - Otros)
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
function buscarconcepto(pValidaAuditoria, pCargarStore, pNomGrid, wPantalla, wCliente, wPlan, wSubPlan)
{
    var DGDataStore;
    var DGColumnModel;
    var DGListingEditorGrid;
    var DGListingWindow;
    var DGListingSelectedRow;
    var DGListingContextMenu;
    var anchoPantalla;
    var MargenIzquierdo;
    var wValidaAuditoria = pValidaAuditoria;

    var el = Ext.get('idusuario');
    var ID_USUARIO = el.getValue();
    el = Ext.get('nomusuario');
    var NOM_USUARIO = el.getValue();
    el = Ext.get('codusuario');
    var COD_USUARIO = el.getValue();
    el = Ext.get('idempresa');
    var ID_EMPRESA = el.getValue();
    el = Ext.get('nomempresa');
    var NOM_EMPRESA = el.getValue();
    el = Ext.get('idcliente');
    var ID_CLIENTE = el.getValue();
    el = Ext.get('nomcliente');
    var NOM_CLIENTE = el.getValue();
    el = Ext.get('idsede');
    var ID_SEDE = el.getValue();
    el = Ext.get('nomsede');
    var NOM_SEDE = el.getValue();
    el = Ext.get('idperfil');
    var ID_PERFIL = el.getValue();
    var ID_ORIGEN = wPantalla;
    anchoPantalla = screen.width;
    switch(anchoPantalla)
    {
        case 1024:
            MargenIzquierdo = 15;
            break;
        case 1280:
            MargenIzquierdo = 150;
            break;
    }

    var btnSalir = new Ext.Button({
        id: 'btnSalir',
        text: 'Salir',
        iconCls: 'btnSalir',
        minWidth: 80,
        handler:function(){
            DGListingWindow.close();
        }
    });

    DGDataStore = new Ext.data.GroupingStore({
        id: 'DGDataStore',
        proxy: new Ext.data.HttpProxy({
            url: '../../controlador/conceptos/gridconceptos.php',
            method: 'POST'
        }),
        baseParams: {
            pNomTabla: "USR_" + ID_USUARIO,
            pOrigen: ID_ORIGEN,
            pIPS: ID_IPS,
            pCliente: wCliente, 
            pPlan: wPlan, 
            pSubPlan: wSubPlan
        },
        groupField: 'TipoEstudio',
        loadMask: {msg:"Cargando Registros, por favor espere..."},
        autoload: false,
        reader: new Ext.data.JsonReader({
            root: 'results',
            totalProperty: 'total',
            id: 'id'
          },[
            {name: 'IDConcepto', type: 'int', mapping: 'IDConcepto'},
            {name: 'Codigo', type: 'string', mapping: 'Codigo'},
            {name: 'Descripcion', type: 'string', mapping: 'Descripcion'},
            {name: 'TipoEstudio', type: 'string', mapping: 'TipoEstudio'},
            {name: 'EsMX', type: 'string', mapping: 'EsMX'},
            {name: 'EsAnatomo', type: 'string', mapping: 'EsAnatomo'},
            {name: 'CUPSCodigo', type: 'string', mapping: 'CUPSCodigo'},
            {name: 'CodMxMinisterio', type: 'string', mapping: 'CodMxMinisterio'},
            {name: 'POS', type: 'string', mapping: 'POS'},
            {name: 'NivelProced', type: 'int', mapping: 'NivelProced'},
            {name: 'EsCX', type: 'string', mapping: 'EsCX'},
            {name: 'NivelProced', type: 'int', mapping: 'NivelProced'},
            {name: 'UVR', type: 'float', mapping: 'UVR'},
            {name: 'GrupoQx', type: 'int', mapping: 'GrupoQx'},
            {name: 'MinDiasSol', type: 'int', mapping: 'MinDiasSol'},
            {name: 'CantidadMaxSol', type: 'int', mapping: 'CantidadMaxSol'},
            {name: 'DosisMaxPac', type: 'int', mapping: 'DosisMaxPac'},
            {name: 'EsPyP', type: 'string', mapping: 'EsPyP'},
            {name: 'IdTipoEstudio', type: 'string', mapping: 'IdTipoEstudio'},
            {name: 'PreparacionEspecial', type: 'string', mapping: 'PreparacionEspecial'},
            {name: 'Tarifa', type: 'float', mapping: 'Tarifa'},
            {name: 'TipoAutoriza', type: 'string', mapping: 'TipoAutoriza'},
            {name: 'TipoRegProced', type: 'string', mapping: 'TipoRegProced'}
         ]),
        sortInfo:{field: 'TipoEstudio', field: 'Codigo', field: 'Descripcion', direction: "ASC"}
    });

    function CodConcepto(val, x, store){
      return '<b style="color: #5959be;font-size: 10px;">'+val+'</b>';
    }

    function DescripcionConcepto(val, x, store){
        var html = '<table><tr><td><b style="color: #5959be;font-size: 12px;">'+val+'</b></td></tr><tr><td><p style="color: #fc6262;">Tipo Estudio: ' + store.data.TipoEstudio + '</p></tr></td><tr><td><p style="color: #033803;font-weight: bold;">Nivel: ' + store.data.NivelProced + '</p></tr></td><tr><td>Tarifa: ' + FormatoMoneda(store.data.Tarifa) + '</tr></td></table>';
        if (wValidaAuditoria=="1")
            if(store.data.TipoAutoriza == "E" || store.data.TipoAutoriza == "S")
                html = '<table style="background:url(\'../../../resources/varios/alert1.png\') no-repeat"><tr><td><b style="color: #5959be;font-size: 12px;">'+val+'</b></td></tr><tr><td><p style="color: #fc6262;">Tipo Estudio: ' + store.data.TipoEstudio + '</p></tr></td><tr><td><p style="color: #033803;font-weight: bold;">Nivel: ' + store.data.NivelProced + '</p></tr></td><tr><td>Tarifa: ' + FormatoMoneda(store.data.Tarifa) + '</tr></td></table>';
        return html;
    }

    function auditoria_image(val){
        switch (val)
        {
            case 'Z':
                return '<table><tr><td><img src="../../../resources/varios/pagoparticular.png"/></td><td align="center">Facturar Particular</td></tr></table>';
                break;

            case 'E':
                return '<table><tr><td><img src="../../../resources/varios/hospital.png"/></td><td align="center">Autorizar en EPS</td></tr></table>';
                break;

            case 'P':
                return '<table><tr><td><img src="../../../resources/varios/legalizar.png"/></td><td align="center">Autorizado</td></tr></table>';
                break;

            case 'J':
                return '<table><tr><td><img src="../../../resources/varios/jefe.png"/></td><td align="center">Autorizar por Jefe</td></tr></table>';
                break;

            case 'A':
                return '<table><tr><td><img src="../../../resources/varios/auditoria.png"/></td><td align="center">Autorizar por Auditor</td></tr></table>';
                break;

            default:
                return '';
                break;

        }
    }

    DGColumnModel = new Ext.grid.ColumnModel(
        [{
            header: 'IDConcepto',
            dataIndex: 'IDConcepto',
            sortable: false,
            width: 1,
            hidden: true,
            hideable: false
        },{
            header: 'Codigo',
            dataIndex: 'Codigo',
            sortable: true,
            renderer: CodConcepto,
            width: 120
        },{
            header: 'Descripcion',
            dataIndex: 'Descripcion',
            renderer: DescripcionConcepto,
            sortable: true,
            width: 670
        },{
            header: 'TipoEstudio',
            dataIndex: 'TipoEstudio',
            sortable: false,
            width: 1,
            hidden: true,
            hideable: false
        },{
            header: 'EsMX',
            dataIndex: 'EsMX',
            sortable: false,
            width: 1,
            hidden: true,
            hideable: false
        },{
            header: 'EsAnatomo',
            dataIndex: 'EsAnatomo',
            sortable: false,
            width: 1,
            hidden: true,
            hideable: false
        },{
            header: '',
            dataIndex: 'TipoAutoriza',
            sortable: false,
            renderer: auditoria_image,
            width: 120,
            hideable: false
        },{
            header: 'Tarifa',
            dataIndex: 'Tarifa',
            sortable: false,
            width: 1,
            hidden: true,
            hideable: false
        }]
    );
    DGColumnModel.defaultSortable= true;

    doMsgBoxAlert = function(record) {
        switch (wPantalla)
        {
            case "RADICAR_CITA":
                Ext.getCmp('intConceptoAsignaCita').setValue(record.get('IDConcepto'));
                Ext.getCmp('intConceptoAsignaCita').setRawValue(record.get('Descripcion'));
                break;
            default:
                if (pValidaAuditoria=="1")
                {
                    if(record.get('TipoAutoriza') == "E" || record.get('TipoAutoriza') == "S")
                    {
                        Sexy.info('<table><tr><td width="50"><img src="../../../resources/varios/alert.png" alt=""/></td><td width="10">&nbsp</td><td style="padding 10px;"><h1 style="color: #ff9900; font-size: 14px;">Radicación de Conceptos</h1><br/><p style="color: #003333;font-weight: bold;">' + record.get('Descripcion') + '</p><br/>No se Puede Registar en este Modulo.</p></td><td width="70">&nbsp</td></tr></table>');
                    }else
                    {
                        Ext.getCmp('intidConcepto_conceptos').setValue(record.get('IDConcepto'));
                        Ext.getCmp('strCodConcepto_conceptos').setValue(record.get('Codigo'));
                        Ext.getCmp('strDesConcepto_conceptos').setValue(record.get('Descripcion'));
                        Ext.getCmp('intVlrUnitario_conceptos').setValue(record.get('Tarifa'));

                    }
                }else{
                    Ext.getCmp('sysIdProcedimiento').setValue(record.get('IDConcepto'));
                    Ext.getCmp('sysCodConcepto').setValue(record.get('Codigo'));
                    Ext.getCmp('sysDesConcepto').setValue(record.get('Descripcion'));
                    Ext.getCmp('sysVlrTarifa').setValue(record.get('Tarifa'));
                    Ext.getCmp('sysidTipoReg').setValue(record.get('TipoRegProced'));
                    var frm = Ext.getCmp('frmRadica').getForm();
                    frm.clearInvalid();
                    switch (record.get('TipoRegProced')){
                        case "1":
                            Ext.getCmp('fsRIPSAC').setVisible(true);
                            Ext.getCmp('fsRIPSAP').setVisible(false);
                            //Ext.getCmp('fsRIPSAT').setVisible(false);
                            Ext.getCmp('sysDiagPpalHC').allowBlank = false
                            Ext.getCmp('sysDiagRel1HC').allowBlank = true
                            Ext.getCmp('sysDiagRel2HC').allowBlank = true
                            Ext.getCmp('sysDiagRel3HC').allowBlank = true
                            Ext.getCmp('sysTipoDiagosticoHC').allowBlank = false
                            Ext.getCmp('sysFinalidadConsultaHC').allowBlank = false
                            Ext.getCmp('sysCausaExternaHC').allowBlank = false

                            Ext.getCmp('sysDiagPpalProc').allowBlank = true
                            Ext.getCmp('sysDiagRel1Proc').allowBlank = true
                            Ext.getCmp('sysDiagRel2Proc').allowBlank = true
                            Ext.getCmp('sysAmbitoProc').allowBlank = true
                            Ext.getCmp('sysFinalidadProcedimientoProc').allowBlank = true
                            Ext.getCmp('sysPersonalAtiendeProcedimientoProc').allowBlank = true
                            Ext.getCmp('sysFormaRealizaProcedimientoProc').allowBlank = true
                            break;

                        case "2":
                            Ext.getCmp('fsRIPSAC').setVisible(false);
                            Ext.getCmp('fsRIPSAP').setVisible(true);
                            //Ext.getCmp('fsRIPSAT').setVisible(false);
                            Ext.getCmp('sysDiagPpalHC').allowBlank = true
                            Ext.getCmp('sysDiagRel1HC').allowBlank = true
                            Ext.getCmp('sysDiagRel2HC').allowBlank = true
                            Ext.getCmp('sysDiagRel3HC').allowBlank = true
                            Ext.getCmp('sysTipoDiagosticoHC').allowBlank = true
                            Ext.getCmp('sysFinalidadConsultaHC').allowBlank = true
                            Ext.getCmp('sysCausaExternaHC').allowBlank = true

                            Ext.getCmp('sysDiagPpalProc').allowBlank = false
                            Ext.getCmp('sysDiagRel1Proc').allowBlank = true
                            Ext.getCmp('sysDiagRel2Proc').allowBlank = true
                            Ext.getCmp('sysAmbitoProc').allowBlank = false
                            Ext.getCmp('sysFinalidadProcedimientoProc').allowBlank = false
                            Ext.getCmp('sysPersonalAtiendeProcedimientoProc').allowBlank = false
                            Ext.getCmp('sysFormaRealizaProcedimientoProc').allowBlank = false
                            break;

                        default:
                            break;
                    }
                }
                if (pCargarStore == "SI")
                {
                    switch (pNomGrid)
                    {
                        case "gridProfesionalesCitas":
                            Ext.getCmp('gridProfesionalesCitas').store.load({
                                params: {
                                    pEmpresa: ID_EMPRESA,
                                    pIPS: ID_IPS,
                                    pProced: record.get('IDConcepto'),
                                    pCodBloqueo: CODBLOQUEOAGENDA
                                }
                            });
                            Ext.getCmp('gridConsultoriosCitas').store.load();
                            Ext.getCmp('gridDiasAgendaCitas').store.load();
                            Ext.getCmp('gridHorariosAgendasCitas').store.load();
                            break;
                        default:
                            break;
                    }
                }
                break;
        }
        DGListingWindow.close();
    };

    doRowDblClick = function(thisGrid, rowIndex)  {
       var record = thisGrid.getStore().getAt(rowIndex);
       doMsgBoxAlert(record);
    };

    doRowCtxMenu = function(thisGrid, rowIndex, evtObj)
    {
        evtObj.stopEvent();
        var record = thisGrid.getStore().getAt(rowIndex);
        if (!thisGrid.rowCtxMenu)
        {
            thisGrid.rowCtxMenu = new Ext.menu.Menu({
                items : {
                    text    : 'Seleccionar Concepto',
                    handler : function() {
                        doMsgBoxAlert(record);
                    }
                }
            });
       }
       thisGrid.rowCtxMenu.showAt(evtObj.getXY());
    };
    
    DGListingEditorGrid =  new Ext.grid.GridPanel({
        id: 'DGListingEditorGrid',
        store: DGDataStore,
        cm: DGColumnModel,
        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
        iconCls:'icon-grid',
        loadMask:{msg:"Cargando Registros, por favor espere..."},
        listeners: {
           rowdblclick: doRowDblClick,
           rowcontextmenu: doRowCtxMenu,
           destroy: function(thisGrid) {
               if (thisGrid.rowCtxMenu) {
                   thisGrid.rowCtxMenu.destroy();
               }
           }
        },
        view: new Ext.grid.GroupingView({
            groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})'
        }),
        bbar: new Ext.PagingToolbar({
            pageSize: 15,
            store: DGDataStore,
            displayInfo: true
        }),
        tbar:[
            new Ext.app.SearchField({
                store: DGDataStore,
                params: {start: 0, limit: 15},
                emptyText: 'Escriba su criterio de búsqueda...!',
                width: 420
            }),
            '->',
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Seleccionar',
                iconCls: 'btnSelect',
                id: 'btnSelectSearch',
                listeners:{
                    click : function(){
                        if(Ext.getCmp('DGListingEditorGrid').selModel.getCount() == 1){
                            doMsgBoxAlert(Ext.getCmp('DGListingEditorGrid').selModel.getSelected());
                        }else{
                            Ext.MessageBox.show({
                                title: 'Pacientes',
                                msg: 'Debe Seleccionar un Registro.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ]
    });

   DGListingWindow = new Ext.Window({
        id: 'DGListingWindow',
        title: 'Busqueda de Conceptos',
        closable:false,
        width:980,
        height:480,
        plain:true,
        resizable : false,
        modal: true,
        x: MargenIzquierdo,
        y:120,
        layout: 'fit',
        loadMask: true,
        items: DGListingEditorGrid,
        bbar:[{
            text  : 'Empresa: ' + NOM_EMPRESA,
            xtype : 'tbtext'
        },'->',{
            text  : 'Sistemas Ofisalud - desarrollo@ofisalud.com - Tel: 3016398114',
            xtype : 'tbtext'
        },'-',btnSalir]
    });
    DGListingWindow.show();
   
}