/*
* @category    Funcion Buscar Ocupacion CIUO
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
function buscarciuo(pCampo, pCampo2)
{
    var DGDataStoreCIUO;
    var DGColumnModelCIUO;
    var DGListingEditorGridCIUO;
    var DGListingWindowCIUO;
    var DGListingSelectedRowCIUO;
    var DGListingContextMenuCIUO;
    var anchoPantallaCIUO;
    var MargenIzquierdoCIUO;

    var el = Ext.get('idusuario');
    var ID_USUARIO = el.getValue();
    el = Ext.get('nomusuario');
    var NOM_USUARIO = el.getValue();
    el = Ext.get('codusuario');
    var COD_USUARIO = el.getValue();
    el = Ext.get('idempresa');
    var ID_EMPRESA = el.getValue();
    el = Ext.get('nomempresa');
    var NOM_EMPRESA = el.getValue();
    el = Ext.get('idcliente');
    var ID_CLIENTE = el.getValue();
    el = Ext.get('nomcliente');
    var NOM_CLIENTE = el.getValue();
    el = Ext.get('idsede');
    var ID_SEDE = el.getValue();
    el = Ext.get('nomsede');
    var NOM_SEDE = el.getValue();
    el = Ext.get('idperfil');
    var ID_PERFIL = el.getValue();
    anchoPantalla = screen.width;
    switch(anchoPantalla)
    {
        case 1024:
            MargenIzquierdoCIUO = 15;
            break;
        case 1280:
            MargenIzquierdoCIUO = 150;
            break;
    }

    var btnSalir = new Ext.Button({
        id: 'btnSalirCIUO',
        text: 'Salir',
        icon: '../../../resources/botones/salir.png',
        iconCls: 'x-btn-text-icon',
        minWidth: 80,
        handler:function(){
            DGListingWindowCIUO.close();
        }
    });

    DGDataStoreCIUO = new Ext.data.Store({
        id: 'DGDataStoreCIUO',
        proxy: new Ext.data.HttpProxy({
            url: '../../controlador/ciuo/gridciuo.php',
            method: 'POST'
        }),
        loadMask: {msg:"Cargando Registros, por favor espere..."},
        autoload: false,
        reader: new Ext.data.JsonReader({
            root: 'results',
            totalProperty: 'total',
            id: 'id'
          },[
            {name: 'Codigo', type: 'string', mapping: 'Codigo'},
            {name: 'Descripcion', type: 'string', mapping: 'Descripcion'}
         ]),
      sortInfo:{field: 'Codigo', field: 'Descripcion', direction: "ASC"}
    });

    DGColumnModelCIUO = new Ext.grid.ColumnModel(
        [{
            header: 'Codigo',
            dataIndex: 'Codigo',
            sortable: true,
            width: 120
        },{
            header: 'Descripcion',
            dataIndex: 'Descripcion',
            sortable: true,
            width: 780
        }]
    );
    DGColumnModelCIUO.defaultSortable= true;

    doMsgBoxAlertCIUO = function(record) {
        //alert(pCampo);
        var codciuo = record.get('Codigo');
        Ext.getCmp(pCampo).setValue(codciuo);
        if(typeof pCampo2 != 'undefined'){
            Ext.getCmp(pCampo2).setValue(record.get('Descripcion'));
        }
        DGListingWindowCIUO.close();
    };

    doRowDblClickCIUO = function(thisGrid, rowIndex)  {
       var record = thisGrid.getStore().getAt(rowIndex);
       doMsgBoxAlertCIUO(record);
    };

    doRowCtxMenuCIUO = function(thisGrid, rowIndex, evtObj)
    {
        evtObj.stopEvent();
        var record = thisGrid.getStore().getAt(rowIndex);
        if (!thisGrid.rowCtxMenu)
        {
            thisGrid.rowCtxMenu = new Ext.menu.Menu({
                items : {
                    text    : 'Seleccionar Ocupacion',
                    handler : function() {
                        doMsgBoxAlertCIUO(record);
                    }
                }
            });
       }
       thisGrid.rowCtxMenu.showAt(evtObj.getXY());
    };
    
    DGListingEditorGridCIUO =  new Ext.grid.GridPanel({
        id: 'DGListingEditorGridCIUO',
        store: DGDataStoreCIUO,
        cm: DGColumnModelCIUO,
        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
        iconCls:'icon-grid',
        loadMask:{msg:"Cargando Registros, por favor espere..."},
        listeners: {
           rowdblclick: doRowDblClickCIUO,
           rowcontextmenu: doRowCtxMenuCIUO,
           destroy: function(thisGrid) {
               if (thisGrid.rowCtxMenu) {
                   thisGrid.rowCtxMenu.destroy();
               }
           }
        },
        tbar:[
            new Ext.app.SearchField({
                store: DGDataStoreCIUO,
                width: 120
            }),
            '->',
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Seleccionar',
                iconCls: 'btnSelect',
                id: 'btnSelectSearchCIUO',
                listeners:{
                    click : function(){
                        if(Ext.getCmp('DGListingEditorGridCIUO').selModel.getCount() == 1){
                            doMsgBoxAlertCIUO(Ext.getCmp('DGListingEditorGridCIUO').selModel.getSelected());
                        }else{
                            Ext.MessageBox.show({
                                title: 'Pacientes',
                                msg: 'Debe Seleccionar un Registro.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ]
    });

   DGListingWindowCIUO = new Ext.Window({
        id: 'DGListingWindowCIUO',
        title: 'Busqueda de Ocupaciones CIUO',
        closable:false,
        width:980,
        height:480,
        plain:true,
        resizable : false,
        modal: true,
        x: MargenIzquierdoCIUO,
        y:120,
        layout: 'fit',
        loadMask: true,
        items: DGListingEditorGridCIUO,
        bbar:[{
            text  : 'Empresa: ' + NOM_EMPRESA,
            xtype : 'tbtext'
        },'->',{
            text  : 'Sistemas Ofisalud - desarrollo@ofisalud.com - Tel: 3005703911',
            xtype : 'tbtext'
        },'-',btnSalir]
    });
    DGListingWindowCIUO.show();
   
}