/*
* @category    Funcion Buscar Paciente
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
function buscarpaciente(wPantalla)
{
    var DGDataStore;
    var DGColumnModel;
    var DGListingEditorGrid;
    var DGListingWindow;
    var DGListingSelectedRow;
    var DGListingContextMenu;
    var anchoPantalla;
    var MargenIzquierdo;
    var pDocumento;
    var pNom1;
    var pNom2;
    var pApe1;
    var pApe2;
    var el = Ext.get('idusuario');
    var ID_USUARIO = el.getValue();
    el = Ext.get('nomusuario');
    var NOM_USUARIO = el.getValue();
    el = Ext.get('codusuario');
    var COD_USUARIO = el.getValue();
    el = Ext.get('idempresa');
    var ID_EMPRESA = el.getValue();
    el = Ext.get('nomempresa');
    var NOM_EMPRESA = el.getValue();
    el = Ext.get('idcliente');
    var ID_CLIENTE = el.getValue();
    el = Ext.get('nomcliente');
    var NOM_CLIENTE = el.getValue();
    el = Ext.get('idsede');
    var ID_SEDE = el.getValue();
    el = Ext.get('nomsede');
    var NOM_SEDE = el.getValue();
    el = Ext.get('idperfil');
    var ID_PERFIL = el.getValue();
    var ID_ORIGEN = wPantalla;
    anchoPantalla = screen.width;
    TAREA = "LISTARxQRY";
    if(wPantalla === "ResumenNeurodesa"){
        TAREA = "LISTARxQRYNeuroDesa";
    }
    switch(anchoPantalla)
    {
        case 1024:
            MargenIzquierdo = 15;
            break;
        case 1280:
            MargenIzquierdo = 150;
            break;
    }

    var btnSalir = new Ext.Button({
        id: 'btnSalir',
        text: 'Salir',
        iconCls: 'btnSalir',
        minWidth: 80,
        handler:function(){
            DGListingWindow.close();
        }
    });
    
    DGDataStore = new Ext.data.Store({
        id: 'DGDataStore',
        proxy: new Ext.data.HttpProxy({
            url: '../../controlador/pacientes/controlador_pacientes.php',
            method: 'POST'
        }),
        baseParams: {
            task: TAREA
        },
        loadMask: {msg:"Cargando Registros, por favor espere..."},
        autoload: false,
        reader: new Ext.data.JsonReader({
            root: 'results',
            totalProperty: 'total',
            id: 'id'
          },[
            {name: 'Paciente'},
            {name: 'TipDoc'},
            {name: 'Documento'},
            {name: 'PrimerApellido'},
            {name: 'SegundoApellido'},
            {name: 'PrimerNombre'},
            {name: 'SegundoNombre'},
            {name: 'FecNac'},
            {name: 'FecNacNew', type: "date"},
            {name: 'Edad'},
            {name: 'Genero'},
            {name: 'Direccion'},
            {name: 'Zona'},
            {name: 'Telefono'},
            {name: 'Telefono1'},
            {name: 'Email'},
            {name: 'DeptoMunici'},
            {name: 'IdCliente'}
         ])
    });

    DGDataStore.on('beforeload', function(store){
	store.baseParams = {
            task: "LISTARxQRY",
            pNomBaseDatos: BD_MULTIPRESTADOR,
            pDocumento: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpDocumento').getValue().toUpperCase()),
            pNom1: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpNom1').getValue().toUpperCase()),
            pNom2: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpNom2').getValue().toUpperCase()),
            pApe1: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpApe1').getValue().toUpperCase()),
            pApe2: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpApe2').getValue().toUpperCase())
        };
    });
    
    DGColumnModel = new Ext.grid.ColumnModel(
        [{
            header: 'Paciente',
            dataIndex: 'Paciente',
            sortable: false,
            width: 1,
            hidden: true,
            hideable: false
        },
        {
            header: 'Tdoc',
            dataIndex: 'TipDoc',
            sortable: true,
            width: 40
        },{
            header: 'Documento',
            dataIndex: 'Documento',
            sortable: true,
            width: 130
        },{
            header: '1er Nombre',
            dataIndex: 'PrimerNombre',
            sortable: true,
            width: 150
        },{
            header: '2do Nombre',
            dataIndex: 'SegundoNombre',
            sortable: true,
            width: 150
        },{
            header: '1er Apellido',
            dataIndex: 'PrimerApellido',
            sortable: true,
            width: 150
        },{
            header: '2do Apellido',
            dataIndex: 'SegundoApellido',
            sortable: true,
            width: 150
        },{
            header: 'Telefono',
            dataIndex: 'Telefono',
            sortable: true,
            width: 150
        },{
            header: 'Otro Telefono1',
            dataIndex: 'Telefono1',
            sortable: true,
            width: 150
        }]
    );
    DGColumnModel.defaultSortable= true;
    
                    
    doMsgBoxAlert = function(record) {
        switch(wPantalla){
            case "Basico":
                Ext.getCmp('intPacienteBasico').setValue(record.get('Paciente'));
                Ext.getCmp('sysPacienteBasico').setValue(PonerAcentosMayusculas(record.get('TipDoc') + " " + record.get('Documento') + " - " + record.get('PrimerApellido') + " " + record.get('SegundoApellido') + " " + record.get('PrimerNombre') + " " + record.get('SegundoNombre') + ' Genero: (' + record.get('Genero') + ') - FecNac: (' + record.get('FecNac') + ')'));
                Ext.getCmp('sysPacienteGeneroBasico').setValue(record.get('Genero')); //record.get('') + ') - FecNac: (' + record.get('FecNac')
                if (record.get('FecNac') !== null && record.get('FecNac') !== "")
                {
                    var xfecnac = Array();
                    xfecnac = record.get('FecNac').split('-');
                    var dianac = xfecnac[0];
                    var mesnac = (xfecnac[1].length < 2)?'0':'';
                    mesnac += xfecnac[1];
                    var anonac = xfecnac[2];
                    var pFec2 =  anonac + "/" + mesnac + "/" + dianac;
                    Ext.getCmp('sysPacienteEdadMesesBasico').setValue(MostrarEdadMeses(new Date().format('Y/m/d'), pFec2));
                    Ext.getCmp('sysPacienteEdadAniosBasico').setValue(MostrarEdadAnios(new Date().format('Y/m/d'), pFec2));
                }
                
                break;
            case "Hospitaliza":
                Ext.getCmp('intPacienteObservaHospitaliza').setValue(record.get('Paciente'));
                Ext.getCmp('sysPacienteObservaHospitaliza').setValue(PonerAcentosMayusculas(record.get('TipDoc') + " " + record.get('Documento') + " - " + record.get('PrimerApellido') + " " + record.get('SegundoApellido') + " " + record.get('PrimerNombre') + " " + record.get('SegundoNombre') + ' Genero: (' + record.get('Genero') + ') - FecNac: (' + record.get('FecNac') + ')'));
                break;
            case "Facturacion":
                Ext.getCmp('intPacienteFacturacion').setValue(record.get('Paciente'));
                Ext.getCmp('sysPacienteFacturacion').setValue(PonerAcentosMayusculas(record.get('TipDoc') + " " + record.get('Documento') + " - " + record.get('PrimerApellido') + " " + record.get('SegundoApellido') + " " + record.get('PrimerNombre') + " " + record.get('SegundoNombre') + ' Genero: (' + record.get('Genero') + ') - FecNac: (' + record.get('FecNac') + ')'));
                break;
            case "LegalizaAgendaManual":
                Ext.getCmp('intPacienteLegalizacion').setValue(record.get('Paciente'));
                Ext.getCmp('sysPacienteLegalizacion').setValue(PonerAcentosMayusculas(record.get('TipDoc') + " " + record.get('Documento') + " - " + record.get('PrimerApellido') + " " + record.get('SegundoApellido') + " " + record.get('PrimerNombre') + " " + record.get('SegundoNombre') + ' Genero: (' + record.get('Genero') + ') - FecNac: (' + record.get('FecNac') + ')'));
                break;
            case "Resolucion4505":
                Ext.getCmp('intPacienteLegalizacion').setValue(record.get('Paciente'));
                Ext.getCmp('sysPacienteLegalizacion').setValue(PonerAcentosMayusculas(record.get('TipDoc') + " " + record.get('Documento') + " - " + record.get('PrimerApellido') + " " + record.get('SegundoApellido') + " " + record.get('PrimerNombre') + " " + record.get('SegundoNombre') + ' Genero: (' + record.get('Genero') + ') - FecNac: (' + record.get('FecNac') + ')'));
                Ext.getCmp('sysTipDoc').setValue(record.get('TipDoc'));
                Ext.getCmp('sysDoc').setValue(record.get('Documento'));
                Ext.getCmp('sysPrimer_Nombre').setValue(record.get('PrimerNombre'));
                Ext.getCmp('sysSegundo_Nombre').setValue(record.get('SegundoNombre'));
                Ext.getCmp('sysPrimer_Apellido').setValue(record.get('PrimerApellido'));
                Ext.getCmp('sysSegundo_Apellido').setValue(record.get('SegundoApellido'));
                Ext.getCmp('sysFecNac').setValue(record.get('FecNacNew'));
                Ext.getCmp('sysSexo').setValue(record.get('Genero'));
                break;
            case "CambiarRangoSalarial":
                Ext.getCmp('sysPacienteMalo').setValue(record.get('Paciente'));
                Ext.getCmp('fPacienteMalo').setValue(PonerAcentosMayusculas(record.get('TipDoc') + " " + record.get('Documento') + " - " + record.get('PrimerApellido') + " " + record.get('SegundoApellido') + " " + record.get('PrimerNombre') + " " + record.get('SegundoNombre') + ' Genero: (' + record.get('Genero') + ') - FecNac: (' + record.get('FecNac') + ')'));
                Ext.getCmp('sysTDocCambioRango').setValue(PonerAcentosMayusculas(record.get('TipDoc')));
                Ext.getCmp('sysDocumentoCambioRango').setValue(PonerAcentosMayusculas(record.get('Documento')));
                break;
            case "CambiarClienteInformeNeurodesa":
                Ext.getCmp('sysPacienteMalo').setValue(record.get('Paciente'));
                Ext.getCmp('fPacienteMalo').setValue(PonerAcentosMayusculas(record.get('TipDoc') + " " + record.get('Documento') + " - " + record.get('PrimerApellido') + " " + record.get('SegundoApellido') + " " + record.get('PrimerNombre') + " " + record.get('SegundoNombre') + ' Genero: (' + record.get('Genero') + ') - FecNac: (' + record.get('FecNac') + ')'));
                Ext.getCmp('intClienteResumenNeurodesa').setValue(null);
                Ext.getCmp('intPeriodoResumenNeurodesa').setValue(null);
                Ext.getCmp('intPeriodoResumenNeurodesa').store.load({
                    params: {
                        pEmpresa: ID_EMPRESA,
                        pIPS: ID_IPS,
                        pPaciente: Ext.getCmp('sysPacienteMalo').getValue()
                    }
                });
                break;
            case "ResumenNeurodesa":
                Ext.getCmp('gridHistorialEvoluciones').store.removeAll();
                Ext.getCmp('DetalleResumenNeurodesa').setValue(null);
                Ext.getCmp('intClienteResumenNeurodesa').setValue(record.get('IdCliente'));
                Ext.getCmp('sysPacienteResumenNeurodesa').setValue(record.get('Paciente'));
                Ext.getCmp('fPacienteResumenNeurodesa').setValue(PonerAcentosMayusculas(record.get('TipDoc') + " " + record.get('Documento') + " - " + record.get('PrimerApellido') + " " + record.get('SegundoApellido') + " " + record.get('PrimerNombre') + " " + record.get('SegundoNombre') + ' Genero: (' + record.get('Genero') + ') - FecNac: (' + record.get('FecNac') + ')'));
                Ext.getCmp('gridHistorialEvoluciones').store.load({
                    params: {
                        pEmpresa: ID_EMPRESA,
                        pIPS: ID_IPS,
                        pPaciente: Ext.getCmp('sysPacienteResumenNeurodesa').getValue()
                    }
                });
                break;
            case "ConsultarHCxPaciente":
                Ext.getCmp('intProfesionalSearchHC').setValue(null);
                Ext.getCmp('fecHastaSearchHC').setValue(null);
                Ext.getCmp('fecDesdeSearchHC').setValue(null);
                Ext.getCmp('gridFormulario').store.removeAll();
                Ext.getCmp('gridSinEvolucionar').store.removeAll();
                //Ext.getCmp('DetalleResumenHC').setValue(null);
                Ext.getCmp('DetalleResumenHC').load({
                    url: '../../controlador/asistencial/viewhcxformato.php?pEmpresa=0&pIPS=0&pPaciente=0&pEvolucion=0',
                    scripts:true,
                    scope:this,
                    nocache: false,
                    text: 'Cargando...'
                });
                Ext.getCmp('sysPacienteSearchHC').setValue(record.get('Paciente'));
                Ext.getCmp('fPacienteSearchHC').setValue(PonerAcentosMayusculas(record.get('TipDoc') + " " + record.get('Documento') + " - " + record.get('PrimerApellido') + " " + record.get('SegundoApellido') + " " + record.get('PrimerNombre') + " " + record.get('SegundoNombre') + ' Genero: (' + record.get('Genero') + ') - FecNac: (' + record.get('FecNac') + ')'));
                break;
            case "UnificaPacienteMalo":
                Ext.getCmp('sysPacienteMalo').setValue(record.get('Paciente'));
                Ext.getCmp('fPacienteMalo').setValue(PonerAcentosMayusculas(record.get('TipDoc') + " " + record.get('Documento') + " - " + record.get('PrimerApellido') + " " + record.get('SegundoApellido') + " " + record.get('PrimerNombre') + " " + record.get('SegundoNombre')));
                break;
            case "UnificaPacienteBueno":
                Ext.getCmp('sysPacienteBueno').setValue(record.get('Paciente'));
                Ext.getCmp('fPacienteBueno').setValue(PonerAcentosMayusculas(record.get('TipDoc') + " " + record.get('Documento') + " - " + record.get('PrimerApellido') + " " + record.get('SegundoApellido') + " " + record.get('PrimerNombre') + " " + record.get('SegundoNombre')));
                break;
            case "BarraServicios":
                Ext.getCmp('sysPacienteValido').setValue(0);
                Ext.getCmp('strgenero_citas').setValue("");
                Ext.getCmp('strApe1_citas').setValue("");
                Ext.getCmp('strApe2_citas').setValue("");
                Ext.getCmp('strNom1_citas').setValue("");
                Ext.getCmp('strNom2_citas').setValue("");
                Ext.getCmp('strEdad_citas').setValue("");
                Ext.getCmp('strDeptoMuni_citas').setValue("");
                Ext.getCmp('strDireccion_citas').setValue("");
                Ext.getCmp('strZona_citas').setValue("");
                Ext.getCmp('strTel1_citas').setValue("");
                Ext.getCmp('strTel2_citas').setValue("");
                Ext.getCmp('strEmail_citas').setValue("");
                Ext.getCmp('fecFecNac_citas').setValue("");
                Ext.getCmp('strEdad_citas').setValue("");
                Ext.getCmp('strRegimen_citas').setValue(1);
                Ext.getCmp('strTafiliado_citas').setValue("");
                Ext.getCmp('strParentesco_citas').setValue("");
                Ext.getCmp('strRango_citas').setValue("");
                Ext.getCmp('strEstado_citas').setValue("");
                Ext.getCmp('sysPacienteValido').setValue(0);
                Ext.getCmp('intIdPaciente_citas').setValue(record.get('Paciente'));
                Ext.getCmp('sysPacienteValido').setValue(1);
                Ext.getCmp('strTdoc_citas').setValue(record.get('TipDoc'));
                Ext.getCmp('strdocpac_citas').setValue(record.get('Documento'));
                Ext.getCmp('strgenero_citas').setValue(record.get('Genero'));
                Ext.getCmp('strApe1_citas').setValue(PonerAcentosMayusculas(record.get('PrimerApellido')));
                Ext.getCmp('strApe2_citas').setValue(PonerAcentosMayusculas(record.get('SegundoApellido')));
                Ext.getCmp('strNom1_citas').setValue(PonerAcentosMayusculas(record.get('PrimerNombre')));
                Ext.getCmp('strNom2_citas').setValue(PonerAcentosMayusculas(record.get('SegundoNombre')));
                Ext.getCmp('strDeptoMuni_citas').setValue(record.get('DeptoMunici'));
                Ext.getCmp('strDireccion_citas').setValue(PonerAcentosMayusculas(record.get('Direccion')));
                Ext.getCmp('strZona_citas').setValue(record.get('Zona'));
                Ext.getCmp('strTel1_citas').setValue(PonerAcentosMayusculas(record.get('Telefono')));
                Ext.getCmp('strTel2_citas').setValue(PonerAcentosMayusculas(record.get('Telefono1')));
                Ext.getCmp('strEmail_citas').setValue(PonerAcentosMayusculas(record.get('Email')));
                if (record.get('FecNac') !== null && record.get('FecNac') !== "" && record.get('FecNac') !== "00-0-0000")
                {
                    var xfecnac = Array();
                    xfecnac = record.get('FecNac').split('-');
                    var dianac = xfecnac[0];
                    var mesnac = (xfecnac[1].length < 2)?'0':'';
                    mesnac += xfecnac[1];
                    var anonac = xfecnac[2];
                    Ext.getCmp('fecFecNac_citas').setValue(dianac + "-" + mesnac + "-" + anonac);
                    Ext.getCmp('strEdad_citas').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),Ext.getCmp('fecFecNac_citas').getValue().format('Y/m/d')));
                }
                break;
                
            case "BarraServiciosIPS":
                var myEdad = "";
                Ext.getCmp('sysPacienteValido').setValue(0);
                Ext.getCmp('strgenero_citas').setValue("");
                Ext.getCmp('strApe1_citas').setValue("");
                Ext.getCmp('strApe2_citas').setValue("");
                Ext.getCmp('strNom1_citas').setValue("");
                Ext.getCmp('strNom2_citas').setValue("");
                Ext.getCmp('strEdad_citas').setValue("");
                Ext.getCmp('strDeptoMuni_citas').setValue("");
                Ext.getCmp('strDireccion_citas').setValue("");
                Ext.getCmp('strZona_citas').setValue("");
                Ext.getCmp('strTel1_citas').setValue("");
                Ext.getCmp('strTel2_citas').setValue("");
                Ext.getCmp('strEmail_citas').setValue("");
                Ext.getCmp('fecFecNac_citas').setValue("");
                Ext.getCmp('strEdad_citas').setValue("");
                Ext.getCmp('strRegimen_citas').setValue(1);
                Ext.getCmp('strTafiliado_citas').setValue("");
                Ext.getCmp('strParentesco_citas').setValue("");
                Ext.getCmp('strRango_citas').setValue("");
                Ext.getCmp('strEstado_citas').setValue("");
                Ext.getCmp('sysPacienteValido').setValue(0);
                Ext.getCmp('intIdPaciente_citas').setValue(record.get('Paciente'));
                Ext.getCmp('sysPacienteValido').setValue(1);
                Ext.getCmp('strTdoc_citas').setValue(record.get('TipDoc'));
                Ext.getCmp('strdocpac_citas').setValue(record.get('Documento'));
                Ext.getCmp('strgenero_citas').setValue(record.get('Genero'));
                Ext.getCmp('strApe1_citas').setValue(PonerAcentosMayusculas(record.get('PrimerApellido')));
                Ext.getCmp('strApe2_citas').setValue(PonerAcentosMayusculas(record.get('SegundoApellido')));
                Ext.getCmp('strNom1_citas').setValue(PonerAcentosMayusculas(record.get('PrimerNombre')));
                Ext.getCmp('strNom2_citas').setValue(PonerAcentosMayusculas(record.get('SegundoNombre')));
                Ext.getCmp('strDeptoMuni_citas').setValue(record.get('DeptoMunici'));
                Ext.getCmp('strDireccion_citas').setValue(PonerAcentosMayusculas(record.get('Direccion')));
                Ext.getCmp('strZona_citas').setValue(record.get('Zona'));
                Ext.getCmp('strTel1_citas').setValue(PonerAcentosMayusculas(record.get('Telefono')));
                Ext.getCmp('strTel2_citas').setValue(PonerAcentosMayusculas(record.get('Telefono1')));
                Ext.getCmp('strEmail_citas').setValue(PonerAcentosMayusculas(record.get('Email')));
                if (record.get('FecNac') !== null && record.get('FecNac') !== "" && record.get('FecNac') !== "00-0-0000")
                {
                    var xfecnac = Array();
                    xfecnac = record.get('FecNac').split('-');
                    var dianac = xfecnac[0];
                    var mesnac = (xfecnac[1].length < 2)?'0':'';
                    mesnac += xfecnac[1];
                    var anonac = xfecnac[2];
                    Ext.getCmp('fecFecNac_citas').setValue(dianac + "-" + mesnac + "-" + anonac);
                    Ext.getCmp('strEdad_citas').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),Ext.getCmp('fecFecNac_citas').getValue().format('Y/m/d')));
                    myEdad = MostrarEdadCompleta(new Date().format('Y/m/d'),Ext.getCmp('fecFecNac_citas').getValue().format('Y/m/d'));
                }
                verInfoActividadesxPaciente(record.get('Paciente'),PonerAcentosMayusculas(record.get('TipDoc') + " " + record.get('Documento') + " - " + record.get('PrimerNombre') + " " + record.get('SegundoNombre') + " " + record.get('PrimerApellido') + " " + record.get('SegundoApellido') ) + " - Genero: " + record.get('Genero') + " - Edad: " + myEdad);
                break;
            case "Radicacion":
                Ext.getCmp('fPacienteValido').setValue(0);
                Ext.getCmp('fGenero').setValue("");
                Ext.getCmp('fApe1').setValue("");
                Ext.getCmp('fApe2').setValue("");
                Ext.getCmp('fNom1').setValue("");
                Ext.getCmp('fNom2').setValue("");
                Ext.getCmp('fEdad').setValue("");
                Ext.getCmp('fDeptoMuni').setValue("");
                Ext.getCmp('fDireccion').setValue("");
                Ext.getCmp('fZona').setValue("");
                Ext.getCmp('fTel1').setValue("");
                Ext.getCmp('fTel2').setValue("");
                Ext.getCmp('fEmail').setValue("");
                Ext.getCmp('fFecNac').setValue("");
                Ext.getCmp('fEdad').setValue("");
                Ext.getCmp('fRegimen').setValue(1);
                Ext.getCmp('fTafiliado').setValue("");
                Ext.getCmp('fParentesco').setValue("");
                Ext.getCmp('fRango').setValue("");
                Ext.getCmp('fEstado').setValue("");
                Ext.getCmp('fPacienteValido').setValue(1);
                Ext.getCmp('fIdPaciente').setValue(record.get('Paciente'));
                Ext.getCmp('fTdoc').setValue(record.get('TipDoc'));
                Ext.getCmp('fDocID').setValue(record.get('Documento'));
                Ext.getCmp('fGenero').setValue(record.get('Genero'));
                Ext.getCmp('fApe1').setValue(PonerAcentosMayusculas(record.get('PrimerApellido')));
                Ext.getCmp('fApe2').setValue(PonerAcentosMayusculas(record.get('SegundoApellido')));
                Ext.getCmp('fNom1').setValue(PonerAcentosMayusculas(record.get('PrimerNombre')));
                Ext.getCmp('fNom2').setValue(PonerAcentosMayusculas(record.get('SegundoNombre')));
                Ext.getCmp('fDeptoMuni').setValue(record.get('DeptoMunici'));
                Ext.getCmp('fDireccion').setValue(PonerAcentosMayusculas(record.get('Direccion')));
                Ext.getCmp('fZona').setValue(record.get('Zona'));
                Ext.getCmp('fTel1').setValue(PonerAcentosMayusculas(record.get('Telefono')));
                Ext.getCmp('fTel2').setValue(PonerAcentosMayusculas(record.get('Telefono1')));
                Ext.getCmp('fEmail').setValue(PonerAcentosMayusculas(record.get('Email')));
                if (record.get('FecNac') !== null && record.get('FecNac') !== "" && record.get('FecNac') !== "00-0-0000"){
                    var xfecnac = Array();
                    xfecnac = record.get('FecNac').split('-');
                    var dianac = xfecnac[0];
                    var mesnac = (xfecnac[1].length < 2)?'0':'';
                    mesnac += xfecnac[1];
                    var anonac = xfecnac[2];
                    Ext.getCmp('fFecNac').setValue(dianac + "-" + mesnac + "-" + anonac);
                    Ext.getCmp('fEdad').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),Ext.getCmp('fFecNac').getValue().format('Y/m/d')));
                }
                break;
            case "POS":
                Ext.getCmp('fPacienteValido').setValue(0);
                Ext.getCmp('fGenero').setValue("");
                Ext.getCmp('fApe1').setValue("");
                Ext.getCmp('fApe2').setValue("");
                Ext.getCmp('fNom1').setValue("");
                Ext.getCmp('fNom2').setValue("");
                Ext.getCmp('fEdad').setValue("");
                Ext.getCmp('fDeptoMuni').setValue("");
                Ext.getCmp('fDireccion').setValue("");
                Ext.getCmp('fZona').setValue("");
                Ext.getCmp('fTel1').setValue("");
                Ext.getCmp('fTel2').setValue("");
                Ext.getCmp('fEmail').setValue("");
                Ext.getCmp('fFecNac').setValue("");
                Ext.getCmp('fEdad').setValue("");
                Ext.getCmp('fRegimen').setValue(1);
                Ext.getCmp('fTafiliado').setValue("");
                Ext.getCmp('fParentesco').setValue("");
                Ext.getCmp('fRango').setValue("");
                Ext.getCmp('fEstado').setValue("");
                Ext.getCmp('fPacienteValido').setValue(1);
                Ext.getCmp('fIdPaciente').setValue(record.get('Paciente'));
                Ext.getCmp('fTdoc').setValue(record.get('TipDoc'));
                Ext.getCmp('fDocID').setValue(record.get('Documento'));
                Ext.getCmp('fGenero').setValue(record.get('Genero'));
                Ext.getCmp('fApe1').setValue(PonerAcentosMayusculas(record.get('PrimerApellido')));
                Ext.getCmp('fApe2').setValue(PonerAcentosMayusculas(record.get('SegundoApellido')));
                Ext.getCmp('fNom1').setValue(PonerAcentosMayusculas(record.get('PrimerNombre')));
                Ext.getCmp('fNom2').setValue(PonerAcentosMayusculas(record.get('SegundoNombre')));
                Ext.getCmp('fDeptoMuni').setValue(record.get('DeptoMunici'));
                Ext.getCmp('fDireccion').setValue(PonerAcentosMayusculas(record.get('Direccion')));
                Ext.getCmp('fZona').setValue(record.get('Zona'));
                Ext.getCmp('fTel1').setValue(PonerAcentosMayusculas(record.get('Telefono')));
                Ext.getCmp('fTel2').setValue(PonerAcentosMayusculas(record.get('Telefono1')));
                Ext.getCmp('fEmail').setValue(PonerAcentosMayusculas(record.get('Email')));
                break;
            default:
                break;
        }
        CREAR_PACIENTE = 1;
        DGListingWindow.close();
    };

    doRowDblClick = function(thisGrid, rowIndex)  {
       var record = thisGrid.getStore().getAt(rowIndex);
       doMsgBoxAlert(record);
    };

    doRowCtxMenu = function(thisGrid, rowIndex, evtObj)
    {
        evtObj.stopEvent();
        var record = thisGrid.getStore().getAt(rowIndex);
        if (!thisGrid.rowCtxMenu)
        {
            thisGrid.rowCtxMenu = new Ext.menu.Menu({
                items : {
                    text    : 'Seleccionar Paciente',
                    handler : function() {
                        doMsgBoxAlert(record);
                    }
                }
            });
       }
       thisGrid.rowCtxMenu.showAt(evtObj.getXY());
    };
    
    DGListingEditorGrid =  new Ext.grid.GridPanel({
        id: 'DGListingEditorGrid',
        store: DGDataStore,
        cm: DGColumnModel,
        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
        iconCls:'icon-grid',
        loadMask:{msg:"Cargando Registros, por favor espere..."},
        listeners: {
           rowdblclick: doRowDblClick,
           rowcontextmenu: doRowCtxMenu,
           destroy: function(thisGrid) {
               if (thisGrid.rowCtxMenu) {
                   thisGrid.rowCtxMenu.destroy();
               }
           }
        },
        bbar: new Ext.PagingToolbar({
            pageSize: 15,
            store: DGDataStore,  
            displayInfo: true
        }),
        tbar:[
            {
                xtype: 'textfield',
                emptyText: 'Nro Documento...!',
                id: 'searchpDocumento',
                width: 110
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'textfield',
                emptyText: '1er Nombre...!',
                id: 'searchpNom1',
                width: 110
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'textfield',
                emptyText: '2do Nombre...!',
                id: 'searchpNom2',
                width: 110
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'textfield',
                emptyText: '1er Apellido...!',
                id: 'searchpApe1',
                width: 110
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'textfield',
                emptyText: '2do Apellido...!',
                id: 'searchpApe2',
                width: 110
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                tooltip: 'Buscar Paciente',
                iconCls: 'btnBuscar',
                id: 'btnEjecutarSearchPac',
                listeners:{
                    click: function(){
                        DGDataStore.load({
                            params: {
                                task: TAREA,
                                pNomBaseDatos: BD_MULTIPRESTADOR,
                                pDocumento: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpDocumento').getValue().toUpperCase()),
                                pNom1: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpNom1').getValue().toUpperCase()),
                                pNom2: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpNom2').getValue().toUpperCase()),
                                pApe1: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpApe1').getValue().toUpperCase()),
                                pApe2: QuitarAcentosTxtMayusculas(Ext.getCmp('searchpApe2').getValue().toUpperCase()),
                                start: 0, 
                                limit: 15
                            }
                        });
                    }
                }
            },
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                tooltip: 'Limpiar Datos del Paciente',
                iconCls: 'btnLimpiar',
                id: 'btnLimpiarSearchPac',
                listeners:{
                    click: function(){
                        Ext.getCmp('searchpDocumento').setValue(null);
                        Ext.getCmp('searchpNom1').setValue(null);
                        Ext.getCmp('searchpNom2').setValue(null);
                        Ext.getCmp('searchpApe1').setValue(null);
                        Ext.getCmp('searchpApe2').setValue(null);
                        DGDataStore.load({
                            params: {
                                pNomBaseDatos: BD_MULTIPRESTADOR,
                                pDocumento: 'NA',
                                pApe1: 'NA',
                                pApe2: 'NA',
                                pNom1: 'NA',
                                pNom2: 'NA',
                                start: 0, 
                                limit: 15
                            }
                        });
                    }
                }
            },
            /*
            new Ext.app.SearchField({
                store: DGDataStore,
                params: {start: 0, limit: 15},
                emptyText: 'Nro Documento...!',
                id: 'searchpDocumento',
                width: 110
            })*/
            '->',
            {
                xtype: 'tbseparator'
            },
            {
                xtype: 'button',
                text: 'Seleccionar',
                iconCls: 'btnSelect',
                id: 'btnSelectSearchPaciente',
                listeners:{
                    click : function(){
                        if(Ext.getCmp('DGListingEditorGrid').selModel.getCount() == 1){
                            doMsgBoxAlert(Ext.getCmp('DGListingEditorGrid').selModel.getSelected());
                        }else{
                            Ext.MessageBox.show({
                                title: 'Pacientes',
                                msg: 'Debe Seleccionar un Paciente.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            },
            {
                xtype: 'tbseparator'
            }
        ]
    });

   DGListingWindow = new Ext.Window({
        id: 'DGListingWindow',
        title: 'Busqueda de Pacientes',
        closable:false,
        width:980,
        height:480,
        plain:true,
        resizable : false,
        modal: true,
        x: MargenIzquierdo,
        y:120,
        layout: 'fit',
        loadMask: true,
        items: DGListingEditorGrid,
        bbar:[{
            text  : 'Empresa: ' + NOM_EMPRESA,
            xtype : 'tbtext'
        },'->',{
            text  : 'Sistemas Ofisalud - desarrollo@ofisalud.com - Tel: 3016398114',
            xtype : 'tbtext'
        },'-',btnSalir]
    });
    DGListingWindow.show();
   
}