/*
* @category    Solicitud Examenes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

SolExaMedicare202101Ui = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    initComponent: function() {
        
        searchStoreExaMedicare2018 = new Ext.data.Store({
            //id: 'dsSolExaIPS002',
            proxy: new Ext.data.ScriptTagProxy({
                url: '../../controlador/asistencial/controlador_solexa_searchmedicare2018.php'
            }),
            reader: new Ext.data.JsonReader({
                root: 'data',
                totalProperty: 'totalCount',
                id: 'id'
            }, 
            [
                {name: 'Codigo'},
                {name: 'Descripcion'},
                {name: 'TipoEstudio'},
                {name: 'Tarifa'},
                {name: 'infoTarifa'},
                {name: 'TipoAutoriza'},
                {name: 'EsCX'},
                {name: 'CantidadMaxSol'},
                {name: 'MinDiasSol'},
                {name: 'UsaAuditoria'},
                {name: 'NotificaCorreo'},
                {name: 'DiasSolicitados'}
            ])
        });
        
        StorePaqueteServicios = new Ext.data.Store({
            proxy: new Ext.data.ScriptTagProxy({
                url: '../../controlador/combobox/controlador_paquetes.php'
            }),
            reader: new Ext.data.JsonReader({
                root: 'data',
                totalProperty: 'totalCount',
                id: 'id'
            }, 
            [
                { name: 'Codigo' },
                { name: 'Descripcion' }
            ])
        });
        StorePaqueteServicios.load();
        
        this.items = [
            {
                xtype: 'compositefield',
                frame: true,
                style: 'background:transparent;',
                items: [
                    {
                        html: 'Paquete de Ordenamientos: '
                    },
                    {
                        xtype: 'combo',
                        allowBlank: true,
                        store: StorePaqueteServicios,
                        forceSelection: true,
                        triggerAction: 'all',
                        mode: 'local',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        emptyText: 'Seleccione el Paquete de Ordenamientos que desea solicitar....',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        width: 300,
                        submitValue: true,
                        id: 'sysPaquete'
                    },
                    {
                        xtype: 'button',
                        text: 'Adicionar',
                        iconCls: 'btnAddRow',
                        listeners: {
                            click : function() {
                                if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1 && Ext.getCmp('sysPaquete').getValue() != "" && Ext.getCmp('sysPaquete').getValue() != null){
                                    Ext.Msg.show({
                                        title: 'Ordenamientos',
                                        msg: 'Esta Seguro que Desea Adicionar el Paquete de Solicitud para: ' + Ext.getCmp('sysPaquete').getRawValue() + '?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn){
                                            if(btn === "yes"){
                                                fnAddRegistrospaqueteExaMedicare202101("../../controlador/asistencial/controlador_solexa_medicare2021.php",{task: "ADDPAQUETE_OFICLINIC_001", pCAS: Ext.getCmp('sysCASHC').getValue(), pPQT: Ext.getCmp('sysPaquete').getValue()}, 'gridExamenesHC');
                                            }
                                        }
                                    });
                                }else{
                                    Ext.Msg.show({
                                        title: 'eOfiClinic',
                                        msg: 'Usted No ha Guardado la Evolución',
                                        buttons: Ext.Msg.OK,
                                        icon: Ext.Msg.ERROR
                                    });
                                }
                            }
                        }
                    }
                ]
            },
            {
                xtype: 'grid',
                title: ' ',
                id: 'gridExamenesHC',
                store: 'StoreGridExaSolicitadosHC',
                anchor: "100%",
                height: 325,
                border: false,
                frame: true,
                loadMask: true,
                colModel: new Ext.ux.grid.LockingColumnModel([
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'idConsecutivoSolicitud',
                        id: 'idConsecutivoSolicitud'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción',
                        sortable: false,
                        width: 450,
                        dataIndex: 'descConcepto',
                        id: 'descConcepto'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Cantidad',
                        sortable: false,
                        width: 80,
                        dataIndex: 'Cantidad',
                        id: 'Cantidad'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Notas a Proveedor',
                        sortable: false,
                        width: 330,
                        dataIndex: 'notasProveedor',
                        id: 'notasProveedor'
                    }
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                iconCls:'icon-grid',
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'button',
                                text: 'Adicionar',
                                iconCls: 'btnAddRow',
                                id: 'btnAddExaEvolucion',
                                listeners: {
                                    click : function() {
                                        if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1){
                                            if (objEXAADD !== "NA"){
                                                var xSolEXAADD = eval(objEXAADD);
                                                Ext.getCmp('intPrestadorExa').setValue(ID_EMPRESA);
                                                Ext.getCmp('intIPSExa').setValue(ID_SEDE);
                                                Ext.getCmp('intPacienteExa').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                Ext.getCmp('intCASExa').setValue(Ext.getCmp('sysCASHC').getValue());
                                                Ext.getCmp('intProfesionalExa').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                Ext.getCmp('intUsuarioExa').setValue(ID_USUARIO);
                                                Ext.getCmp('sysClienteExa').setValue(Ext.getCmp('sysIdClienteHC').getValue());
                                                Ext.getCmp('sysPlanExa').setValue(Ext.getCmp('sysIdPlanHC').getValue());
                                                Ext.getCmp('sysSubPlanExa').setValue(Ext.getCmp('sysIdSubPlanHC').getValue());
                                                searchStoreExaMedicare2018.setBaseParam('pCCAS', Ext.getCmp('sysCASHC').getValue());
                                                searchStoreExaMedicare2018.setBaseParam('pCliente', Ext.getCmp('sysClienteExa').getValue());
                                                xSolEXAADD.show();
                                            }
                                        }else{
                                            Ext.Msg.show({
                                                title: 'eOfiClinic',
                                                msg: 'Usted No ha Guardado la Evolución',
                                                buttons: Ext.Msg.OK,
                                                icon: Ext.Msg.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Eliminar',
                                iconCls: 'btnDelRow',
                                id: 'btnDelExaEvolucion',
                                listeners: {
                                    click : function() {
                                        if(parseInt(Ext.getCmp('gridExamenesHC').selModel.getCount()) === 1){
                                            var selections = Ext.getCmp('gridExamenesHC').selModel.getSelections();
                                            Ext.Msg.show({
                                                title: 'Ordenamientos',
                                                msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.descConcepto + '?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn)
                                                {
                                                    if(btn === "yes"){
                                                        fnEliminarRegistrosExaMedicare202101("../../controlador/asistencial/controlador_solexa_medicare2018.php",{task: "ELIMINAR_OFICLINIC_001", pIdMx: selections[0].json.idConsecutivoSolicitud}, 'gridExamenesHC');
                                                    }
                                                }
                                            });
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Actualizar',
                                iconCls: 'btnActualizarGrid',
                                listeners: {
                                    click : function() {
                                        Ext.getCmp("gridReporteParaclinicos").store.reload();
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            '->',
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Imprimir Orden',
                                iconCls: 'btnImprimir',
                                id: 'btnPrintExaEvolucionAll',
                                listeners: {
                                    click : function() {
                                        //window.open ("../../controlador/asistencial/printordenexa0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue(),"Ordenamientos");
                                        window.open ("../../controlador/asistencial/printordenexa0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue(),"Ordenamientos");
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Imprimir Seleccionados',
                                iconCls: 'btnImprimir',
                                id: 'btnPrintExaSeleccion',
                                listeners: {
                                    click : function() {
                                        var Registros;
                                        Registros = Ext.getCmp('gridExamenesHC').selModel.getCount();
                                        if(Registros > 0){
                                            var selections = Ext.getCmp('gridExamenesHC').selModel.getSelections();
                                            var prez = [];
                                            for(i = 0; i < Registros; i++){
                                                prez.push(selections[i].json.idConsecutivoSolicitud);
                                            }
                                            var encoded_array = Ext.encode(prez);
                                            window.open ("../../controlador/asistencial/printordenexa0_1.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue() +  "&pItems=" + encoded_array,"Formula Medica");
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'Debe seleccionar los Examenes a imprimir',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                            xtype: 'button',
                            text: 'Ver Historial Solicitud Servicios',
                            iconCls: 'btnCitasAsignadas',
                            id: 'btnVerHistorialExamens',
                            listeners: {
                                click : function() {
                                    viewHistorialOrdenamientos(Ext.getCmp('sysIdPacienteHC').getValue(),"S");
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        }
                        ]
                    }
            }
        ];
        SolExaMedicare202101Ui.superclass.initComponent.call(this);
    }
});

function fnAddRegistrospaqueteExaMedicare202101(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        Ext.getCmp("gridReporteParaclinicos").store.reload();
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        Ext.getCmp("gridReporteParaclinicos").store.reload();
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron adicionar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos adicionar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos adicionar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}

function fnEliminarRegistrosExaMedicare202101(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        Ext.getCmp("gridReporteParaclinicos").store.reload();
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        Ext.getCmp("gridReporteParaclinicos").store.reload();
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}