/*
* @category    Solicitud Examenes Especializados CVM 001
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

SolCVM001Ui = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    initComponent: function() {
        this.items = [
            {
                xtype: 'grid',
                title: ' ',
                id: 'gridSolicitudesCVMxPaciente',
                store: 'StoreGridCVMExaSolicitadosxPaciente',
                anchor: "100%",
                height: 335,
                border: false,
                frame: true,
                loadMask: true,
                colModel: new Ext.ux.grid.LockingColumnModel([
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'idConsecutivoSolicitud',
                        id: 'idConsecutivoSolicitud'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción',
                        sortable: false,
                        width: 450,
                        dataIndex: 'descConcepto',
                        id: 'descConcepto'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Cantidad',
                        sortable: false,
                        width: 80,
                        dataIndex: 'Cantidad',
                        id: 'Cantidad'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Notas a Proveedor',
                        sortable: false,
                        width: 330,
                        dataIndex: 'notasProveedor',
                        id: 'notasProveedor'
                    }
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                iconCls:'icon-grid',
                //view: new Ext.grid.GroupingView(),
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'button',
                                text: 'Adicionar Examen',
                                iconCls: 'btnAddRow',
                                id: 'btnAddSolExamenes',
                                listeners: {
                                    click : function() {
                                        if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1){
                                            var xSolEXACVMADD = new winSolExaCVMIPS001Ui();
                                            Ext.getCmp('intPrestadorExaCVM').setValue(ID_EMPRESA);
                                            Ext.getCmp('intIPSExaCVM').setValue(ID_SEDE);
                                            Ext.getCmp('intPacienteExaCVM').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                            Ext.getCmp('intCASExaCVM').setValue(Ext.getCmp('sysCASHC').getValue());
                                            Ext.getCmp('intConsecutivoHCExaCVM').setValue(Ext.getCmp('sysConsecutivoDetalleHC').getValue());
                                            Ext.getCmp('intProfesionalExaCVM').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                            Ext.getCmp('intUsuarioExaCVM').setValue(ID_USUARIO);
                                            Ext.getCmp('sysClienteExaCVM').setValue(Ext.getCmp('sysIdClienteHC').getValue());
                                            Ext.getCmp('sysPlanExaCVM').setValue(Ext.getCmp('sysIdPlanHC').getValue());
                                            Ext.getCmp('sysSubPlanExaCVM').setValue(Ext.getCmp('sysIdSubPlanHC').getValue());
                                            Ext.getCmp('strFechaExaCVM').setValue(Ext.getCmp('sysFechaHC').getValue());
                                            Ext.getCmp('strDiagnosticoExaCVM').setValue(Ext.getCmp('sysDiagPpalHC').getValue());

                                            searchStoreExaCVM.setBaseParam('pCliente', Ext.getCmp('sysIdClienteHC').getValue());
                                            searchStoreExaCVM.setBaseParam('pPlan', Ext.getCmp('sysIdPlanHC').getValue());
                                            searchStoreExaCVM.setBaseParam('pSubPlan', Ext.getCmp('sysIdSubPlanHC').getValue());
                                            xSolEXACVMADD.show();
                                        }else{
                                            Ext.Msg.show({
                                                title: 'eOfiClinic',
                                                msg: 'Usted No ha Guardado la Evolución',
                                                buttons: Ext.Msg.OK,
                                                icon: Ext.Msg.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Eliminar Examen',
                                iconCls: 'btnDelRow',
                                id: 'btnDelSolExamenes',
                                listeners: {
                                    click : function() {
                                        if(Ext.getCmp('gridSolicitudesCVMxPaciente').selModel.getCount() === 1){
                                            var selections = Ext.getCmp('gridSolicitudesCVMxPaciente').selModel.getSelections();
                                            Ext.Msg.show({
                                                title: 'Examenes Especializados',
                                                msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.descConcepto + '?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn){
                                                    if(btn === "yes"){
                                                        fnEliminarRegistrosCVMExaIPS001("../../controlador/asistencial/controlador_cvm.php",{task: "ELIMINAR_SOLEXA", pIdExa: selections[0].json.idConsecutivoSolicitud, pConceptoExa: selections[0].json.idConcepto, pCASRemExa: Ext.getCmp('sysCASHC').getValue()}, 'gridSolicitudesCVMxPaciente');
                                                    }
                                                }
                                            });
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            '->',
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Imprimir Orden',
                                iconCls: 'btnImprimir',
                                listeners: {
                                    click : function() {
                                        window.open ("../../controlador/asistencial/printordenexacvm0.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue(),"Ordenamientos");
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Imprimir Examenes Seleccionados',
                                iconCls: 'btnImprimir',
                                listeners: {
                                    click : function() {
                                        var Registros;
                                        Registros = Ext.getCmp('gridSolicitudesCVMxPaciente').selModel.getCount();
                                        if(Registros > 0){
                                            var selections = Ext.getCmp('gridSolicitudesCVMxPaciente').selModel.getSelections();
                                            var prez = [];
                                            for(i = 0; i < Registros; i++){
                                                prez.push(selections[i].json.idConsecutivoSolicitud);
                                            }
                                            var encoded_array = Ext.encode(prez);
                                            window.open ("../../controlador/asistencial/printordenexa0_1.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pPaciente=" + Ext.getCmp('sysIdPacienteHC').getValue() + "&pCAS=" + Ext.getCmp('sysCASHC').getValue() +  "&pItems=" + encoded_array,"Formula Medica");
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'Debe seleccionar los Examenes a imprimir',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            }
                        ]
                    }
            }
        ];
        SolCVM001Ui.superclass.initComponent.call(this);
    }
});

function fnEliminarRegistrosCVMExaIPS001(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}