/*
* @category    Formulario Adicionar Medicamentos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winSolExaCVMIPS001Ui = Ext.extend(Ext.Window, {
    title: '.:: Examenes / Procedimientos Especializados::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winSolExaCVMIPS001Ui',
    initComponent: function() {
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddExamenes',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'sysClienteExaCVM',
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysPlanExaCVM',
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysSubPlanExaCVM',
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'strTipoExaCVM',
                                value: "E",
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPrestadorExaCVM',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIPSExaCVM',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPacienteExaCVM',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intCASExaCVM',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intConsecutivoHCExaCVM',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intProfesionalExaCVM',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioExaCVM',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Busqueda',
                                store: searchStoreExaCVM,
                                displayField: 'Descripcion',
                                typeAhead: false,
                                loadingText: 'Buscando...',
                                anchor: '100%',
                                hideTrigger: true,
                                minChars: 4,
                                emptyText:'Escriba el nombre del servicio -- p.e: PAQUIMETRIA',
                                id: 'sysSearchExaCVM',
                                onSelect: function(record){ // override default onSelect to do redirect
                                    Ext.getCmp('intConceptoOfiMedicalExaCVM').setValue(null);
                                    Ext.getCmp('strNomConceptoOfiMedicalExaCVM').setValue(null);
                                    Ext.getCmp('intConceptoOfiMedicalExaCVM').setValue(record.data.Codigo);
                                    Ext.getCmp('strNomConceptoOfiMedicalExaCVM').setValue(record.data.Descripcion);
                                    Ext.getCmp('strGrupoConceptoOfiMedicalExaCVM').setValue(record.data.TipoEstudio);
                                    Ext.getCmp('intTrifaOfiMedicalExaCVM').setValue(record.data.Tarifa);
                                    if(parseInt(record.data.EsCX) === 1){
                                        Ext.getCmp('intOjoExaCVM').allowBlank = false;
                                    }else{
                                        Ext.getCmp('intOjoExaCVM').allowBlank = true;
                                    }
                                    Ext.getCmp('sysSearchExaCVM').clearValue();
                                    Ext.getCmp('sysSearchExaCVM').collapse();
                                }
                            },
                            {
                                html: '<hr>'
                            },        
                            {
                                xtype: 'hidden',
                                id: 'intConceptoOfiMedicalExaCVM'
                            },
                            {
                                xtype: 'hidden',
                                id: 'intTrifaOfiMedicalExaCVM'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Concepto',
                                anchor: '100%',
                                readOnly: true,
                                allowBlank: false,
                                id: 'strNomConceptoOfiMedicalExaCVM'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Grupo',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                id: 'strGrupoConceptoOfiMedicalExaCVM'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numberfield',
                                        fieldLabel: 'Cantidad',
                                        id: 'intCantidadExaCVM',
                                        width: 80,
                                        allowBlank: false,
                                        minValue: 1,
                                        maxValue: 360,
                                        value: 1
                                    },
                                    {
                                        html: 'Ojo:'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 632,
                                        store: 'StoreMiembroParte',
                                        anchor: '100%',
                                        validationDelay: 50,
                                        triggerAction: 'all',
                                        mode: 'local',
                                        typeAhead: true,
                                        forceSelection: true,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        id: 'intOjoExaCVM'
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                fieldLabel: 'Notas a Proveedor',
                                anchor: '100%',
                                allowBlank: true,
                                id: 'memNotasExaCVM'
                            },
                            {
                                xtype: 'hidden',
                                id: 'strFechaExaCVM',
                                allowBlank: true
                            },
                            {
                                xtype: 'combo',
                                width: 80,
                                fieldLabel: 'Es Prioritario',
                                name: 'Es Prioritario',
                                allowBlank: false,
                                store: 'StoreSiNo',
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                value: 'NO',
                                id: 'strServicioPrioritarioExaCVM'
                            },
                            {
                                xtype: 'fieldset',
                                title: 'CONSENTIMIENTO INFORMADO',
                                layout: 'form',
                                labelWidth: 450,
                                collapsible: false,
                                titleCollapse: false,
                                anchor: '100%',
                                autoHeight: true,
                                items: [
                                    {
                                      xtype: 'combo',
                                      width: 80,
                                      fieldLabel: 'Se le Muestra y Explica al Paciente el Consentimiento Informado',
                                      name: 'Se le Muestra y Explica al Paciente el Consentimiento Informado',
                                      allowBlank: false,
                                      store: 'StoreSiNo',
                                      valueField: 'Descripcion',
                                      displayField: 'Descripcion',
                                      mode: 'local',
                                      forceSelection: true,
                                      typeAhead: true,
                                      typeAheadDelay: 10,
                                      triggerAction: 'all',
                                      id: 'strConsentimientoInformadoExaCVM'
                                  }
                                ]
                            },
                            {
                                xtype: 'hidden',
                                id: 'memConsentimientoExaCVM',
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'strDiagnosticoExaCVM',
                                allowBlank: true
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddMx',
                            listeners:{
                                click : function(){
                                    fnGuardarRegItemCVMExaIPS001("GUARDAR_SOLEXA","SI","winSolExaCVMIPS001Ui","frmAddExamenes","../../controlador/asistencial/controlador_cvm.php","gridSolicitudesCVMxPaciente");
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winSolExaCVMIPS001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegItemCVMExaIPS001(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        if (typeof pLimpiarForm !== 'undefined'){
                            if (pLimpiarForm === "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid !== 'undefined'){
                            if (pGrid !== 'NA'){
                                Ext.getCmp(pGrid).store.load({
                                    params:{
                                        pCAS: Ext.getCmp('intCASExaCVM').getValue(),
                                        pConsecutivoHC: Ext.getCmp('intConsecutivoHCExaCVM').getValue(),
                                        pEmpresa: Ext.getCmp('intPrestadorExaCVM').getValue(),
                                        pIPS: Ext.getCmp('intIPSExaCVM').getValue(),
                                        pPaciente: Ext.getCmp('intPacienteExaCVM').getValue(),
                                        task: "VerExaSolicitadosxHC"
                                    }
                                });
                            }
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
