/*
* @category    Formulario Adicionar Solicitud Examenes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winSolExa003Ui = Ext.extend(Ext.Window, {
    title: 'eOfiMedical .:: Examenes / Procedimientos ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winSolExa002Ui',
    initComponent: function() {
        var selMx = "0";
        var stConceptosOfimedical = new StoreConceptosOfimedical();
        stConceptosOfimedical.load({
            params: {
                pTipo: "E"
            }
        });
        var stConceptosGrupos = new StoreGrupoConceptosOfimedical();
        stConceptosGrupos.load();
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddExamenes',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'strTipoExa',
                                value: "E",
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPrestadorExa',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIPSExa',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPacienteExa',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intCASExa',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intProfesionalExa',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioExa',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Descripción',
                                anchor: '100%',
                                allowBlank: false,
                                store: stConceptosOfimedical,
                                typeAhead: true,
                                typeAheadDelay: 450,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'strConceptoOfiMedicalExa',
                                listeners:{
                                    select : function(cmb, rec, idx){
                                        if (cmb.getValue() == "" || cmb.getValue() == null){
                                            Ext.getCmp('strGrupoConceptoOfiMedicalExa').setValue("SERVICIOS");
                                        }else{
                                            Ext.getCmp('strGrupoConceptoOfiMedicalExa').setValue(rec.data.GrupoConcepto);
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Grupo',
                                anchor: '100%',
                                allowBlank: false,
                                store: stConceptosGrupos,
                                typeAhead: true,
                                typeAheadDelay: 450,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                value: "SERVICIOS",
                                id: 'strGrupoConceptoOfiMedicalExa'
                            },
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'Cantidad',
                                id: 'intCantidadExa',
                                width: 80,
                                allowBlank: false,
                                minValue: 1,
                                maxValue: 360,
                                value: 1
                            },
                            {
                                xtype: 'textarea',
                                fieldLabel: 'Notas a Proveedor',
                                anchor: '100%',
                                allowBlank: true,
                                id: 'memNotasExa'
                            },
                            {
                                xtype: 'hidden',
                                id: 'strSelectConceptoExa',
                                allowBlank: true
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddExa',
                            listeners:{
                                click : function(){
                                    /*Ext.Msg.show({
                                        title: 'Guardar Examenes',
                                        msg: 'Esta Seguro que Desea Guardar la Información?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn)
                                        {
                                            if(btn=="yes")
                                            {
                                                fnGuardarRegItemExa("GUARDAR_OFIMEDICAL","SI","winSolExa002Ui","frmAddExamenes","../../controlador/solexa/controlador_solexa.php","gridExamenesHC");
                                            }
                                        }
                                    });*/
                                    fnGuardarRegItemExa("GUARDAR_OFIMEDICAL","SI","winSolExa002Ui","frmAddExamenes","../../controlador/solexa/controlador_solexa.php","gridExamenesHC");
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winSolExa003Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegItemExa(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        Ext.getCmp('strSelectConceptoExa').setValue(parseInt(Ext.getCmp('strConceptoOfiMedicalExa').getValue()));
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        /*Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });*/
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarDatosBasicosTarjeta').setVisible(false);
                                Ext.getCmp('btnModificarDatosBasicosTarjeta').setVisible(true);
                            }
                        }
                        /*if(pCerrar == "SI"){
                            Ext.getCmp(pWin).close();
                        }*/
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
