/*
* @category    Formulario Adicionar Medicamentos Ecopetrol
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winSolMxIPS001Ui = Ext.extend(Ext.Window, {
    title: '.:: Medicamentos ::.',
    width: 920,
    //autoHeight: true,
    height: 500,
    autoScroll: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winSolMx001Ui',
    initComponent: function() {
        var selMx = "0";
        var stPosologia = new StorePosologiaConceptosOfimedical();
        
        // Template para Combo de Medicamento
        var TemplateCombo = '<tpl for=".">';
        TemplateCombo += '<tpl if="PrioridadListado==\'1\'">';
        TemplateCombo += '<div class="cbSearchMx">';
        TemplateCombo += '<table border="0" width="720"><tr><td style="background-color:#A9F5BC;">';
        TemplateCombo += '<span style="background-color:#A9F5BC; font-size:14px">{Descripcion}</span><br>';
        TemplateCombo += '<span style="background-color:#A9F5BC; font-size:13px">Comercial: {NombreComercial}</span><br>';
        TemplateCombo += '<span style="background-color:#A9F5BC; font-size:13px">Laboratorio: {NomLaboratorio}</span><br><br>';
        TemplateCombo += '<span style="background-color:#A9F5BC; font-size:11px">Reg INVIMA: {RegistroINVIMA}</span><br>';
        TemplateCombo += '<span style="background-color:#A9F5BC; font-size:13px; text-align:right;">Vlr Unitario: <b>{VlrCostoFormato}</b></span><hr>';
        TemplateCombo += '</td></tr></table>';
        TemplateCombo += '</div>';
        TemplateCombo += '</tpl>';
        TemplateCombo += '<tpl if="PrioridadListado==\'2\'">';
        TemplateCombo += '<div class="cbSearchMx">';
        TemplateCombo += '<table border="0" width="720"><tr><td style="background-color:#ECF6CE;">';
        TemplateCombo += '<span style="background-color:#ECF6CE; font-size:14px">{Descripcion}</span><br>';
        TemplateCombo += '<span style="background-color:#ECF6CE; font-size:13px">Comercial: {NombreComercial}</span><br>';
        TemplateCombo += '<span style="background-color:#ECF6CE; font-size:13px">Laboratorio: {NomLaboratorio}</span><br><br>';
        TemplateCombo += '<span style="background-color:#ECF6CE; font-size:11px">Reg INVIMA: {RegistroINVIMA}</span><br>';
        TemplateCombo += '<span style="background-color:#ECF6CE; font-size:13px; text-align:right;">Vlr Unitario: <b>{VlrCostoFormato}</b></span><hr>';
        TemplateCombo += '</td></tr></table>';
        TemplateCombo += '</div>';
        TemplateCombo += '</tpl>';
        TemplateCombo += '<tpl if="PrioridadListado==\'3\'">';
        TemplateCombo += '<div class="cbSearchMx">';
        TemplateCombo += '<table border="0" width="720"><tr><td style="background-color:#F8E0E0;">';
        TemplateCombo += '<span style="background-color:#F8E0E0; font-size:14px">{Descripcion}</span><br>';
        TemplateCombo += '<span style="background-color:#F8E0E0; font-size:13px">Comercial: {NombreComercial}</span><br>';
        TemplateCombo += '<span style="background-color:#F8E0E0; font-size:13px">Laboratorio: {NomLaboratorio}</span><br><br>';
        TemplateCombo += '<span style="background-color:#F8E0E0; font-size:11px">Reg INVIMA: {RegistroINVIMA}</span><br>';
        TemplateCombo += '<span style="background-color:#F8E0E0; font-size:13px; text-align:right;">Vlr Unitario: <b>{VlrCostoFormato}</b></span><hr>';
        TemplateCombo += '</td></tr></table>';
        TemplateCombo += '</div>';
        TemplateCombo += '</tpl>';
        TemplateCombo += '</tpl>';
        
        var searchStoreMx = new Ext.data.Store({
            proxy: new Ext.data.ScriptTagProxy({
                url: '../../controlador/asistencial/controlador_ecopetrol.php'
            }),
            baseParams:{
                task: "SEARCH_MX",
                pAllMx: false
            },
            reader: new Ext.data.JsonReader({
                root: 'data',
                totalProperty: 'totalCount',
                id: 'id'
            }, 
            [
                {name: 'Codigo'},
                {name: 'Descripcion'},
                {name: 'NombreComercial'},
                {name: 'NomLaboratorio'},
                {name: 'CodMxMinisterio'},
                {name: 'RegistroINVIMA'},
                {name: 'CodigoCUM'},
                {name: 'ClasificacionListado'},
                {name: 'PrioridadListado'},
                {name: 'ClasificacionListado1'},
                {name: 'VlrCosto'},
                {name: 'VlrCostoFormato'},
                {name: 'TxtUnidadEmpaque'},
                {name: 'CantidadUnidadEmpaque'},
                {name: 'Cantminimo'},
                {name: 'Fraccionable'}
            ])
        });

        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '99%',
                id: 'frmAddMedicamentos',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'sysOpcionMx',
                                value: "N",
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'strTipoMx',
                                value: "M",
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPrestadorMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIPSMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPacienteMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intCASMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysConsecutivoHCMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysIdConsecutivoSolicitudMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intProfesionalMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'sysVlrUnitarioMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'checkbox',
                                boxLabel: 'Incluir todo el vademécum?',
                                anchor: '100%',
                                value: 'false',
                                id: 'sysIncluirAllMx',
                                listeners: {
                                    check: function(t,checked){
                                        Ext.getCmp('sysSearchMx').store.removeAll();
                                        Ext.getCmp('sysSearchMx').clearValue();
                                        Ext.getCmp('sysSearchMx').collapse();
                                    }
                                }
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Busqueda',
                                store: searchStoreMx,
                                displayField: 'Descripcion',
                                typeAhead: false,
                                loadingText: 'Buscando...',
                                anchor: '100%',
                                hideTrigger: true,
                                minChars: 4,
                                emptyText:'Escriba el nombre del Medicamento -- p.e: ACETA',
                                tpl: new Ext.XTemplate(TemplateCombo),
                                itemSelector: 'div.cbSearchMx',
                                name: 'cbSearchMx',
                                id: 'sysSearchMx',
                                onSelect: function(record){ // override default onSelect to do redirect
                                    Ext.getCmp('intConceptoOfiMedicalMx').setValue(null);
                                    Ext.getCmp('strNomConceptoOfiMedicalMx').setValue(null);
                                    Ext.getCmp('intConceptoOfiMedicalMx').setValue(record.data.Codigo);
                                    Ext.getCmp('strNomConceptoOfiMedicalMx').setValue(record.data.Descripcion);
                                    
                                    Ext.getCmp('sysNomComercialMx').setValue(record.data.NombreComercial);
                                    Ext.getCmp('sysNomLaboratorioMx').setValue(record.data.NomLaboratorio);
                                    Ext.getCmp('sysINVIMAMx').setValue(record.data.RegistroINVIMA);
                                    Ext.getCmp('sysClasificacionMx').setValue(record.data.ClasificacionListado);
                                    Ext.getCmp('sysClasificacion1Mx').setValue(record.data.ClasificacionListado1);
                                    Ext.getCmp('sysVlrUnitarioMx').setValue(record.data.VlrCosto);
                                    
                                    Ext.getCmp('sysUnidadEmpaqueMx').setValue(record.data.TxtUnidadEmpaque + " - " + record.data.CantidadUnidadEmpaque);
                                    Ext.getCmp('sysCantidadMinimaMx').setValue(parseInt(record.data.Cantminimo));
                                    Ext.getCmp('sysFraccionableMx').setValue(record.data.Fraccionable);
        
                                    Ext.getCmp('sysSearchMx').clearValue();
                                    Ext.getCmp('sysSearchMx').collapse();
                                    stPosologia.removeAll();
                                    stPosologia.load({
                                        params: {
                                            task: 'BUSCAR_POSOLOGIA_OFICLINIC',
                                            pConceptoOfimedical: Ext.getCmp('intConceptoOfiMedicalMx').getValue()
                                        }
                                    });
                                    Ext.getCmp('strPosologiaMx').setValue(null);
                                    Ext.getCmp('intCantidadMx').setValue(null);
                                    if(parseInt(record.data.PrioridadListado) > 1){
                                        fnActivarCamposJustifica("SI");
                                    }else{
                                        fnActivarCamposJustifica("NO");
                                    }
                                },
                                listeners: {
                                    beforequery: function(queryEvent){
                                        Ext.getCmp('sysSearchMx').store.setBaseParam("pAllMx", Ext.getCmp('sysIncluirAllMx').getValue());
                                    }
                                }
                            },
                            {
                                html: '<hr>'
                            },        
                            {
                                xtype: 'hidden',
                                id: 'intConceptoOfiMedicalMx'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Generico',
                                anchor: '100%',
                                readOnly: true,
                                allowBlank: true,
                                id: 'strNomConceptoOfiMedicalMx'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Comercial',
                                anchor: '100%',
                                readOnly: true,
                                allowBlank: true,
                                id: 'sysNomComercialMx'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Laboratorio',
                                anchor: '100%',
                                readOnly: true,
                                allowBlank: true,
                                id: 'sysNomLaboratorioMx'
                            },
                            {
                                xtype: 'compositefield',
                                anchor: '100%',
                                style: 'background:transparent;',
                                id: 'syscmpinfoempaque',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: 'Unidad Empaque',
                                        width: 250,
                                        readOnly: true,
                                        allowBlank: true,
                                        id: 'sysUnidadEmpaqueMx'
                                    },
                                    {
                                        html: 'Cantidad Minima: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 70,
                                        readOnly: true,
                                        allowBlank: true,
                                        id: 'sysCantidadMinimaMx'
                                    },
                                    {
                                        html: 'Fraccionable: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 40,
                                        readOnly: true,
                                        allowBlank: true,
                                        id: 'sysFraccionableMx'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                anchor: '100%',
                                style: 'background:transparent;',
                                id: 'syscmpinfoinvima',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: 'Reg. INVIMA',
                                        width: 335,
                                        readOnly: true,
                                        allowBlank: true,
                                        id: 'sysINVIMAMx'
                                    },
                                    {
                                        html: 'Tipo: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 70,
                                        readOnly: true,
                                        allowBlank: true,
                                        id: 'sysClasificacionMx'
                                    },   
                                    {
                                        html: '-'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 300,
                                        readOnly: true,
                                        allowBlank: true,
                                        id: 'sysClasificacion1Mx'
                                    }
                                ]
                            },
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'Cantidad',
                                id: 'intCantidadMx',
                                width: 80,
                                allowBlank: false,
                                minValue: 1,
                                maxValue: 360,
                                listeners: {
                                    change: function(t, newValue, oldValue){
                                        if(Ext.getCmp('sysFraccionableMx').getValue() === "N"){
                                            var moduloFraccion = parseInt(newValue) % parseInt(Ext.getCmp('sysCantidadMinimaMx').getValue());
                                            if(parseInt(newValue) < parseInt(Ext.getCmp('sysCantidadMinimaMx').getValue())){
                                                 Ext.MessageBox.show({
                                                    title: 'Medicamentos',
                                                    msg: 'La Cantidad solicitada no puede ser inferior a la cantidad minima de empaque.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                                Ext.getCmp('intCantidadMx').setValue(null);
                                            }else{
                                                if(parseInt(moduloFraccion) !== 0){
                                                    Ext.MessageBox.show({
                                                         title: 'Medicamentos',
                                                         msg: 'La Cantidad solicitada no es multiplo de la cantidad minima de empaque.',
                                                         buttons: Ext.MessageBox.OK,
                                                         icon: Ext.MessageBox.ERROR
                                                    }); 
                                                    Ext.getCmp('intCantidadMx').setValue(null);
                                                }
                                            }
                                        }else{
                                            //alert("Solicitado: " + newValue + " - Minimo: " + Ext.getCmp('sysCantidadMinimaMx').getValue());
                                            if(parseInt(newValue) < parseInt(Ext.getCmp('sysCantidadMinimaMx').getValue())){
                                                 Ext.MessageBox.show({
                                                    title: 'Medicamentos',
                                                    msg: 'La Cantidad solicitada no puede ser inferior a la cantidad minima de empaque.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                                Ext.getCmp('intCantidadMx').setValue(null);
                                            }
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Posología',
                                anchor: '100%',
                                allowBlank: false,
                                store: stPosologia,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: false,
                                id: 'strPosologiaMx'
                            },
                            {
                                xtype: 'fieldset',
                                anchor: '100%',
                                layout: 'form',
                                title: 'MEDICAMENTOS UTILIZADOS HASTA LA FECHA',
                                style: 'background:transparent;',
                                id: 'fsMxUtilizados',
                                items: [
                                    {
                                        html: '<br>'
                                    },
                                    {
                                        xtype: 'panel',
                                        anchor: '100%',
                                        layout: 'form',
                                        title: '1.',
                                        style: 'background:transparent;',
                                        labelWidth: 250,
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Medicamento Utilizado',
                                                name: 'Medicamento Utilizado',
                                                anchor: '100%',
                                                maxLength: 250,
                                                allowBlank: true,
                                                id: 'strMedicamentoUtiliza1Mx'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Tiempo de Uso',
                                                name: 'Tiempo de Uso',
                                                anchor: '100%',
                                                maxLength: 250,
                                                allowBlank: true,
                                                id: 'strTiempoUso1Mx'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Dosis Utilizada',
                                                name: 'Dosis Utilizada',
                                                anchor: '100%',
                                                maxLength: 250,
                                                allowBlank: true,
                                                id: 'strDosisUtilizada1Mx'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Respuesta Clínica',
                                                name: 'Respuesta Clínica',
                                                anchor: '100%',
                                                maxLength: 250,
                                                allowBlank: true,
                                                id: 'strRespuestaClinica1Mx'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Descripción de la Reacción Adversa Reportada o Encontrada',
                                                name: 'Descripción de la Reacción Adversa Reportada o Encontrada',
                                                anchor: '100%',
                                                maxLength: 250,
                                                allowBlank: true,
                                                id: 'strRAM1Mx'
                                            }
                                        ]
                                    },
                                    {
                                        html: '<hr>'
                                    },
                                    {
                                        xtype: 'panel',
                                        anchor: '100%',
                                        layout: 'form',
                                        title: '2.',
                                        style: 'background:transparent;',
                                        labelWidth: 250,
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Medicamento Utilizado',
                                                name: 'Medicamento Utilizado',
                                                anchor: '100%',
                                                maxLength: 250,
                                                allowBlank: true,
                                                id: 'strMedicamentoUtiliza2Mx'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Tiempo de Uso',
                                                name: 'Tiempo de Uso',
                                                anchor: '100%',
                                                maxLength: 250,
                                                allowBlank: true,
                                                id: 'strTiempoUso2Mx'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Dosis Utilizada',
                                                name: 'Dosis Utilizada',
                                                anchor: '100%',
                                                maxLength: 250,
                                                allowBlank: true,
                                                id: 'strDosisUtilizada2Mx'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Respuesta Clínica',
                                                name: 'Respuesta Clínica',
                                                anchor: '100%',
                                                maxLength: 250,
                                                allowBlank: true,
                                                id: 'strRespuestaClinica2Mx'
                                            },
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'Descripción de la Reacción Adversa Reportada o Encontrada',
                                                name: 'Descripción de la Reacción Adversa Reportada o Encontrada',
                                                anchor: '100%',
                                                maxLength: 250,
                                                allowBlank: true,
                                                id: 'strRAM2Mx'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                anchor: '100%',
                                layout: 'table',
                                title: 'VENTAJAS TERAPÉUTICAS SOBRE LOS MEDICAMENTOS EXISTENTES EN EL LME',
                                style: 'background:transparent;',
                                id: 'fsMxVentajasTerapeuticas',
                                items: [
                                    {
                                        xtype: 'textarea',
                                        fieldLabel: 'VENTAJAS TERAPÉUTICAS SOBRE LOS MEDICAMENTOS EXISTENTES EN EL LME',
                                        name: 'VENTAJAS TERAPÉUTICAS SOBRE LOS MEDICAMENTOS EXISTENTES EN EL LME',
                                        width: 890,
                                        allowBlank: true,
                                        id: 'strVentajasTerapeuticasMx'
                                    }
                                ]
                            },
                            {
                                xtype: 'fieldset',
                                anchor: '100%',
                                layout: 'table',
                                title: 'RESULTADO DEL ANÁLISIS RIESGO – BENEFICIO',
                                style: 'background:transparent;',
                                id: 'fsMxRiesgoBeneficio',
                                items: [
                                    {
                                        xtype: 'textarea',
                                        fieldLabel: 'RESULTADO DEL ANÁLISIS RIESGO – BENEFICIO',
                                        name: 'RESULTADO DEL ANÁLISIS RIESGO – BENEFICIO',
                                        width: 890,
                                        allowBlank: true,
                                        id: 'strRiesgoBeneficioMx'
                                    }
                                ]
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddMx',
                            listeners:{
                                click : function(){
                                    fnGuardarRegItemMxIPS004("GUARDAR_MX","SI","winSolMxIPS001Ui","frmAddMedicamentos","../../controlador/asistencial/controlador_ecopetrol.php","gridMedicamentosHC");
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                fnActivarCamposJustifica("NO");
            }}
        });
        winSolMxIPS001Ui.superclass.initComponent.call(this);
    }
});

function fnActivarCamposJustifica(wActivar){
    if(wActivar === "NO"){
        Ext.getCmp('strMedicamentoUtiliza1Mx').allowBlank = true;
        Ext.getCmp('strMedicamentoUtiliza1Mx').clearInvalid();
        Ext.getCmp('strMedicamentoUtiliza2Mx').allowBlank = true;
        Ext.getCmp('strMedicamentoUtiliza2Mx').clearInvalid();
        Ext.getCmp('strTiempoUso1Mx').allowBlank = true;
        Ext.getCmp('strTiempoUso1Mx').clearInvalid();
        Ext.getCmp('strDosisUtilizada1Mx').allowBlank = true;
        Ext.getCmp('strDosisUtilizada1Mx').clearInvalid();
        Ext.getCmp('strRespuestaClinica1Mx').allowBlank = true;
        Ext.getCmp('strRespuestaClinica1Mx').clearInvalid();
        Ext.getCmp('strRAM1Mx').allowBlank = true;
        Ext.getCmp('strRAM1Mx').clearInvalid();
        Ext.getCmp('strTiempoUso2Mx').allowBlank = true;
        Ext.getCmp('strTiempoUso2Mx').clearInvalid();
        Ext.getCmp('strDosisUtilizada2Mx').allowBlank = true;
        Ext.getCmp('strDosisUtilizada2Mx').clearInvalid();
        Ext.getCmp('strRespuestaClinica2Mx').allowBlank = true;
        Ext.getCmp('strRespuestaClinica2Mx').clearInvalid();
        Ext.getCmp('strRAM2Mx').allowBlank = true;
        Ext.getCmp('strRAM2Mx').clearInvalid();
        Ext.getCmp('fsMxUtilizados').setVisible(false);
        Ext.getCmp('strVentajasTerapeuticasMx').allowBlank = true;
        Ext.getCmp('strVentajasTerapeuticasMx').clearInvalid();
        Ext.getCmp('strRiesgoBeneficioMx').allowBlank = true;
        Ext.getCmp('strRiesgoBeneficioMx').clearInvalid();
        Ext.getCmp('fsMxVentajasTerapeuticas').setVisible(false);
        Ext.getCmp('fsMxRiesgoBeneficio').setVisible(false);
    }else{
        Ext.getCmp('strMedicamentoUtiliza1Mx').allowBlank = false;
        Ext.getCmp('strTiempoUso1Mx').allowBlank = false;
        Ext.getCmp('strDosisUtilizada1Mx').allowBlank = false;
        Ext.getCmp('strRespuestaClinica1Mx').allowBlank = false;
        Ext.getCmp('strRAM1Mx').allowBlank = false;
        Ext.getCmp('strMedicamentoUtiliza2Mx').allowBlank = true;
        Ext.getCmp('strTiempoUso2Mx').allowBlank = true;
        Ext.getCmp('strDosisUtilizada2Mx').allowBlank = true;
        Ext.getCmp('strRespuestaClinica2Mx').allowBlank = true;
        Ext.getCmp('strRAM2Mx').allowBlank = true;
        Ext.getCmp('fsMxUtilizados').setVisible(true);
        Ext.getCmp('strVentajasTerapeuticasMx').allowBlank = false;
        Ext.getCmp('strRiesgoBeneficioMx').allowBlank = false;
        Ext.getCmp('fsMxVentajasTerapeuticas').setVisible(true);
        Ext.getCmp('fsMxRiesgoBeneficio').setVisible(true);
    }
}

function fnGuardarRegItemMxIPS004(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var wAccion = pAccion;
    if(Ext.getCmp('sysOpcionMx').getValue() === "N"){
        wAccion = "GUARDAR_MXECO";
    }else{
        wAccion = "MODIFICAR_MXECO";
    }
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: wAccion,
                pIdConsecutivoSolicitud: Ext.getCmp('sysIdConsecutivoSolicitudMx').getValue(),
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        if (typeof pLimpiarForm !== 'undefined'){
                            if (pLimpiarForm === "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid !== 'undefined'){
                            if (pGrid !== 'NA'){
                                Ext.getCmp(pGrid).store.load({
                                    params:{
                                        pCAS: Ext.getCmp('intCASMx').getValue(),
                                        pConsecutivoHC: Ext.getCmp('sysConsecutivoHCMx').getValue(),
                                        pEmpresa: Ext.getCmp('intPrestadorMx').getValue(),
                                        pIPS: Ext.getCmp('intIPSMx').getValue(),
                                        pPaciente: Ext.getCmp('intPacienteMx').getValue(),
                                        task: "VerMxSolicitadosxHC"
                                    },
                                    callback: function(){
                                        var NET = 0;
                                        Ext.getCmp('sysTotalFormula').setValue(0);
                                        Ext.getCmp(pGrid).store.each(function(record){
                                            NET = NET + (record.get('VlrUnitario')*record.get('Cantidad'));
                                        });
                                        Ext.getCmp('sysTotalFormula').setValue(NET);
                                        if(Ext.getCmp('sysOpcionMx').getValue() === "M"){
                                            Ext.getCmp('winSolMx001Ui').close();    
                                        }
                                    }
                                });
                            }
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
