/*
* @category    Solicitud Medicamentos IPS 002
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

SolMxIPS002Ui = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    initComponent: function() {
        this.items = [
            {
                xtype: 'grid',
                title: ' ',
                id: 'gridMedicamentosHC',
                store: 'StoreGridMxSolicitadosObservaHospitalizaHC',
                anchor: "100%",
                height: 335,
                border: false,
                frame: true,
                loadMask: true,
                colModel: new Ext.ux.grid.LockingColumnModel([
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'idConsecutivoSolicitud',
                        id: 'idConsecutivoSolicitud'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción',
                        sortable: false,
                        width: 450,
                        dataIndex: 'descConcepto',
                        id: 'descConcepto'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Cantidad',
                        sortable: false,
                        width: 80,
                        dataIndex: 'Cantidad',
                        id: 'Cantidad'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Posologia',
                        sortable: false,
                        width: 330,
                        dataIndex: 'Posologia',
                        id: 'Posologia'
                    }
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
                iconCls:'icon-grid',
                //view: new Ext.grid.GroupingView(),
                /*bbar: {
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'button',
                            text: 'Importar Formulacion',
                            iconCls: 'btnImportarFormula',
                            id: 'btnImportarUltimaFormula',
                            listeners: {
                                click : function() {
                                   if (Ext.getCmp('sysYaGuardoHC').getValue() === 1 || Ext.getCmp('sysYaGuardoHC').getValue() === "1"){
                                        var cmpResumenFormulacion = new winFrmVerFormulacion({
                                        renderTo: Ext.getBody()
                                        });
                                        Ext.getCmp('winViewFormulacion').title = "PACIENTE: " + Ext.getCmp('sysPacienteHC').getValue();
                                        Ext.getCmp('gridHistorialFormulaciones').store.load({
                                            params: {
                                                pEmpresa: Ext.getCmp('sysEmpresaHC').getValue(),
                                                pPaciente: Ext.getCmp('sysIdPacienteHC').getValue()
                                            }
                                        });
                                        Ext.getCmp('CASImportarFormulacion').setValue(Ext.getCmp('sysCASHC').getValue());
                                        cmpResumenFormulacion.show();
                                    }else{
                                        Ext.Msg.show({
                                            title: 'eOfiClinic',
                                            msg: 'Usted No ha Guardado la Evolución',
                                            buttons: Ext.Msg.OK,
                                            icon: Ext.Msg.ERROR
                                        });
                                    }
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Ver Historial Farmacologico',
                            iconCls: 'btnCitasAsignadas',
                            id: 'btnVerHistorialFarmacologico',
                            listeners: {
                                click : function() {
                                    viewHistorialFarmacologico(Ext.getCmp('sysIdPacienteHC').getValue());
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        }
                    ]
                },*/
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'button',
                                text: 'Adicionar Medicamento',
                                iconCls: 'btnAddRow',
                                id: 'btnAddMxEvolucion',
                                listeners: {
                                    click : function() {
                                        if (parseInt(Ext.getCmp('sysYaGuardoHC').getValue()) === 1){
                                            if (objMXADD !== "NA"){
                                                var xSolMXADD = eval(objMXADD);
                                                Ext.getCmp('intPrestadorMx').setValue(ID_EMPRESA);
                                                Ext.getCmp('intIPSMx').setValue(ID_SEDE);
                                                Ext.getCmp('intPacienteMx').setValue(Ext.getCmp('sysIdPacienteHC').getValue());
                                                Ext.getCmp('intCASMx').setValue(Ext.getCmp('sysCASHC').getValue());
                                                Ext.getCmp('intConsecutivoHCMx').setValue(Ext.getCmp('sysConsecutivoDetalleHC').getValue());
                                                Ext.getCmp('intProfesionalMx').setValue(Ext.getCmp('sysProfesionalHC').getValue());
                                                Ext.getCmp('intUsuarioMx').setValue(ID_USUARIO);
                                                xSolMXADD.show();
                                            }
                                        }else{
                                            Ext.Msg.show({
                                                title: 'eOfiClinic',
                                                msg: 'Usted No ha Guardado la Evolución',
                                                buttons: Ext.Msg.OK,
                                                icon: Ext.Msg.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Eliminar Medicamento',
                                iconCls: 'btnDelRow',
                                id: 'btnDelMxEvolucion',
                                listeners: {
                                    click : function() {
                                        if(Ext.getCmp('gridMedicamentosHC').selModel.getCount() === 1){
                                            var selections = Ext.getCmp('gridMedicamentosHC').selModel.getSelections();
                                            Ext.Msg.show({
                                                title: 'Medicamentos',
                                                msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.descConcepto + '?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn){
                                                    if(btn ==="yes"){
                                                        fnEliminarRegistrosMxIPS002("../../controlador/asistencial/controlador_observahospitaliza.php",{task: "ELIMINAR_SOLMX", pIdMx: selections[0].json.idConsecutivoSolicitud}, 'gridMedicamentosHC');
                                                    }
                                                }
                                            });
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            }
                        ]
                    }
            }
        ];
        SolMxIPS002Ui.superclass.initComponent.call(this);
    }
});

function fnEliminarRegistrosMxIPS002(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}