/*
* @category    Formulario Adicionar Medicamentos con NO POS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winSolMxIPS004Ui = Ext.extend(Ext.Window, {
    title: '.:: Medicamentos ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winSolMx004Ui',
    initComponent: function() {
        var selMx = "0";
        var stPosologia = new StorePosologiaConceptosOfimedical();
        var dataAmbitoNOPOSMX = [
            ["AMBULATORIO"],
            ["HOSPITALIZACION"],
            ["URGENCIAS"]
        ];
        var stAmbitoNOPOSMX = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stAmbitoNOPOSMX.loadData(dataAmbitoNOPOSMX);
        
        var dataTipoServicioNOPOSMX = [
            ["MEDICAMENTO"],
            ["INSUMO"],
            ["PRODUCTO BIOLOGICO"]
        ];
        var stTipoServicioNOPOSMX = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoServicioNOPOSMX.loadData(dataTipoServicioNOPOSMX);
        var dataCaracterServicioItemNOPOSMX = [
            ['UNICO'],
            ['SUCESIVO']
        ];
        var stCaracterServicioItemNOPOSMX = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stCaracterServicioItemNOPOSMX.loadData(dataCaracterServicioItemNOPOSMX);
        
        var searchStoreMx = new Ext.data.Store({
            proxy: new Ext.data.ScriptTagProxy({
                url: '../../controlador/asistencial/controlador_oficlinic_solmxnopos.php'
            }),
            reader: new Ext.data.JsonReader({
                root: 'data',
                totalProperty: 'totalCount',
                id: 'id'
            }, [
                {name: 'Codigo'},
                {name: 'Descripcion'},
                {name: 'POS'},
                {name: 'CodigoCUM'},
                {name: 'RegistroINVIMA'},
                {name: 'PreparacionEspecial'}
            ])
        });

        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddMedicamentos',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'strTipoMx',
                                value: "M",
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPrestadorMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIPSMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPacienteMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intCASMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intConsecutivoHCMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intProfesionalMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Busqueda',
                                store: searchStoreMx,
                                displayField: 'Descripcion',
                                typeAhead: false,
                                loadingText: 'Buscando...',
                                anchor: '100%',
                                hideTrigger: true,
                                minChars: 4,
                                emptyText:'Escriba el nombre del Medicamento -- p.e: ACETA',
                                id: 'sysSearchMx',
                                onSelect: function(record){ // override default onSelect to do redirect
                                    Ext.getCmp('intConceptoOfiMedicalMx').setValue(null);
                                    Ext.getCmp('strNomConceptoOfiMedicalMx').setValue(null);
                                    Ext.getCmp('intConceptoOfiMedicalMx').setValue(record.data.Codigo);
                                    Ext.getCmp('strNomConceptoOfiMedicalMx').setValue(record.data.Descripcion);
                                    //alert(record.data.Descripcion);
                                    //alert(record.data.PreparacionEspecial);
                                    //alert(record.data.POS);
                                    if(parseInt(record.data.POS) === 0) {
                                        Ext.getCmp('fsNOPOSMX').setDisabled(false);
                                        Ext.getCmp('fsNOPOSMX').expand();
                                        Ext.getCmp('fsNOPOSMX').setVisible(true);
                                        Ext.getCmp('strEsNOPOS').setValue(1);
                                        Ext.getCmp('strAmbitoNOPOS').allowBlank = false;
                                        Ext.getCmp('memResumenDXNOPOS').allowBlank = false;
                                        Ext.getCmp('memCasoClinicoNOPOS').allowBlank = false;
                                        Ext.getCmp('memTratamientosRealizadosNOPOS').allowBlank = false;
                                        Ext.getCmp('strTipoServicioItemNOPOS').allowBlank = false;
                                        Ext.getCmp('strCaracterItemNOPOS').allowBlank = false;
                                        Ext.getCmp('strCaracterCantidadItemNOPOS').allowBlank = false;
                                        Ext.getCmp('strCaracterDiasItemNOPOS').allowBlank = false;
                                        Ext.getCmp('strHomologoItemNOPOS').allowBlank = false;
                                        Ext.getCmp('strHomologoSustitutoItemNOPOS').allowBlank = false;
                                        Ext.getCmp('memJustificacionItemNOPOS').allowBlank = false;
                                        Ext.getCmp('sysCUMItemNOPOS').allowBlank = true;
                                        Ext.getCmp('sysINVIMAItemNOPOS').allowBlank = true;
                                        Ext.getCmp('sysCUMItemNOPOS').setValue(PonerAcentosMayusculas(record.data.CodigoCUM));
                                        Ext.getCmp('sysINVIMAItemNOPOS').setValue(PonerAcentosMayusculas(record.data.RegistroINVIMA));
                                        Ext.getCmp('memJustificacionItemNOPOS').setValue(PonerAcentosMayusculas(record.data.PreparacionEspecial));
                                        Ext.getCmp('strAmbitoNOPOS').setValue("AMBULATORIO");
                                        Ext.getCmp('strTipoServicioItemNOPOS').setValue("MEDICAMENTO");
                                        Ext.Ajax.request({ //Cargar datos de ultima formulacion de este medicamento
                                            url: '../../controlador/asistencial/controlador_cvm.php',
                                            params:{
                                                task: 'BUSCAR_ITEM_NOPOS_SOLICITADO',
                                                pPaciente: Ext.getCmp('intPacienteMx').getValue(),
                                                pConcepto: record.data.Codigo
                                            },
                                            success: function(response,options)
                                            {
                                                var el = Ext.get('response'); // get the LOG
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                    //Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                } else {
                                                    Ext.getCmp('strAmbitoNOPOS').setValue(Contenido[1]);
                                                    Ext.getCmp('memResumenDXNOPOS').setValue(Contenido[12]);
                                                    Ext.getCmp('memCasoClinicoNOPOS').setValue(Contenido[2]);
                                                    Ext.getCmp('memTratamientosRealizadosNOPOS').setValue(Contenido[3]);
                                                    Ext.getCmp('strTipoServicioItemNOPOS').setValue(Contenido[0]);
                                                    Ext.getCmp('strCaracterItemNOPOS').setValue(Contenido[4]);
                                                    Ext.getCmp('strCaracterCantidadItemNOPOS').setValue(Contenido[5]);
                                                    Ext.getCmp('strCaracterDiasItemNOPOS').setValue(Contenido[6]);
                                                    Ext.getCmp('strHomologoItemNOPOS').setValue(Contenido[7]);
                                                    Ext.getCmp('strHomologoSustitutoItemNOPOS').setValue(Contenido[8]);
                                                    Ext.getCmp('memJustificacionItemNOPOS').setValue(Contenido[9]);
                                                    Ext.getCmp('intCantidadMx').setValue(Contenido[10]);
                                                    Ext.getCmp('strPosologiaMx').setValue(Contenido[11]);
                                                }
                                            },
                                            scope: this 
                                        });
                                    }else{
                                        Ext.getCmp('fsNOPOSMX').setVisible(false);
                                        Ext.getCmp('strEsNOPOS').setValue(0);
                                        Ext.getCmp('strAmbitoNOPOS').setValue(null);
                                        Ext.getCmp('memResumenDXNOPOS').setValue(null);
                                        Ext.getCmp('memCasoClinicoNOPOS').setValue(null);
                                        Ext.getCmp('memTratamientosRealizadosNOPOS').setValue(null);
                                        Ext.getCmp('strTipoServicioItemNOPOS').setValue(null);
                                        Ext.getCmp('strCaracterItemNOPOS').setValue(null);
                                        Ext.getCmp('strCaracterCantidadItemNOPOS').setValue(null);
                                        Ext.getCmp('strCaracterDiasItemNOPOS').setValue(null);
                                        Ext.getCmp('strHomologoItemNOPOS').setValue(null);
                                        Ext.getCmp('strHomologoSustitutoItemNOPOS').setValue(null);
                                        Ext.getCmp('memJustificacionItemNOPOS').setValue(null);
                                        Ext.getCmp('sysCUMItemNOPOS').setValue(null);
                                        Ext.getCmp('sysINVIMAItemNOPOS').setValue(null);
                                        Ext.getCmp('strAmbitoNOPOS').allowBlank = true;
                                        Ext.getCmp('memResumenDXNOPOS').allowBlank = true;
                                        Ext.getCmp('memCasoClinicoNOPOS').allowBlank = true;
                                        Ext.getCmp('memTratamientosRealizadosNOPOS').allowBlank = true;
                                        Ext.getCmp('strTipoServicioItemNOPOS').allowBlank = true;
                                        Ext.getCmp('strCaracterItemNOPOS').allowBlank = true;
                                        Ext.getCmp('strCaracterCantidadItemNOPOS').allowBlank = true;
                                        Ext.getCmp('strCaracterDiasItemNOPOS').allowBlank = true;
                                        Ext.getCmp('strHomologoItemNOPOS').allowBlank = true;
                                        Ext.getCmp('strHomologoSustitutoItemNOPOS').allowBlank = true;
                                        Ext.getCmp('memJustificacionItemNOPOS').allowBlank = true;
                                        Ext.getCmp('sysCUMItemNOPOS').allowBlank = true;
                                        Ext.getCmp('sysINVIMAItemNOPOS').allowBlank = true;
                                    }
                                    Ext.getCmp('sysSearchMx').clearValue();
                                    Ext.getCmp('sysSearchMx').collapse();
                                    stPosologia.removeAll();
                                    stPosologia.load({
                                        params: {
                                            task: 'BUSCAR_POSOLOGIA_OFICLINIC',
                                            pConceptoOfimedical: Ext.getCmp('intConceptoOfiMedicalMx').getValue()
                                        }
                                    });
                                    Ext.getCmp('strPosologiaMx').setValue(null);
                                    Ext.getCmp('intCantidadMx').setValue(null);
                                }
                            },
                            {
                                html: '<hr>'
                            },        
                            {
                                xtype: 'hidden',
                                id: 'intConceptoOfiMedicalMx'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Medicamento',
                                anchor: '100%',
                                readOnly: true,
                                allowBlank: false,
                                id: 'strNomConceptoOfiMedicalMx'
                            },
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'Cantidad',
                                id: 'intCantidadMx',
                                width: 80,
                                allowBlank: false,
                                minValue: 1,
                                maxValue: 360,
                                value: 1
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Posología',
                                anchor: '100%',
                                allowBlank: false,
                                store: stPosologia,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: false,
                                id: 'strPosologiaMx'
                            },
                            {
                                xtype: 'fieldset',
                                title: 'NO POS',
                                anchor: '100%',
                                autoHeight: true,
                                forceLayout: true,
                                collapsed: true,
                                collapsible: true,
                                id: 'fsNOPOSMX',
                                items:[
                                    {   
                                        xtype: 'hidden',
                                        value: 0,
                                        id: 'strEsNOPOS'
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Ambito',
                                        anchor: '100%',
                                        allowBlank: false,
                                        store: stAmbitoNOPOSMX,
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        value: 'AMBULATORIO',
                                        id: 'strAmbitoNOPOS'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        anchor: '100%',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                fieldLabel: 'CUM',
                                                width: 200,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysCUMItemNOPOS'
                                            },
                                            {
                                                html: 'Registro INVIMA:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 200,
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'sysINVIMAItemNOPOS'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textarea',
                                        allowBlank: true,
                                        anchor: '100%',
                                        style: 'text-transform:uppercase;',
                                        fieldLabel: 'Resumen DX',
                                        id: 'memResumenDXNOPOS'
                                    },
                                    {
                                        xtype: 'textarea',
                                        allowBlank: false,
                                        anchor: '100%',
                                        style: 'text-transform:uppercase;',
                                        fieldLabel: 'Caso Clinico',
                                        id: 'memCasoClinicoNOPOS'
                                    },
                                    {
                                        xtype: 'textarea',
                                        allowBlank: true,
                                        anchor: '100%',
                                        style: 'text-transform:uppercase;',
                                        fieldLabel: 'Tratamientos Realizados',
                                        id: 'memTratamientosRealizadosNOPOS'
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Tipo Servicio',
                                        name: 'Tipo Servicio',
                                        anchor: '100%',
                                        allowBlank: false,
                                        store: stTipoServicioNOPOSMX,
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        value: 'MEDICAMENTO',
                                        id: 'strTipoServicioItemNOPOS'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        anchor: '100%',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Uso',
                                                name: 'Uso',
                                                width: 100,
                                                allowBlank: false,
                                                store: stCaracterServicioItemNOPOSMX,
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                id: 'strCaracterItemNOPOS',
                                                listeners:{
                                                    select : function(cmb, rec, idx){
                                                        if(cmb.getValue() === "SUCESIVO"){
                                                            Ext.getCmp('strCaracterCantidadItemNOPOS').setReadOnly(false);
                                                            Ext.getCmp('strCaracterDiasItemNOPOS').setReadOnly(false);
                                                            Ext.getCmp('strCaracterCantidadItemNOPOS').setValue(Ext.getCmp('intCantidadMx').getValue());
                                                            Ext.getCmp('strCaracterCantidadItemNOPOS').allowBlank = false;
                                                            Ext.getCmp('strCaracterDiasItemNOPOS').allowBlank = false;
                                                        }else{
                                                            Ext.getCmp('strCaracterCantidadItemNOPOS').clearInvalid();
                                                            Ext.getCmp('strCaracterDiasItemNOPOS').clearInvalid();
                                                            Ext.getCmp('strCaracterCantidadItemNOPOS').setReadOnly(true);
                                                            Ext.getCmp('strCaracterDiasItemNOPOS').setReadOnly(true);
                                                            Ext.getCmp('strCaracterCantidadItemNOPOS').setValue(1);
                                                            Ext.getCmp('strCaracterDiasItemNOPOS').setValue(null);
                                                            Ext.getCmp('strCaracterCantidadItemNOPOS').allowBlank = true;
                                                            Ext.getCmp('strCaracterDiasItemNOPOS').allowBlank = true;
                                                        }
                                                    }
                                                }
                                            },
                                            {
                                                html: 'Cantidad:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 80,
                                                name: 'Cantidad',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'strCaracterCantidadItemNOPOS'
                                            },
                                            {
                                                html: 'Dias:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 350,
                                                name: 'Dias',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'strCaracterDiasItemNOPOS'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        anchor: '100%',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Homologo',
                                                name: 'Homologo',
                                                width: 70,
                                                allowBlank: false,
                                                store: 'StoreSiNo',
                                                forceSelection: true,
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione....',
                                                submitValue: true,
                                                id: 'strHomologoItemNOPOS',
                                                listeners:{
                                                    select : function(cmb, rec, idx){
                                                        if(cmb.getValue() === "SI"){
                                                            Ext.getCmp('strHomologoSustitutoItemNOPOS').setReadOnly(false);
                                                            Ext.getCmp('strHomologoSustitutoItemNOPOS').allowBlank = false;
                                                        }else{
                                                            Ext.getCmp('strHomologoSustitutoItemNOPOS').clearInvalid();
                                                            Ext.getCmp('strHomologoSustitutoItemNOPOS').setReadOnly(true);
                                                            Ext.getCmp('strHomologoSustitutoItemNOPOS').setValue(null);
                                                            Ext.getCmp('strHomologoSustitutoItemNOPOS').allowBlank = true;
                                                        }
                                                    }
                                                }
                                            },
                                            {
                                                html: 'Sustituto:'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 570,
                                                name: 'Sustituto',
                                                allowBlank: true,
                                                readOnly: true,
                                                id: 'strHomologoSustitutoItemNOPOS'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'textarea',
                                        fieldLabel: 'Justificacion',
                                        name: 'Justificacion',
                                        //height: 35,
                                        anchor: '100%',
                                        grow: true,
                                        growMin: 35,
                                        growMax: 400,
                                        allowBlank: true,
                                        id: 'memJustificacionItemNOPOS'
                                    }
                                ]
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddMx',
                            listeners:{
                                click : function(){
                                    fnGuardarRegItemMxIPS004("GUARDAR_OFICLINIC_NOPOS","SI","winSolMxIPS004Ui","frmAddMedicamentos","../../controlador/solmx/controlador_solmx.php","gridMedicamentosHC");
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                //Ext.getCmp('fsNOPOSMX').setVisible(false);
                Ext.getCmp('fsNOPOSMX').setDisabled(true);
                Ext.getCmp('strEsNOPOS').setValue(0);
                Ext.getCmp('strAmbitoNOPOS').setValue(null);
                Ext.getCmp('memResumenDXNOPOS').setValue(null);
                Ext.getCmp('memCasoClinicoNOPOS').setValue(null);
                Ext.getCmp('memTratamientosRealizadosNOPOS').setValue(null);
                Ext.getCmp('strTipoServicioItemNOPOS').setValue(null);
                Ext.getCmp('strCaracterItemNOPOS').setValue(null);
                Ext.getCmp('strCaracterCantidadItemNOPOS').setValue(null);
                Ext.getCmp('strCaracterDiasItemNOPOS').setValue(null);
                Ext.getCmp('strHomologoItemNOPOS').setValue(null);
                Ext.getCmp('strHomologoSustitutoItemNOPOS').setValue(null);
                Ext.getCmp('memJustificacionItemNOPOS').setValue(null);
                Ext.getCmp('sysCUMItemNOPOS').setValue(null);
                Ext.getCmp('sysINVIMAItemNOPOS').setValue(null);
                Ext.getCmp('strAmbitoNOPOS').allowBlank = true;
                Ext.getCmp('memResumenDXNOPOS').allowBlank = true;
                Ext.getCmp('memCasoClinicoNOPOS').allowBlank = true;
                Ext.getCmp('memTratamientosRealizadosNOPOS').allowBlank = true;
                Ext.getCmp('strTipoServicioItemNOPOS').allowBlank = true;
                Ext.getCmp('strCaracterItemNOPOS').allowBlank = true;
                Ext.getCmp('strCaracterCantidadItemNOPOS').allowBlank = true;
                Ext.getCmp('strCaracterDiasItemNOPOS').allowBlank = true;
                Ext.getCmp('strHomologoItemNOPOS').allowBlank = true;
                Ext.getCmp('strHomologoSustitutoItemNOPOS').allowBlank = true;
                Ext.getCmp('memJustificacionItemNOPOS').allowBlank = true;
                Ext.getCmp('sysCUMItemNOPOS').allowBlank = true;
                Ext.getCmp('sysINVIMAItemNOPOS').allowBlank = true;
            }}
        });
        winSolMxIPS004Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegItemMxIPS004(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        if (typeof pLimpiarForm !== 'undefined'){
                            if (pLimpiarForm === "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid !== 'undefined'){
                            if (pGrid !== 'NA'){
                                Ext.getCmp(pGrid).store.load({
                                    params:{
                                        pCAS: Ext.getCmp('intCASMx').getValue(),
                                        pConsecutivoHC: Ext.getCmp('intConsecutivoHCMx').getValue(),
                                        pEmpresa: Ext.getCmp('intPrestadorMx').getValue(),
                                        pIPS: Ext.getCmp('intIPSMx').getValue(),
                                        pPaciente: Ext.getCmp('intPacienteMx').getValue(),
                                        task: "VerMxSolicitadosxHC"
                                    }
                                });
                            }
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
