/*
* @category    Formulario Adicionar Medicamentos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winSolMxIPS201801Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Medicamentos ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winSolMx002Ui',
    initComponent: function() {
        var selMx = "0";
        var stPosologia = new StorePosologiaConceptosOfimedical();
               
        var searchStoreMx = new Ext.data.Store({
            proxy: new Ext.data.ScriptTagProxy({
                url: '../../controlador/asistencial/controlador_oficlinic_solmx_medicare.php'
            }),
            reader: new Ext.data.JsonReader({
                root: 'data',
                totalProperty: 'totalCount',
                id: 'id'
            }, [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ])
        });

        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddMedicamentos',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'sysYaGuardoMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'strTipoMx',
                                value: "M",
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPrestadorMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIPSMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPacienteMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intCASMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intProfesionalMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioMx',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Busqueda',
                                store: searchStoreMx,
                                displayField: 'Descripcion',
                                typeAhead: false,
                                loadingText: 'Buscando...',
                                anchor: '100%',
                                hideTrigger: true,
                                minChars: 4,
                                emptyText:'Escriba el nombre del Medicamento -- p.e: ACETA',
                                id: 'sysSearchMx',
                                onSelect: function(record){ // override default onSelect to do redirect
                                    Ext.getCmp('intConceptoOfiMedicalMx').setValue(null);
                                    Ext.getCmp('strNomConceptoOfiMedicalMx').setValue(null);
                                    Ext.getCmp('intConceptoOfiMedicalMx').setValue(record.data.Codigo);
                                    Ext.getCmp('strNomConceptoOfiMedicalMx').setValue(record.data.Descripcion);
                                    Ext.getCmp('sysSearchMx').clearValue();
                                    Ext.getCmp('sysSearchMx').collapse();
                                    stPosologia.removeAll();
                                    stPosologia.load({
                                        params: {
                                            task: 'BUSCAR_POSOLOGIA_OFICLINIC',
                                            pConceptoOfimedical: Ext.getCmp('intConceptoOfiMedicalMx').getValue()
                                        }
                                    });
                                    Ext.getCmp('strPosologiaMx').setValue(null);
                                    Ext.getCmp('intCantidadMx').setValue(null);
                                }
                            },
                            {
                                html: '<hr>'
                            },        
                            {
                                xtype: 'hidden',
                                id: 'intConceptoOfiMedicalMx'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Medicamento',
                                anchor: '100%',
                                readOnly: true,
                                allowBlank: false,
                                id: 'strNomConceptoOfiMedicalMx'
                            },
                            
                            {
                                xtype: 'numberfield',
                                fieldLabel: 'Cantidad',
                                id: 'intCantidadMx',
                                width: 80,
                                allowBlank: false,
                                minValue: 1,
                                maxValue: 360,
                                value: 1
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Posología',
                                anchor: '100%',
                                allowBlank: false,
                                store: stPosologia,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: false,
                                id: 'strPosologiaMx'
                            },
                            {
                                xtype: 'hidden',
                                id: 'strSelectConceptoMx',
                                allowBlank: true
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddMx',
                            listeners:{
                                click : function(){
                                    if(parseInt(Ext.getCmp('sysYaGuardoMx').getValue())===0){
                                        Ext.getCmp('sysYaGuardoMx').setValue(1);
                                        fnGuardarRegItemMxIPS201801("GUARDAR_OFICLINIC","SI","winSolMxIPS001Ui","frmAddMedicamentos","../../controlador/solmx/controlador_solmx.php","gridMedicamentosHC");
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    searchStoreMx.setBaseParam('pCAS', Ext.getCmp('intCASMx').getValue());
                }
            }
        });
        winSolMxIPS201801Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegItemMxIPS201801(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid()){
        Ext.getCmp('strSelectConceptoMx').setValue(parseInt(Ext.getCmp('intConceptoOfiMedicalMx').getValue()));
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        if (typeof pLimpiarForm != 'undefined'){
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined'){
                            if (pGrid != 'NA'){
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        /*if (typeof pCampoLlave != 'undefined'){
                            if (pCampoLlave != 'NA'){
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarDatosBasicosTarjeta').setVisible(false);
                                Ext.getCmp('btnModificarDatosBasicosTarjeta').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }*/
                        Ext.getCmp('sysYaGuardoMx').setValue(0);
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        Ext.getCmp('sysYaGuardoMx').setValue(0);
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
                Ext.getCmp('sysYaGuardoMx').setValue(0);
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
