/*
* @category    Solicitud Medicamentos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

SolNOPOSRegPac001Ui = Ext.extend(Ext.Panel, {
    anchor: '100%',
    //autoHeight: true,
    height: 500,
    initComponent: function() {
        function renderSolicitudRegPacNOPOS(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return '<span style="color: blue;">' + value + '</span></br>Fecha:' + record.get('FecSolicitud') + '</br>Profesional:' + record.get('nomProfesional');
        }
        
        this.items = [
            {
                xtype: 'container',
                width: 982,
                height: 490,
                layout: 'border',
                items: [
                    {
                        xtype: 'panel',
                        region: 'center',
                        anchor: '100%',
                        height: 480,
                        border: true,
                        autoLoad:{
                            url:'../../../app/controlador/nopos/viewsolicitudnopos001.php?pPaciente=' + wPaciente + '&pSolicitud=0',
                            scripts: true,
                            scope: this
                        },
                        autoScroll: true,
                        closable: false,
                        id: 'DetalleNOPOSxRegPaciente',
                        tbar:{
                            xtype: 'toolbar',
                            items: [
                                '->',
                                {
                                    xtype: 'button',
                                    text: 'Imprimir',
                                    iconCls: 'btnImprimir',
                                    id: 'btnProntItemGridRegPaciente',
                                    listeners: {
                                        click: function(){
                                            if(Ext.getCmp('gridSolicitudesNOPOSxRegPaciente').selModel.getCount() === 1){
                                                var selections = Ext.getCmp('gridSolicitudesNOPOSxRegPaciente').selModel.getSelections();
                                                window.open ("../../controlador/nopos/printnopos.php?pPaciente=" + selections[0].json.Paciente + "&pSolicitud=" + selections[0].json.idConsecutivoSolicitud,"SOLICITUD");
                                            }
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                }
                            ]
                        }
                    },
                    {
                        xtype: 'grid',
                        id: 'gridSolicitudesNOPOSxRegPaciente',
                        region: 'west',
                        frame: true,
                        loadMask: true,
                        flex: 1,
                        width: 370,
                        height: 480,
                        store: 'StoreGridSolicitudNOPOS',
                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                        listeners:{
                            rowclick : function(grid, fila, e){
                                var selections = grid.selModel.getSelections();
                                var updater = Ext.getCmp('DetalleNOPOSxRegPaciente').getUpdater();
                                url:'../../../app/controlador/nopos/viewsolicitudnopos001.php?pPaciente=' + wPaciente + '&pSolicitud=0',
                                updater.setDefaultUrl('../../../app/controlador/nopos/viewsolicitudnopos001.php?pPaciente=' + wPaciente + '&pSolicitud=' + selections[0].json.idConsecutivoSolicitud);
                                updater.refresh();
                            }
                        },
                        columns: [
                            {
                                header: 'Solicitud',
                                readOnly: true,
                                sortable: true,
                                dataIndex: 'Descripcion',
                                renderer: renderSolicitudRegPacNOPOS,
                                width: 270
                            }
                        ],
                        viewConfig: {
                            forceFit:true
                        },
                        columnLines: true
                    }
                ]
            }
        ];
        SolNOPOSRegPac001Ui.superclass.initComponent.call(this);
    }
});
