/*
* @category    Formulario Adicionar Registro - NO POS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winRegistroItemNOPOSUi = Ext.extend(Ext.Window, {
    title: '.:: Servicio NO POS ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winRegistroItemNOPOSUi',
    initComponent: function() {
        Ext.QuickTips.init();
        Ext.form.Field.prototype.msgTarget = 'side';
        
        var dataTipoServicioItemNOPOS = [
            ['PROCEDIMIENTO'],
            ['INTERVENCION'],
            ['INSUMO'],
            ['PRODUCTO BIOLOGICO'],
            ['DISPOSITIVO BIOMEDICO'],
            ['MEDICAMENTO']
        ];
        var stTipoServicioItemNOPOS = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoServicioItemNOPOS.loadData(dataTipoServicioItemNOPOS);
        
        var dataCaracterServicioItemNOPOS = [
            ['UNICO'],
            ['SUCESIVO']
        ];
        var stCaracterServicioItemNOPOS = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stCaracterServicioItemNOPOS.loadData(dataCaracterServicioItemNOPOS);
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmRegistroItemNOPOS',
                padding: 10,
                labelWidth: 200,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'IdItemNOPOS',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'compositefield',
                                anchor: '100%',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Tipo Servicio',
                                        name: 'Tipo Servicio',
                                        width: 150,
                                        allowBlank: false,
                                        store: stTipoServicioItemNOPOS,
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        id: 'strTipoServicioItemNOPOS'
                                    },
                                    {
                                        html: 'Descripcion:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 120,
                                        name: 'Descripcion',
                                        allowBlank: false,
                                        id: 'strDescripcionItemNOPOS'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                anchor: '100%',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Caracter',
                                        name: 'Caracter',
                                        width: 150,
                                        allowBlank: false,
                                        store: stCaracterServicioItemNOPOS,
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        id: 'strCaracterItemNOPOS'
                                    },
                                    {
                                        html: 'Cantidad:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 120,
                                        name: 'Cantidad',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'strCaracterCantidadItemNOPOS'
                                    },
                                    {
                                        html: 'Dias:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 120,
                                        name: 'Dias',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'strCaracterDiasItemNOPOS'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                anchor: '100%',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Homologo',
                                        name: 'Homologo',
                                        width: 150,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        forceSelection: true,
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione....',
                                        submitValue: true,
                                        id: 'strHomologoItemNOPOS'
                                    },
                                    {
                                        html: 'Sustituto:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 120,
                                        name: 'Sustituto',
                                        allowBlank: true,
                                        readOnly: true,
                                        id: 'strHomologoSustitutoItemNOPOS'
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                fieldLabel: 'Justificacion',
                                name: 'Justificacion',
                                height: 35,
                                anchor: '99%',
                                grow: true,
                                growMin: 35,
                                growMax: 400,
                                allowBlank: true,
                                id: 'memJustificacionItemNOPOS'
                            },
                            {
                                xtype: 'textarea',
                                fieldLabel: 'Evidencia',
                                name: 'Evidencia',
                                height: 35,
                                anchor: '99%',
                                grow: true,
                                growMin: 35,
                                growMax: 400,
                                allowBlank: true,
                                id: 'memEvidenciaItemNOPOS'
                            },
                            {
                                xtype: 'textarea',
                                fieldLabel: 'Casuistica',
                                name: 'Casuistica',
                                height: 35,
                                anchor: '99%',
                                grow: true,
                                growMin: 35,
                                growMax: 400,
                                allowBlank: true,
                                id: 'memCasuisticaItemNOPOS'
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddItemNOPOS',
                            listeners:{
                                click : function(){
                                    Ext.Msg.show({
                                        title: 'Guardar Tipo Servicio NO POS',
                                        msg: 'Esta Seguro que Desea Guardar la Información?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn)
                                        {
                                            if(btn=="yes")
                                            {
                                                fnGuardarRegItemNOPOS("GUARDAR_ITEM_NOPOS","SI","winRegistroItemNOPOSUi","frmRegistroItemNOPOS","../../controlador/asistencial/controlador_nopos.php","gridDientesActividadesRealizadas");
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winRegistroItemNOPOSUi.superclass.initComponent.call(this);
    }
});

function fnGuardarRegItemNOPOS(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        /*if (typeof pGrid != 'undefined'){
                            if (pGrid != 'NA'){
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }*/
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            
                        }
                        if(pCerrar == "SI"){
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
