/*
* @category    Formulario Adicionar Solicitud NO POS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winSolNOPOS001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Solicitud NO POS - CTC ::.',
    width: 980,
    height: 610,
    modal: true,
    closable: false,
    autoScroll: true,
    padding: 10,
    id: 'winSolNOPOS001Ui',
    initComponent: function() {
        var selNOPOS = "0";
        
        var dataAmbitoNOPOS = [
            ["AMBULATORIO"],
            ["HOSPITALIZACION"],
            ["URGENCIAS"]
        ];
        var stAmbitoNOPOS = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stAmbitoNOPOS.loadData(dataAmbitoNOPOS);
        
        var stDetalleSolicitudNOPOS = new StoreGridItemsSolicitudNOPOS();
        
        this.tbar = [
            {
                xtype: 'toolbar',
                anchor: '100%',
                items: [
                    '->',
                    {
                        xtype: 'tbseparator'
                    },
                    {
                        xtype: 'button',
                        text: 'Guardar Solicitud',
                        iconCls: 'btnGuardar',
                        listeners:{
                            click : function(){
                                if (parseInt(Ext.getCmp('sysYaGuardoNOPOS').getValue()) === 0) {
                                    Ext.Msg.show({
                                        title: 'eOfiClinic',
                                        msg: 'Esta seguro que desea Guardar la solicitud?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn)
                                        {
                                            if(btn === "yes"){
                                                fnGuardarRegistrosSolNOPOS();
                                            }
                                        }
                                    });
                                }else{
                                    Ext.Msg.show({
                                        title: 'eOfiClinic',
                                        msg: 'Esta seguro que desea Modificar la solicitud?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn)
                                        {
                                            if(btn === "yes"){
                                                fnModificarRegistrosSolNOPOS();
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    },
                    {
                        xtype: 'tbseparator'
                    }
                ]
            }
        ],
        this.bbar = [
            {
                xtype: 'toolbar',
                anchor: '100%',
                items: [
                    '->',
                    {
                        xtype: 'tbseparator'
                    },
                    {
                        xtype: 'button',
                        text: 'Salir',
                        iconCls: 'btnSalir',
                        listeners:{
                            click : function(){
                                Ext.getCmp('winSolNOPOS001Ui').close();
                            }
                        }
                    },
                    {
                        xtype: 'tbseparator'
                    }
                ]
            }
        ],
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddSolictudNOPOS',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                value: 0,
                                id: 'sysIdSolicitudNOPOS'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                value: 0,
                                id: 'sysYaGuardoNOPOS'
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPrestadorNOPOS',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIPSNOPOS',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intCASNOPOS',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intProfesionalNOPOS',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioNOPOS',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPacienteNOPOS',
                                value: 0
                            },
                            {
                                xtype: 'compositefield',
                                anchor: '100%',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 754,
                                        fieldLabel: 'Paciente',
                                        readOnly: true,
                                        allowBlank: true,
                                        emptyText: 'Debe Buscar Paciente....',
                                        id: 'sysPacienteNOPOS'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Paciente',
                                        id: 'btnBuscarPacienteNOPOS'
                                    },
                                    {
                                        xtype: 'button',
                                        tooltip: 'Limpiar Datos del Paciente',
                                        iconCls: 'btnLimpiar',
                                        id: 'btnLimpiarPacienteNOPOS'
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Entidad',
                                anchor: '100%',
                                allowBlank: false,
                                store: 'StoreCliente',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'intClienteNOPOS'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Ambito',
                                anchor: '100%',
                                allowBlank: false,
                                store: stAmbitoNOPOS,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'strAmbitoNOPOS'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: 'Descripcion',
                                        width: 450,
                                        allowBlank: false,
                                        style: 'text-transform:uppercase;',
                                        id: 'strDescripcionNOPOS'
                                    },
                                    {
                                        html: 'Fecha Solicitud'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 130,
                                        allowBlank: false,
                                        disabledDates: '',
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecFechaSolicitudNOPOS'
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                allowBlank: false,
                                anchor: '100%',
                                style: 'text-transform:uppercase;',
                                fieldLabel: 'Resumen DX',
                                id: 'memResumenDXNOPOS'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Codigo DX',
                                width: 100,
                                allowBlank: false,
                                id: 'strDiagnosticoNOPOS'
                            },
                            {
                                xtype: 'textarea',
                                allowBlank: false,
                                anchor: '100%',
                                style: 'text-transform:uppercase;',
                                fieldLabel: 'Caso Clinico',
                                id: 'memCasoClinicoNOPOS'
                            },
                            {
                                xtype: 'textarea',
                                allowBlank: true,
                                anchor: '100%',
                                style: 'text-transform:uppercase;',
                                fieldLabel: 'Tratamientos Realizados',
                                id: 'memTratamientosRealizadosNOPOS'
                            },
                            {
                                xtype: 'textarea',
                                allowBlank: true,
                                anchor: '100%',
                                style: 'text-transform:uppercase;',
                                fieldLabel: 'Ayudas Diagnosticas',
                                id: 'memAyudasDxNOPOS'
                            },
                            {
                                xtype: 'textarea',
                                allowBlank: true,
                                anchor: '100%',
                                style: 'text-transform:uppercase;',
                                fieldLabel: 'Otros',
                                id: 'memOtrosNOPOS'
                            }
                        ]
                    },
                    {
                        xtype: 'grid',
                        title: '<center>DETALLE SERVICIOS SOLICITADOS</center>',
                        id: 'gridDetalleSolicitudNOPOS',
                        layout: 'fit',
                        frame: true,
                        loadMask: true,
                        flex: 1,
                        height: 315,
                        store: stDetalleSolicitudNOPOS,
                        tbar:{
                            xtype: 'toolbar',
                            items: [
                                {
                                    xtype: 'button',
                                    text: 'Adicionar',
                                    iconCls: 'btnAddRow',
                                    listeners: {
                                        click: function(){
                                            if(parseInt(Ext.getCmp('sysYaGuardoNOPOS').getValue()) === 1){
                                                var winRegistroItemNOPOS = new winRegistroItemNOPOSUi();
                                                Ext.getCmp('intIdItemNOPOS').setValue(Ext.getCmp('sysIdSolicitudNOPOS').getValue());
                                                winRegistroItemNOPOS.show();
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Adicionar Item',
                                                    msg: 'Debe guardar primero la solicitud.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        }
                                        
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Eliminar',
                                    iconCls: 'btnDelRow',
                                    listeners: {
                                        click: function(){
                                            if(Ext.getCmp('gridDetalleSolicitudNOPOS').selModel.getCount() === 1){
                                                var selections = Ext.getCmp('gridDetalleSolicitudNOPOS').selModel.getSelections();
                                                Ext.Msg.show({
                                                    title: 'Servicios NO POS',
                                                    msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.TipoServicio + ' - ' + selections[0].json.Descripcion + '?',
                                                    buttons: Ext.Msg.YESNO,
                                                    icon: Ext.Msg.QUESTION,
                                                    fn: function(btn){
                                                        if(btn === "yes"){
                                                            fnEliminarRegistrosItemsSolNOPOS("../../controlador/nopos/controlador_nopos.php",{task: "ELIMINAR_ITEM_NOPOS", pIdServicioNOPOS: selections[0].json.IdRegistroDetalle}, 'gridDetalleSolicitudNOPOS')
                                                        }
                                                    }
                                                });
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Error',
                                                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        }
                                    }
                                }
                            ]
                        },
                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                        columns: [
                            {
                                header: 'Tipo',
                                readOnly: true,
                                sortable: false,
                                dataIndex: 'TipoServicio',
                                width: 120
                            },
                            {
                                header: 'Descripcion',
                                readOnly: true,
                                sortable: false,
                                dataIndex: 'Descripcion',
                                width: 270
                            },
                            {
                                header: 'Uso',
                                readOnly: true,
                                sortable: false,
                                dataIndex: 'Caracter',
                                width: 120
                            },
                            {
                                header: 'Cantidad',
                                readOnly: true,
                                sortable: false,
                                dataIndex: 'CaracterCantidad',
                                width: 120
                            },
                            {
                                header: 'Dias',
                                readOnly: true,
                                sortable: false,
                                dataIndex: 'CaracterDias',
                                width: 120
                            }
                        ],
                        viewConfig: {
                            forceFit:true
                        },
                        columnLines: true
                    }
                ]
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                Ext.getCmp('gridDetalleSolicitudNOPOS').store.load({
                    params:{
                        pIdSolicitud: Ext.getCmp('sysIdSolicitudNOPOS').getValue()
                    }
                });
            }}
        }); 
        winSolNOPOS001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosSolNOPOS(){
    var frm = Ext.getCmp('frmAddSolictudNOPOS').getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: '../../controlador/nopos/controlador_nopos.php',
            params:{
                task: 'guardar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('intPrestadorNOPOS').getValue(),
                pIPS: Ext.getCmp('intIPSNOPOS').getValue(),
                pPaciente: Ext.getCmp('intPacienteNOPOS').getValue(),
                pProfesional: Ext.getCmp('intProfesionalNOPOS').getValue(),
                pUsuario: Ext.getCmp('intUsuarioNOPOS').getValue(),
                pCAS: Ext.getCmp('intCASNOPOS').getValue()
            },
            success: function(res,req){
                if(parseInt(req.result.requestedId)>0){
                    Ext.MessageBox.show({
                        title: 'Guardar',
                        msg: 'Se Guardo la Información con Exito.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.INFO
                    });
                    Ext.getCmp('sysYaGuardoNOPOS').setValue(1); 
                    Ext.getCmp('sysIdSolicitudNOPOS').setValue(parseInt(req.result.requestedId)); 
                    Ext.getCmp('gridDetalleSolicitudNOPOS').store.load({
                        params: {
                            pIdSolicitud: req.result.requestedId
                        }
                    });
                    Ext.getCmp('gridSolicitudesNOPOSxPaciente').store.load({
                        params: {
                            task: 'LISTAR_NOPOS',
                            pPaciente: Ext.getCmp('intPacienteNOPOS').getValue()
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Guardar',
                        msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    Ext.getCmp('sysYaGuardoNOPOS').setValue(0); 
                    Ext.getCmp('sysIdSolicitudNOPOS').setValue(0); 
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnModificarRegistrosSolNOPOS(){
    var frm = Ext.getCmp('frmAddSolictudNOPOS').getForm();
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: '../../controlador/nopos/controlador_nopos.php',
            params:{
                task: 'modificar',
                CAMPOS: listacampos,
                pEmpresa: Ext.getCmp('intPrestadorNOPOS').getValue(),
                pIPS: Ext.getCmp('intIPSNOPOS').getValue(),
                pPaciente: Ext.getCmp('intPacienteNOPOS').getValue(),
                pProfesional: Ext.getCmp('intProfesionalNOPOS').getValue(),
                pUsuario: Ext.getCmp('intUsuarioNOPOS').getValue(),
                pCAS: Ext.getCmp('intCASNOPOS').getValue(),
                pIdSolicitud: Ext.getCmp('sysIdSolicitudNOPOS').getValue()
            },
            success: function(res,req)
            {
                if(parseInt(req.result.requestedId)>0){
                    Ext.MessageBox.show({
                        title: 'Guardar',
                        msg: 'Se Guardo la Información con Exito.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.INFO
                    });
                    Ext.getCmp('gridSolicitudesNOPOSxPaciente').store.load({
                        params: {
                            task: 'LISTAR_NOPOS',
                            pPaciente: Ext.getCmp('intPacienteNOPOS').getValue()
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Guardar',
                        msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}

function fnEliminarRegistrosItemsSolNOPOS(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                    }
                    break;

                case 3:
                    if (typeof pGrid != 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}