/*
* @category    Formulario Adicionar Solicitud Remisiones
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winSolRem002Ui = Ext.extend(Ext.Window, {
    title: 'eOfiMedical .:: Remisiones ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winSolRem002Ui',
    initComponent: function() {
        var selMx = "0";
        var stConceptosOfimedical = new StoreConceptosOfimedical();
        stConceptosOfimedical.load({
            params: {
                pTipo: "R"
            }
        });
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddRemisiones',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 80,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'strTipoRem',
                                value: "R",
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPrestadorRem',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIPSRem',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intPacienteRem',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intCASRem',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intConsecutivoHCRem',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intProfesionalRem',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioRem',
                                value: 0,
                                allowBlank: true
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Descripción',
                                anchor: '100%',
                                allowBlank: false,
                                store: stConceptosOfimedical,
                                typeAhead: true,
                                typeAheadDelay: 450,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: false,
                                id: 'strConceptoOfiMedicalRem'
                            },
                            {
                                xtype: 'textarea',
                                fieldLabel: 'Remisión',
                                anchor: '100%',
                                allowBlank: true,
                                id: 'memRemision'
                            },
                            {
                                xtype: 'hidden',
                                id: 'strSelectConceptoRem',
                                allowBlank: true
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddRem',
                            listeners:{
                                click : function(){
                                    /*Ext.Msg.show({
                                        title: 'Guardar Remisiones',
                                        msg: 'Esta Seguro que Desea Guardar la Información?',
                                        buttons: Ext.Msg.YESNO,
                                        icon: Ext.Msg.QUESTION,
                                        fn: function(btn)
                                        {
                                            if(btn=="yes")
                                            {
                                                fnGuardarRegItemRem("GUARDAR_OFIMEDICAL","SI","winSolRem002Ui","frmAddRemisiones","../../controlador/solrem/controlador_solrem.php","gridRemisionesHC");
                                            }
                                        }
                                    });*/
                                    fnGuardarRegItemRem("GUARDAR_OFIMEDICAL_002","SI","winSolRem002Ui","frmAddRemisiones","../../controlador/solrem/controlador_solrem.php","gridRemisionesHC");
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winSolRem002Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegItemRem(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        Ext.getCmp('strSelectConceptoRem').setValue(parseInt(Ext.getCmp('strConceptoOfiMedicalRem').getValue()));
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        /*Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });*/
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarDatosBasicosTarjeta').setVisible(false);
                                Ext.getCmp('btnModificarDatosBasicosTarjeta').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
